//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDNXFORMDEV_H
#define WSDNXFORMDEV_H

#include <WSDwindowDev.h>

#define N_VIEWR     64

class WSDnxFormDev               :public WSDwindowDev {
  private:
  protected:
   WSClistData _child_dev_list;
   void*       _window;
   void*       _context;
   void*       _mem_context;
   short       _bg;
   short       _bg_pix;

    long       _click_time;
    WSCushort _mno;
    WSCbool _added_to_child_dev_list;
    WSCrectList _clip_fore_list[N_VIEWR];
    long    _clip_num;
static WSCbool _expose_sequence;
static WSClistData _geometry_update_list;
static WSClistData _update_list;
static WSClistData _expose_list;
static short _global_region_x;
static short _global_region_y;
static WSCushort _global_region_w;
static WSCushort _global_region_h;

static short _exposed_global_region_x;
static short _exposed_global_region_y;
static WSCushort _exposed_global_region_w;
static WSCushort _exposed_global_region_h;

  public:
virtual long createWindow();
virtual long createPixmap(); //call for Expose only...
virtual long createContext();
virtual long destroyWindow();
virtual long destroyPixmap();
virtual long destroyContext();
virtual WSCbool getParentVisible();
    WSCrectList* getClipList();
    void   clearClipList();
    void   setClipNum(long num);

virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
virtual void _clear_area( long x,long y,WSCulong w,WSCulong h);

    WSDnxFormDev();
    virtual ~WSDnxFormDev();
    virtual long setVisible(WSCbool fl);
    virtual long setValue(long kind,void*);
    virtual long getDeviceResource();
    virtual long getWindowResource();
    virtual long getContextResource();
    virtual long getSpecialResource();
    virtual WSDdev* getEventParentDev();

    void _evh_expose(WSCrect* );
    void _evh_expose_abs(WSCrect* );
    void _expose_ex(WSCrect*);
    void _expose_ex_abs(WSCrect*);
    void _evh_btn_press(void* ev);
    void _evh_btn_release(void* ev);
    void _evh_mouse_move(void* ev);
    void _evh_mouse_out();
    void _evh_mouse_in(short x,short y);
    void _evh_resize(WSCrect*);
    void _evh_destroy(void* ev);

    void*  getWindow();
    void*  getContext();
    void*  getMemContext();
    void*  getParentWindow();
    void*  getParentContext();
    void*  getParentMemContext();
    WSCbool getUseMemContext();

    WSDnxFormDev* getParentAreaDev();
    WSDnxFormDev* getMostParentAreaDev();
    void addChildDevList(WSDnxFormDev*);
    void delChildDevList(WSDnxFormDev*);
    void setChildDevListFlag(WSCbool);
    WSCbool getChildDevListFlag();

    virtual long raise();
    virtual long lower();
    static WSCbool isValidInstance(WSDnxFormDev*);

    virtual void getAbstSize(short*,short*,WSCushort*,WSCushort*);
    virtual void getAbstPos(short*,short*);
    virtual WSCbool haveWindow();
    WSClistData getChildDevList();

    void setDefaultRegion();
    void redrawAll();

    WSDnxFormDev* getChildWithPoint(short x,short y);
    static WSDnxFormDev* getMouseGrabedDev(); 
    static void setMouseGrabedDev(WSDnxFormDev* dev); 
    virtual void drawBackGround(long x,long y,WSCulong w,WSCulong h);
    virtual void exposeExecute(short x,short y,WSCushort w,WSCushort h);
    virtual void recursiveExposeExecute(short x,short y,WSCushort w,WSCushort h);
    virtual long exposeArea(long x,long y,WSCulong w,WSCulong h,WSCbool scaling = True);    
    void addUpdateList();
    void addGeometryUpdateList();
static void executeUpdate();
static void setGlobalRegion(short x,short y,WSCushort,WSCushort);
static void getGlobalRegion(short* x,short* y,WSCushort*,WSCushort*);

    virtual void getParentAbstPos(short*,short*);

  WSMFclassDef(WSDnxFormDev,WSDwindowDev);
};
#endif
 
