//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVBARGRAPH_H
#define WSCVBARGRAPH_H

#include <WScom.h>
#include <WSCnwbase.h>
#define WSCvbarGraph_VER	1000

class WSCvbarGraph :public WSCnwbase{

  protected:
    char*     _values;
    char*     _data_source_name;
    WSCushort _num;
    short     _hatch_color;
    short     _bg_blink_color;
    WSCuchar  _barw;
    WSCuchar  _orientation;
    WSCuchar  _rev;
    WSCuchar  _lw;
    unsigned  _hatch_pattern:4;
    unsigned  _lt:4;
    unsigned  _data_source_type:2;
    unsigned  _stippled:1;
    unsigned  _need_ds_update:1;


    WSMFpropertyDef(WSNvalue,     char*,_values     );
    WSMFpropertyDef(WSNcolumns,   WSCushort,_num    );
    WSMFpropertyDef(WSNbarThickness,  WSCuchar,_barw );
    WSMFpropertyDef(WSNorientation,  WSCuchar,_orientation );
    WSMFpropertyDef(WSNreverseFlag,  WSCbool,_rev );
    WSMFpropertyDef(WSNstippled,        WSCbool, _stippled         );
    WSMFpropertyDef(WSNhatchPattern,    WSCuchar, _hatch_pattern    );
    WSMFpropertyDef(WSNhatchColor,      short,   _hatch_color      );
    WSMFpropertyDef(WSNlineWidth, WSCuchar, _lw);
    WSMFpropertyDef(WSNlineType,  WSCuchar,      _lt);
    WSMFpropertyDef(WSNdataSource,  WSCuchar, _data_source_type  );
    WSMFpropertyDef(WSNdataSourceName,  char*, _data_source_name  );
    WSMFpropertyDef(WSNbackBlinkColor,      short,   _bg_blink_color      );

    void _set_ds_instance();

  public:
    WSCvbarGraph(WSCbase* base, char* name);
    virtual ~WSCvbarGraph();

    virtual long draw();
    virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT);
    virtual long getDataSourceType();
    virtual char* getDataSourcePropertyName();
    virtual void update();
    virtual char* getDefaultProperty();

    WSMFguiClassDef(WSCvbarGraph, WSCnwbase);
    WSMFversionDef  (WSCvbarGraph);
};
#endif
