//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCclassInformation.h>
#include <WSCform.h>
#include <WSCvmifield.h>
#include <advance/WSCmessageBox.h>
#include <WSCscrForm.h>
#include <WSDfont.h>
#include <WSCfontSet.h>
#include <WSDkeyboard.h>
#include <WSCtextField.h>
#include <WSDappDev.h>

#define WS_TOOLB_PIX    WS_PIXMAP_DIR "bi24.xpm"

#define WS_TB_WIDTH     450
#define WS_TB_HEIGHT    280
#define WS_TB_SCRHEIGHT 600
#define WS_TB_T         48
#define WS_TB_H         48
#define WS_TB_W         48
#define WS_TB_X         8
#define WS_TB_Y         8

WSMFguiClassInitialize(WSCmessageBox,WSCbaseDialog);

WSCmessageBox::WSCmessageBox(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

  _form = NULL;
  _label_string = WSGFstrdup("");
  _no = False;
  _textf = NULL;
  _vvalue = 0;
  _hvalue = 0;

  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNlabelString,char*,_label_string,WSSlabelString);
    WSMFpropertyCreate(WSNvbarValue,WSCulong,_vvalue,WSSvalue);
    WSMFpropertyCreate(WSNhbarValue,WSCulong,_hvalue,WSSvalue);
  WSMFpropertyCreateEnd
}

WSMFproperty( WSCmessageBox,WSNlabelString,char*,_label_string,WSGFstrdup(""));
WSMFproperty( WSCmessageBox,WSNvbarValue,WSCulong,_vvalue,0);
WSMFproperty( WSCmessageBox,WSNhbarValue,WSCulong,_hvalue,0);

void WSCmessageBox::setWorkWSNvbarValue(WSCulong val){
  _textf->setPropertyV(WSNvbarValue,val);
}
void WSCmessageBox::getWorkWSNvbarValue(WSCulong* val){ 
  _textf->getPropertyV(WSNvbarValue,val);
}
void WSCmessageBox::setWorkWSNhbarValue(WSCulong val){
  _textf->setPropertyV(WSNhbarValue,val);
}
void WSCmessageBox::getWorkWSNhbarValue(WSCulong* val){ 
  _textf->getPropertyV(WSNhbarValue,val);
}

void WSCmessageBox::setWorkWSNlabelString(char* data){
  WSCstring str(data);
 
  _textf->setPropertyV(WSNlabelString,data);
//  long lines = str.getWords("\n");
//  _textf->setPropertyV(WSNvbarValue,(WSCushort)(lines -2));
}

void WSCmessageBox::getWorkWSNlabelString(char** /*data*/){
}

WSCmessageBox::~WSCmessageBox(){
  delete _label_string;
}

long WSCmessageBox::initialize(){
  WSCbaseDialog::initialize();
  setPropertyV(WSNwidth,(WSCushort)WS_TB_WIDTH);
  setPropertyV(WSNheight,(WSCushort)WS_TB_HEIGHT);
  setPropertyV(WSNtitleString,WSGFgettext("W3:WSSTR MessageBox"));

  _form = new WSCform(this,"tb-area");
  _form->initialize();
  _form->setInternalObject(True);
  _form->setPropertyV(WSNx,(short)1);
  _form->setPropertyV(WSNy,(short)5);
  _form->setPropertyV(WSNwidth, (WSCushort)(WS_TB_WIDTH -2));
  _form->setPropertyV(WSNheight,(WSCushort)(WS_TB_HEIGHT -45));
//  _form->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  _form->setPropertyV(WSNbackColor,"gray80");
  _form->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _form->setPropertyV(WSNtopShadowColor,"gray95");
//  _form->setPropertyV(WSNbottomShadowColor,"gray45");
  _form->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _form->setVisible(True);

  _textf = new WSCtextField(_form,"tb-area");
  _textf->initialize();
  _textf->setInternalObject(True);
  _textf->setPropertyV(WSNx,(short)5);
  _textf->setPropertyV(WSNy,(short)5);
  _textf->setPropertyV(WSNwidth, (WSCushort)(WS_TB_WIDTH -12));
  _textf->setPropertyV(WSNheight,(WSCushort)(WS_TB_HEIGHT -55));
//  _textf->setPropertyV(WSNbackColor,"gray80");
  _textf->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _textf->setPropertyV(WSNworkBackColor,"gray85");
//  _textf->setPropertyV(WSNtopShadowColor,"gray95");
//  _textf->setPropertyV(WSNbottomShadowColor,"gray45");
//  _textf->setSensitive(False);
  _textf->setPropertyV(WSNusePixmap,(WSCbool)True);
  _textf->setVisible(True);

  WSCprocedure* op1 = new WSCprocedure("sop4",WSEV_KEY_HOOK);
  op1->setFunction(_textf_work,"_textf_work");
  _textf->addProcedure(op1);

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  return WS_NO_ERR;
}
void WSCmessageBox::_textf_work(WSCbase* textf){
  if (WSGIappKeyboard()->isCursorKey() != False){
    return;
  }
  long key = WSGIappKeyboard()->getKey();
  if ((key == WSK_C || key == WSK_c) && WSGIappKeyboard()->withCntl() != False){
    return;
  }
  WSGIappKeyboard()->setKey(0);
}
void WSCmessageBox::onResize(WSCrect* rect){
  WSCbaseDialog::onResize(rect);
  _adjust();
}

void WSCmessageBox::_adjust(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }
  if (_w > 2){
    _form->setPropertyV(WSNwidth,(WSCushort)(_w -2));
  }else{
    _form->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_h+diff > 45 ){
    _form->setPropertyV(WSNheight,(WSCushort)(_h+diff -45));
  }else{
    _form->setPropertyV(WSNheight,(WSCushort)(1));
  }
  if (_w > 12){
    _textf->setPropertyV(WSNwidth,(WSCushort)(_w -12));
  }else{
    _textf->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_h+diff > 55 ){
    _textf->setPropertyV(WSNheight,(WSCushort)(_h+diff -55));
  }else{
    _textf->setPropertyV(WSNheight,(WSCushort)(1));
  }
}
WSCbase* WSCmessageBox::getPropertyInheritChild(){
  return _textf;
}
void WSCmessageBox::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() != WS_DIALOG_CANCEL){
    _popuped = 0;
    setVisible(False);
  }
}
void WSCmessageBox::onGuiPolicyChange(long policy){
  if (_form != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _form->setProperty(WSNy,5);
      _form->setProperty(WSNshadowThickness,1);
      _textf->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _form->setProperty(WSNy,0);
      _form->setProperty(WSNshadowThickness,0);
      _textf->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    }
    _adjust();
  }
}
WSCtextField* WSCmessageBox::getTextField(){
  return _textf;
}
