#include <WScom.h>
#include <WSCvbtn.h>
#include <WSDappDev.h>
#include <WSCblink.h>
#include <WSCimageSet.h>
#include <WSCcolorSet.h>
#include <WSCform.h>
#include <WSCvtoggle.h>
#include <WSCoption.h>
#include <WSCpopupFrame.h>
#include <WSDmouse.h>
#include <WSCguiPolicy.h>

short WSGFgetParentBackColor(WSCbase* client){
  WSCbase* parent = client->getParent();
  WSCstring parent_bg("DEF1");
  if (parent != NULL){
    parent_bg = (char*)parent->getProperty(WSNbackColor);
    if (parent->existProperty(WSNworkBackColor) != False){
      parent_bg = (char*)parent->getProperty(WSNworkBackColor);
    }
  }
  return WSGIappColorSet()->getColorNo(parent_bg);
}

void WSGFgetFixedRGB(long r,long g,long b,long v,long* r1,long*g1,long* b1){
  *r1 = r + v;
  *g1 = g + v;
  *b1 = b + v;
  if (v > 0){
    if (*r1 > 255){
      *r1 = 255;
    }
    if (*g1 > 255){
      *g1 = 255;
    }
    if (*b1 > 255){
      *b1 = 255;
    }
  }else{
    if (*r1 < 0){
      *r1 = 0;
    }
    if (*g1 < 0){
      *g1 = 0;
    }
    if (*b1 < 0){
      *b1 = 0;
    }
  }
}
short WSGFgetFixedColor(short cno,long val){
  WSDcolor* color = WSGIappColorSet()->getColor(cno);
  long r,g,b;
  color->getRGB(&r,&g,&b);
  long r1,g1,b1;
  WSGFgetFixedRGB(r,g,b,val,&r1,&g1,&b1);

  char buffer[64];
  sprintf(buffer,"#%02x%02x%02x",r1,g1,b1);
  return WSGIappColorSet()->getColorNo(buffer);
 }

void WSGFdrawModern1BtnShadow(WSDdev* dev,long shadow_type,WSCushort stick,
   short fg_no, short ts_no, short bs_no, short bg_no,short parent_bg_no,
   short x, short y, WSCushort w,WSCushort h,WSCbool nodark,WSCbool nosize){
//printf("pno=%d cname=%s\n",pno,WSGIappColorSet()->getColorName(pno));
  if (stick * 2 > w){
    stick = w / 2;
  }
  if (stick * 2 > h){
    stick = h / 2;
  }
  if (stick == 0){
    return;
  }

  dev->setLineDashType(0);
  dev->setLineWidth(1);
  if (shadow_type == WS_SHADOW_OUT){
    short ts1 = WSGFgetFixedColor(parent_bg_no,16);

    dev->setForeColor(ts1);
    dev->drawRect(x,y,w,h);
//    dev->drawLine(x,y+h-1,x+w-1,y+h-1);
//    dev->drawLine(x+w-1,y,x+w-1,y+h-1);
    if (nosize == False){
      short ts2 = WSGFgetFixedColor(bg_no,16);
      dev->setForeColor(ts2);
      dev->drawFillRect(x+2,y+2,1,h-4);

      short ts3 = WSGFgetFixedColor(bg_no,8);
      dev->setForeColor(ts3);
      dev->drawFillRect(x+3,y+4,1,h-8);


      short bs2 = WSGFgetFixedColor(bg_no,-16);
      dev->setForeColor(bs2);
      dev->drawFillRect(x+w-3,y+2,1,h-4);

      short bs3 = WSGFgetFixedColor(bg_no,-8);
      dev->setForeColor(bs3);
      dev->drawFillRect(x+w-4,y+4,1,h-8);
    }
    short bs1 = WSGFgetFixedColor(parent_bg_no,-16);
    dev->setForeColor(bs1);
    dev->drawFillRect(x,y,1,h);
    dev->drawFillRect(x,y,w,1);

    dev->setForeColor(bs_no);
    dev->drawRect(x+1,y+1,w-2,h-2);

    dev->drawFillRect(x+2,y+2,1,1);
    dev->drawFillRect(x+w-3,y+2,1,1);
    dev->drawFillRect(x+2,y+h-3,1,1);
    dev->drawFillRect(x+w-3,y+h-3,1,1);

    dev->setForeColor(bs1);
    dev->drawFillRect(x+1,y+1,1,1);
    dev->drawFillRect(x+w-2,y+1,1,1);
    dev->drawFillRect(x+1,y+h-2,1,1);

    dev->setForeColor(ts1);
    dev->drawFillRect(x+w-2,y+h-2,1,1);

    dev->setForeColor(parent_bg_no);
    dev->drawFillRect(x,y,1,1);
    dev->drawFillRect(x+w-1,y+h-1,1,1);
    dev->drawFillRect(x,y+h-1,1,1);
    dev->drawFillRect(x+w-1,y,1,1);

    return;

  }else{
    WSGFdrawShadow(dev,shadow_type,stick,
                   fg_no, ts_no, bs_no, bg_no,
                   x, y, w, h, nodark);
  }
  return;
}
void WSGFdrawModern1Shadow(WSDdev* dev,long shadow_type,WSCushort stick,
   short fg_no, short ts_no, short bs_no, short bg_no,short pno,
   short x, short y, WSCushort w,WSCushort h,WSCbool nodark){
//printf("pno=%d cname=%s\n",pno,WSGIappColorSet()->getColorName(pno));
  if (stick * 2 > w){
    stick = w / 2;
  }
  if (stick * 2 > h){
    stick = h / 2;
  }
  if (stick == 0){
    return;
  }

  dev->setLineDashType(0);
  dev->setLineWidth(1);
  if (shadow_type == WS_SHADOW_OUT || shadow_type == WS_SHADOW_IN){
    short ts1 = WSGFgetFixedColor(pno,16);

//printf("%d cname=%s %s\n",bs1,buffer,WSGIappColorSet()->getColorName(bs1));
    dev->setForeColor(ts1);
    dev->drawRect(x,y,w,h);
//    dev->drawLine(x,y+h-1,x+w-1,y+h-1);
//    dev->drawLine(x+w-1,y,x+w-1,y+h-1);

    short bs1 = WSGFgetFixedColor(pno,-16);
//printf("%d cname=%s %s\n",ts1,buffer,WSGIappColorSet()->getColorName(ts1));
    dev->setForeColor(bs1);
    dev->drawFillRect(x,y,1,h);
    dev->drawFillRect(x,y,w,1);

    dev->setForeColor(bs_no);
    dev->drawRect(x+1,y+1,w-2,h-2);

#if 0
    dev->drawRect(x+2,y+2,1,1);
    dev->drawRect(x+w-3,y+2,1,1);
    dev->drawRect(x+2,y+h-3,1,1);
    dev->drawRect(x+w-3,y+h-3,1,1);

    dev->setForeColor(ts1);
    dev->drawRect(x+1,y+1,1,1);
    dev->drawRect(x+w-2,y+1,1,1);
    dev->drawRect(x+1,y+h-2,1,1);

    dev->setForeColor(bs1);
    dev->drawRect(x+w-2,y+h-2,1,1);

    dev->setForeColor(pno);
    dev->drawFillRect(x,y,1,1);
    dev->drawFillRect(x+w-1,y+h-1,1,1);
    dev->drawFillRect(x,y+h-1,1,1);
    dev->drawFillRect(x+w-1,y,1,1);
#endif
#if 0
    dev->drawFillRect(x + w - st,y,st,h);
    dev->drawFillRect(x,y + h - st,w,st);

    dev->setForeColor(ts_no);
    dev->drawFillRect(x,y,st,h);
    dev->drawFillRect(x,y,w,st);
#endif
    return;

  }else{
    WSGFdrawShadow(dev,shadow_type,stick,
                   fg_no, ts_no, bs_no, bg_no,
                   x, y, w, h, nodark);
  }
  return;
}

void WSCvbtn_draw_mdr1(void* ptr){
  WSCvbtn_draw_struct* st = (WSCvbtn_draw_struct*)ptr;

  WSCbool absolute = st->_this->getAbsoluteDraw();
  WSDdev* dev = st->dev;
  if (absolute == False &&
      dev->isExposed(st->x, st->y, st->width, st->height) == False) {
    return;
  }
  if ( st->shadow_type == WS_SHADOW_NONE &&
       st->blinking  != False &&
       st->blink_fore != False &&
       st->twin_blink == False){
    return;
  }
  WSCstring str = st->label_string;
  if (st->orientation == WS_VERTICAL) {
    WSGFcreateVerticalString(&str);
  } else {
    str.replaceString("\\n", "\n", 0);
  }

  long err = dev->beginDraw(st->x, st->y, st->width, st->height, absolute);
  if (err != WS_NO_ERR){
    return;
  }

  st->_this->WSCbase::update();
  st->_this->setAbsoluteDraw(False);
  WSCushort w = st->width;
  WSCushort h = st->height;

  short fgc = st->fore_color;
  short bgc = st->back_color;

  if (st->reverse_flag == True){
    if (st->blinking  != False &&
        st->blink_fore != False &&
        st->blink_type != WS_FORE ){
      dev->setForeColor(st->blink_color);
      bgc = st->blink_color;
    }else{
      dev->setForeColor(st->fore_color);
      bgc = st->fore_color;
    }
  }else{
    if (st->blinking  != False &&
        st->blink_fore != False &&
        st->blink_type != WS_FORE ){
      dev->setForeColor(st->back_blink_color);
      bgc = st->back_blink_color;
    }else{
      dev->setForeColor(st->back_color);
      bgc = st->back_color;
    }
  }

  if (st->no_background != False){
    dev->drawFillRect(0, 0, w, h);
  }
  if (st->gradation == 0 && st->no_background == False){
    short ts1 = WSGFgetFixedColor(bgc,32);
    short bs1 = WSGFgetFixedColor(bgc,-32);
    if (st->shadow_thickness != 0){
      if (st->press_state == False) {
        dev->drawGradation(WS_GR_T_B,ts1,
                         bgc,bs1,0, 1,
                         st->width, st->height,st->height*2/3);
      }else{
        dev->setForeColor(bs1);
        dev->drawFillRect(0, 0, w, h);
      }
    }else{
      dev->drawFillRect(0, 0, w, h);
    }
  }

  if (st->gradation != 0){
    if (st->press_state == True) {
      dev->drawGradation(st->gradation,st->top_shadow_color,
                         st->back_color,st->bottom_shadow_color,0, 1,
                         st->width, st->height,st->gradation_margin);
    }else{
      dev->drawGradation(st->gradation,st->top_shadow_color,
                         st->back_color,st->bottom_shadow_color,0, 0,
                         st->width, st->height,st->gradation_margin);
    }
  }

  WSCushort stick = st->shadow_thickness;
  short          xx = stick + st->margin_left;
  short          yy = stick + st->margin_top;
  WSCushort ww = st->width - stick*2;
  WSCushort hh = st->height - stick*2;
  WSCushort h_m = st->margin_left + st->margin_right;
  WSCushort v_m = st->margin_top + st->margin_bottom;

  if (ww < h_m){
    ww = 1;
  }else{
    ww = ww - h_m;
  }
  if (hh < v_m){
    hh = 1;
  }else{
    hh = hh - v_m;
  } 
  WSDimage* image = NULL;
  if (st->blinking  != False &&
      st->blink_type != WS_BACK &&
      st->blink_fore != False ){ 
    if (st->blink_pixmap != -1 && st->twin_blink != False){
      image = WSGIappImageSet()->getImage(st->blink_pixmap);
      short dy = yy;
      if (st->press_state == True){
        dy++;
      }
      dev->drawImage (xx, dy, ww, hh, image, st->_this->getAlignment());
    }
  }else{
    short dy=yy;
    WSCbool drawfl = False;
    if (st->press_state != False) {
      dy++;
      if (st->push_pixmap != -1) {
        image = WSGIappImageSet()->getImage(st->push_pixmap);
        drawfl = True;
      } else if (st->label_pixmap != -1){
        image = WSGIappImageSet()->getImage(st->label_pixmap);
        drawfl = True;
      }
    }else{
      if (st->label_pixmap != -1){
        image = WSGIappImageSet()->getImage(st->label_pixmap);
        drawfl = True;
      }
    }
    if (drawfl != False){
      dev->drawImage (xx, dy, ww, hh, image, st->_this->getAlignment());
    }
  }

  short fgno = st->fore_color;
  short bgno = st->back_color;
  short tsno = st->top_shadow_color;
  short bsno = st->bottom_shadow_color;
  WSCbool specialfocus= st->_this->getSpecialFocus();

  if ( stick > 0){
    char    type = WS_SHADOW_OUT;
    if (st->_this->getSensitive() == False ||
        (st->_this->getPropertyEditMode() != False && st->_this->getUserData(WS_DET) == 0)) {
      type = WS_SHADOW_OUT;
    }else if (st->press_state == True) {
      type = WS_SHADOW_IN;
    }

    short pbg = WSGFgetParentBackColor(st->_this);
    if (specialfocus == False ||st->focus_border == False) {
      if (st->gradation == 0){
        WSGFdrawModern1BtnShadow(dev, type, stick, tsno, tsno, bsno, bgc, pbg,
                               0, 0, w, h,False,False);
      }else{
        WSGFdrawModern1BtnShadow(dev, type, stick, tsno, tsno, bsno, bgc, pbg,
                               0, 0, w, h,False,True);
      }
    }else{
      if (st->gradation == 0){
        WSGFdrawModern1BtnShadow(dev, type, stick, tsno, tsno, bsno, bgc, pbg,
                               1, 1, w-2, h-2,False,False);
      }else{
        WSGFdrawModern1BtnShadow(dev, type, stick, tsno, tsno, bsno, bgc, pbg,
                               1, 1, w-2, h-2,False,True);
      }
    }
    if (specialfocus != False && st->focus_border != False ){
      dev->setForeColor(WS_DF_DARKBOTTOMSHADOWCOLOR);
      dev->setLineDashType(0);
      dev->setLineWidth(1);
      dev->drawRect(0,0,w,h);
    }
  }

  if (st->_this->getSensitive() == False ||
      (st->_this->getPropertyEditMode() != False && (long)st->_this->getUserData(WS_DET) == 0)){
    if (st->emboss != False){

      if (st->blinking  != False &&
          st->blink_fore != False &&
          st->blink_type != WS_BACK &&
          st->twin_blink == False){
        // do nothing...
      }else{
        if (st->twin_blink == False || st->blinking == False){
          if (st->blinking  != False &&
              st->blink_fore != False &&
              st->blink_type != WS_BACK &&
              st->twin_blink != False) {
            dev->setForeColor(st->blink_color);
          } else {
            dev->setForeColor(tsno);
          }
          dev->drawString(xx+1, yy+1, ww, hh, &str, st->font, st->_this->getAlignment(), -1, False);
        }
      }
    }else{
      dev->setHatchPattern(8);
    }
  }

  if (st->reverse_flag == True) {
    if (st->blinking  != False &&
        st->blink_fore != False &&
        st->blink_type != WS_BACK &&
        st->twin_blink != False) {
      dev->setForeColor(st->back_blink_color);
    } else {
      if( st->emboss != False && (st->_this->getSensitive() == False ||
          (st->_this->getPropertyEditMode() != False && (long)st->_this->getUserData(WS_DET) == 0))){
        dev->setForeColor(bsno);
      }else{
        dev->setForeColor(bgno);
      }
    }
  }else{
    if (st->blinking  != False &&
        st->blink_fore != False &&
        st->blink_type != WS_BACK &&
        st->twin_blink != False) {
      dev->setForeColor(st->blink_color);
    }else{
      if ( st->emboss != False && (st->_this->getSensitive() == False ||
        (st->_this->getPropertyEditMode() != False && (long)st->_this->getUserData(WS_DET) == 0))){
        dev->setForeColor(bsno);
      }else{
        dev->setForeColor(fgno);
      }
    }
  }
  if (st->blinking  != False &&
      st->blink_fore != False &&
      st->blink_type != WS_BACK &&
      st->twin_blink == False ){
      //do nothing...
  }else{
    if (st->press_state == True) {
      dev->drawString(xx, yy+1, ww, hh, &str,  st->font, st->_this->getAlignment(), -1, False);
    }else{
      dev->drawString(xx, yy, ww, hh, &str, st->font, st->_this->getAlignment(), -1, False);

    }

    // draw dashed focused line...
    if (st->_this->getFocus() != False && st->enable_focus_move != False) {
      if (w > 4 + stick*2 && h > 4 + stick*2) {
        // 褹ϣ˸
        dev->setLineWidth(0);
        // 褹˸
        dev->setLineDashType(8);
        if (st->press_state == True) {
          //1 dot below
          dev->drawRect(stick + 2, stick + 3, w - stick * 2 - 4, h - stick * 2 - 4);
        } else {
          dev->drawRect(stick + 2, stick + 2, w - stick * 2 - 4, h - stick * 2 - 4);
        }
      }
    }
  }

  dev->endDraw();
  return; 
}

void WSCform_draw_mdr1(void* ptr){
  WSCform_draw_struct* st = (WSCform_draw_struct*)ptr;

  WSCbool absolute = st->_this->getAbsoluteDraw();
  WSDdev* dev = st->dev;

  long err = dev->beginDraw(0,0,st->width,st->height,absolute);
  if (err != WS_NO_ERR){
    return;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = st->width;
  WSCushort eh = st->height;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  st->_this->WSCbase::update();
  st->_this->setAbsoluteDraw(False);

  if (st->back_pixmap == -1){
    if (st->gradation == 0){
      dev->setForeColor(st->back_color);
      dev->drawFillRect(0,0,st->width,st->height);
      dev->setForeColor(st->back_color);

    }else{
      dev->drawGradation(st->gradation,st->top_shadow_color,st->back_color,st->bottom_shadow_color,0,0,st->width,st->height,st->gradation_margin);
    }
  }
  if (st->_this->getDotMode() == True){
    dev->setForeColor(st->fore_color);
    long i,j;
    for(i=0; i<st->width; i+=10){
      for(j=0; j<st->height; j+=10){
        if (ex < i+1 && i < ex+ ew+1 &&
            ey < j+1 && j < ey+ eh+1 ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }

//draw shadow
  if (st->shadow_thickness > 0){
#if 0
    dev->setLineWidth(1);
    dev->setLineDashType(0);
    dev->setForeColor(st->bottom_shadow_color);
    dev->drawRect(0,0,st->width,st->height);
#endif
    short tsno = st->top_shadow_color;
    short bsno = st->bottom_shadow_color;
    short bgc = st->back_color;
    short pbg = WSGFgetParentBackColor(st->_this);
    WSGFdrawModern1Shadow(dev, st->shadow_type, st->shadow_thickness,
        tsno, tsno, bsno, bgc, pbg, 0, 0, st->width, st->height,False);

  }

  dev->endDraw();

  return;
}
void WSCvtoggle_draw_mdr1(void* ptr){
  WSCvtoggle_draw_struct* dt = (WSCvtoggle_draw_struct*)ptr;

  WSCbool absolute = dt->_this->getAbsoluteDraw();
  WSCvtoggle* _this = dt->_this;
  WSDdev* dev = dt->dev;
  short x = dt->x;
  short y = dt->y;
  WSCushort w = dt->width;
  WSCushort h = dt->height;
  WSCushort st = dt->shadow_thickness;
  long blinking   = dt->blinking;
  long _bl_fl   = dt->blinking;
  long blinkfore  = dt->blink_fore;
  long shadowtype = dt->shadow_type;
  long twinblink  = dt->twin_blink;
  long _tw_fl  = dt->twin_blink;
  long blinktype  = dt->blink_type;
  long _bl_type  = dt->blink_type;
  short fgno         = dt->fore_color;
  short _fore_color  = dt->fore_color;
  short bgno         = dt->back_color;
  short _back_color  = dt->back_color;
  short blinkcolorno = dt->blink_color;
  short _blink_color = dt->blink_color;
  short backblinkno  = dt->back_blink_color;
  short _bg_blink_color  = dt->back_blink_color;
  short tsno         = dt->top_shadow_color;
  short _ts_color    = dt->top_shadow_color;
  short bsno         = dt->bottom_shadow_color;
  short _bs_color    = dt->bottom_shadow_color;

  char* _label_string = dt->label_string;
  char* _select_string = dt->select_string;
  short _label_pixmap = dt->label_pixmap;
  short _blink_pixmap = dt->blink_pixmap;
  short _select_color = dt->select_color;
  short _select_pixmap = dt->select_pixmap;
  short _press_status = dt->press_status;
  long  _orientation = dt->orientation;
  long  _grad_no = dt->gradation;
  long  _grad_margin = dt->gradation_margin;
  long  _margin_left = dt->margin_left;
  long  _margin_right = dt->margin_right;
  long  _margin_top = dt->margin_top;
  long  _margin_bottom = dt->margin_bottom;
  WSCbool  _emboss = dt->emboss;
  WSCuchar _font = dt->font;
  WSCbool  _rv_fl = dt->reverse_flag;
  WSCbool  _enable_focus_move = dt->enable_focus_move;
  WSCbool  _toggle_status = dt->toggle_status;
  WSCbool  _unique = dt->unique;
  WSCbool  _select_reset = dt->select_reset;
  WSCuchar _indicator_size = dt->indicator_size;
  WSCuchar _indicator_type = dt->indicator_type;
  WSCuchar _indicator_shadow_thick = dt->indicator_shadow_thickness;
  WSCbool  _indicator_on = dt->indicator_on;
  short    _indicator_pixmap = dt->indicator_pixmap;
  short    _indicator_color = dt->indicator_color;

  WSCstring str;
  if (_press_status == False){
    str.setString( _label_string );
  }else{
    if (_select_string == NULL){
      str.setString( _label_string );
    }else{
      if (_select_string[0] == 0 ){
        str.setString( _label_string );
      }else{
        str.setString( _select_string );
      }
    }
  }
  if (_orientation == WS_VERTICAL) {
    WSGFcreateVerticalString(&str);
  } else {
    str.replaceString("\\n", "\n", 0);
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return;
  }

  _this->WSCbase::update();
  _this->setAbsoluteDraw(False);

  if (_rv_fl == True) {
    if (blinking  != False &&
        blinkfore != False &&
        blinktype != WS_FORE ){
      dev->setForeColor(blinkcolorno);
    } else {
      dev->setForeColor(fgno);
    }
  } else {
    if (blinking  != False &&
        blinkfore != False &&
        blinktype != WS_FORE ){
      dev->setForeColor(backblinkno);
    } else {
      dev->setForeColor(bgno);
    }
  }
  if (_grad_no == 0){
    dev->drawFillRect(0, 0, w, h);
  }else{
    if (_press_status == True  && _indicator_on == False){
      dev->drawGradation(_grad_no,tsno,bgno,bsno,0, 1, w, h,_grad_margin);
    }else{
      dev->drawGradation(_grad_no,tsno,bgno,bsno,0, 0, w, h,_grad_margin);
    }
  }

  short offsetx = 0;
  short left_margin = _margin_left;
  short right_margin = _margin_right;
  short top_margin    = _margin_top;
  short bottom_margin = _margin_bottom;

  if (_indicator_on == True) {
    offsetx = _indicator_size;
  }
  short sx = st + left_margin + offsetx;
  short sy = st + top_margin;
  short sw = 0;
  short sh = 0;
  if ( w > offsetx + st * 2){
    sw = w -offsetx -st * 2;
  }
  if ( sw < left_margin + right_margin ){
    sw = 1;
  }else{
    sw = sw - left_margin - right_margin;
  }

  if ( h > st * 2){
    sh = h - st * 2;
  }

  if (sh < top_margin + bottom_margin){
    sh = 1;
  }else{
    sh = sh - top_margin - bottom_margin;
  }

  WSDimage* image;
  if (blinking  != False &&
      blinktype != WS_BACK &&
      blinkfore != False ){
    if (_blink_pixmap != -1 && twinblink != False){
      image = WSGIappImageSet()->getImage(_blink_pixmap);
      short dy = sy;
      if (_press_status == True  && _indicator_on == False){
        dy++;
      }
      dev->drawImage (sx, dy, sw, sh, image, _this->getAlignment());
    }
  } else {
    if ( _label_pixmap != -1){
      image = WSGIappImageSet()->getImage( _label_pixmap );
      short dy = sy;
      if (_press_status == True  && _indicator_on == False){
        dy++;
      }
      dev->drawImage (sx, dy, sw, sh, image, _this->getAlignment());
    }
  }

  if (st > 0){
    char type = WS_SHADOW_OUT;
    if (_press_status == True  && _indicator_on == False){
      type = WS_SHADOW_IN;
    }
    short pbg = WSGFgetParentBackColor(_this);
    if (_grad_no == 0){
      WSGFdrawModern1BtnShadow(dev, type, st, _fore_color, tsno, bsno,bgno,pbg,
                             0, 0, w, h,False,False);
    }else{
      WSGFdrawModern1BtnShadow(dev, type, st, _fore_color, tsno, bsno,bgno,pbg,
                             0, 0, w, h,False,True);
    }
  }

  if (_this->getSensitive() == False ||
      (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0)){
    if (_emboss != False){
      if (_bl_fl != False &&
        blinkfore != False &&
        _bl_type != WS_BACK &&
        _tw_fl != False) {
        dev->setForeColor(blinkcolorno);
      } else {
        dev->setForeColor(tsno);
      }
      dev->setBackColor(bgno);

      if (blinking  != False &&
          blinktype != WS_BACK &&
          blinkfore != False &&
          twinblink == False){
      }else{
        if (twinblink == False || blinking == False){
          dev->drawString(sx+1, sy+1, sw, sh,
                      &str, _font, _this->getAlignment(), -1, False);
        }
      }
    }else{
      dev->setHatchPattern(8);
    }
  } else {
    dev->setHatchPattern(0);
  }

  if (_indicator_on == True){
     offsetx = _indicator_size;
  }

  if (_rv_fl == True) {
    if (_bl_fl == True &&
        blinkfore == True &&
        _bl_type != WS_BACK &&
        _tw_fl == True){
      dev->setForeColor(_bg_blink_color);
    }else{
      if ( _emboss != False && (_this->getSensitive() == False ||
          (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
        dev->setForeColor(_bs_color);
      } else {
        dev->setForeColor(_back_color);
      }
    }
  } else {
    if (_bl_fl == True &&
        blinkfore == True &&
        _bl_type != WS_BACK &&
        _tw_fl == True){
      dev->setForeColor(_blink_color);
    }else{
      if ( _emboss != False && (_this->getSensitive() == False ||
          (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
         dev->setForeColor(_bs_color);
      }else{
         dev->setForeColor(_fore_color);
      }
    }
  }

  if (sw != 0 && sh != 0){

    if (_bl_fl  != False &&
        _bl_type != WS_BACK &&
        blinkfore != False &&
        _tw_fl == False){
        // 褷ʤ
    }else{


      if (_press_status == True  && _indicator_on == False){
        dev->drawString(sx ,sy  +1,
                        sw ,sh, &str, _font, _this->getAlignment(), -1, False);
      }else{
        dev->drawString(sx, sy, sw, sh,
                      &str, _font, _this->getAlignment(), -1, False);
      }

      //եΥ饤
      // եưݤĤξΤ
      if (_this->getFocus() == True && _enable_focus_move == True){
        dev->setLineWidth( 1 );
        dev->setLineDashType( 8 );
        if (w > 4 + st*2 && h > 4 + st*2){
          if (_indicator_on == False){
            if (_press_status == True ){
              dev->drawRect(st+2, st+3, w-st*2-4, h-st*2-4);
            }else{
              dev->drawRect(st+2, st+2, w-st*2-4, h-st*2-4);
            }
          }else{
            WSCushort ww = 0;
            if ( w > offsetx + st * 2 +4 + left_margin/2){
              ww = w -offsetx -st * 2 -4 - left_margin/2;
            }
            if (ww >0 && (long)h-(long)st*2 -4 > 0){
              dev->drawRect(st+left_margin/2+2+_indicator_size, st+2, ww, h -st*2 -4);
            }
          }
        }
      }

    }
  }

  if (_indicator_on == True){
    //󥸥κɸη׻
    char itype = _indicator_type;
    WSCushort isize = _indicator_size;
    short ypos = (h - isize)/2;
    short xpos = st + left_margin /2;
    if (h < isize){
        ypos = 0;
    }

    //󥸥طʤ
    WSDimage* image;
    if (_press_status == True ){
      if (_select_pixmap == -1){
        dev->setForeColor(_select_color);
        dev->drawFillRect(xpos, ypos, isize, isize);
      }else{
        image = WSGIappImageSet()->getImage(_select_pixmap);
          dev->drawImage (xpos, ypos, isize, isize, image, WS_CENTER);
      }
    }else{
      if (_indicator_pixmap == -1){
        dev->setForeColor(_indicator_color);
        dev->drawFillRect(xpos, ypos, isize, isize);
      }else{
        image = WSGIappImageSet()->getImage(_indicator_pixmap);
          dev->drawImage (xpos, ypos, isize, isize, image, WS_CENTER);
      }
    }
    if (itype != WS_NONE ){
      char type = WS_SHADOW_OUT;
      if (_press_status == True){
        if  ( itype == WS_IN_OUT){
          type = WS_SHADOW_IN;
        }
      }
      if  ( itype == WS_IN){
        type = WS_SHADOW_IN;
      }
      if (_grad_no == 0){
        WSGFdrawModern1BtnShadow(dev, type, _indicator_shadow_thick,
                     _fore_color, _ts_color, _bs_color,_back_color,_back_color,
                     xpos, ypos , isize, isize,False,False);
      }else{
        WSGFdrawModern1BtnShadow(dev, type, _indicator_shadow_thick,
                     _fore_color, _ts_color, _bs_color,_back_color,_back_color,
                     xpos, ypos , isize, isize,False,True);
      }
    }
  }

  dev->endDraw();
  return;
}

void WSCvradio_draw_mdr1(void* ptr){
  WSCvtoggle_draw_struct* dt = (WSCvtoggle_draw_struct*)ptr;

  WSCbool absolute = dt->_this->getAbsoluteDraw();
  WSCvtoggle* _this = dt->_this;
  WSDdev* dev = dt->dev;
  short x = dt->x;
  short y = dt->y;
  WSCushort w = dt->width;
  WSCushort h = dt->height;
  WSCushort st = dt->shadow_thickness;
  WSCushort _shadow_thick = dt->shadow_thickness;
  long blinking   = dt->blinking;
  long _bl_fl   = dt->blinking;
  long blinkfore  = dt->blink_fore;
  long shadowtype = dt->shadow_type;
  long twinblink  = dt->twin_blink;
  long _tw_fl  = dt->twin_blink;
  long blinktype  = dt->blink_type;
  long _bl_type  = dt->blink_type;
  short fgno         = dt->fore_color;
  short _fore_color  = dt->fore_color;
  short bgno         = dt->back_color;
  short _back_color  = dt->back_color;
  short blinkcolorno = dt->blink_color;
  short _blink_color = dt->blink_color;
  short backblinkno  = dt->back_blink_color;
  short _bg_blink_color  = dt->back_blink_color;
  short tsno         = dt->top_shadow_color;
  short _ts_color    = dt->top_shadow_color;
  short bsno         = dt->bottom_shadow_color;
  short _bs_color    = dt->bottom_shadow_color;

  char* _label_string = dt->label_string;
  char* _select_string = dt->select_string;
  short _label_pixmap = dt->label_pixmap;
  short _blink_pixmap = dt->blink_pixmap;
  short _select_color = dt->select_color;
  short _select_pixmap = dt->select_pixmap;
  short _press_status = dt->press_status;
  long  _orientation = dt->orientation;
  long  _grad_no = dt->gradation;
  long  _grad_margin = dt->gradation_margin;
  long  _margin_left = dt->margin_left;
  long  _margin_right = dt->margin_right;
  long  _margin_top = dt->margin_top;
  long  _margin_bottom = dt->margin_bottom;
  WSCbool  _emboss = dt->emboss;
  WSCuchar _font = dt->font;
  WSCbool  _rv_fl = dt->reverse_flag;
  WSCbool  _enable_focus_move = dt->enable_focus_move;
  WSCbool  _toggle_status = dt->toggle_status;
  WSCbool  _unique = dt->unique;
  WSCbool  _select_reset = dt->select_reset;
  WSCuchar _indicator_size = dt->indicator_size;
  WSCuchar _indicator_type = dt->indicator_type;
  WSCuchar _indicator_shadow_thick = dt->indicator_shadow_thickness;
  WSCbool  _indicator_on = dt->indicator_on;
  short    _indicator_pixmap = dt->indicator_pixmap;
  short    _indicator_color = dt->indicator_color;


  WSCstring str;
  if (_press_status == False){
    str.setString( _label_string );
  }else{
    if (_select_string == NULL){
      str.setString( _label_string );
    }else{
      if (_select_string[0] == 0 ){
        str.setString( _label_string );
      }else{
        str.setString( _select_string );
      }
    }
  }
  if (_orientation == WS_VERTICAL) {
    WSGFcreateVerticalString(&str);
  } else {
    str.replaceString("\\n", "\n", 0);
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return;
  }

  _this->WSCbase::update();
  _this->setAbsoluteDraw(False);

  if (_rv_fl == True) {
    if (blinking  != False &&
        blinkfore != False &&
        blinktype != WS_FORE ){
      dev->setForeColor(blinkcolorno);
    } else {
      dev->setForeColor(fgno);
    }
  } else {
    if (blinking  != False &&
        blinkfore != False &&
        blinktype != WS_FORE ){
      dev->setForeColor(backblinkno);
    } else {
      dev->setForeColor(bgno);
    }
  }

  if (_grad_no == 0){
    dev->drawFillRect(0, 0, w, h);
  }else{
    if (_press_status == True  && _indicator_on == False){
      dev->drawGradation(_grad_no,tsno,bgno,bsno,0, 1, w, h,_grad_margin);
    }else{
      dev->drawGradation(_grad_no,tsno,bgno,bsno,0, 0, w, h,_grad_margin);
    }
  }

  short offsetx = 0;
  short left_margin = _margin_left;
  short right_margin = _margin_right;
  short top_margin    = _margin_top;
  short bottom_margin = _margin_bottom;

  if (_indicator_on == True) {
    offsetx = _indicator_size;
  }
  short sx = st + left_margin + offsetx;
  short sy = st + top_margin;
  short sw = 0;
  short sh = 0;
  if ( w > offsetx + st * 2){
    sw = w -offsetx -st * 2;
  }
  if ( sw < left_margin + right_margin ){
    sw = 1;
  }else{
    sw = sw - left_margin - right_margin;
  }

  if ( h > st * 2){
    sh = h - st * 2;
  }

  if (sh < top_margin + bottom_margin){
    sh = 1;
  }else{
    sh = sh - top_margin - bottom_margin;
  }
  WSDimage* image;
  if (blinking  != False &&
      blinktype != WS_BACK &&
      blinkfore != False ){
    if (_blink_pixmap != -1 && twinblink != False){
      image = WSGIappImageSet()->getImage(_blink_pixmap);
      short dy = sy;
      if (_press_status == True  && _indicator_on == False){
        dy++;
      }
      dev->drawImage (sx, dy, sw, sh, image, _this->getAlignment());
    }
  } else {
    if ( _label_pixmap != -1){
      image = WSGIappImageSet()->getImage( _label_pixmap );
      short dy = sy;
      if (_press_status == True  && _indicator_on == False){
        dy++;
      }
      dev->drawImage (sx, dy, sw, sh, image, _this->getAlignment());
    }
  }
  if (_this->getSensitive() == False ||
      (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0)){
    if (_emboss != False){
      if (_bl_fl != False &&
        blinkfore != False &&
        _bl_type != WS_BACK &&
        _tw_fl != False) {
        dev->setForeColor(blinkcolorno);
      } else {
        dev->setForeColor(tsno);
      }
      dev->setBackColor(bgno);

      if (blinking  != False &&
          blinktype != WS_BACK &&
          blinkfore != False &&
          twinblink == False){
      }else{
        if (twinblink == False || blinking == False){
          dev->drawString(sx+1, sy+1, sw, sh,
                      &str, _font, _this->getAlignment(), -1, False);
        }
      }
    }else{
      dev->setHatchPattern(8);
    }
  } else {
    dev->setHatchPattern(0);
  }

  if (_indicator_on == True){
     offsetx = _indicator_size;
  }
  if (_rv_fl == True) {
    if (_bl_fl == True &&
        blinkfore == True &&
        _bl_type != WS_BACK &&
        _tw_fl == True){
      dev->setForeColor(_bg_blink_color);
    }else{
      if ( _emboss != False && (_this->getSensitive() == False ||
          (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
        dev->setForeColor(_bs_color);
      } else {
        dev->setForeColor(_back_color);
      }
    }
  } else {
    if (_bl_fl == True &&
        blinkfore == True &&
        _bl_type != WS_BACK &&
        _tw_fl == True){
      dev->setForeColor(_blink_color);
    }else{
      if ( _emboss != False && (_this->getSensitive() == False ||
          (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
         dev->setForeColor(_bs_color);
      }else{
         dev->setForeColor(_fore_color);
      }
    }
  }
  if (sw != 0 && sh != 0){

    if (_bl_fl  != False &&
        _bl_type != WS_BACK &&
        blinkfore != False &&
        _tw_fl == False){
        // 褷ʤ
    }else{


      if (_press_status == True  && _indicator_on == False){
        dev->drawString(sx ,sy  +1,
                        sw ,sh, &str, _font, _this->getAlignment(), -1, False);
      }else{
        dev->drawString(sx, sy, sw, sh,
                      &str, _font, _this->getAlignment(), -1, False);
      }

      //եΥ饤
      // եưݤĤξΤ
      if (_this->getFocus() == True && _enable_focus_move == True){
        dev->setLineWidth( 1 );
        dev->setLineDashType( 8 );
        if (w > 4 + st*2 && h > 4 + st*2){
          if (_indicator_on == False){
            if (_press_status == True ){
              dev->drawRect(st+2, st+3, w-st*2-4, h-st*2-4);
            }else{
              dev->drawRect(st+2, st+2, w-st*2-4, h-st*2-4);
            }
          }else{
            WSCushort ww = 0;
            if ( w > offsetx + st * 2 +4 + left_margin/2){
              ww = w -offsetx -st * 2 -4 - left_margin/2;
            }
            if (ww >0 && (long)h-(long)st*2 -4 > 0){
              dev->drawRect(st+left_margin/2+2+_indicator_size, st+2, ww, h -st*2 -4);
            }
          }
        }
      }

    }
  }
  if (_indicator_on == True){
//    char itype = _indicator_type;
    WSCushort isize = _indicator_size;
    short ypos = (h - isize)/2;
    short xpos = st + left_margin /2;
    if (h < isize){
      ypos = 0;
    }

    if (_unique == 0){
#if 0
      dev->setForeColor(_indicator_color);
      dev->drawFillRect(xpos, ypos, isize, isize);
#endif
      short ts1 = WSGFgetFixedColor(_indicator_color,32);
      short bs1 = WSGFgetFixedColor(_indicator_color,-32);
      dev->drawGradation(WS_GR_RB_LT,ts1,
                         _indicator_color,bs1,
                         xpos, ypos, isize, isize, isize/2);

      if (_press_status == True ){
        dev->setForeColor(_select_color);
        long iw = isize -st*2;
        WSCpoint pt[6];
#if 0
        pt[0].x = xpos + _shadow_thick + iw/4;
        pt[0].y = ypos + _shadow_thick + iw/4;
        pt[1].x = xpos + _shadow_thick;
        pt[1].y = ypos + _shadow_thick + iw/2;
        pt[2].x = xpos + isize/2;
        pt[2].y = ypos + isize - _shadow_thick;
        pt[3].x = xpos + isize - _shadow_thick;
        pt[3].y = ypos + _shadow_thick;
        pt[4].x = xpos + isize/2;
        pt[4].y = ypos + isize/2;
#endif

#if 0
        long xpos1 = xpos;
        long ypos1 = ypos +1;
        pt[0].x = xpos1 + _shadow_thick + iw*1/8;
        pt[0].y = ypos1 + _shadow_thick + iw*3/8 -2;
        pt[1].x = xpos1 + _shadow_thick + iw*1/8;
        pt[1].y = ypos1 + _shadow_thick + iw*5/8 -1;
        pt[2].x = xpos1 + _shadow_thick + iw*3/8;
        pt[2].y = ypos1 + _shadow_thick + iw*6/8 +1;
        pt[3].x = xpos1 + _shadow_thick + iw*7/8 +1;
        pt[3].y = ypos1 + _shadow_thick + iw*3/8;
        pt[4].x = xpos1 + _shadow_thick + iw*7/8 +1;
        pt[4].y = ypos1 + _shadow_thick + iw*1/8 -1;
        pt[5].x = xpos1 + _shadow_thick + iw*3/8;
        pt[5].y = ypos1 + _shadow_thick + iw*4/8;

        dev->drawFillPoly(pt,6);
#endif
#if 0
        long margin = iw /6;
        dev->drawFillRect(xpos + _shadow_thick +margin,
                          ypos + _shadow_thick +margin,
                          iw - margin*2,
                          iw - margin*2);
#endif
        long margin = iw /3;
        long i;
        dev->setLineDashType(0); 
        dev->setLineWidth(1); 
        for(i=0; i<margin; i++){
          dev->drawLine( xpos + _shadow_thick + iw*1/8,
                         ypos + _shadow_thick + iw*4/8 + i,
                         xpos + _shadow_thick + iw*3/8,
                         ypos + _shadow_thick + iw*5/8 + i);
          dev->drawLine( xpos + _shadow_thick + iw*3/8,
                         ypos + _shadow_thick + iw*5/8 + i,
                         xpos + _shadow_thick + iw*7/8,
                         ypos + _shadow_thick + iw*1/8 + i);

        }
      }

      WSGFdrawModern1Shadow(dev, WS_SHADOW_IN, _shadow_thick,
                   _fore_color, _ts_color, _bs_color,_back_color,_back_color,
                   xpos, ypos , isize, isize,False);
    }else{
      short ts1 = WSGFgetFixedColor(_back_color,16);
      short bs1 = WSGFgetFixedColor(_back_color,-16);


      dev->setHatchPattern((char)0);
      dev->setForeColor(ts1);
      dev->drawFillArc(xpos,ypos,isize,isize,240*64,180*64,WS_ARC_PIE);

      dev->setForeColor(bs1);
      dev->drawFillArc(xpos,ypos,isize,isize,60*64,180*64,WS_ARC_PIE);

      dev->setForeColor(_bs_color);
      dev->drawFillArc(xpos+_shadow_thick -1,ypos+_shadow_thick -1,
                       isize - _shadow_thick*2 +2,
                       isize - _shadow_thick*2 +2,0*64,360*64,WS_ARC_PIE);

      dev->setForeColor(_indicator_color);
      dev->drawFillArc(xpos+_shadow_thick,ypos+_shadow_thick,
                       isize - _shadow_thick*2,
                       isize - _shadow_thick*2,0*64,360*64,WS_ARC_PIE);

      if (_press_status == True ){
        dev->setForeColor(_select_color);
        dev->drawFillArc(xpos+_shadow_thick*2,
                         ypos+_shadow_thick*2,
                         isize - _shadow_thick*4,
                         isize - _shadow_thick*4,0*64,360*64,WS_ARC_PIE);
      }
    }
  }

  dev->endDraw();
}
void WSCoption_draw_mdr1(void* ptr){
  WSCoption_draw_struct* dt = (WSCoption_draw_struct*)ptr;

  WSCbool absolute = dt->_this->getAbsoluteDraw();
  WSCoption* _this = dt->_this;
  WSDdev* dev = dt->dev;

  short x = dt->x;
  short y = dt->y;
  WSCushort w = dt->width;
  WSCushort h = dt->height;

  long _bl_fl   = dt->blinking;
  long _tw_fl  = dt->twin_blink;
  long _bl_type  = dt->blink_type;
  short _fore_color  = dt->fore_color;
  short _back_color  = dt->back_color;
  short _blink_color = dt->blink_color;
  short _bg_blink_color  = dt->back_blink_color;
  short _ts_color    = dt->top_shadow_color;
  short _bs_color    = dt->bottom_shadow_color;

  char* _label_string = dt->label_string;
  short _label_pixmap = dt->label_pixmap;
  short _blink_pixmap = dt->blink_pixmap;
  short _press_state = dt->press_state;
  long  _grad_no = dt->gradation;
  long  _grad_margin = dt->gradation_margin;
  long  _margin_left = dt->margin_left;
  long  _margin_right = dt->margin_right;
  long  _margin_top = dt->margin_top;
  long  _margin_bottom = dt->margin_bottom;
  WSCbool  _emboss = dt->emboss;
  WSCuchar _font = dt->font;
  WSCbool  _rv_fl = dt->reverse_flag;

  WSCushort st    = dt->shadow_thickness;
  long blinking   = _bl_fl;
  long shadowtype = dt->shadow_type;
  long blinkfore  = dt->blink_fore;
  long blinktype  = _bl_type;
  long reverse    = _rv_fl;
  long twinblink  = _tw_fl;
  short fgno      = _fore_color;
  short bgno      = _back_color;
  short blno      = _blink_color;
  short blbgno    = _bg_blink_color;
  short tsno      = _ts_color;
  short bsno      = _bs_color;
  WSCbool bldraw  = (blinking != False && blinkfore != False);
  char  align     = _this->getAlignment();

  long er = dev->beginDraw(x, y, w, h, absolute);
  if (er != WS_NO_ERR){
    return;
  }

  _this->WSCbase::update();
  _this->setAbsoluteDraw(False);

  WSCstring  str(_label_string);
  str.replaceString("\\n", "\n", 0);

  WSCushort margin_left   = _margin_left;
  WSCushort margin_right  = _margin_right;
  WSCushort margin_top    = _margin_top;
  WSCushort margin_bottom = _margin_bottom;
  short sx = st + margin_left;
  short sy = st + margin_top;

  short sw = 0;
  if ( w > st*2 + margin_left + margin_right + 23){
    sw = w - st*2 - margin_left - margin_right - 23;
  }

  short sh = 0;
  if ( h > st*2 + margin_top + margin_bottom){
    sh = h -st*2 - margin_top - margin_bottom;
  }

  if (reverse != False) {
    if (blinktype != WS_FORE && bldraw && twinblink != False) {
      dev->setForeColor(blno);
      dev->setBackColor(blbgno);
    } else {
      dev->setForeColor(fgno);
      dev->setBackColor(bgno);
    }
  } else {
    if (blinktype != WS_FORE && bldraw && twinblink != False) {
      dev->setForeColor(blbgno);
      dev->setBackColor(blno);
    } else {
      dev->setForeColor(bgno);
      dev->setBackColor(fgno);
    }
  }
  if (_grad_no == 0){
    short ts1 = WSGFgetFixedColor(bgno,32);
    short bs1 = WSGFgetFixedColor(bgno,-32);

    if (dt->shadow_thickness != 0){
      if (dt->press_state == False) {
        dev->drawGradation(WS_GR_T_B,ts1,
                         bgno,bs1,0, 1,
                         dt->width, dt->height,dt->height*2/3);
      }else{
        dev->setForeColor(bs1);
        dev->drawFillRect(0, 0, w, h);
      }
    }else{
      dev->drawFillRect(0, 0, w, h);
    }
//    dev->drawFillRect(st, st, w-st*2, h-st*2);
  }else{
    dev->drawGradation(_grad_no,tsno,bgno,bsno,st, st, w-st*2, h-st*2,_grad_margin);
  }

  WSDimage* image;
  if (bldraw && blinktype != WS_BACK ){
    if (_blink_pixmap != -1 && twinblink != False){
      image = WSGIappImageSet()->getImage(_blink_pixmap);
      dev->drawImage (sx, sy, sw, sh, image, align);
    }
  }else{
    if (_label_pixmap != -1){
      image = WSGIappImageSet()->getImage(_label_pixmap);
      dev->drawImage (sx, sy, sw, sh, image, align);
    }
  }

  if (st > 0) {
    char    type = WS_SHADOW_OUT;
    if (_press_state != False) {
      type = WS_SHADOW_IN;
    }
    if (_this->getSensitive() == False ||
       (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0)){
      type = WS_SHADOW_OUT;
    }
    short pbgno = WSGFgetParentBackColor(_this);
    if (_grad_no == 0){
      WSGFdrawModern1BtnShadow(dev, type, st, fgno, tsno, bsno, bgno, pbgno,
                          0, 0, w, h, False,False);
    }else{
      WSGFdrawModern1BtnShadow(dev, type, st, fgno, tsno, bsno, bgno, pbgno,
                          0, 0, w, h, False,True);
    }
  }

  if ( _this->getSensitive() == False ||
       (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0)){
    if (_emboss != False){
      if (bldraw && blinktype != WS_BACK && twinblink != False) {
        dev->setForeColor(blno);
      } else {
        dev->setForeColor(tsno);
      }
      dev->setBackColor(bgno);

      if (bldraw && blinktype != WS_BACK && twinblink == False){
      }else{
        if (twinblink == False || blinking == False){
          dev->drawString(sx+1, sy+1, sw, sh, &str, _font, align, -1, False);
        }
      }
    }else{
      dev->setHatchPattern(8);
    }
  }else{
    dev->setHatchPattern(0);
  }

  if (reverse != False) {
    if (bldraw && blinktype != WS_BACK && twinblink != False) {
      dev->setForeColor(blbgno);
    } else {
      if( _emboss != False && (_this->getSensitive() == False ||
          (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
        dev->setForeColor(bsno);
      }else{
        dev->setForeColor(bgno);
      }
    }
    dev->setBackColor(fgno);
  }else{
    if(bldraw && blinktype != WS_BACK && twinblink != False) {
      dev->setForeColor(blno);
    }else{
      if ( _emboss != False && (_this->getSensitive() == False ||
        (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
        dev->setForeColor(bsno);
      }else{
        dev->setForeColor(fgno);
      }
    }
    dev->setBackColor(bgno);
  }
  if ( !(bldraw && blinktype != WS_BACK && twinblink == False) ){
    dev->drawString(sx, sy, sw, sh, &str, _font, align, -1, False);
  }

  if (st + 23 < w ){
    WSGFdrawShadow(dev, WS_SHADOW_OUT, 2, fgno, tsno,bsno,bgno,
                   w-23 -st, (h-7)/2, 15, 7);
  }
  dev->endDraw();

}
void WSCpopupFrame_draw_mdr1(void* ptr){
  WSCpopupFrame_draw_struct* dt = (WSCpopupFrame_draw_struct*)ptr;
  
  WSCpopupFrame* _this = dt->_this;
  WSCbool absolute = _this->getAbsoluteDraw();
  WSDdev* dev = dt->dev; 

  WSCushort st = dt->shadow_thickness;
  long err = dev->beginDraw(0,0,dt->width,dt->height,absolute);
  if (err != WS_NO_ERR){
    return;
  }

  dt->_this->WSCbase::update();
  dt->_this->setAbsoluteDraw(False);

  short x = dt->x;
  short y = dt->y;
  WSCushort w = dt->width;
  WSCushort h = dt->height;
  short _x = dt->x;
  short _y = dt->y;
  WSCushort _w = dt->width;
  WSCushort _h = dt->height;

  short _fg_no = dt->fore_color;
  short _bg_no = dt->back_color;
  short _ts_no = dt->top_shadow_color;
  short _bs_no = dt->bottom_shadow_color;
  short _back_pixmap = dt->back_pixmap;
  long _shadow_type  = dt->shadow_type;
  char* _menu_str    = dt->menu_str;
  long _font         = dt->font;
  WSCbool _emboss        = dt->emboss;
  WSCushort _item_height = dt->item_height;
  WSCbool* _status_array = dt->status_array;

  short px, py;
  WSGIappMouse()->getMousePosition(&px, &py);

  dev->setForeColor(_bg_no);
  dev->drawFillRect(0, 0, w, h);

  if (st > 1){
    WSGFdrawModern1Shadow(dev, _shadow_type, st,
                        _fg_no,_ts_no,_bs_no,_bg_no,_bg_no,
                        0, 0, w, h,False);
  }else if (st == 1){
    dev->setForeColor(_bs_no);
    dev->drawRect(0,0,w,h);
  }    

  WSCstring str(_menu_str);
  str.replaceString(",", "\n", 0);

  _this->set_value_effective(False);

  short posy = st;
  long i;
  long num = str.getWords("\n");
  for(i=0; i < num; i++){
    WSCstring sect = str.getWord(i, "\n");
    sect.replaceString(":", "\n", 0);
    WSCstring sect_str = sect.getWord(0, "\n");

    if (_status_array[i] == False) {
      if (_emboss != False){
        dev->setForeColor(_ts_no);
        dev->drawString(st*2+3, posy +st+1, w -st*4 -2, _item_height -st*2,
                 &sect_str, _font, WS_LEFT, -1, False);
      }else{
        dev->setHatchPattern(8);
      }
    }else{
      dev->setHatchPattern(0);
    }
    if (_x < px && px < _x +_w && _y + posy < py &&
         py < _y + posy + _item_height){
      if (_status_array[i] != False) {
        dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTCOLOR));
        dev->drawFillRect( st+1,posy +1,_w -st*2 -2,_item_height-2);
      }
    }
    if (_emboss != False && _status_array[i] == False){
      dev->setForeColor(_bs_no);
    }else{
      dev->setForeColor(_fg_no);
    }
    if (_x < px && px < _x +_w && _y + posy < py &&
         py < _y + posy + _item_height){
      if (_status_array[i] != False) {
        dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTFORECOLOR));
      }
    }
    dev->drawString(st*2+2, posy +st, _w -st*4 -2, _item_height -st*2,
          &sect_str, _font, WS_LEFT, -1, False);
    if (_x < px && px < _x +_w && _y + posy < py &&
         py < _y + posy + _item_height){
      _this->set_value(0);
      WSCstring sect_value = sect.getWord(1, "\n");
      _this->set_value(atoi(sect_value.getString()));
      _this->set_value_effective(True);
    }else{
      WSGFdrawShadow(dev, _shadow_type, st,
         _bg_no, _bg_no, _bg_no,_bg_no,st, posy, _w-st*2, _item_height,True);
    }
    posy += _item_height;
  }
  dev->endDraw();
  return;
}

class _gui_policy_register_{
  public: _gui_policy_register_(){
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCvbtn::draw",WSCvbtn_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCform::draw",WSCform_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCvtoggle::draw",WSCvtoggle_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCvradio::draw",WSCvradio_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCoption::draw",WSCoption_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCpopupFrame::draw",WSCpopupFrame_draw_mdr1);
  }
};

static _gui_policy_register_ _run_register;

