//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvscrBar.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDtimer.h>
#include <WSDimage.h>
#include <WSCimageSet.h>
#include <WSCbaseList.h>
#include <WSDappDev.h>
#include <WSDmwindowDev.h>


WSMFguiClassInitialize(WSCvscrBar,WSCnwbase);
WSMFversion(WSCvscrBar,WSCnwbase);

WSCvscrBar::WSCvscrBar(WSCbase* base,char* objname):
                WSCnwbase(base,objname){

  _bar_status = WS_OVER;
//  _out_side_mouse_release = True;
  _out_side_mouse_move = True;
  _btn_x_bk =0;
  _btn_y_bk =0;
  _value_bk =0;
  _timer_id = 0;
  _maximum = 1000;
  _bp_no = -1;
 
  _shadow_thick = 2;
//  _bg_no  = WSGFcolor("gray85");
//  _bg2_no = WSGFcolor("gray75");
//  _ts_no  = WSGFcolor("gray95");
//  _bs_no  = WSGFcolor("gray65");
  _bg_no  = WS_DF_NWBACKCOLOR;
  _bg2_no = WS_DF_BARSHADOWCOLOR;
  _ts_no  = WS_DF_NWTOPSHADOWCOLOR;
  _bs_no  = WS_DF_NWBOTTOMSHADOWCOLOR;
  _slider_size  = 100;
  _increment    = 10;
  _page_increment = 30;
  _value          = 0;
  _orientation    = WS_HORIZONTAL;
  _grad_on = 0;
  _mask_images = NULL;
  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvscrBar);

    WSMFpropertyCreate(WSNshadowThickness,WSCuchar, _shadow_thick,WSSshadowThickness );
    WSMFpropertyCreate(WSNbackColor, short,    _bg_no,WSSbackColor  );
    WSMFpropertyCreate(WSNbarShadowColor,short, _bg2_no,WSSbarShadowColor );
    WSMFpropertyCreate(WSNtopShadowColor, short,  _ts_no,WSStopShadowColor );
    WSMFpropertyCreate(WSNbottomShadowColor,short, _bs_no,WSSbottomShadowColor );
    WSMFpropertyCreate(WSNsliderSize, WSCulong, _slider_size,WSSsliderSize );
    WSMFpropertyCreate(WSNmaximum,  WSCulong, _maximum,WSSmaximum  );
    WSMFpropertyCreate(WSNincrement,    WSCushort, _increment,WSSincrement);
    WSMFpropertyCreate(WSNpageIncrement, WSCushort, _page_increment,WSSpageIncrement);
    WSMFpropertyCreate(WSNvalue,  WSCulong, _value,WSSvalue );
    WSMFpropertyCreate(WSNorientation,WSCuchar, _orientation,WSSorientation );
      WSMFpropertySetSelection(WSRorientation,WSRorientationD);
    WSMFpropertyCreate(WSNbackPixmap, short, _bp_no,WSSbackPixmap  );
    WSMFpropertyCreate(WSNgradation, WSCbool, _grad_on,WSSgradation2 );
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);

    WSMFpropertyDelete(WSNblinkFlag);
    WSMFpropertyDelete(WSNblinkRate);
    WSMFpropertyDelete(WSNtwinBlink);
    WSMFpropertyDelete(WSNblinkColor);
    WSMFpropertyDelete(WSNblinkRefreshing);

    WSMFaddTrigger(WSEV_VALUE_CH  );
    WSMFaddTrigger(WSEV_ACTIVATE );

    WSMFdelTrigger(WSEV_MOUSE_MOVE  );
    WSMFdelTrigger(WSEV_MOUSE_PRESS   );
    WSMFdelTrigger(WSEV_MOUSE_RELEASE );

    WSMFaddExtTrigger(WSEV_BEGIN,"BEGIN" );
    WSMFaddExtTrigger(WSEV_END,"END" );
    WSMFaddExtTrigger(WSEV_INCREMENT,"INCREMENT" );
    WSMFaddExtTrigger(WSEV_PAGE_INCREMENT,"PAGE-INCREMENT" );
    WSMFaddExtTrigger(WSEV_DECREMENT,"DECREMENT" );
    WSMFaddExtTrigger(WSEV_PAGE_DECREMENT,"PAGE-DECREMENT" );

  WSMFpropertyCreateEnd
}

WSCvscrBar::~WSCvscrBar(){
  WSGIappObjectList()->delEvent(this,WSEV_GUI_POLICY_CH);
}

//ץѥƥѥץκ
WSMFproperty( WSCvscrBar, WSNshadowThickness,   WSCuchar, _shadow_thick,2             );
//WSMFproperty( WSCvscrBar, WSNbackColor,         short,  _bg_no   ,WSGFcolor("gray85") );
//WSMFproperty( WSCvscrBar, WSNbarShadowColor,    short,  _bg2_no  ,WSGFcolor("gray75") );
//WSMFproperty( WSCvscrBar, WSNtopShadowColor,    short,  _ts_no   ,WSGFcolor("gray95") );
//WSMFproperty( WSCvscrBar, WSNbottomShadowColor, short,  _bs_no   ,WSGFcolor("gray65") );
WSMFproperty( WSCvscrBar, WSNbackColor,         short,  _bg_no   ,WS_DF_NWBACKCOLOR);
WSMFproperty( WSCvscrBar, WSNbarShadowColor,    short,  _bg2_no  ,WS_DF_BARSHADOWCOLOR);
WSMFproperty( WSCvscrBar, WSNtopShadowColor,    short,  _ts_no   ,WS_DF_NWTOPSHADOWCOLOR);
WSMFproperty( WSCvscrBar, WSNbottomShadowColor, short,  _bs_no   ,WS_DF_NWBOTTOMSHADOWCOLOR);
WSMFproperty( WSCvscrBar, WSNsliderSize,        WSCulong, _slider_size     ,100       );
WSMFproperty( WSCvscrBar, WSNmaximum,           WSCulong, _maximum         ,1000      );
WSMFproperty( WSCvscrBar, WSNincrement,         WSCushort, _increment       ,10        );
WSMFproperty( WSCvscrBar, WSNpageIncrement,     WSCushort, _page_increment  ,30        );
WSMFproperty( WSCvscrBar, WSNvalue,             WSCulong, _value           ,0         );
WSMFproperty( WSCvscrBar, WSNorientation,       WSCuchar,  _orientation     ,WS_HORIZONTAL   );
WSMFproperty(WSCvscrBar, WSNbackPixmap,        short,_bp_no    ,-1    );
WSMFproperty(WSCvscrBar, WSNgradation,        WSCbool,_grad_on    ,0    );

void WSCvscrBar::setWorkWSNgradation(WSCbool){ }
void WSCvscrBar::getWorkWSNgradation(WSCbool*){ }
void WSCvscrBar::setWorkWSNbackPixmap(short){ }
void WSCvscrBar::getWorkWSNbackPixmap(short*){ }
void WSCvscrBar::setWorkWSNshadowThickness(WSCuchar){ }
void WSCvscrBar::getWorkWSNshadowThickness(WSCuchar*){ }
void WSCvscrBar::setWorkWSNbackColor(short){ }
void WSCvscrBar::getWorkWSNbackColor(short*){ }
void WSCvscrBar::setWorkWSNbarShadowColor(short){ }
void WSCvscrBar::getWorkWSNbarShadowColor(short*){ }
void WSCvscrBar::setWorkWSNtopShadowColor(short){ }
void WSCvscrBar::getWorkWSNtopShadowColor(short*){ }
void WSCvscrBar::setWorkWSNbottomShadowColor(short){ }
void WSCvscrBar::getWorkWSNbottomShadowColor(short*){ }
void WSCvscrBar::setWorkWSNsliderSize(WSCulong size){
  WSCulong v = _value;
  if (_maximum < size + _value){
    long val = _maximum - size;
    if (val < 0){
       val = 0;
       _slider_size = _maximum;
    }
    _value = val;
    if (v != _value){
      onValueChange();
    }
  }
}
void WSCvscrBar::getWorkWSNsliderSize(WSCulong*){ }
void WSCvscrBar::setWorkWSNmaximum(WSCulong max){
  if (max == 0){
    max = 1;
  }
  if (max < _slider_size + _value){
    long val = max - _slider_size;
    if (val < 0){
       val = 0;
       _slider_size = max;
    }
    _value = val;
  }
  _maximum = max;
}
void WSCvscrBar::getWorkWSNmaximum(WSCulong*){}
void WSCvscrBar::setWorkWSNincrement(WSCushort){}
void WSCvscrBar::getWorkWSNincrement(WSCushort*){}
void WSCvscrBar::setWorkWSNpageIncrement(WSCushort){}
void WSCvscrBar::getWorkWSNpageIncrement(WSCushort*){}
void WSCvscrBar::setWorkWSNvalue(WSCulong value){
  if ((value+_slider_size) > _maximum) {
    long val = _maximum - _slider_size;
    if (val < 0) {
      val = 0;
    }
    _value = (WSCushort)val;
  }
  if (getInitialized() != False){
    onValueChange();
  }
}
void WSCvscrBar::getWorkWSNvalue(WSCulong*){}
void WSCvscrBar::setWorkWSNorientation(WSCuchar){}
void WSCvscrBar::getWorkWSNorientation(WSCuchar*){}

void WSCvscrBar::_timer_work(WSCuchar clock,void* data){
  WSCvscrBar* obj = (WSCvscrBar*)data;

  if (obj->_timer_on == False){
    obj->_timer_on = True;
    obj->_clock_bk = clock;
    return;
  }
  //execute 2 seconds after...
  if (clock - obj->_clock_bk  > 2){
    if (obj->_bar_status == WS_BBTN2){
      if (obj->_value < obj->_increment){
        obj->_value = 0;
      } else{
        obj->_value -= obj->_increment;
      }
       obj->onDecrement();
     } else if (obj->_bar_status == WS_BBTN3){
       obj->_value += obj->_increment;
       if (obj->_value > obj->_maximum - obj->_slider_size){
         obj->_value = obj->_maximum - obj->_slider_size;
       }
       obj->onIncrement();
    } else if (obj->_bar_status == WS_INTER1){
      if (obj->_value < obj->_page_increment){
        obj->_value = 0;
      } else {
        obj->_value -= obj->_page_increment;
      }
      obj->onPageDecrement();
    } else if (obj->_bar_status == WS_INTER2){
      obj->_value += obj->_page_increment;
      if (obj->_value > obj->_maximum - obj->_slider_size){
        obj->_value = obj->_maximum - obj->_slider_size;
      }
      obj->onPageIncrement();
    }
    obj->onValueChange();
    obj->setAbsoluteDraw(True);
    obj->draw();
  }
}

long WSCvscrBar::execEventProc(long ev,void* data){
  short x = _x;
  short y = _y;

  if (ev == WSEV_MOUSE_PRESS){
    WSCpoint* point = (WSCpoint*)data;
    _btn_x_bk = point->x -x;
    _btn_y_bk = point->y -y;
  }
  return WSCnwbase::execEventProc(ev,data);
}

void WSCvscrBar::onMousePress(WSCpoint* point){
  if (getSensitive() == False){
    WSCbase::onMousePress(point);
    return;
  }
  _out_side_mouse_release = True;

  WSCushort w = _w;
  WSCushort h = _h;

  _bar_status =  _bar_in(point->x,point->y,0,0, w ,h, _shadow_thick);

  if (_bar_status == WS_BAR){
    _value_bk = _value;
  }
  if (_bar_status == WS_BBTN1){
    _value = 0;
    onBegin();
  }else if (_bar_status == WS_BBTN4){
    _value = _maximum - _slider_size;
    onEnd();
  }else if (_bar_status == WS_BBTN2){
    if (_value < _increment){
      _value = 0;
    }else{
      _value -= _increment;
    }
    onDecrement();
    _timer_on = False;
    _timer_id = WSGIappTimer()->addTimerProc(_timer_work,WS250MS,this);
  }else if (_bar_status == WS_INTER1){
    if (_value < _page_increment){
      _value = 0;
    }else{
      _value -= _page_increment;
    }
    onPageDecrement();
    _timer_on = False;
    _timer_id = WSGIappTimer()->addTimerProc(_timer_work,WS250MS,this);
  }else if (_bar_status == WS_BBTN3){
    _value += _increment;
    if (_value > _maximum - _slider_size){
      _value = _maximum - _slider_size;
    }
    onIncrement();
    _timer_on = False;
    _timer_id = WSGIappTimer()->addTimerProc(_timer_work,WS250MS,this);
  }else if (_bar_status == WS_INTER2){
    _value += _page_increment;
    if (_value > _maximum - _slider_size){
      _value = _maximum - _slider_size;
    }
    onPageIncrement();
    _timer_on = False;
    _timer_id = WSGIappTimer()->addTimerProc(_timer_work,WS250MS,this);
  }
  if (_bar_status  != 0 ){
    WSDdev* dev = getowndev();
    if (dev == NULL){
      return;
    }
    onValueChange();
    setAbsoluteDraw(True);
    draw();
  }
  WSCnwbase::onMousePress(point);
}

void WSCvscrBar::onMouseRelease(WSCpoint*){
  if (getSensitive() == False){
    return;
  }
  _out_side_mouse_release = False;

  if (_timer_id != 0){
     _timer_on = False;
     WSGIappTimer()->delTimerProc(_timer_id);
     _timer_id = 0;
  }
  if (_bar_status != WS_OVER){
    onActivate();
  }
  _bar_status = WS_OVER;
  setAbsoluteDraw(True);
  draw();
}

void WSCvscrBar::onMouseMove(WSCpoint* point){
  if (getSensitive() == False){
    return;
  }
  if (_bar_status == WS_BAR){
    WSCushort w = _w;
    WSCushort h = _h;

    WSCushort sw;
    long pt;
    if (_orientation == WS_HORIZONTAL){
      sw = w - h*3 +_shadow_thick * 6;
      pt = point->x - _btn_x_bk;
    }else{
      sw = h - w*3 +_shadow_thick * 6;
      pt = point->y - _btn_y_bk;
    }

    long pos;
    if ( _bar_status == WS_BAR ){
      pos = _value_bk + pt *(long)_maximum / sw;
      if ( pos > (long)(_maximum - _slider_size)){
        pos = _maximum - _slider_size;
      }
      if (pos < 0){
        pos = 0;
      }
      if (_value != (WSCulong)pos){
        _value = pos;
        onValueChange();
      }else{
        _value = pos;
      }
      setAbsoluteDraw(True);
      _draw_sl_bar();
    }
  }

}

void WSCvscrBar::onActivate(){
  execProcedure(WSEV_ACTIVATE);
}
void WSCvscrBar::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}
void WSCvscrBar::onBegin(){
  execProcedure(WSEV_BEGIN);
  execProcedure(WSEV_VALUE_CH);
}
void WSCvscrBar::onEnd(){
  execProcedure(WSEV_END);
  execProcedure(WSEV_VALUE_CH);
}
void WSCvscrBar::onIncrement(){
  execProcedure(WSEV_INCREMENT);
  execProcedure(WSEV_VALUE_CH);
}
void WSCvscrBar::onPageIncrement(){
  execProcedure(WSEV_PAGE_INCREMENT);
  execProcedure(WSEV_VALUE_CH);
}
void WSCvscrBar::onDecrement(){
  execProcedure(WSEV_DECREMENT);
  execProcedure(WSEV_VALUE_CH);
}
void WSCvscrBar::onPageDecrement(){
  execProcedure(WSEV_PAGE_DECREMENT);
  execProcedure(WSEV_VALUE_CH);
}

long WSCvscrBar::_device_initialize(){

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  dev->setEnableEventBit( WSEV_MOUSE_MOVE_BIT | WSEV_MOUSE_OUT_BIT |
                            WSEV_MOUSE_PRESS_BIT  | WSEV_MOUSE_RELEASE_BIT );

  WSCnwbase::_device_initialize();
  char fl = True;
  dev->setValue(WSDEV_USE_PIXMAP,&fl);

  return WS_NO_ERR;
}

long WSCvscrBar::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  if (_maximum < _slider_size + _value){
     long val = _maximum - _slider_size;
     if (val < 0){
       val = 0;
       _slider_size = _maximum;
     }
     _value = val;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute != False){

  }else if (dev->isExposed(x,y,w,h) == False ){
    return WS_NO_ERR;
  }
  if (WSGIappDev()->getExtGuiPolicySelected() != False){
    if (_ext_draw_proc == NULL){
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->
                               getExtGuiPolicyProc("WSCvscrBar::draw");
    }
    if (_ext_draw_proc != NULL){
      WSCvscrBar_draw_struct st;
      st._this = this;
      st.dev = dev;
      st.x = _x;
      st.y = _y;
      st.width = _w;
      st.height = _h;
      st.shadow_thickness = _shadow_thick;
      st.slider_size = _slider_size;
      st.maximum = _maximum;
      st.value = _value;
      st.bar_status = _bar_status;
      st.orientation = _orientation;
      st.fore_color   = _fore_color;
      st.back_color   = _bg_no;
      st.back_color2   = _bg2_no;
      st.top_shadow_color = _ts_no;
      st.bottom_shadow_color = _bs_no;
      st.back_pixmap = _bp_no;
      st.gradation = _grad_on;

      _ext_draw_proc(&st);
      return WS_NO_ERR;
    }
  }

  long err = dev->beginDraw(x,y,w,h,absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);

  WSCushort st = _shadow_thick;
  WSCushort st2 = _shadow_thick;
  x =0;
  y =0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    st = 0;
  }
  double bar_area_width  = w - h*3 + st*6;
  double bar_area_height = h - w*3 + st*6;

  dev->setForeColor( _bg2_no );
  if (_grad_on == False){
    dev->drawFillRect( 0,0,w,h);
  }else{
    dev->drawGradation( WS_GR_LT_RB,_ts_no,_bg_no,_bs_no,0-w/2,0-h/2,w*2,h*2,0);
  }

  if (_bp_no != -1){
    WSDimage* image = WSGIappImageSet()->getImage(_bp_no);
    dev->drawImage(0,0,0,0,w,h,image);
  }
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    WSGFdrawShadow(dev,WS_SHADOW_IN, st2, _fore_color, _ts_no,_bs_no, _bg_no, x,y,w,h);
  }
  long policy = WSGIappDev()->getGuiPolicy();

  if (_orientation == WS_HORIZONTAL){
    long ah = h/2;
    if (w > 2){
      if (w > 2  + st*2){
        WSCulong _slider_size_alt = _slider_size;
        long _value_alt = _value;
        if ((WSCulong)((double)bar_area_width * _slider_size /_maximum) < WS_MINIMUM_WIDTH ){
          if ( w-h*3 + st*6 != 0){
            _slider_size_alt  = (WSCulong)(WS_MINIMUM_WIDTH * _maximum / bar_area_width);
            if ( x +w +st*3 -h*3/2 < 
               x -st*3 +h*3/2 +(long)((double)bar_area_width * (_value+_slider_size_alt)/_maximum)){ 
              _value_alt = _maximum -_slider_size_alt;
            }
            if (_value_alt < 0){
              _value_alt = 0;
            }
          }
        }

        long   smallbtn_w  = h/2 -st*4;
        long   smallbtn_h  = h   -st*4;
        if (smallbtn_w < 1){
          smallbtn_w = 1;
        }
        if (smallbtn_h < 1){
          smallbtn_h = 1;
        }
        //btn left left
        dev->setForeColor( _bg_no );
        dev->drawFillRect( x + st*2 , y+st*2, smallbtn_w, smallbtn_h );
        WSGFdrawShadow(dev,_bar_status != WS_BBTN1 ?
                                         WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +st , y +st,
                   h/2 -st*2,
                   h -st*2 );

        //btn left
        dev->setForeColor( _bg_no );
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          if (_bar_status == WS_BBTN2){
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_bs_no, _ts_no, WS_LEFT,
                   x +h/2 -st,
                   y +st,
                   h -st*2,
                   h -st*2 );
          }else{
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_ts_no, _bs_no, WS_LEFT,
                   x +h/2 -st,
                   y +st,
                   h -st*2,
                   h -st*2);
          }
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->drawFillRect( x +h/2, y+st*2, smallbtn_h, smallbtn_h );
          WSGFdrawShadow(dev,_bar_status != WS_BBTN2 ?
                                           WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +h/2 -st,
                   y +st,
                   h -st*2,
                   h -st*2 );
          WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_LEFT,
                      x + h/2   + h/4 -st*2,
                      y + h/4,
                      ah,ah);
        }
        //bar
        if (policy & WS_POLICY_AQUA){
          WSCushort bw = (long)(x +w + st*3 -((double)h)*3/2 - (((double)bar_area_width) * (_maximum -_value_alt -_slider_size_alt) / _maximum )
                   -(x +((double)h)*3/2 -st*3 + (((double)bar_area_width) * _value_alt / _maximum )));
          WSCushort bh = h -st*2;
          if (_mask_images != NULL){
            WSCulong val = (WSCulong)((WSCulong)bw << 16 + bh);
            WSCulong val2 = (WSCulong)_mask_images[4];
            if (val != val2){
              delete _mask_images[0];
              delete _mask_images[1];
              delete _mask_images[2];
              delete _mask_images[3];
              delete _mask_images;
              _mask_images = NULL;
            }
          }
          if (_mask_images == NULL){
            _mask_images = new WSDmwindowDev*[5];
            _mask_images[0] = WSGFgetAquaImage(_ts_no,bw,bh,0);
            _mask_images[1] = WSGFgetAquaImage(WS_DF_AQUAFORECOLOR,bw,bh,0);
            _mask_images[2] = WSGFgetAquaImage(WS_DF_AQUAHIGHLIGHTCOLOR,bw,bh,0);
            _mask_images[3] = WSGFgetAquaMaskImage(bw,bh,0);
            _mask_images[4] = (WSDmwindowDev*)((WSCulong)((WSCulong)bw << 16 + bh));
          }
          short posx =  (short)(x +(double)h*3/2 -st*2 + (bar_area_width * _value_alt / _maximum ));
          short posy =  y +st*2;
//          if (_mouse_in != False){
//            _mask_images[2]->copyToWindowWithMask(dev,0,0,bw,bh,0,0,_mask_images[3]);
//          }else if (getFocus() != False){
          if (getFocus() != False){
            _mask_images[1]->copyToWindowWithMask(dev,0,0,bw,bh,posx,posy,_mask_images[3]);
          }else{
            _mask_images[2]->copyToWindowWithMask(dev,0,0,bw,bh,posx,posy,_mask_images[3]);
//            _mask_images[0]->copyToWindowWithMask(dev,0,0,bw,bh,posx,posy,_mask_images[3]);
          }
        }else{
          dev->setForeColor( _bg_no );
          dev->drawFillRect( (short)(x +(double)h*3/2 -st*2 + (bar_area_width * _value_alt / _maximum )),
                   y +st*2 ,
                   (WSCushort)(x +w + st*3 -st -(double)h*3/2 - ((double)bar_area_width * (_maximum -_value_alt -_slider_size_alt) / _maximum )
                    - (short)(x +(double)h*3/2 -st*2 + ((double)bar_area_width * _value_alt / _maximum ))), 
                   h -st*4 );

          long bwidth = (long)(x +w + st*3 -((double)h)*3/2 - (((double)bar_area_width) * (_maximum -_value_alt -_slider_size_alt) / _maximum )
            -(x +((double)h)*3/2 -st*3 + (((double)bar_area_width) * _value_alt / _maximum )));

          if (bwidth < 2){
            bwidth = 2;
          }
          WSGFdrawShadow(dev, WS_SHADOW_OUT,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   (WSCushort)(x +(double)h*3/2 -st*3 + (bar_area_width * _value_alt / _maximum )),
                   y +st , bwidth, h -st*2 );
        }
        //btn right
        dev->setForeColor( _bg_no );
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          if (_bar_status == WS_BBTN3){
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_bs_no, _ts_no, WS_RIGHT,
                   x +w +st*3 -h*3/2 ,
                   y +st,
                   h -st*2,
                   h -st*2 );
          }else{
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_ts_no, _bs_no, WS_RIGHT,
                   x +w +st*3 -h*3/2 ,
                   y +st,
                   h -st*2,
                   h -st*2 );
          }
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->drawFillRect( x +w + st*4 -h*3/2, y+st*2, smallbtn_h, smallbtn_h );
          WSGFdrawShadow(dev,_bar_status != WS_BBTN3 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +w +st*3 -h*3/2 ,
                   y +st,
                   h -st*2,
                   h -st*2 );
          WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_RIGHT,
                      x +w +st*2 -h*3/2 +h/4,
                      y +h/4,
                      ah,ah);
        }

        //btn right right
        dev->setForeColor( _bg_no );
        dev->drawFillRect( x +w + st*2 -h/2, y+st*2, smallbtn_w, smallbtn_h );
        WSGFdrawShadow(dev,_bar_status != WS_BBTN4 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +w +st -h/2 ,
                   y +st,
                   h/2 -st*2,
                   h -st*2 );
      }
    }
  }else{
    if (h > 2){
      long ah = w/2;
      if (h > 2  + st*2){
        WSCulong _slider_size_alt = _slider_size;
        long           _value_alt = _value;
        if ((WSCulong)(bar_area_height * _slider_size /_maximum) < WS_MINIMUM_WIDTH ){
          if ( h-w*3 + st*6 != 0){
            _slider_size_alt  = (WSCulong)(WS_MINIMUM_WIDTH * _maximum / bar_area_height);

            if ( y +h +st*3 -w*3/2 < 
                 y -st*3 +w*3/2 +(long)(bar_area_height * (_value+_slider_size_alt)/_maximum)){ 
               _value_alt = _maximum -_slider_size_alt;
            }
            if (_value_alt < 0){
              _value_alt = 0;
            }
          }
        }

        long   smallbtn_w  = w   -st*4;
        long   smallbtn_h  = w/2 -st*4;
        if (smallbtn_w < 1){
          smallbtn_w = 1;
        }
        if (smallbtn_h < 1){
          smallbtn_h = 1;
        }
         //btn up up
        dev->setForeColor( _bg_no );
        dev->drawFillRect( x + st*2 , y+st*2, smallbtn_w, smallbtn_h );
        WSGFdrawShadow(dev,_bar_status != WS_BBTN1 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +st , y +st,
                   w -st*2,
                   w/2 -st*2 );

        //btn up
        dev->setForeColor( _bg_no );
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          if (_bar_status == WS_BBTN2){
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_bs_no, _ts_no, WS_UP,
                   x +st ,
                   y -st + w/2,
                   w -st*2,
                   w -st*2 );
          }else{
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_ts_no, _bs_no, WS_UP,
                   x +st ,
                   y -st + w/2,
                   w -st*2,
                   w -st*2 );
          }
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->drawFillRect( x + st*2 , y+w/2, smallbtn_w, smallbtn_w );
          WSGFdrawShadow(dev,_bar_status != WS_BBTN2 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +st ,
                   y -st + w/2,
                   w -st*2,
                   w -st*2 );

          WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_UP,
                      x + w/4,
                      y + w/2 +w/4 -st*2,
                      ah,ah);
        }
        //bar
        if (policy & WS_POLICY_AQUA){
          WSCushort bw = w -st*2;
          WSCushort bh = (long)((y +h +st*3 - ((double)w)*3/2 - (((double)bar_area_height) * (_maximum -_value_alt - _slider_size_alt) / _maximum ))
                    -(y -st*3 + ((double)w)*3/2 + (((double)bar_area_height) * _value_alt / _maximum )));
          if (_mask_images != NULL){
            WSCulong val = (WSCulong)((WSCulong)bw << 16 + bh);
            WSCulong val2 = (WSCulong)_mask_images[4];
            if (val != val2){
              delete _mask_images[0];
              delete _mask_images[1];
              delete _mask_images[2];
              delete _mask_images[3];
              delete _mask_images;
              _mask_images = NULL;
            }
          }
          if (_mask_images == NULL){
            _mask_images = new WSDmwindowDev*[5];
            _mask_images[0] = WSGFgetAquaImage(_ts_no,bw,bh,0);
            _mask_images[1] = WSGFgetAquaImage(WS_DF_AQUAFORECOLOR,bw,bh,0);
            _mask_images[2] = WSGFgetAquaImage(WS_DF_AQUAHIGHLIGHTCOLOR,bw,bh,0);
            _mask_images[3] = WSGFgetAquaMaskImage(bw,bh,0);
            _mask_images[4] = (WSDmwindowDev*)((WSCulong)((WSCulong)bw << 16 + bh));
          }
          short posx = x +st;
          short posy = (short)(y -st*3 + (double)w*3/2 + ((double)bar_area_height * _value_alt / _maximum ));
          if (getFocus() != False){
            _mask_images[1]->copyToWindowWithMask(dev,0,0,bw,bh,posx,posy,_mask_images[3]);
          }else{
            _mask_images[2]->copyToWindowWithMask(dev,0,0,bw,bh,posx,posy,_mask_images[3]);
          }
        }else{

          dev->setForeColor( _bg_no );
          dev->drawFillRect(
                   x +st*2 ,
                   (short)(y -st*2 + (double)w*3/2 + (bar_area_height * _value_alt / _maximum )),
                   w -st*4,
                   (WSCushort)((y +h +st*3 -st - (double)w*3/2 - ((double)bar_area_height * (_maximum -_value_alt - _slider_size_alt) / _maximum ))
                      - (short)(y -st*2 + (double)w*3/2 + ((double)bar_area_height * _value_alt / _maximum ))) );
//printf("WSCvscrBar::draw val=%d max=%d\n",_value_alt,_maximum);

          long bheight = (long)((y +h +st*3 - ((double)w)*3/2 - (((double)bar_area_height) * (_maximum -_value_alt - _slider_size_alt) / _maximum ))
                    -(y -st*3 + ((double)w)*3/2 + (((double)bar_area_height) * _value_alt / _maximum )));

          if (bheight < 2){
            bheight = 2;
          }
          WSGFdrawShadow(dev, WS_SHADOW_OUT,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +st ,
                   (short)(y -st*3 + (double)w*3/2 + ((double)bar_area_height * _value_alt / _maximum )),
                   w -st*2, bheight);

        }
        //ܥ
        dev->setForeColor( _bg_no );
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          if (_bar_status == WS_BBTN3){
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_bs_no, _ts_no, WS_DOWN,
                   x +st,
                   y +h +st*3 -w*3/2 ,
                   w -st*2,
                   w -st*2 );
          }else{
            WSGFdrawArrow(dev, False,_shadow_thick*2,
                      _bg_no,_ts_no, _bs_no, WS_DOWN,
                   x +st,
                   y +h +st*3 -w*3/2 ,
                   w -st*2,
                   w -st*2 );
          }
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->drawFillRect( x + st*2 , y+h +st*4 -w*3/2, smallbtn_w, smallbtn_w );
          WSGFdrawShadow(dev,_bar_status != WS_BBTN3 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +st,
                   y +h +st*3 -w*3/2 ,
                   w -st*2,
                   w -st*2 );
          WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_DOWN,
                      x+w/4,
                      y+h +st*2 -w*3/2 + w/4,
                      ah,ah);
        }
        //ܥ󲼲
        dev->setForeColor( _bg_no );
        dev->drawFillRect( x + st*2 , y+h +st*2 -w/2, smallbtn_w, smallbtn_h );
        WSGFdrawShadow(dev,_bar_status != WS_BBTN4 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,
                   x +st,
                   y +h +st -w/2 ,
                   w -st*2,
                   w/2 -st*2 );

      }
    }
  }
  dev->endDraw();
  return WS_NO_ERR;
}

long WSCvscrBar::_bar_in(short px,short py,
                          short x,short y,
                          WSCushort w,WSCushort h,
                          WSCushort st){
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    st = 0;
  }
  if (_orientation == WS_HORIZONTAL){
    if (w > 2  + st*2){

       WSCulong _slider_size_alt = _slider_size;
       long _value_alt = _value;
       if ((WSCulong)((double)(w - h*3 +st*6) * _slider_size /_maximum) < 5 ){
          _slider_size_alt  = 5 * _maximum / (w - h*3 + st*6);
          if ( x +w +st*3 -h*3/2 < 
               x -st*3 +h*3/2 +(long)((double)(w - h*3 +st*6) * (_value+_slider_size_alt)/_maximum)){ 
             _value_alt = (long)((double)(w +st*6 -h*3) * _maximum /(w - h*3 + st*6))-_slider_size_alt;
          }
          if (_value_alt < 0){
            _value_alt = 0;
          }
       }

       if (x+ st < px && x +h/2 -st > px &&
           y+st < py && y +h -st > py){
             return WS_BBTN1;
       }
       if (x-st+h/2 < px && x +h*3/2 -st > px &&
           y+st < py && y +h -st > py){
             return WS_BBTN2;
       }
       if ( x +h*3/2 -st < px &&
           px < x -st*3 +h*3/2 +(long)((double)(w - h*3 +st*6) * _value_alt /_maximum) &&
           y+st < py && y +h -st > py){
             return WS_INTER1;
       }

       if (x -st*3 +h*3/2 +(long)((double)(w - h*3 +st*6) * _value_alt /_maximum) < px &&
           x -st*3 +h*3/2 +(long)((double)(w - h*3 +st*6) * (_value_alt +_slider_size_alt)/_maximum) > px &&
           y+st < py && y +h -st > py){
             return WS_BAR;
       }

       if (x -st*3 +h*3/2 +(long)((double)(w - h*3 +st*6) * (_value_alt +_slider_size_alt)/_maximum) < px &&
           px <x +w +st*3 -h*3/2 &&
           y+st < py && y +h -st > py){
             return WS_INTER2;
       } 

       if ( x +w +st*3 -h*3/2 < px && x +w +st -h/2 > px &&
           y+st < py && y +h -st > py){
             return WS_BBTN3;
       }

       if ( x +w +st -h/2 < px && x +w -st  > px &&
           y+st < py && y +h -st > py){
             return WS_BBTN4;
       }
    }

  }else{
    if (h > 2  + st*2){

       WSCulong _slider_size_alt = _slider_size;
       long _value_alt = _value;
       if ((WSCulong)((double)(h - w*3 +st*6) * _slider_size /_maximum) < 5 ){
          _slider_size_alt  = 5 * _maximum / (h - w*3 + st*6);
          if ( y +h +st*3 -w*3/2 < 
               y -st*3 +w*3/2 +(long)((double)(h - w*3 +st*6) * (_value+_slider_size_alt)/_maximum)){ 
             _value_alt = (long)((double)(h +st*6 -w*3) * _maximum /(h - w*3 + st*6))-_slider_size_alt;
          }
          if (_value_alt < 0){
            _value_alt = 0;
          }
       }

       if (y+st < py && y +w/2 -st > py &&
           x+st < px && x +w -st > px){
             return WS_BBTN1;
       }
       if (y-st+w/2 < py && y +w*3/2 -st > py &&
           x+st < px && x +w -st > px){
             return WS_BBTN2;
       }
       if (y +w*3/2 -st < py &&
           py < y -st*3 +w*3/2 +(long)((double)(h - w*3 +st*6) * _value_alt /_maximum  )&&
           x+st < px && x +w -st > px){
             return WS_INTER1;
       }

       if (y -st*3 +w*3/2 +(long)((double)(h - w*3 +st*6) * _value_alt /_maximum  ) < py &&
           y -st*3 +w*3/2 +(long)((double)(h - w*3 +st*6) * (_value_alt +_slider_size_alt)/_maximum ) > py &&
           x+st < px && x +w -st > px){
             return WS_BAR;
       }

       if (y -st*3 +w*3/2 +(long)((double)(h - w*3 +st*6) * (_value_alt +_slider_size_alt)/_maximum) < py &&
           py < y +h +st*3 -w*3/2 && 
           x+st < px && x +w -st > px){
           return WS_INTER2;
       }
 
       if ( y +h +st*3 -w*3/2 < py && y +h +st -w/2 > py &&
           x+st < px && x +w -st > px){
             return WS_BBTN3;
       }

       if ( y +h +st -w/2 < py && y +h -st  > py &&
           x+st < px && x +w -st > px){
             return WS_BBTN4;
       }
    }
  }
  return WS_OVER;
}

long WSCvscrBar::_draw_sl_bar(){
  //ԥޥåˤʤäΤɬפʤʤä
  draw();
  return WS_NO_ERR;
}
WSCulong WSCvscrBar::getMaxSlideValue(){
  return (_maximum - _slider_size);
}

void(*WSCvscrBar::_ext_draw_proc)(void*) = NULL;
WSCstring WSCvscrBar::_policy_name;

void WSCvscrBar::onGuiPolicyChange(long policy){
  if (getVisible() != False){
    setAbsoluteDraw(True);
    WSCbool fl;
    getPropertyV(WSNblinkRefreshing,&fl);
    if (fl == False){
      draw();
    }else{
      redraw();
    }
  }
  if (WSGIappDev()->getExtGuiPolicySelected() == False){
    _ext_draw_proc = NULL;
  }else{
    if (!strcmp((char*)_policy_name,(char*)WSGIappDev()->getExtGuiPolicyName())){
    }else{
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->getExtGuiPolicyProc("WSCvscrBar::draw");
    }
  }
  if (getVisible() != False){
    needUpdate();
    setAbsoluteDraw(True);
    redraw();
  }
  WSCnwbase::onGuiPolicyChange(policy);
}
char* WSCvscrBar::getDefaultProperty(){
  return WSNvalue;
}
