#include <WScom.h>
#include <WSCvlabel.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCfontSet.h>
#include <WSCsform.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSCbaseList.h>
#include <WSDmouse.h>
#include <WSDkeyboard.h>
#include <WSDappDev.h>
#include <WSCfontSet.h>
#include <WSCcolorSet.h>
#include <WSCvifield.h>
#include <WSCvscrBar.h>
#include <WSCsheet.h>

#include <WSDmwindowDev.h>

#include <WSDexternal.h>
#include <WSClocaleSet.h>
#include <WSCinitializeManager.h>

extern "C" {
void libwssheet_func();
}
void libwssheet_func(){
}

static char *object_symbols[] = {
"WSCsheet", "$(WSDIR)/sys/pixmaps/obj/obj.xpm","WSCsheet is created.",
NULL
};

class _dll_init {
public:
  _dll_init(){
    WSDexternal::setTempData(object_symbols);
  }
};
static _dll_init _execute_initialize;

void _lang_init_proc(){
#include "English.cpp"
#ifndef _WSWIN32
#include "Japanese.cpp"
#endif
#include "Japanese-sjis.cpp"
#ifndef _WSWIN32
#include "Japanese-utf8.cpp"
#include "Korean.cpp"
#endif
}

class _lang_init_{
public:
  _lang_init_(){
    WSGIappInitializeManager()->addInitializeProc(_lang_init_proc);
  };
};

static _lang_init_ _run_lang_init;


WSMFguiClassInitialize(WSCsheet, WSCform);

WSCsheet::WSCsheet(WSCbase* base, char* objname) : WSCform(base, objname)
{
	_shadow_type = WS_SHADOW_IN;
	_back_color = WS_DF_BACKCOLOR;

	_sheetBackColor = WS_DF_BACKCOLOR;
	_cellBackColor = WS_DF_WORKBACKCOLOR;
	_cellTextColor = WS_DF_FORECOLOR;
	_fixedBackColor = WS_DF_BACKCOLOR;
	_fixedTextColor = WS_DF_FORECOLOR;
	_gridColor = WS_DF_BARSHADOWCOLOR;
	_selectBackColor = WSGIappColorSet()->getColorNo("#000080");
	
	_rows = 0;
	_cols = 0;
	_fixedRows = 0;
	_fixedCols = 0;

	_font = 0;
	_fixedFont = 0;
	
	_gridLines = WSCSHEET_BOTH;
	_bar_thick = 16;

	_colWidth = WSCSHEET_DEF_COL_WIDTH;
	_colHeight = WSCSHEET_DEF_ROW_HEIGHT;
	_fixedColHeight = _colHeight;

	_mousepress = False;
	_mouseSelect = False;
	_editEnabled = False;
	_vautoNumber = True;
	_hautoNumber = True;
	_initVisible = True;
	
	_vdb = NULL;
	_dataSource = WSGFstrdup("");
	_tableName = WSGFstrdup("");
	_dbItem = WSGFstrdup("");
	_dbSortItem1 = WSGFstrdup("");
	_dbSort1 = WSCSHEET_DB_SORT_ASC;
	_dbSortItem2 = WSGFstrdup("");
	_dbSort2 = WSCSHEET_DB_SORT_ASC;
	_dbSortItem3 = WSGFstrdup("");
	_dbSort3 = WSCSHEET_DB_SORT_ASC;
	_dbFilter = WSGFstrdup("");
	_dbStmtString = WSGFstrdup("");
	_dbCellAutoResize = True;
	_dbCellTitle = True;
	
    WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNrows, long, _rows, WSSrows);
    WSMFpropertyCreate(WSNcols, long, _cols, WSScols);
    WSMFpropertyCreate(WSNfixedRows, long, _fixedRows, WSSfixedRows);
    WSMFpropertyCreate(WSNfixedCols, long, _fixedCols, WSSfixedCols);
    WSMFpropertyCreate(WSNgridLines, short, _gridLines, WSSgridLines);
    WSMFpropertySetSelection(WSRgridLines, WSRgridLinesD);
    WSMFpropertyCreate(WSNcellDefWidth, long, _colWidth, WSScellDefWidth);
    WSMFpropertyCreate(WSNcellDefHeight, long, _colHeight, WSScellDefHeight);
    WSMFpropertyCreate(WSNfixedColHeight, long, _fixedColHeight, WSSfixedColHeight);
    WSMFpropertyCreate(WSNcellDefFont, short, _font, WSScellDefFont);
    WSMFpropertyCreate(WSNfixedCellFont, short, _fixedFont, WSSfixedCellFont);
    WSMFpropertyCreate(WSNeditEnabled, WSCbool, _editEnabled, WSSeditEnabled);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate(WSNhautoNumber, WSCbool, _hautoNumber, WSShautoNumber);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate(WSNvautoNumber, WSCbool, _vautoNumber, WSSvautoNumber);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate(WSNsheetBackColor, short, _sheetBackColor, WSSsheetBackColor);
    WSMFpropertyCreate(WSNcellDefBackColor, short, _cellBackColor, WSScellDefBackColor);
    WSMFpropertyCreate(WSNcellDefTextColor, short, _cellTextColor, WSScellDefTextColor);
    WSMFpropertyCreate(WSNfixedBackColor, short, _fixedBackColor, WSSfixedBackColor);
    WSMFpropertyCreate(WSNfixedTextColor, short, _fixedTextColor, WSSfixedTextColor);
    WSMFpropertyCreate(WSNgridColor, short, _gridColor, WSSgridColor);

    WSMFpropertyCreate(WSNdataSourceName, char*, _dataSource, WSSdataSourceName);
    WSMFpropertyCreate(WSNdbTableName, char*, _tableName, WSSdbTableName);
    WSMFpropertyCreate(WSNdbItem, char*, _dbItem, WSSdbitem);
    WSMFpropertyCreate(WSNsortItem1, char*, _dbSortItem1, WSSsortItem1);
    WSMFpropertyCreate(WSNsort1, WSCuchar, _dbSort1, WSSsort1);
    WSMFpropertySetSelection(WSRsort1, WSRsort1D);
    WSMFpropertyCreate(WSNsortItem2, char*, _dbSortItem2, WSSsortItem2);
    WSMFpropertyCreate(WSNsort2, WSCuchar, _dbSort2, WSSsort2);
    WSMFpropertySetSelection(WSRsort2, WSRsort2D);
    WSMFpropertyCreate(WSNsortItem3, char*, _dbSortItem3, WSSsortItem3);
    WSMFpropertyCreate(WSNsort3, WSCuchar, _dbSort3, WSSsort3);
    WSMFpropertySetSelection(WSRsort3, WSRsort3D);
    WSMFpropertyCreate(WSNfilter, char*, _dbFilter, WSSfilter);
    WSMFpropertyCreate(WSNsql, char*, _dbStmtString, WSSsql); 
    WSMFpropertyCreate(WSNdbCellAutoResize, WSCbool, _dbCellAutoResize, WSSdbCellAutoResize);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate(WSNdbCellTitle, WSCbool, _dbCellTitle, WSSdbCellTitle);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);

    WSMFaddExtTrigger(WSEV_SCR_MOUSE_PRESS,"SCR-MOUSE-PRESS");
    WSMFaddExtTrigger(WSEV_SCR_MOUSE_RELEASE,"SCR-MOUSE-RELEASE");
    WSMFaddExtTrigger(WSEV_SCR_MOUSE_MOVE,"SCR-MOUSE-MOVE");

    WSMFaddTrigger(WSEV_ACTIVATE);
    WSMFaddTrigger(WSEV_KEY_PRESS);
    WSMFaddTrigger(WSEV_KEY_RELEASE);
    WSMFaddTrigger(WSEV_KEY_HOOK);
    WSMFaddTrigger(WSEV_VALUE_CH);

    WSMFpropertyCreateEnd
}

WSMFproperty(WSCsheet, WSNrows, long, _rows, WSCSHEET_DEF_ROWS);
WSMFproperty(WSCsheet, WSNcols, long, _cols, WSCSHEET_DEF_COLS);
WSMFproperty(WSCsheet, WSNfixedRows, long, _fixedRows, WSCSHEET_DEF_FIXEDROWS);
WSMFproperty(WSCsheet, WSNfixedCols, long, _fixedCols, WSCSHEET_DEF_FIXEDCOLS);
WSMFproperty(WSCsheet, WSNgridLines, short, _gridLines, WSCSHEET_BOTH);
WSMFproperty(WSCsheet, WSNcellDefWidth, long, _colWidth, WSCSHEET_DEF_COL_WIDTH);
WSMFproperty(WSCsheet, WSNcellDefHeight, long, _colHeight, WSCSHEET_DEF_ROW_HEIGHT);
WSMFproperty(WSCsheet, WSNfixedColHeight, long, _fixedColHeight, WSCSHEET_DEF_ROW_HEIGHT);
WSMFproperty(WSCsheet, WSNcellDefFont, short, _font, (char)WSGIappFontSet()->getDefaultFontNo());
WSMFproperty(WSCsheet, WSNfixedCellFont, short, _fixedFont, (char)WSGIappFontSet()->getDefaultFontNo());
WSMFproperty(WSCsheet, WSNeditEnabled, WSCbool, _editEnabled, False);
WSMFproperty(WSCsheet, WSNhautoNumber, WSCbool, _hautoNumber, True);
WSMFproperty(WSCsheet, WSNvautoNumber, WSCbool, _vautoNumber, True);
WSMFproperty(WSCsheet, WSNsheetBackColor, short, _sheetBackColor, WS_DF_BACKCOLOR);
WSMFproperty(WSCsheet, WSNcellDefBackColor, short, _cellBackColor, WS_DF_WORKBACKCOLOR);
WSMFproperty(WSCsheet, WSNcellDefTextColor, short, _cellTextColor, WS_DF_FORECOLOR);
WSMFproperty(WSCsheet, WSNfixedBackColor, short, _fixedBackColor, WS_DF_BACKCOLOR);
WSMFproperty(WSCsheet, WSNfixedTextColor, short, _fixedTextColor, WS_DF_FORECOLOR);
WSMFproperty(WSCsheet, WSNgridColor, short, _gridColor, WS_DF_BARSHADOWCOLOR);

WSMFproperty(WSCsheet, WSNdataSourceName, char*, _dataSource, WSGFstrdup(""));
WSMFproperty(WSCsheet, WSNdbTableName, char*, _tableName, WSGFstrdup(""));
WSMFproperty(WSCsheet, WSNdbItem, char*, _dbItem, WSGFstrdup(""));
WSMFproperty(WSCsheet, WSNsortItem1, char*, _dbSortItem1, WSGFstrdup(""));
WSMFproperty(WSCsheet, WSNsort1, WSCuchar, _dbSort1, 0);
WSMFproperty(WSCsheet, WSNsortItem2, char*, _dbSortItem2, WSGFstrdup(""));
WSMFproperty(WSCsheet, WSNsort2, WSCuchar, _dbSort2, 0);
WSMFproperty(WSCsheet, WSNsortItem3, char*, _dbSortItem3, WSGFstrdup(""));
WSMFproperty(WSCsheet, WSNsort3, WSCuchar, _dbSort3, 0);
WSMFproperty(WSCsheet, WSNfilter, char*, _dbFilter, WSGFstrdup(""));
WSMFproperty(WSCsheet, WSNsql, char*, _dbStmtString, WSGFstrdup("")); 
WSMFproperty(WSCsheet, WSNdbCellAutoResize, WSCbool, _dbCellAutoResize, True);
WSMFproperty(WSCsheet, WSNdbCellTitle, WSCbool, _dbCellTitle, True);

void WSCsheet::setWorkWSNrows(long val)
{
	if(_initialized != False){
		setRowCount(val);
	}
}
void WSCsheet::getWorkWSNrows(long*){}
void WSCsheet::setWorkWSNcols(long val)
{
	if(_initialized != False){
		setColumnCount(val);
	}
}
void WSCsheet::getWorkWSNcols(long*){}
void WSCsheet::setWorkWSNfixedRows(long val)
{
	if(_initialized != False){
		setFixedRowCount(val);
	}
}
void WSCsheet::getWorkWSNfixedRows(long*){}
void WSCsheet::setWorkWSNfixedCols(long val)
{
	if(_initialized != False){
		setFixedColumnCount(val);
	}
}
void WSCsheet::getWorkWSNfixedCols(long*){}
void WSCsheet::setWorkWSNgridLines(short val)
{
	if(_initialized != False){
		setGridLines(val);
	}
}
void WSCsheet::getWorkWSNgridLines(short*){}
void WSCsheet::setWorkWSNcellDefWidth(long val)
{
	if(_initialized != False){
		_colWidth = val;
		needUpdate();
	}
}
void WSCsheet::getWorkWSNcellDefWidth(long*){}
void WSCsheet::setWorkWSNcellDefHeight(long val)
{
	if(_initialized != False){
		_colHeight = val;
		needUpdate();
	}
}
void WSCsheet::getWorkWSNcellDefHeight(long*){}

void WSCsheet::setWorkWSNfixedColHeight(long val)
{
	if(_initialized != False){
		_fixedColHeight = val;
		needUpdate();
	}
}
void WSCsheet::getWorkWSNfixedColHeight(long*){}
void WSCsheet::setWorkWSNcellDefFont(short val)
{
	if(_initialized != False){
		setCellDefFont(val);
	}
}
void WSCsheet::getWorkWSNcellDefFont(short*){}
void WSCsheet::setWorkWSNfixedCellFont(short val)
{
	if(_initialized != False){
		setFixedCellFont(val);
	}
}
void WSCsheet::getWorkWSNfixedCellFont(short*){}
void WSCsheet::setWorkWSNeditEnabled(WSCbool val){}
void WSCsheet::getWorkWSNeditEnabled(WSCbool*){}
void WSCsheet::setWorkWSNhautoNumber(WSCbool val)
{
	if(_initialized != False){
		setHorzAutoNumber(val);
		needUpdate();
	}
}
void WSCsheet::getWorkWSNhautoNumber(WSCbool*){}
void WSCsheet::setWorkWSNvautoNumber(WSCbool val)
{
	if(_initialized != False){
		setVertAutoNumber(val);
		needUpdate();
	}
}
void WSCsheet::getWorkWSNvautoNumber(WSCbool*){}
void WSCsheet::setWorkWSNsheetBackColor(short val)
{
	if(_initialized != False){
		setSheetBkColor(val);
	}
}
void WSCsheet::getWorkWSNsheetBackColor(short*){}
void WSCsheet::setWorkWSNcellDefBackColor(short val)
{
	if(_initialized != False){
		setCellDefBkColor(val);
	}
}
void WSCsheet::getWorkWSNcellDefBackColor(short*){}
void WSCsheet::setWorkWSNcellDefTextColor(short val)
{
	if(_initialized != False){
		setCellDefTextColor(val);
	}
}
void WSCsheet::getWorkWSNcellDefTextColor(short*){}
void WSCsheet::setWorkWSNfixedBackColor(short val)
{
	if(_initialized != False){
		setFixedBkColor(val);
	}
}
void WSCsheet::getWorkWSNfixedBackColor(short*){}
void WSCsheet::setWorkWSNfixedTextColor(short val)
{
	if(_initialized != False){
		setFixedTextColor(val);
	}
}
void WSCsheet::getWorkWSNfixedTextColor(short*){}
void WSCsheet::setWorkWSNgridColor(short val)
{
	if(_initialized != False){
		setGridColor(val);
	}
}
void WSCsheet::getWorkWSNgridColor(short*){}
void WSCsheet::setWorkWSNdataSourceName(char*){}
void WSCsheet::getWorkWSNdataSourceName(char**){}
void WSCsheet::setWorkWSNdbTableName(char*){}
void WSCsheet::getWorkWSNdbTableName(char**){}
void WSCsheet::setWorkWSNdbItem(char* val){}
void WSCsheet::getWorkWSNdbItem(char**){}
void WSCsheet::setWorkWSNsortItem1(char* val){}
void WSCsheet::getWorkWSNsortItem1(char**){}
void WSCsheet::setWorkWSNsort1(WSCuchar val){}
void WSCsheet::getWorkWSNsort1(WSCuchar*){}
void WSCsheet::setWorkWSNsortItem2(char* val){}
void WSCsheet::getWorkWSNsortItem2(char**){}
void WSCsheet::setWorkWSNsort2(WSCuchar val){}
void WSCsheet::getWorkWSNsort2(WSCuchar*){}
void WSCsheet::setWorkWSNsortItem3(char* val){}
void WSCsheet::getWorkWSNsortItem3(char**){}
void WSCsheet::setWorkWSNsort3(WSCuchar val){}
void WSCsheet::getWorkWSNsort3(WSCuchar*){}
void WSCsheet::setWorkWSNfilter(char* val){}
void WSCsheet::getWorkWSNfilter(char**){}
void WSCsheet::setWorkWSNsql(char* val){}
void WSCsheet::getWorkWSNsql(char**){}
void WSCsheet::setWorkWSNdbCellAutoResize(WSCbool val){}
void WSCsheet::getWorkWSNdbCellAutoResize(WSCbool*){}
void WSCsheet::setWorkWSNdbCellTitle(WSCbool val){}
void WSCsheet::getWorkWSNdbCellTitle(WSCbool*){}


WSCsheet::~WSCsheet()
{
	setRowCount(0);

	if(_dataSource) {
		delete[] _dataSource;
	}
	if(_tableName) {
		delete[] _tableName;
	}
	if(_dbItem) {
		delete[] _dbItem;
	}
	if(_dbSortItem1) {
		delete[] _dbSortItem1;
	}
	if(_dbSortItem2) {
		delete[] _dbSortItem2;
	}
	if(_dbSortItem3) {
		delete[] _dbSortItem3;
	}
	if(_dbFilter) {
		delete[] _dbFilter;
	}
	if(_dbStmtString) {
		delete[] _dbStmtString;
	}

}
///////////////////////////////////////////////////////////////////////////////
// event
//
long WSCsheet::initialize()
{
	WSCform::initialize();
  
	WSCstring addstr;
  
	WSCstring scrname;
	
	scrname.setString(getInstanceName());
	addstr.setString("-sheet");
	scrname.addString(addstr);

	WSCbase* htmp1 = WSCbase::getNewInstance(getUseScrBarClass(), this, scrname.getString());
	_sheet = (WSCform*)htmp1->cast("WSCform");
	if(_sheet == NULL) {
		_sheet = new WSCform(this, scrname.getString());
	}
	_sheet->setInternalObject(True);
	_sheet->setUseParentBaseDev(True);
	_sheet->initialize();
	_sheet->setPropertyV(WSNshadowType, (char)WS_SHADOW_BORDER);
	_sheet->setPropertyV(WSNshadowThickness, (WSCuchar)0);
	_sheet->setPropertyV(WSNbackColor, _sheetBackColor);
	
	WSCprocedure* op = new WSCprocedure("sheet-exports", WSEV_EXPOSE);
	op->setInternal(True);
	op->setFunction(onSheetExpose, "onSheetExpose");
	_sheet->addProcedure(op);

	op = new WSCprocedure("sheet-mousemove", WSEV_MOUSE_MOVE);
	op->setInternal(True);
	op->setFunction(onSheetMouseMove, "onSheetMouseMove");
	_sheet->addProcedure(op);

	op = new WSCprocedure("sheet-mousepress", WSEV_MOUSE_PRESS);
	op->setInternal(True);
	op->setFunction(onSheetMousePress, "onSheetMousePress");
	_sheet->addProcedure(op);

	op = new WSCprocedure("sheet-mouserelease", WSEV_MOUSE_RELEASE);
	op->setInternal(True);
	op->setFunction(onSheetMouseRelease, "onSheetMouseRelease");
	_sheet->addProcedure(op);

	_sheet->setVisible(True);

	scrname.setString(getInstanceName());
	addstr.setString("-hscr");
	scrname.addString(addstr);

	WSCbase* htmp = WSCbase::getNewInstance(getUseScrBarClass(), this, scrname.getString());
	_hscrBar = (WSCvscrBar*)htmp->cast("WSCvscrBar");
	if(_hscrBar == NULL) {
		_hscrBar = new WSCvscrBar(this, scrname.getString());
	}
	_hscrBar->setInternalObject(True);
	_hscrBar->setUseParentBaseDev(True);
	_hscrBar->initialize();

	WSCprocedure* op1 = new WSCprocedure("value-ch", WSEV_VALUE_CH);
	op1->setInternal(True);
	op1->setFunction(onHscroolClick, "onHscroolClick");
	_hscrBar->addProcedure(op1);
	_hscrBar->setPropertyV(WSNincrement, (WSCushort)1);
	_hscrBar->setVisible(True);

	scrname.setString(getInstanceName());
	addstr.setString("-vscr");
	scrname.addString(addstr);
	WSCbase* vtmp = WSCbase::getNewInstance(getUseScrBarClass(), this, scrname.getString());
	_vscrBar = (WSCvscrBar*)vtmp->cast("WSCvscrBar");
	if(_vscrBar == NULL) {
		_vscrBar = new WSCvscrBar(this, scrname.getString());
	}
	_vscrBar->setInternalObject(True);
	_vscrBar->setUseParentBaseDev(True);
	_vscrBar->initialize();
	_vscrBar->setPropertyV(WSNorientation, (WSCuchar)WS_VERTICAL);

	WSCprocedure* op2 = new WSCprocedure("value-ch", WSEV_VALUE_CH);
	op2->setInternal(True);
	op2->setFunction(onVscrollClick, "onVscrollClick");
	_vscrBar->addProcedure(op2);
	_vscrBar->setPropertyV(WSNincrement, (WSCushort)1);
	_vscrBar->setVisible(True);

	scrname.setString(getInstanceName());
	addstr.setString("-edit");
	scrname.addString(addstr);
	vtmp = WSCbase::getNewInstance("WSCvifield", _sheet, scrname.getString());
	_edit = (WSCvifield*)vtmp->cast("WSCvifield");
	if(_edit == NULL) {
		_edit = new WSCvifield(_sheet, scrname. getString());
	}
	_edit->setInternalObject(True);
	_edit->setUseParentBaseDev(True);
	_edit->initialize();
	_edit->setPropertyV(WSNshadowType, (char)WS_SHADOW_BORDER);
	_edit->setPropertyV(WSNshadowThickness, (WSCuchar)0);

	WSCprocedure* op3 = new WSCprocedure("focus-ch", WSEV_FOCUS_CH);
	op3->setInternal(True);
	op3->setFunction(onEditFocusChange, "onEditFocusChange");
	_edit->addProcedure(op3);

	WSCprocedure* op4 = new WSCprocedure("key-press", WSEV_KEY_PRESS);
	op4->setInternal(True);
	op4->setFunction(onEditKeyPress, "onEditKeyPress");
	_edit->addProcedure(op4);

	WSCprocedure* op5 = new WSCprocedure("key-release", WSEV_KEY_RELEASE);
	op5->setInternal(True);
	op5->setFunction(onEditKeyRelease, "onEditKeyRelease");
	_edit->addProcedure(op5);

	WSCprocedure* op6 = new WSCprocedure("key-hook", WSEV_KEY_HOOK);
	op6->setInternal(True);
	op6->setFunction(onEditKeyHook, "onEditKeyHook");
	_edit->addProcedure(op6);

	WSCprocedure* op7 = new WSCprocedure("activate", WSEV_ACTIVATE);
	op7->setInternal(True);
	op7->setFunction(onEditActivate, "onEditActivate");
	_edit->addProcedure(op7);

	WSCprocedure* op8 = new WSCprocedure("value-ch", WSEV_VALUE_CH);
	op8->setInternal(True);
	op8->setFunction(onEditValueChange, "onEditValueChange");
	_edit->addProcedure(op8);

	clear();

	return WS_NO_ERR;
}
long WSCsheet::_device_initialize()
{
	WSCform::_device_initialize();
	WSDdev* dev = getowndev();
	if(dev != NULL) {
		dev->setEnableEventBit(WSEV_EXPOSE_BIT | 
							   WSEV_RESIZE_BIT | 
							   WSEV_VISIBLE_CH_BIT |
							   WSEV_MOUSE_MOVE_BIT | 
							   WSEV_MOUSE_PRESS_BIT | 
							   WSEV_MOUSE_RELEASE_BIT);
		return WS_NO_ERR;
	}
	return WS_ERR;
}

long WSCsheet::clear(long col, long row)
{
	WSCbool ref = getNoRefresh();
	
	setNoRefresh(True);
	
	setRowCount(0);
	
	setRowCount(row);
	setColumnCount(col);
	setFixedRowCount();
	setFixedColumnCount();

	_topVisibleRow = _fixedRows;
	_topVisibleCol = _fixedCols;

	_focusRow = 1;
	_focusCol = 1;
	_startRow = _focusRow;
	_startCol = _focusCol;
	_endRow = _focusRow;
	_endCol = _focusCol;
	_selectCell = False;
	
	setNoRefresh(ref);
	
	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::draw()
{
	if(getNoRefresh() != False) {
		WSCbase::update();
		setAbsoluteDraw(False);
		return WS_NO_ERR;
	}
	if(getVisible() == False) {
		return WS_NO_ERR;
	}
	if(isNeedUpdate() != False) {
		adjustScrollBar();
	}

	WSDdev* dev = getowndev();
	if(dev == NULL) {
		return WS_ERR;
	}
	WSCushort w = _w;
	WSCushort h = _h;
	WSCushort shadow_thick = _shadow_thick;

	WSCbool absolute = getAbsoluteDraw();

	if(absolute == False) {
		if(dev->isExposed(0, 0, w, h) == False) {
			return WS_NO_ERR;
		}
	}
	long err = dev->beginDraw(0, 0, w, h, True);
	if(err != WS_NO_ERR) {
		return WS_NO_ERR;
	}
	if(shadow_thick > 0){
		if(WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS) {
			WSGFdrawShadow(dev, _shadow_type, shadow_thick, _fore_color, 
			               _ts_color, _bs_color, _back_color, 0, 0, w, h);
		}
	}
	dev->endDraw();

	_sheet->execProcedure(WSEV_EXPOSE);

	return WS_NO_ERR;
}
long WSCsheet::redraw()
{
	return WSCform::redraw();
}
long WSCsheet::cdraw()
{
	return WSCform::cdraw();
}
void WSCsheet::update()
{
  WSCform::update();
}
void WSCsheet::onResize(WSCrect* rect)
{
	adjustScrollBar();
}
void WSCsheet::onMouseMove(WSCpoint* pt)
{
	if(_mousepress) {
		long row, col;
		getCellNo(pt, &col, &row);

		if((col >= 0 && row >= 0) && 
		   ((col >= getFixedColumnCount() && row >= getFixedRowCount()) || 
		    (col >= getFixedColumnCount() && row < getFixedRowCount())  || 
		    (col < getFixedColumnCount() && row >= getFixedRowCount()))) {
			if(_focusRow != row || _focusCol != col) {
				if(col >= getFixedColumnCount()) {
					setRowCol(col, _endRow);
				}
				if(row >= getFixedRowCount()) {
					setRowCol(_endCol, row);
				}
				_selectCell = True;
				_mouseSelect = True;

				posMoveCell(pt);

				focusCellVisible(_focusCol, _focusRow, _focusCol, _focusRow);

				draw();
			}
		} else {
			posMoveCell(pt);
			draw();
		}
	}
	WSCform::onMouseMove(pt);
}
void WSCsheet::onMousePress(WSCpoint* pt)
{
	long row, col, oldRow = -1, oldCol = -1;

	if(getPropertyEditMode()) {
		return;
	}
	getCellNo(pt, &col, &row);

	if(col >= 0 && row >= 0) {
		oldRow = _focusRow;
		oldCol = _focusCol;
		
		_mousepress = True;
		_selectCell = False;
		_mouseSelect = False;

		_focusRow = row;
		_focusCol = col;
		_startRow = row;
		_startCol = col;
		_endRow = row;
		_endCol = col;

		if(row < _fixedRows) {
			_startRow = 0;
			_focusRow = _fixedRows;
			_endRow = _rows;
			_mouseSelect = True;
			_selectCell = True;
		}
		if(col < _fixedCols) {
			_startCol = 0;
			_focusCol = _fixedCols;
			_endCol = _cols;
			_mouseSelect = True;
			_selectCell = True;
		}

		focusCellVisible(oldCol, oldRow, col, row);

		draw();
	}
	
	WSCform::onMousePress(pt);
}
void WSCsheet::onMouseRelease(WSCpoint* pt)
{
	if(getSelectCell()) {
		long row, col;
		getCellNo(pt, &col, &row);

		if(col >= getFixedColumnCount() && row >= getFixedRowCount()) {
			setRowCol(col, row);
			focusCellVisible(_focusCol, _focusRow, _focusCol, _focusRow);
			draw();
		}
	}
	_mousepress = False;

	WSCform::onMouseRelease(pt);
}
void WSCsheet::onVisibleChange(WSCbool vis)
{
	if(vis && _initVisible) {
		_initVisible = False;

		if(!getPropertyEditMode()) {
			setNoRefresh(True);

			dbDataSet();

			setNoRefresh(False);
		}
	}
	WSCform::onVisibleChange(vis);
}
///////////////////////////////////////////////////////////////////////////////
// local event
//
void WSCsheet::onHscroolClick(WSCbase* obj)
{
	WSCulong val;
	WSCbase* parent = obj->getParent();
	WSCsheet* ss = (WSCsheet*)parent->cast("WSCsheet");

	obj->getPropertyV(WSNvalue, &val);

	val += ss->getFixedColumnCount();
	if((long)val >= ss->getColumnCount()) {
		val = ss->getColumnCount() - 1;
	}
	ss->focusCellVisible(ss->getFocusCol(), ss->getFocusRow(), -1, -1);
	ss->setTopVisibleCol((long)val);
}
void WSCsheet::onVscrollClick(WSCbase* obj)
{
	WSCulong val;
	WSCbase* parent = obj->getParent();
	WSCsheet* ss = (WSCsheet*)parent->cast("WSCsheet");

	obj->getPropertyV(WSNvalue, &val);

	val += ss->getFixedRowCount();
	if((long)val >= ss->getRowCount()) {
		val = ss->getRowCount() - 1;
	}
	ss->focusCellVisible(ss->getFocusCol(), ss->getFocusRow(), -1, -1);
	ss->setTopVisibleRow((long)val);
}
void WSCsheet::onEditFocusChange(WSCbase* obj)
{
	if(!obj->getFocus()) {
		WSCbase* p = obj->getParent();
		WSCbase* parent = p->getParent();
		WSCsheet* ss = (WSCsheet*)parent->cast("WSCsheet");
		ss->focusCellVisible(ss->getFocusCol(), ss->getFocusRow(), -1, -1);
	}
}
void WSCsheet::onSheetExpose(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCsheet* ss = (WSCsheet*)parent->cast("WSCsheet");
	if(ss == NULL) {
		return;
	}

	WSCushort shadow_thick = 0;
	long    width = ss->getClientWidth();
	long    height = ss->getClientHeight();

	WSDdev* dev = obj->getowndev();
	if(dev == NULL) {
		return;
	}
	WSCbool absolute = obj->getAbsoluteDraw();
	if(absolute == False) {
		if(dev->isExposed(0, 0, width, height) == False) {
			return;
		}
	}
	long err = dev->beginDraw(0, 0, width, height, True);
	if(err != WS_NO_ERR) {
		return;
	}

	dev->setForeColor(ss->getSheetBkColor());
	dev->drawFillRect(0, 0, width, height);

	WSCrect rect;
	long    row, col;
	
	rect.y = shadow_thick;
	rect.height = rect.y + -1;
	for(row = 0; row < ss->getFixedRowCount(); row++) {
		rect.x = shadow_thick;
		rect.height = ss->getRowHeight(row) - 1;
		for(col = 0; (col < ss->getFixedColumnCount()) && (rect.x < width); col++) {
			rect.width = ss->getColumnWidth(col) - 1;
			ss->drawFixedCell(dev, col, row, rect);
			rect.x += rect.width + 1;
			ss->setEndVisibleCol(col);
		}
		rect.y += rect.height + 1;
		ss->setEndVisibleRow(row);
	}
	long    x, y;
	x = rect.x;
	rect.y = shadow_thick;
	rect.height = rect.y + -1;
	for(row = 0; row < ss->getFixedRowCount(); row++) {
		rect.x = x;
		rect.height = ss->getRowHeight(row) - 1;
		for(col = ss->getTopVisibleCol(); (col < ss->getColumnCount()) && (rect.x < width); col++) {
			rect.width = ss->getColumnWidth(col) - 1;
			ss->drawFixedCell(dev, col, row, rect);
			rect.x += rect.width + 1;
			ss->setEndVisibleCol(col);
		}
		rect.y += rect.height + 1;
	}
	y = rect.y;
	for(row = ss->getTopVisibleRow(); (row < ss->getRowCount()) && (rect.y < height); row++) {
		rect.x = shadow_thick;
		rect.height = ss->getRowHeight(row) - 1;
		for(col = 0; (col < ss->_fixedCols) && (rect.x < width); col++) {
			rect.width = ss->getColumnWidth(col) - 1;
			ss->drawFixedCell(dev, col, row, rect);
			rect.x += rect.width + 1;
		}
		rect.y += rect.height + 1;
	}
	x = rect.x;
	rect.y = y;
	for(row = ss->getTopVisibleRow(); (row < ss->getRowCount()) && (rect.y < height); row++) {
		rect.x = x;
		rect.height = ss->getRowHeight(row);
		for(col = ss->_topVisibleCol; (col < ss->getColumnCount()) && (rect.x < width); col++) {
			rect.width = ss->getColumnWidth(col);
			ss->drawCell(dev, col, row, rect);
			rect.x += rect.width;
		}
		rect.y += rect.height;
	}

	dev->endDraw();
}
void WSCsheet::onSheetMouseMove(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCsheet* ss = (WSCsheet*)parent->cast("WSCsheet");

	WSCpoint pt;
	short    x, y;
	if(WSGIappMouse()->getMousePosition(&x, &y, obj)) {
		pt.x = (long)x;
		pt.y = (long)y;
		ss->onMouseMove(&pt);
		ss->onScrMouseMove(&pt);
	}
}
void WSCsheet::onSheetMousePress(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCsheet* ss = (WSCsheet*)parent->cast("WSCsheet");

	WSCpoint pt;
	short    x, y;
	if(WSGIappMouse()->getMousePosition(&x, &y, obj)) {
		pt.x = (long)x;
		pt.y = (long)y;
		ss->onMousePress(&pt);
		ss->onScrMousePress(&pt);
	}
}
void WSCsheet::onSheetMouseRelease(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCsheet* ss = (WSCsheet*)parent->cast("WSCsheet");

	WSCpoint pt;
	short    x, y;
	if(WSGIappMouse()->getMousePosition(&x, &y, obj)) {
		pt.x = (long)x;
		pt.y = (long)y;
		ss->onMouseRelease(&pt);
		ss->onScrMouseRelease(&pt);
	}
}
void WSCsheet::onScrMouseMove(WSCpoint* pt)
{
	execProcedure(WSEV_SCR_MOUSE_MOVE);
}
void WSCsheet::onScrMousePress(WSCpoint* pt)
{
	execProcedure(WSEV_SCR_MOUSE_PRESS);
}
void WSCsheet::onScrMouseRelease(WSCpoint* pt)
{
	execProcedure(WSEV_SCR_MOUSE_RELEASE);
}
void WSCsheet::onEditActivate(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCbase* sheet = parent->getParent();
	WSCsheet* ss = (WSCsheet*)sheet->cast("WSCsheet");
	ss->onActivate();
}
void WSCsheet::onEditKeyPress(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCbase* sheet = parent->getParent();
	WSCsheet* ss = (WSCsheet*)sheet->cast("WSCsheet");
	ss->onKeyPress(WSGIappKeyboard());
}
void WSCsheet::onEditKeyRelease(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCbase* sheet = parent->getParent();
	WSCsheet* ss = (WSCsheet*)sheet->cast("WSCsheet");
	ss->onKeyRelease(WSGIappKeyboard());
}
void WSCsheet::onEditKeyHook(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCbase* sheet = parent->getParent();
	WSCsheet* ss = (WSCsheet*)sheet->cast("WSCsheet");
	ss->onKeyHook(WSGIappKeyboard());
}
void WSCsheet::onEditValueChange(WSCbase* obj)
{
	WSCbase* parent = obj->getParent();
	WSCbase* sheet = parent->getParent();
	WSCsheet* ss = (WSCsheet*)sheet->cast("WSCsheet");
	if(ss->_edit->getVisible()) {
		ss->onValueChange();
	}
}
void WSCsheet::onActivate()
{
	execProcedure(WSEV_ACTIVATE);
}
void WSCsheet::onKeyPress(WSDkeyboard* keyboard)
{
	execProcedure(WSEV_KEY_PRESS);
}
void WSCsheet::onKeyRelease(WSDkeyboard* keyboard)
{
	execProcedure(WSEV_KEY_RELEASE);
}
void WSCsheet::onKeyHook(WSDkeyboard* keyboard)
{
	execProcedure(WSEV_KEY_HOOK);
}
void WSCsheet::onValueChange()
{
	execProcedure(WSEV_VALUE_CH);
}
///////////////////////////////////////////////////////////////////////////////
// property function
//
long WSCsheet::setFixedRowCount(long fixedRows)
{
	if(fixedRows < 0) {
		return WS_ERR;
	}
	_fixedRows = fixedRows;
	if(_focusRow < _fixedRows) {
		_focusRow = _fixedRows;
	}
	if(_startRow < _fixedRows) {
		_startRow = _fixedRows;
	}
	if(_endRow < _fixedRows) {
		_endRow = _fixedRows;
	}
	if(_topVisibleRow < _fixedRows) {
		_topVisibleRow = _fixedRows;
	}
	if(_fixedRows <= _rows) {
		return WS_NO_ERR;
	}
	return rowSize(fixedRows);
}
long WSCsheet::setFixedColumnCount(long fixedCols)
{
	if(fixedCols < 0) {
		return WS_ERR;
	}
	_fixedCols = fixedCols;
	if(_focusCol < _fixedCols) {
		_focusCol = _fixedCols;
	}
	if(_startCol < _fixedCols) {
		_startCol = _fixedCols;
	}
	if(_endCol < _fixedCols) {
		_endCol = _fixedCols;
	}
	if(_topVisibleCol < _fixedCols) {
		_topVisibleCol = _fixedCols;
	}
	if(_fixedCols <= _cols) {
		return WS_NO_ERR;
	}
	return colSize(fixedCols);
}
long WSCsheet::setRowCount(long rows)
{
	if(rows < 0) {
		return WS_ERR;
	}
	return rowSize(rows);
}
long WSCsheet::setColumnCount(long cols)
{
	if(cols < 0) {
		return WS_ERR;
	}
	return colSize(cols);
}
long WSCsheet::getFixedRowHeight(long row)
{
	if(row < 0 || row >= getFixedRowCount()) {
		return 0;
	}
	return getRowHeight(row);
}
long WSCsheet::setFixedRowHeight(long row, long height)
{
	if(row < 0 || row >= getFixedRowCount()) {
		return WS_ERR;
	}
	return setRowHeight(row, height);
}
long WSCsheet::getFixedColumnWidth(long col)
{
	if(col < 0) {
		return WS_ERR;
	}
	return getColumnWidth(col);
}
long WSCsheet::setFixedColumnWidth(long col, long width)
{
	if(col < 0) {
		return WS_ERR;
	}
	return setColumnWidth(col, width);
}
long WSCsheet::getRowHeight(long row)
{
	if(row < 0 || row >= getRowCount()) {
		return 0;
	}
	WSCsheetRow* rowdata = getRowData(row);
	if(rowdata) {
		long height = rowdata->getRowHeight();
		if(height == WSCSHEET_DEFAULT) {
			if(row < getFixedRowCount()) {
				height = _fixedColHeight;
			} else {
				height = _colHeight;
			}
		}
		return height;
	}
	return 0;
}
long WSCsheet::setRowHeight(long row, long height)
{
	if(row != -1 && (row < 0 || row >= getRowCount())) {
		return WS_ERR;
	}
	if(height > getClientHeight()) {
		height =  getClientHeight();
	}
	WSCsheetRow* rowdata;
	if(row != -1) {
		rowdata = getRowData(row);
		if(!rowdata) {
			return WS_ERR;
		}
		rowdata->setRowHeight(height);
	} else {
		for(long r = 0; r < getRowCount(); r++) {
			rowdata = getRowData(r);
			if(!rowdata) {
				return WS_ERR;
			}
			rowdata->setRowHeight(height);
		}
	}
	draw();
	return WS_NO_ERR;
}
long WSCsheet::getColumnWidth(long col)
{
	if(col < 0 || col >= getColumnCount()) {
		return 0;
	}
	return getWidthValue(col);
}
long WSCsheet::setColumnWidth(long col, long width)
{
	if(col != -1 && (col < 0 || col >= getColumnCount())) {
		return WS_ERR;
	}
	if(width > _clientWidth) {
		width =  _clientWidth;
	}
	if(col != -1) {
		long* p = getWidthData(col);
		if(!p) {
			return WS_ERR;
		}
		*p = width;
	} else {
		for(long c = 0; c < getColumnCount(); c++) {
			long* p = getWidthData(c);
			if(!p) {
				return WS_ERR;
			}
			*p = width;
		}
	}
	draw();
	return WS_NO_ERR;
}
long WSCsheet::setSheetBkColor(char* cname)
{
	return setSheetBkColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setSheetBkColor(short color)
{
	_sheetBackColor = color;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellDefBkColor(char* cname)
{
	return setCellDefBkColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setCellDefBkColor(short color)
{
	_cellBackColor = color;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellBkColor(char* cname)
{
	return setCellBkColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setCellBkColor(long col, long row, char* cname)
{
	return setCellBkColor(col, row, WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setCellBkColor(short color)
{
	WSCsheetCell* cell;
	
	if(getSelectCell()) {
		for(long row = getStartRow(); row <= getEndRow(); row++) {
			for(long col = getStartCol(); col <= getEndCol(); col++) {
				cell = getCell(col, row, True);
				if(cell) {
					cell->crBkClr = color;
				}
			}
		}
	} else {
		cell = getCell(_startCol, _startRow, True);
		if(!cell) {
			return WS_ERR;
		}
		cell->crBkClr = color;
	}

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::setCellBkColor(long col, long row, short color)
{
	WSCsheetCell* cell = getCell(col, row, True);
	if(!cell) {
		return WS_ERR;
	}
	cell->crBkClr = color;

	draw();

	return WS_NO_ERR;
}
short WSCsheet::getCellBkColor(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return (cell->crBkClr == WSCSHEET_DEFCOLOR ? _cellBackColor : cell->crBkClr);
	}
	return _cellBackColor;
}
long WSCsheet::setCellDefTextColor(char* cname)
{
	return setCellDefTextColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setCellDefTextColor(short color)
{
	_cellTextColor = color;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellTextColor(char* cname)
{
	return setCellTextColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setCellTextColor(long col ,long row, char* cname)
{
	return setCellTextColor(col, row, WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setCellTextColor(short color)
{
	
	WSCsheetCell* cell;
	
	if(getSelectCell()) {
		for(long row = getStartRow(); row <= getEndRow(); row++) {
			for(long col = getStartCol(); col <= getEndCol(); col++) {
				cell = getCell(col, row, True);
				if(cell) {
					cell->crFgClr = color;
				}
			}
		}
	} else {
		cell = getCell(_startCol, _startRow, True);
		if(!cell) {
			return WS_ERR;
		}
		cell->crFgClr = color;
	}

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::setCellTextColor(long col ,long row, short color)
{
	WSCsheetCell* cell = getCell(col, row, True);
	if(!cell) {
		return WS_ERR;
	}
	cell->crFgClr = color;

	draw();

	return WS_NO_ERR;
}
short WSCsheet::getCellTextColor(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return (cell->crFgClr == WSCSHEET_DEFCOLOR ? _cellTextColor : cell->crFgClr);
	}
	return _cellTextColor;
}
long WSCsheet::setFixedTextColor(char* cname)
{
	return setFixedTextColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setFixedTextColor(short color)
{
	_fixedTextColor = color;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setFixedBkColor(char* cname)
{
	return setFixedBkColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setFixedBkColor(short color)
{
	_fixedBackColor = color;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setGridColor(char* cname)
{
	return setGridColor(WSGIappColorSet()->getColorNo(cname));
}
long WSCsheet::setGridColor(short color)
{
	_gridColor = color;

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::setGridLines(short gridLines)
{
	_gridLines = gridLines;

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::setCellGridLines(short gridLines)
{
	WSCsheetCell* cell;
	
	if(getSelectCell()) {
		long startRow = getStartRow();
		long startCol = getStartCol();

		if(startRow < getFixedRowCount()) {
			startRow = getFixedRowCount();
		}
		if(startCol < getFixedColumnCount()) {
			startCol = getFixedColumnCount();
		}
		for(long row = startRow; row <= getEndRow(); row++) {
			for(long col = startCol; col <= getEndCol(); col++) {
				cell = getCell(col, row, True);
				if(cell) {
					cell->crLine = gridLines;
				}
			}
		}
	} else {
		cell = getCell(_startCol, _startRow, True);
		if(!cell) {
			return WS_ERR;
		}
		cell->crLine = gridLines;
	}

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellGridLines(long col, long row, short gridLines)
{
	WSCsheetCell* cell = getCell(col, row, True);
	if(!cell) {
		return WS_ERR;
	}
	cell->crLine = gridLines;

	draw();
	
	return WS_NO_ERR;
}
short WSCsheet::getCellGridLines(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return cell->crLine;
	}
	return _gridLines;
}
long WSCsheet::setText(short text)
{
	WSCstring str;
	str << text;
	return setCellText(str);
}
long WSCsheet::setText(WSCushort text)
{
	WSCstring str;
	str << text;
	return setCellText(str);
}
long WSCsheet::setText(long text)
{
	WSCstring str;
	str << text;
	return setCellText(str);
}
long WSCsheet::setText(WSCulong text)
{
	WSCstring str;
	str << text;
	return setCellText(str);
}
long WSCsheet::setText(float text)
{
	WSCstring str;
	str << text;
	return setCellText(str);
}
long WSCsheet::setText(double text)
{
	WSCstring str;
	str << text;
	return setCellText(str);
}
long WSCsheet::setText(const char* text)
{
	WSCstring str;
	str = text;
	return setCellText(str);
}
long WSCsheet::setText(const WSCvariant& text)
{
	WSCstring str;
	str = text;
	return setCellText(str);
}
long WSCsheet::setText(const WSCstring& text)
{
	return setCellText(text);
}
long WSCsheet::setText(long col, long row, short text)
{
	WSCstring str;
	str << text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, WSCushort text)
{
	WSCstring str;
	str << text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, long text)
{
	WSCstring str;
	str << text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, WSCulong text)
{
	WSCstring str;
	str << text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, float text)
{
	WSCstring str;
	str << text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, double text)
{
	WSCstring str;
	str << text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, const char* text)
{
	WSCstring str;
	str = text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, const WSCvariant& text)
{
	WSCstring str;
	str = text;
	return setCellText(col, row, str);
}
long WSCsheet::setText(long col, long row, const WSCstring& text)
{
	return setCellText(col, row, text);
}
WSCstring WSCsheet::getText(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);

	if(cell) {
		return cell->text;
	}
	return "";
}
long WSCsheet::setFixedText(long col, long row, short text)
{
	WSCstring str;
	str = text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, WSCushort text)
{
	WSCstring str;
	str << text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, long text)
{
	WSCstring str;
	str << text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, WSCulong text)
{
	WSCstring str;
	str = text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, float text)
{
	WSCstring str;
	str << text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, double text)
{
	WSCstring str;
	str << text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, const char* text)
{
	WSCstring str = text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, const WSCvariant& text)
{
	WSCstring str;
	str = text;
	return setFixedCellText(col, row, str);
}
long WSCsheet::setFixedText(long col, long row, const WSCstring& text)
{
	return setFixedCellText(col, row, text);
}
WSCstring WSCsheet::getFixedText(long col, long row)
{
	if(col < 0 || row < 0) {
		return "";
	}
	if((row >= getFixedRowCount() && col >= getFixedColumnCount())) {
		return "";
	}
	return getText(col, row);
}
long WSCsheet::getCellNo(WSCpoint* pt, long* col, long* row)
{
	long x = 0;
	long y = 0;
	long i;

	*row = -1;
	*col = -1;

	if(pt->x >= getClientWidth() || pt->y >= getClientHeight()) {
		return WS_NO_ERR;
	}
	
	for(i = 0; (i < getFixedRowCount()) && (y < pt->y); i++) {
		y += getRowHeight(i);
		if(y >= pt->y) {
			*row = i;
		}
	}
	for(i = 0; (i < getFixedColumnCount()) && (x < pt->x); i++) {
		x += getColumnWidth(i);
		if(x >= pt->x) {
			*col = i;
		}
	}
	if(*row == -1) {
		for(i = getTopVisibleRow(); (i < getRowCount()) && (y < pt->y); i++) {
			y += getRowHeight(i);
			if(y >= pt->y) {
				*row = i;
			}
		}
	}
	if(*col == -1) {
		for(i = getTopVisibleCol(); (i < getColumnCount()) && (x < pt->x); i++) {
			x += getColumnWidth(i);
			if(x >= pt->x) {
				*col = i;
			}
		}
	}
	return WS_NO_ERR;
}
long WSCsheet::setFocusCell(long col, long row)
{
	if(col >= getColumnCount() || row >= getRowCount()) {
		return WS_ERR;
	}
	long oldCol, oldRow;

	if(col < 0) {
		col = -1;
	}
	if(row < 0) {
		row = -1;
	}
	oldCol = _focusCol;
	oldRow = _focusRow;
	_focusCol = col;
	_focusRow = row;

	focusCellVisible(oldCol, oldRow, col, row);

	draw();
	
	return WS_NO_ERR;
}
void WSCsheet::setRow(long row)
{
	setStartRow(row);
	_endRow = _startRow;
}
void WSCsheet::setStartRow(long row)
{
	if(row < 0) {
		_startRow = -1;
	} else {
		_startRow = row;
	}
}
void WSCsheet::setEndRow(long row)
{
	if(row < 0) {
		_endRow = -1;
	} else {
		_endRow = row;
	}
}
void WSCsheet::setCol(long col)
{
	setStartCol(col);
	_endCol = _startCol;
}
void WSCsheet::setStartCol(long col)
{
	if(col < 0) {
		_startCol = -1;
	} else {
		_startCol = col;
	}
}
void WSCsheet::setEndCol(long col)
{
	if(col < 0) {
		_endCol = -1;
	} else {
		_endCol = col;
	}
}
void WSCsheet::setSelectCell(WSCbool val)
{
	_selectCell = val;
	_mouseSelect = False;
	setFocusCell(-1, -1); 
}
long WSCsheet::getFocusCellRect(WSCrect* rect)
{
	return getVisibleCellRect(_focusCol, _focusRow, rect);
}
long WSCsheet::getVisibleCellRect(long col, long row, WSCrect* rect)
{
	rect->x = 0;
	rect->y =0;
	rect->width = 0;
	rect->height = 0;

	if(col < 0 || col >= getColumnCount()) {
		return WS_ERR;
	}
	if(row < 0 || row >= getRowCount()) {
		return WS_ERR;
	}
	long r;
	long height;
	
	for(r = 0; r < getFixedRowCount(); r++) {
		WSCsheetRow* rowdata = getRowData(r);
		if(rowdata) {
			height = rowdata->getRowHeight();
			rect->height = (height == WSCSHEET_DEFAULT ? _fixedColHeight : height);
			rect->y += rect->height;
		}
	}
	for(r = getTopVisibleRow(); r <= row; r++) {
		WSCsheetRow* rowdata = getRowData(r);
		if(rowdata) {
			height = rowdata->getRowHeight();
			rect->height = (height == WSCSHEET_DEFAULT ? _colHeight : height);
			if(r < row) {
				rect->y += rect->height;
			}
		}
	}
	long c;
	for(c = 0; c < getFixedColumnCount(); c++) {
		rect->width = getWidthValue(c);
		rect->x += rect->width;
	}
	for(c = getTopVisibleCol(); c <= col; c++) {
		rect->width = getWidthValue(c);
		if(c < col) {
			rect->x += rect->width;
		}
	}

	return WS_NO_ERR;
}
long WSCsheet::getCellRect(long col, long row, WSCrect* rect)
{
	rect->x = 0;
	rect->y =0;
	rect->width = 0;
	rect->height = 0;

	if(col < 0 || col >= getColumnCount()) {
		return WS_ERR;
	}
	if(row < 0 || row >= getRowCount()) {
		return WS_ERR;
	}
	long height;
	
	for(long r = 0; r <= row; r++) {
		WSCsheetRow* rowdata = getRowData(r);
		if(rowdata) {
			height = rowdata->getRowHeight();
			if(height == WSCSHEET_DEFAULT) {
				if(row < getFixedRowCount()) {
					height = _fixedColHeight;
				} else {
					height = _colHeight;
				}
			}
			rect->height = height;
			if(r > 0) {
				rect->y += rect->height;
			}
		}
	}
	for(long c = 0; c <= col; c++) {
		rect->width = getWidthValue(c);
		if(c > 0) {
			rect->x += rect->width;
		}
	}

	return WS_NO_ERR;
}
long WSCsheet::setCellDefFont(short fontno)
{
	_font = fontno;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellFont(short fontno)
{
	WSCsheetCell* cell;
	
	if(getSelectCell()) {
		long startRow = getStartRow();
		long startCol = getStartCol();

		if(startRow < getFixedRowCount()) {
			startRow = getFixedRowCount();
		}
		if(startCol < getFixedColumnCount()) {
			startCol = getFixedColumnCount();
		}
		for(long row = startRow; row <= getEndRow(); row++) {
			for(long col = startCol; col <= getEndCol(); col++) {
				cell = getCell(col, row, True);
				if(cell) {
					cell->fontno = fontno;
				}
			}
		}
	} else {
		cell = getCell(_startCol, _startRow, True);
		if(!cell) {
			return WS_ERR;
		}
		cell->fontno = fontno;
	}

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellFont(long col, long row, short fontno)
{
	WSCsheetCell* cell = getCell(col, row, True);
	if(!cell) {
		return WS_ERR;
	}
	cell->fontno = fontno;

	draw();

	return WS_NO_ERR;
}
short WSCsheet::getCellFont(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return cell->fontno;
	}
	return _font;
}
long WSCsheet::setFixedCellFont(short fontno)
{
	_fixedFont = fontno;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellAlignemnt(char align)
{
	WSCsheetCell* cell;
	
	if(getSelectCell()) {
		long startRow = getStartRow();
		long startCol = getStartCol();

		if(startRow < getFixedRowCount()) {
			startRow = getFixedRowCount();
		}
		if(startCol < getFixedColumnCount()) {
			startCol = getFixedColumnCount();
		}
		for(long row = startRow; row <= getEndRow(); row++) {
			for(long col = startCol; col <= getEndCol(); col++) {
				cell = getCell(col, row, True);
				if(cell) {
					cell->align = align;
				}
			}
		}
	} else {
		cell = getCell(_startCol, _startRow, True);
		if(!cell) {
			return WS_ERR;
		}
		cell->align = align;
	}

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellAlignemnt(long col, long row, char align)
{
	WSCsheetCell* cell = getCell(col, row, True);
	if(!cell) {
		return WS_ERR;
	}
	cell->align = align;

	draw();

	return WS_NO_ERR;
}
char WSCsheet::getCellAlignemnt(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return cell->align;
	}
	return WS_LEFT;
}
long WSCsheet::setFixedCellAlignemnt(long col, long row, char align)
{
	if(col < 0 || row < 0) {
		return WS_ERR;
	}
	if((row >= getFixedRowCount() && col >= getFixedColumnCount())) {
		return WS_ERR;
	}
	WSCsheetCell* cell = getCell(col, row, True);
	if(cell) {
		cell->align = align;
	}
	return WS_NO_ERR;
}
char WSCsheet::getFixedCellAlignemnt(long col, long row)
{
	if(col < 0 || row < 0) {
		return WS_ERR;
	}
	if((row >= getFixedRowCount() && col >= getFixedColumnCount())) {
		return WS_ERR;
	}
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return cell->align;
	}
	return WS_LEFT;
}
long WSCsheet::setCellLock(WSCbool lock)
{
	WSCsheetCell* cell;
	
	if(getSelectCell()) {
		long startRow = getStartRow();
		long startCol = getStartCol();

		if(startRow < getFixedRowCount()) {
			startRow = getFixedRowCount();
		}
		if(startCol < getFixedColumnCount()) {
			startCol = getFixedColumnCount();
		}
		for(long row = startRow; row <= getEndRow(); row++) {
			for(long col = startCol; col <= getEndCol(); col++) {
				cell = getCell(col, row, True);
				if(cell) {
					cell->lock = lock;
				}
			}
		}
	} else {
		cell = getCell(_startCol, _startRow, True);
		if(!cell) {
			return WS_ERR;
		}
		cell->lock = lock;
	}

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setCellLock(long col, long row, WSCbool lock)
{
	WSCsheetCell* cell = getCell(col, row, True);
	if(!cell) {
		return WS_ERR;
	}
	cell->lock = lock;

	draw();

	return WS_NO_ERR;
}
WSCbool WSCsheet::getCellLock(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return cell->lock;
	}
	return WSCSHEET_CELL_NOLOCK;
}
long WSCsheet::insertRow()
{
	long rows = 1;
	long row = _startRow;
	
	if(getSelectCell() && getStartCol() < getFixedColumnCount()) {
		row = getStartRow();
		rows = getEndRow() - getStartRow() + 1;
	} else if(_startRow < getFixedRowCount() || _startRow >= getRowCount()) {
		return WS_ERR;
	}
	insertRow(row, rows);

	return WS_NO_ERR;
}
long WSCsheet::insertRow(long row, long rows)
{
	if(row < getFixedRowCount() && rows <= 0) {
		return WS_ERR;
	}
	WSCbool rf = getNoRefresh();
	
	setNoRefresh(True);

	for(long count = 0; count < rows; count++) {
		WSCsheetRow* rowdata = new WSCsheetRow(_cols, WSCSHEET_DEFAULT);
		_rowData.add(rowdata, row);
	}
	long oldRows = _rows;
	_rows += rows;

	rowSize(oldRows);
	
	setNoRefresh(rf);

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::insertCol()
{
	long cols = 1;
	long col = _startCol;
	
	if(getSelectCell() && getStartRow() < getFixedRowCount()) {
		col = getStartCol();
		cols = getEndCol() - getStartCol() + 1;
	} else if(_startCol < getFixedColumnCount() || _startCol >= getColumnCount()) {
		return WS_ERR;
	}
	insertCol(col, cols);

	return WS_NO_ERR;
}
long WSCsheet::insertCol(long col, long cols)
{
	if(col < getFixedColumnCount() || cols <= 0) {
		return WS_ERR;
	}
	WSCbool rf = getNoRefresh();
	
	setNoRefresh(True);

	for(long row = 0; row < getRowCount(); row++) {
		WSCsheetRow* rowdata = getRowData(row);
		if(rowdata) {
			rowdata->insertCol(col, cols);
		}
	}
	for(long count = 0; count < cols; count++) {
		long* width = new long;
		*width = WSCSHEET_DEFAULT;
		_colWidthData.add(width, col);
	}
	setNoRefresh(rf);

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::deleteRow()
{
	long rows = 1;
	long row = _startRow;
	
	if(getSelectCell() && getStartCol() < getFixedColumnCount()) {
		row = getStartRow();
		rows = getEndRow() - getStartRow() + 1;
	} else if(_startRow < getFixedRowCount() || _startRow >= getRowCount()) {
		return WS_ERR;
	}
	deleteRow(row, rows);

	return WS_NO_ERR;
}
long WSCsheet::deleteRow(long row, long rows)
{
	if(row < getFixedRowCount() || rows <= 0) {
		return WS_ERR;
	}
	WSCbool rf = getNoRefresh();
	
	setNoRefresh(True);

	long max = getRowCount() - row;
	if(rows > max) {
		rows = max;
	}
	for(long count = 0; count < rows; count++) {
		WSCsheetRow* rowdata = (WSCsheetRow*)_rowData.getData(row);
		if(rowdata) {
			rowdata->clear();
			delete rowdata;
		}
		_rowData.delPos(row);
	}
	long oldRows = _rows;
	_rows -= rows;

	rowSize(oldRows);
	
	setNoRefresh(rf);

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::deleteCol()
{
	long cols = 1;
	long col = _startCol;
	
	if(getSelectCell() && getStartRow() < getFixedRowCount()) {
		col = getStartCol();
		cols = getEndCol() - getStartCol() + 1;
	} else if(_startCol < getFixedColumnCount() || _startCol >= getColumnCount()) {
		return WS_ERR;
	}
	deleteCol(col, cols);

	return WS_NO_ERR;
}
long WSCsheet::deleteCol(long col, long cols)
{
	if(col < getFixedColumnCount() || cols <= 0 || cols > (getColumnCount() - getFixedColumnCount())) {
		return WS_ERR;
	}
	WSCbool rf = getNoRefresh();
	
	setNoRefresh(True);
	long max = getColumnCount() - col;
	if(cols > max) {
		cols = max;
	}
	for(long row = 0; row < getRowCount(); row++) {
		WSCsheetRow* rowdata = getRowData(row);
		if(rowdata) {
			rowdata->deleteCol(col, cols);
		}
	}
	long count;
	for(count = 0; count < cols; count++) {
		long* width = getWidthData(col);
		if(width) {
			delete width;
		}
		_colWidthData.delPos(col);
	}
	_colWidthData.setSize(getColumnCount());

	setNoRefresh(rf);

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::setTopVisibleRow(long row)
{
	if(row < getFixedRowCount() || row >= getRowCount()) {
		return WS_ERR;
	}
	_topVisibleRow = row;

	draw();

	return WS_NO_ERR;
}
long WSCsheet::setTopVisibleCol(long col)
{
	if(col < getFixedColumnCount() || col >= getColumnCount()) {
		return WS_ERR;
	}
	_topVisibleCol = col;

	draw();
	return WS_NO_ERR;
}
///////////////////////////////////////////////////////////////////////////////
// local function
//
long WSCsheet::setCellText(const WSCstring& text)
{
	WSCsheetCell* cell;
	
	if(getSelectCell()) {
		long startRow = getStartRow();
		long startCol = getStartCol();

		if(startRow < getFixedRowCount()) {
			startRow = getFixedRowCount();
		}
		if(startCol < getFixedColumnCount()) {
			startCol = getFixedColumnCount();
		}
		for(long row = startRow; row <= getEndRow(); row++) {
			for(long col = startCol; col <= getEndCol(); col++) {
				cell = getCell(col, row, True);
				if(cell) {
					cell->text = text;
				}
			}
		}
	} else {
		cell = getCell(_startCol, _startRow, True);
		if(!cell) {
			return WS_ERR;
		}
		cell->text = text;
	}

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::setCellText(long col, long row, const WSCstring& text)
{
	WSCsheetCell* cell;
	
	if(row < 0 || row >= getRowCount()) {
		return WS_ERR;
	}
	if(col < 0 || col >= getColumnCount()) {
		return WS_ERR;
	}
	cell = getCell(col, row, True);
	if(!cell) {
		return WS_ERR;
	}
	cell->text = text;

	draw();
	
	return WS_NO_ERR;
}
WSCstring WSCsheet::getCellText(long col, long row)
{
	WSCsheetCell* cell = getCell(col, row);
	if(cell) {
		return cell->text;
	}
	return "";
}
long WSCsheet::setFixedCellText(long col, long row, const WSCstring& text)
{
	WSCsheetCell* cell;
	
	WSCstring str = text;
	if(col < 0 || row < 0) {
		return WS_ERR;
	}
	if((row >= getFixedRowCount() && col >= getFixedColumnCount())) {
		return WS_ERR;
	}
	cell = getCell(col, row, True);
	if(cell) {
		cell->text = text;
	} else {
		return WS_ERR;
	}

	draw();
	
	return WS_NO_ERR;
}
WSCstring WSCsheet::getFixedCellText(long col, long row)
{
	if(col < 0 || row < 0) {
		return "";
	}
	if((row >= getFixedRowCount() && col >= getFixedColumnCount())) {
		return "";
	}
	return getCellText(col, row);
}
void WSCsheet::adjustScrollBar()
{
	long width = this->getProperty(WSNwidth);
	long height = this->getProperty(WSNheight);

	_clientWidth = width-_bar_thick-_shadow_thick * 2;
	_clientHeight = height-_bar_thick-_shadow_thick * 2;

	_sheet->setProperty(WSNx, _shadow_thick);
	_sheet->setProperty(WSNy, _shadow_thick);
	_sheet->setProperty(WSNwidth, _clientWidth);
	_sheet->setProperty(WSNheight, _clientHeight);

	_hscrBar->setProperty(WSNx, _shadow_thick);
	_hscrBar->setProperty(WSNy, _clientHeight + _shadow_thick);
	_hscrBar->setProperty(WSNwidth, _clientWidth);
	_hscrBar->setProperty(WSNheight, _bar_thick);

	WSCulong val = 10;

	_hscrBar->setPropertyV(WSNmaximum,(WSCulong)(_cols + val - getFixedColumnCount() - 1));
	_hscrBar->setPropertyV(WSNsliderSize,(WSCulong)val);
	_hscrBar->setPropertyV(WSNincrement, (WSCushort)1);

	_vscrBar->setProperty(WSNx, _clientWidth + _shadow_thick);
	_vscrBar->setProperty(WSNy, _shadow_thick);
	_vscrBar->setProperty(WSNwidth, _bar_thick);
	_vscrBar->setProperty(WSNheight, _clientHeight);

	_vscrBar->setPropertyV(WSNmaximum,(WSCulong)(_rows + val - getFixedRowCount() - 1));
	_vscrBar->setPropertyV(WSNsliderSize,(WSCulong)val);
	_vscrBar->setPropertyV(WSNincrement, (WSCushort)1);


}
char* WSCsheet::getUseScrBarClass()
{
  return "WSCvbscrBar";
}
long WSCsheet::drawFixedCell(WSDdev* dev, long col, long row, WSCrect rect)
{
	WSCsheetCell* cell = getCell(col, row);
	if(!cell) {
		return WS_ERR;
	}
	if(rect.x >= getClientWidth()) {
		return WS_NO_ERR;
	}
	if(rect.y >= getClientHeight()) {
		return WS_NO_ERR;
	}
	long startRow = getStartRow();
	long endRow = getEndRow();
	long startCol = getStartCol();
	long endCol = getEndCol();

	WSCbool c = False;
	if(startCol == 0 && startRow == 0) {
		c = False;
	} else if(col == getFocusCol() || (col < getFixedColumnCount() && row == getFocusRow())) {
		c = True;
	} else if(_mouseSelect && col >= startCol && 
			  col <= endCol && row >= startRow && row <= endRow) {
		c = True;
	}
	dev->setForeColor(getFixedBkColor());

	dev->drawFillRect(rect.x, rect.y, rect.width, rect.height);

	dev->setForeColor((c) ? WS_DF_FORECOLOR : WS_DF_TOPSHADOWCOLOR);

	dev->drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
	dev->drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
 
	dev->setForeColor((c) ? WS_DF_TOPSHADOWCOLOR : WS_DF_FORECOLOR);

	dev->drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);

	if(col == getFixedColumnCount()-1) {
		dev->setForeColor(WS_DF_FORECOLOR);
	} else {
		dev->setForeColor((c) ? WS_DF_TOPSHADOWCOLOR : WS_DF_FORECOLOR);
	}
	dev->drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);

	dev->setForeColor(getFixedTextColor());

	if((getVertAutoNumber() && col == 0)  || (getHorzAutoNumber() && row == 0)) {
		if(row != 0 || col != 0) {
			WSCstring str;
			char      align;
			
			str = (row == 0 ? col : row);
			align = (row == 0 ? WS_CENTER : WS_RIGHT);

			dev->drawString(rect.x+2, rect.y+1, 
							rect.width-3, rect.height-1, 
							getFixedCellFont(), align, str);
		}
	} else {
		dev->drawString(rect.x+2, rect.y+1, 
						rect.width-3, rect.height-1, 
						getFixedCellFont(), cell->align, cell->text);
	}
	return WS_NO_ERR;
}
long WSCsheet::drawCell(WSDdev* dev, long col, long row, WSCrect rect)
{
	WSCsheetCell* cell = getCell(col, row);
	if(!cell) {
		return WS_ERR;
	}
	if(rect.x >= getClientWidth()) {
		return WS_NO_ERR;
	}
	if(rect.y >= getClientHeight()) {
		return WS_NO_ERR;
	}
	long startRow = getStartRow();
	long endRow = getEndRow();
	long startCol = getStartCol();
	long endCol = getEndCol();

	WSCbool c = False;
	short   color;

	color = (cell->crBkClr == WSCSHEET_DEFCOLOR ? getCellDefBkColor() : cell->crBkClr);

	if(col == _focusCol && row == _focusRow) {
		c = False;
	} else if(_mouseSelect && col >= startCol && 
			  col <= endCol && row >= startRow && row <= endRow) {
		c = True;
	}

	dev->setForeColor((c) ? _selectBackColor : color);
	
	dev->drawFillRect(rect.x, rect.y, rect.width, rect.height);

	long focusCol = getFocusCol();
	long focusRow = getFocusRow();
	
	if((col == focusCol && row == focusRow) || 
	   (focusCol < getFixedColumnCount() && col == getFixedColumnCount() && row == getFocusRow()) || 
	   (focusCol == col && focusRow < getFixedRowCount() && row == getFixedRowCount())) {

		dev->setForeColor(WS_DF_FORECOLOR);

		rect.x--;
		rect.y--;
		dev->drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
		dev->drawLine(rect.x, rect.y, rect.x, rect.y + rect.height+1);
	
		dev->drawLine(rect.x, rect.y + rect.height, rect.x + rect.width+1, rect.y + rect.height);
		dev->drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height+1);
	} else {
		rect.x--;
		rect.y--;

		short linetype = (cell->crLine == WSCSHEET_DEFAULT ? _gridLines : cell->crLine);
		
		if(linetype == WSCSHEET_VERT || linetype == WSCSHEET_BOTH) {
			dev->setForeColor(getGridColor());
			if(col == getFixedColumnCount() && row == getFocusRow()) {
				dev->drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
			}
			if(col == getColumnCount()-1) {
				dev->setForeColor(WS_DF_FORECOLOR);
			} else {
				dev->setForeColor(getGridColor());
			}
			dev->drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
		}
		if(linetype == WSCSHEET_HORZ || linetype == WSCSHEET_BOTH) {
			dev->setForeColor(getGridColor());
			if(col == getFocusCol() && row == getFixedRowCount()) {
				dev->drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
			}
			if(row == getRowCount()-1) {
				dev->setForeColor(WS_DF_FORECOLOR);
			}
			dev->drawLine(rect.x, rect.y + rect.height, rect.x + rect.width+1, rect.y + rect.height);
		}
	}
	color = (cell->crFgClr == WSCSHEET_DEFCOLOR ? getCellDefTextColor() : cell->crFgClr);
	dev->setForeColor((c) ? WS_DF_WORKBACKCOLOR : color);

	short font = (cell->fontno == WSCSHEET_DEFFONT ? getCellDefFont() : cell->fontno);
	
	dev->drawString(rect.x+3, rect.y+1, 
					rect.width-3, rect.height-1, 
					font, cell->align, cell->text);

	return WS_NO_ERR;
}
long WSCsheet::rowSize(long rows)
{
	WSCbool ref = getNoRefresh();
	
	setNoRefresh(True);

	if(rows < _fixedRows) {
		_fixedRows = rows;
	}
	if(_topVisibleRow < _fixedRows) {
		_topVisibleRow = _fixedRows;
	}

	if(_focusRow >= rows) {
		setFocusCell(-1, -1);
	}

	_rowData.setSize(rows);
	_rows = rows;

	adjustScrollBar();

	setNoRefresh(ref);

	draw();
	
	return WS_NO_ERR;
}
long WSCsheet::colSize(long cols)
{
	WSCbool ref = getNoRefresh();

	setNoRefresh(True);

	if(cols < _fixedCols) {
		_fixedCols = cols;
	}
	if(_topVisibleCol < _fixedCols) {
		_topVisibleCol = _fixedCols;
	}

	if(_focusCol >= cols) {
		setFocusCell(-1, -1);
	}

	if(cols != _cols) {
		long row;
		
		for(row = 0; row < getRowCount(); row++) {
			WSCsheetRow* rowdata = getRowData(row);
			if(rowdata) {
				rowdata->setColSize(cols);
			}
		}
		_cols = cols;

		_colWidthData.setSize(_cols);
	}

	adjustScrollBar();

	setNoRefresh(ref);

	draw();

	return WS_NO_ERR;
}
void WSCsheet::setRowCol(long col, long row)
{
	if(_focusRow != row || _focusCol != col) {
		_endRow = row;
		_endCol = col;

		if(row < getFixedRowCount()) {
			_startRow = 0;
		}
		if(_startRow == 0) {
			_endRow = getRowCount();
		}
		if(col < getFixedColumnCount()) {
			_startCol = 0;
		}
		if(_startCol == 0) {
			_endCol = getColumnCount();
		}
	}
}
void WSCsheet::focusCellVisible(long oldCol, long oldRow, long newCol, long newRow)
{
	WSCsheetCell* cell;
	WSCstring text;

	if(!_edit) {
		return;
	}
	if(oldCol >= getFixedColumnCount() && oldRow >= getFixedRowCount() && _edit->getVisible()) {
		text = _edit->getProperty(WSNlabelString);
		cell = getCell(oldCol, oldRow, True);
		cell->text = text;
	}

	if(newCol >= getFixedColumnCount() && newRow >= getFixedRowCount() && getEditEnabled()) {
		cell = getCell(newCol, newRow, True);
		text = cell->text;
		if(cell->lock) {
			_edit->setVisible(False);
			return;
		}
		WSCrect rect;
		if(getFocusCellRect(&rect) == WS_NO_ERR) {
			WSCulong val;
			if((rect.x + rect.width) > getClientWidth() && newCol != getTopVisibleCol()) {
				_hscrBar->getPropertyV(WSNvalue, &val);
				if((long)val < getColumnCount() - getFixedColumnCount()) {
					_hscrBar->setPropertyV(WSNvalue, ++val);
					getFocusCellRect(&rect);
				}
			}
			if((rect.y + rect.height) > getClientHeight() && newRow != getTopVisibleRow()) {
				_vscrBar->getPropertyV(WSNvalue, &val);
				if((long)val < getRowCount() - getFixedRowCount()) {
					_vscrBar->setPropertyV(WSNvalue, ++val);
					getFocusCellRect(&rect);
				}
			}
			WSCbool fval = False;
			if(oldCol != newCol || oldRow != newRow || !_edit->getVisible()) {
				_edit->setSelect(0, 0);
				_edit->setVisible(False);
				fval = True;
			}
			_edit->setPropertyV(WSNlabelString, text.getString());
			_edit->setPropertyV(WSNx, (short)rect.x);
			_edit->setPropertyV(WSNy, (short)rect.y);
			_edit->setPropertyV(WSNwidth, (unsigned short)(rect.width-1));
			_edit->setPropertyV(WSNheight, (unsigned short)(rect.height-1));
			_edit->setPropertyV(WSNfont, (unsigned char)cell->fontno);

			_edit->setFocus(False);
//			_edit->setVisible((getSelectCell() ? False : True));

			if(fval) {
				_edit->setSelect(0, (short)strlen(text.getString()));
				_edit->setPropertyV(WSNcursorPos, (short)strlen(text.getString()));
			}

			_edit->setVisible((getSelectCell() ? False : True));
			_edit->setFocus(True);
		}
	} else {
		_edit->setVisible(False);
	}
}
void WSCsheet::posMoveCell(WSCpoint* pt)
{
	WSCrect  rect;
	WSCulong val;
	
	getVisibleCellRect(getFixedColumnCount(), 0, &rect);
	
	if(pt->x < rect.x) {
		_hscrBar->getPropertyV(WSNvalue, &val);
		if(val > 0) {
			_hscrBar->setPropertyV(WSNvalue, --val);
			setRowCol(_endCol-1, _endRow);
		}
	} else if(pt->x > getClientWidth()) {
		_hscrBar->getPropertyV(WSNvalue, &val);
		if((long)val < getColumnCount() - getFixedColumnCount()) {
			_hscrBar->setPropertyV(WSNvalue, ++val);
			setRowCol(_endCol+1, _endRow);
		}
	}
	getVisibleCellRect(0, getFixedRowCount(), &rect);
	
	if(pt->y < rect.y) {
		_vscrBar->getPropertyV(WSNvalue, &val);
		if(val > 0) {
			_vscrBar->setPropertyV(WSNvalue, --val);
			setRowCol(_endCol, _endRow-1);
		}
	} else if(pt->y > getClientHeight()) {
		_vscrBar->getPropertyV(WSNvalue, &val);
		if((long)val < getRowCount() - getFixedRowCount()) {
			_vscrBar->setPropertyV(WSNvalue, ++val);
			setRowCol(_endCol, _endRow+1);
		}
	}
}
long WSCsheet::getWidthValue(long col)
{
	long* width = getWidthData(col);
	if(!width) {
		return 0;
	}
	return (*width == WSCSHEET_DEFAULT ? _colWidth : *width);
}
WSCsheetCell* WSCsheet::getCell(long col, long row, WSCbool alloc)
{
	if(col < 0 || col >= getColumnCount()) {
		return NULL;
	}
	if(row < 0 || row >= getRowCount()) {
		return NULL;
	}
	WSCsheetRow* rowdata = getRowData(row);
	if(!rowdata) {
		return NULL;
	}
	WSCsheetCell* cell = rowdata->getCell(col);
	if(!cell) {
		if(alloc) {
			cell = rowdata->newCell(col);
		} else {
			cell = &_defCell;
		}
	}
	return cell;
}
WSCsheetRow* WSCsheet::getRowData(long row)
{
	if(row < 0 || row >= _rowData.getNum()) {
		return NULL;
	}
	WSCsheetRow* rowdata = (WSCsheetRow*)_rowData.getData(row);
	if(!rowdata) {
		rowdata = new WSCsheetRow(_cols, WSCSHEET_DEFAULT);
		_rowData.setData(row, rowdata);
	}
	return rowdata;
}
long* WSCsheet::getWidthData(long col)
{
	if(col < 0 || col >= getColumnCount()) {
		return NULL;
	}
	long* width = (long*)_colWidthData.getData(col);
	if(!width) {
		width = new long;
		*width = WSCSHEET_DEFAULT;
		_colWidthData.setData(col, width);
	}
	return width;
}
///////////////////////////////////////////////////////////////////////////////
// database
//
long WSCsheet::setDataSource(const char* name)
{
	if(_dataSource) {
		delete[] _dataSource;
	}
	_dataSource = WSGFstrdup(name);
	
	return WS_NO_ERR;
}
long WSCsheet::setDataSource(WSCstring& name)
{
	if(_dataSource) {
		delete[] _dataSource;
	}
	_dataSource = WSGFstrdup(name.getString());
	
	return WS_NO_ERR;
}
long WSCsheet::setTableName(const char* table)
{
	if(_tableName) {
		delete[] _tableName;
	}
	_tableName = WSGFstrdup(table);

	return WS_NO_ERR;
}
long WSCsheet::setTableName(WSCstring& table)
{
	if(_tableName) {
		delete[] _tableName;
	}
	_tableName = WSGFstrdup(table.getString());

	return WS_NO_ERR;
}
long WSCsheet::setDbItem(const char* item)
{
	if(_dbItem) {
		delete[] _dbItem;
	}
	_dbItem = WSGFstrdup(item);

	return WS_NO_ERR;
}
long WSCsheet::setDbItem(WSCstring& item)
{
	if(_dbItem) {
		delete[] _dbItem;
	}
	_dbItem = WSGFstrdup(item.getString());

	return WS_NO_ERR;
}
long WSCsheet::setDbSortItem1(const char* item)
{
	if(_dbSortItem1) {
		delete[] _dbSortItem1;
	}
	_dbSortItem1 = WSGFstrdup(item);

	return WS_NO_ERR;
}
long WSCsheet::setDbSortItem1(WSCstring& item)
{
	if(_dbSortItem1) {
		delete[] _dbSortItem1;
	}
	_dbSortItem1 = WSGFstrdup(item.getString());

	return WS_NO_ERR;
}
long WSCsheet::setDbSort1(WSCuchar sort)
{
	_dbSort1 = sort;
	return WS_NO_ERR;
}
long WSCsheet::setDbSortItem2(const char* item)
{
	if(_dbSortItem2) {
		delete[] _dbSortItem2;
	}
	_dbSortItem2 = WSGFstrdup(item);

	return WS_NO_ERR;
}
long WSCsheet::setDbSortItem2(WSCstring& item)
{
	if(_dbSortItem2) {
		delete[] _dbSortItem2;
	}
	_dbSortItem2 = WSGFstrdup(item.getString());

	return WS_NO_ERR;
}
long WSCsheet::setDbSort2(WSCuchar sort)
{
	_dbSort2 = sort;
	return WS_NO_ERR;
}
long WSCsheet::setDbSortItem3(const char* item)
{
	if(_dbSortItem3) {
		delete[] _dbSortItem3;
	}
	_dbSortItem3 = WSGFstrdup(item);

	return WS_NO_ERR;
}
long WSCsheet::setDbSortItem3(WSCstring& item)
{
	if(_dbSortItem3) {
		delete[] _dbSortItem3;
	}
	_dbSortItem3 = WSGFstrdup(item.getString());

	return WS_NO_ERR;
}
long WSCsheet::setDbSort3(WSCuchar sort)
{
	_dbSort3 = sort;
	return WS_NO_ERR;
}
long WSCsheet::setDbFilter(const char* filter)
{
	if(_dbFilter) {
		delete[] _dbFilter;
	}
	_dbFilter = WSGFstrdup(filter);

	return WS_NO_ERR;
}
long WSCsheet::setDbFilter(WSCstring& filter)
{
	if(_dbFilter) {
		delete[] _dbFilter;
	}
	_dbFilter = WSGFstrdup(filter.getString());

	return WS_NO_ERR;
}
long WSCsheet::setDbStmtString(const char* stmt)
{
	if(_dbStmtString) {
		delete[] _dbStmtString;
	}
	_dbStmtString = WSGFstrdup(stmt);

	return WS_NO_ERR;
}
long WSCsheet::setDbStmtString(WSCstring& stmt)
{
	if(_dbStmtString) {
		delete[] _dbStmtString;
	}
	_dbStmtString = WSGFstrdup(stmt.getString());

	return WS_NO_ERR;
}
long WSCsheet::dbRefresh()
{
	return dbDataSet();;
}
///////////////////////////////////////////////////////////////////////////////
// database local function
//
long WSCsheet::dbConnect()
{
	if(_vdb) {
		return WS_NO_ERR;
	}
	WSCbase* object = WSGIappObjectList()->getInstance("WSCbase", getDataSource());
	if(object) {
		_vdb = (WSCvdb*)object->cast("WSCvdb");
	} else {
		_vdb = NULL;
	}
	return WS_NO_ERR;
}
long WSCsheet::setFixedCelldbItem(WSCdbRecord* rs)
{
	if(!_vdb) {
		return WS_NO_ERR;
	}
	WSCstring str = getDbItem();
	WSCstring stmt = getDbStmtString();
	long col;
	long width;
	long fixedCols = getFixedColumnCount();
	
	WSDfont* font = WSGIappFontSet()->getFont(_fixedFont);

	if(*(stmt.getString()) == '\0' && strcmp(str.getString(), "*") != 0 && *(str.getString()) != '\0') {
		long words = str.getWords(",");
		for(col = 0; col < words; col++){
			WSCstring* word;
			word = new WSCstring(str.getWord(col, ","));
			setFixedCellText(col + fixedCols, 0, (char*)word->getString());
			setFixedCellAlignemnt(col + fixedCols, 0, WS_CENTER);
			
			width = getColumnWidth(col + fixedCols);
			if(width < (font->getStringWidth(word) + 4)) {
				setColumnWidth(col + fixedCols, font->getStringWidth(word) + 4);
			}
		}
	} else if(rs){
		char name[80];
		WSCstring word;
		long cols = rs->getColCount();
		for(col = 0; col < cols; col++){
			rs->getColName(col, name);
			setFixedCellText(col + fixedCols, 0, name);
			setFixedCellAlignemnt(col + fixedCols, 0, WS_CENTER);
			
			word = name;
			width = getColumnWidth(col + fixedCols);
			if(width < (font->getStringWidth(&word)+4)) {
				setColumnWidth(col + fixedCols, font->getStringWidth(&word) + 4);
			}
		}
	}

	return WS_NO_ERR;
}
long WSCsheet::dbDataSet()
{
	_dbError = "";
	
	dbConnect();

	if(!_vdb) {
		return WS_NO_ERR;
	}
	if(*((char*)_vdb->getProperty(WSNhostname)) == '\0') {
		return WS_NO_ERR;
	}

	WSDfont* font = WSGIappFontSet()->getFont(_fixedFont);

	WSCstring stmt = getDbStmtString();
	if(*(stmt.getString()) == '\0') {
		stmt << "select " << getDbItem() << " from " << getTableName();
		WSCstring work;

		work = getDbFilter();
		if(*(work.getString()) != '\0') {
			stmt << " " << work;
		}
		WSCstring sort;
		work = getDbSortItem1();
		if(*(work.getString()) != '\0') {
			sort << work;
			if(!getDbSort1()) {
				sort << " asc";
			} else {
				sort << " desc";
			}
			work = getDbSortItem2();
			if(*(work.getString()) != '\0') {
				sort << "," << work;
				if(!getDbSort2()) {
					sort << " asc";
				} else {
					sort << " desc";
				}
			}
			work = getDbSortItem3();
			if(*(work.getString()) != '\0') {
				sort << "," << work;
				if(!getDbSort3()) {
					sort << " asc";
				} else {
					sort << " desc";
				}
			}
		}
		if(*(sort.getString()) != '\0') {
			stmt << " order by " << sort;
		}
	}

	if(*(stmt.getString()) == '\0') {
		return WS_NO_ERR;
	}

	WSCbool ref = getNoRefresh();

	setNoRefresh(True);
	
	setEditEnabled(False);
	setHorzAutoNumber(False);

//	clear(2, 2);
	long ret = WS_NO_ERR;
	
	WSCdbRecord rs(_vdb);

	if(_vdb->open() == WS_NO_ERR) {

		if(rs.open(stmt) == WS_NO_ERR) {
			setColumnCount(rs.getColCount() + getFixedColumnCount()+1);
			long rows = rs.getRowCount();
			if(rows < 0) {
				rows = 0;
			}
			dataClear(rs.getColCount() + getFixedColumnCount(), rows + getFixedRowCount());

			if(_dbCellTitle) {
				setFixedCelldbItem(&rs);
			}
			
			WSCstring str;
			char* val = new char[32767*2];
			long col = 0;
			long row = 1;
			long width;
			long fixedCols = getFixedColumnCount();
			
			while (!rs.isEOF()) {
				for(col = 0; col < rs.getColCount(); col++) {
					rs.getColStringValue(col, val);
					if(row >= getRowCount()) {
						setRowCount(row+1);
					}
					setCellText(col + fixedCols, row, val);

					if(_dbCellAutoResize) {
						str = val;
						width = getColumnWidth(col + fixedCols);
						if(width < (font->getStringWidth(&str)+4)) {
							setColumnWidth(col + fixedCols, font->getStringWidth(&str)+4);
						}
					}
				}
				row++;
				rs.moveNext();
			}
			delete[] val;
		} else {
			_dbError = rs.getErrorMessage();
			if(_dbCellTitle) {
				dataClear();
			} else {
				dataClear(getColumnCount(), 2);
			}
			ret = WS_ERR;
		}
		rs.close();
	} else {
		_dbError = _vdb->getErrorMessage();
		if(_dbCellTitle) {
			dataClear();
		} else {
			dataClear(getColumnCount(), 2);
		}
		ret = WS_ERR;
	}
	adjustScrollBar();

	setNoRefresh(ref);

	draw();

	return ret;
}
long WSCsheet::dataClear(long col, long row)
{
	WSCbool ref = getNoRefresh();
	
	setNoRefresh(True);

	setRowCount(row);
	setColumnCount(col);

	setStartCol(1);
	setEndCol(col);
	setStartRow(1);
	setEndRow(row);
	setSelectCell(True);
	setText("");
	setSelectCell(False);
	
	_topVisibleRow = _fixedRows;
	_topVisibleCol = _fixedCols;

	_focusRow = 1;
	_focusCol = 1;
	_startRow = _focusRow;
	_startCol = _focusCol;
	_endRow = _focusRow;
	_endCol = _focusCol;
	_selectCell = False;
	
	setNoRefresh(ref);
	
	draw();

	return WS_NO_ERR;
}
WSCstring WSCsheet::getDbErrorMsg()
{
	return _dbError;
}
