/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.addon.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.NowikiTag;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;

public class CTeXTag
extends NowikiTag {
    public CTeXTag() {
        super("ctex");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            String sizeStr = "D=3";
            Map<String, String> tagAtttributes = this.getAttributes();
            String attributeValue = tagAtttributes.get("d");
            if (attributeValue != null) {
                try {
                    int size = Integer.parseInt(attributeValue);
                    if (size > 0 && size <= 10) {
                        sizeStr = "D=" + size;
                    }
                }
                catch (NumberFormatException size) {
                    // empty catch block
                }
            }
            String urlContent = "\\displaystyle " + content;
            String texFormula = "http://www.mathtran.org/cgi-bin/mathtran?" + sizeStr + "&amp;tex=" + URLEncoder.encode(urlContent, "utf-8");
            writer.append("<span class=\"ctex\"><img src=\"" + texFormula + "\" alt=\"");
            CTeXTag.copyMathLTGT(content, writer);
            writer.append("\" /></span>");
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            _out.append("\\begin{math}\n");
            _out.append(String.valueOf(content) + "\n");
            _out.append("\\end{math}");
        }
    }

    public boolean isReduceTokenStack() {
        return true;
    }
}

