/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.expr;

import info.bliki.wiki.template.expr.Scanner;
import info.bliki.wiki.template.expr.SyntaxError;
import info.bliki.wiki.template.expr.ast.ASTNode;
import info.bliki.wiki.template.expr.ast.IParserFactory;
import info.bliki.wiki.template.expr.ast.NumberNode;
import info.bliki.wiki.template.expr.ast.SymbolNode;
import info.bliki.wiki.template.expr.operator.ASTNodeFactory;
import info.bliki.wiki.template.expr.operator.InfixOperator;
import info.bliki.wiki.template.expr.operator.Operator;
import info.bliki.wiki.template.expr.operator.PostfixOperator;
import info.bliki.wiki.template.expr.operator.PrefixOperator;

public class Parser
extends Scanner {
    boolean fRelaxedSyntax;

    public Parser() {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, false);
    }

    public Parser(boolean relaxedSyntax) throws SyntaxError {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
    }

    public Parser(IParserFactory factory, boolean relaxedSyntax) throws SyntaxError {
        this.fRelaxedSyntax = relaxedSyntax;
        this.fFactory = factory;
    }

    public void setFactory(IParserFactory factory) {
        this.fFactory = factory;
    }

    public IParserFactory getFactory() {
        return this.fFactory;
    }

    private PrefixOperator determinePrefixOperator() {
        Operator oper = null;
        int i = 0;
        while (i < this.fOperList.size()) {
            oper = (Operator)this.fOperList.get(i);
            if (oper instanceof PrefixOperator) {
                return (PrefixOperator)oper;
            }
            ++i;
        }
        return null;
    }

    private PostfixOperator determinePostfixOperator() {
        Operator oper = null;
        int i = 0;
        while (i < this.fOperList.size()) {
            oper = (Operator)this.fOperList.get(i);
            if (oper instanceof PostfixOperator) {
                return (PostfixOperator)oper;
            }
            ++i;
        }
        return null;
    }

    private InfixOperator determineBinaryOperator() {
        Operator oper = null;
        int i = 0;
        while (i < this.fOperList.size()) {
            oper = (Operator)this.fOperList.get(i);
            if (oper instanceof InfixOperator) {
                return (InfixOperator)oper;
            }
            ++i;
        }
        return null;
    }

    private ASTNode parsePrimary() {
        if (this.fToken == 30) {
            PrefixOperator oper = this.determinePrefixOperator();
            if (oper instanceof PrefixOperator) {
                this.getNextToken();
                ASTNode temp = this.parseLookaheadOperator(oper.getPrecedence());
                if (oper.getFunctionName().equals("PreMinus") && temp instanceof NumberNode) {
                    ((NumberNode)temp).toggleSign();
                    return temp;
                }
                return oper.createFunction(this.fFactory, temp);
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no prefix operator.");
        }
        return this.getFactor();
    }

    private ASTNode parseLookaheadOperator(int min_precedence) {
        int lookahead;
        ASTNode rhs = this.parsePrimary();
        while ((lookahead = this.fToken) == 30) {
            Operator operLookahead = this.determineBinaryOperator();
            if (operLookahead instanceof InfixOperator) {
                Operator binOper = operLookahead;
                if (binOper.getPrecedence() > min_precedence) {
                    rhs = this.parseOperators(rhs, operLookahead.getPrecedence());
                    continue;
                }
                if (binOper.getPrecedence() != min_precedence || binOper.getGrouping() != 1) break;
                rhs = this.parseOperators(rhs, operLookahead.getPrecedence());
                continue;
            }
            operLookahead = this.determinePostfixOperator();
            if (!(operLookahead instanceof PostfixOperator) || operLookahead.getPrecedence() <= min_precedence) break;
            this.getNextToken();
            rhs = ((PostfixOperator)operLookahead).createFunction(this.fFactory, rhs);
        }
        return rhs;
    }

    private ASTNode parseOperators(ASTNode lhs, int min_precedence) {
        ASTNode rhs = null;
        while (this.fToken == 30) {
            Operator oper = this.determineBinaryOperator();
            if (oper instanceof InfixOperator) {
                if (oper.getPrecedence() < min_precedence) break;
                this.getNextToken();
                rhs = this.parseLookaheadOperator(oper.getPrecedence());
                lhs = ((InfixOperator)oper).createFunction(this.fFactory, lhs, rhs);
                continue;
            }
            oper = this.determinePostfixOperator();
            if (oper instanceof PostfixOperator) {
                this.getNextToken();
                lhs = ((PostfixOperator)oper).createFunction(this.fFactory, lhs);
                continue;
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no infix or postfix operator.");
            break;
        }
        return lhs;
    }

    public ASTNode parse(String expression) throws SyntaxError {
        this.initialize(expression);
        ASTNode temp = this.parseOperators(this.parsePrimary(), 0);
        if (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            this.throwSyntaxError("End-of-file not reached.");
        }
        return temp;
    }

    private ASTNode getNumber(boolean negative) throws SyntaxError {
        ASTNode temp = null;
        Object[] result = this.getNumberString();
        String number = (String)result[0];
        int numFormat = (Integer)result[1];
        try {
            if (negative) {
                number = String.valueOf('-') + number;
            }
            temp = numFormat < 0 ? this.fFactory.createDouble(number) : this.fFactory.createInteger(number, numFormat);
        }
        catch (Throwable e) {
            this.throwSyntaxError("Number format error: " + number, number.length());
        }
        this.getNextToken();
        return temp;
    }

    private int getIntegerNumber() throws SyntaxError {
        Object[] result = this.getNumberString();
        String number = (String)result[0];
        int numFormat = (Integer)result[1];
        int intValue = 0;
        try {
            intValue = Integer.parseInt(number, numFormat);
        }
        catch (NumberFormatException e) {
            this.throwSyntaxError("Number format error (not an int type): " + number, number.length());
        }
        this.getNextToken();
        return intValue;
    }

    private ASTNode getFactor() throws SyntaxError {
        if (this.fToken == 20) {
            SymbolNode temp = this.fFactory.createSymbol(this.fOperatorString);
            this.getNextToken();
            return temp;
        }
        if (this.fToken == 139) {
            return this.getNumber(false);
        }
        if (this.fToken == 14) {
            this.getNextToken();
            ASTNode temp = this.parseOperators(this.parsePrimary(), 0);
            if (this.fToken != 15) {
                this.throwSyntaxError("')' expected.");
            }
            this.getNextToken();
            return temp;
        }
        switch (this.fToken) {
            case 15: {
                this.throwSyntaxError("Too much open ) in factor.");
            }
        }
        this.throwSyntaxError("Error in factor at character: '" + this.fCurrentChar + "' (" + this.fToken + ")");
        return null;
    }
}

