/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ac.dendai.cdl.mori.wikie.mapred.WMapper;
import jp.ac.dendai.cdl.mori.wikie.parser.WPageElementHandler;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class ISBNMapper
extends WMapper {
    private static String isbnHeader;

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        isbnHeader = job.get("wikie.map.isbnheader", "978");
    }

    public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            WPageElementHandler page = this.createPageHandler(value);
            String id = page.getId();
            String text = WNormalizer.deleteNonPrintingChar(page.getText());
            List<String> isbnArrayList = ISBNMapper.getISBNCode(text, isbnHeader);
            for (String isbnCode : isbnArrayList) {
                output.collect((Object)new Text(id), (Object)new Text(isbnCode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> getISBNCode(String text, String header) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("ISBN *(([0-9]|-)+)");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String code = matcher.group(1).replaceAll("-", "");
            if (code.length() == 10) {
                code = ISBNMapper.convertISBN10To13(code, header);
            }
            if (code.length() != 13) continue;
            result.add(code);
        }
        return result;
    }

    public static String convertISBN10To13(String code10, String header) {
        StringBuffer code13 = new StringBuffer(String.valueOf(header) + code10.substring(0, code10.length() - 1));
        int sum = 0;
        int i = 0;
        while (i < code13.length()) {
            Character c = new Character(code13.charAt(i));
            int n = Integer.parseInt(c.toString());
            sum = i % 2 == 0 ? (sum += n * 1) : (sum += n * 3);
            ++i;
        }
        int checkDigit = 10 - sum % 10;
        if (checkDigit % 10 != 0) {
            code13.append(checkDigit);
        } else {
            code13.append(0);
        }
        return code13.toString();
    }
}

