/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.mapred;

import java.io.IOException;
import jp.ac.dendai.cdl.mori.wikie.mapred.WMapper;
import jp.ac.dendai.cdl.mori.wikie.parser.WPageElementHandler;
import jp.ac.dendai.cdl.mori.wikie.util.WEntry;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class NodeMapper
extends WMapper {
    public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            WPageElementHandler page = this.createPageHandler(value);
            WEntry entry = this.normalizer.normalize(page.getTitle());
            String title = entry.toString();
            if (StringUtils.isNotBlank(title)) {
                String id = page.getId();
                String text = WNormalizer.deleteNonPrintingChar(page.getText());
                String kind = this.linkUtils.getKind(entry, text);
                if (!kind.equals("other")) {
                    output.collect((Object)new Text(id), (Object)new Text(String.valueOf(title) + "\t" + kind));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

