package jp.ac.dendai.cdl.mori.wikie.parser;

import jp.ac.dendai.cdl.mori.wikie.main.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * <pre>
 * page要素の解析に使うHandler
 * タイトルや本文など、XMLの各要素をフィールド変数に格納していく。
 * フィールド変数に格納されるのはXMLの要素の値の文字列そのまま。
 * 解析後はこのクラスのオブジェクトがWikipediaの記事1件を表現することになる。
 * </pre>
 * @author Mori
 *
 */
public class WPageElementHandler extends DefaultHandler {
    /**
     * 処理に使うStringBuffer
     */
    private StringBuffer tmp;
    /**
     * タイトル
     */
    private String title;
    /**
     * ページのID
     */
    private String pageId;
    /**
     * restrictions要素
     */
    private String restrictions;
    /**
     * リビジョンID
     */
    private String revisionId;
    /**
     * タイムスタンプ
     */
    private String timestamp;
    /**
     * 最後に編集したユーザ名（あるいはIPアドレス）
     */
    private String userName;
    /**
     * 最後に編集したユーザID（IPアドレスユーザの場合はブランク）
     */
    private String userId;
    /**
     * text要素
     */
    private String text;

    public WPageElementHandler() {
        text = new String();
    }

    @Override
    public void characters(char[] ch, int start, int length)
            throws SAXException {
        tmp.append(new String(ch, start, length));
    }

    @Override
    public void startElement(String uri, String localName, String name,
            Attributes attributes) throws SAXException {
        tmp = new StringBuffer();
    }

    @Override
    public void endElement(String uri, String localName, String name)
            throws SAXException {
        String value = tmp.toString();
        if (name.equals(WikIE.TITLE_ELEMENT)) {
            title = value;
        }
        else if (name.equals(WikIE.ID_ELEMENT) && pageId == null) {
            pageId = value;
        }
        else if (name.equals(WikIE.ID_ELEMENT) && pageId != null) {
            revisionId = value;
        }
        else if (name.equals(WikIE.TIMESTAMP_ELEMENT)) {
            timestamp = value;
        }
        else if (name.equals(WikIE.USERNAME_ELEMENT)) {
            userName = value;
        }
        else if (name.equals(WikIE.ID_ELEMENT) && revisionId != null) {
            userId = value;
        }
        else if (name.equals(WikIE.IP_ELEMENT)) {
            userName = value;
        }
        else if (name.equals(WikIE.TEXT_ELEMENT)) {
            text = value;
        }
    }

    /**
     * XMLのtitle要素を取得する
     * @return
     */
    public String getTitle() {
        return title;
    }

    /**
     * XMLのページのid要素を取得する
     * @return
     */
    public String getId() {
        return pageId;
    }

    /**
     * XMLのrestrictions要素を取得する
     * @return
     */
    public String getRestrictions() {
        return restrictions;
    }

    /**
     * XMLのrevisionのid要素を取得する
     * @return
     */
    public String getRevisionId() {
        return revisionId;
    }

    /**
     * XMLのtimestamp要素を取得する
     * @return
     */
    public String getTimestamp() {
        return timestamp;
    }

    /**
     * XMLのusername要素を取得する
     * @return
     */
    public String getUserName() {
        return userName;
    }

    /**
     * XMLのユーザのid要素を取得する
     * @return
     */
    public String getUserId() {
        return userId;
    }

    /**
     * XMLのtext要素を取得する
     * @return
     */
    public String getText() {
        return text;
    }

}
