// SPDX-License-Identifier: GPL-2.0-or-later
/** 
 * @file  AboutDlg.h
 *
 * @brief Declaration file for CAboutDlg.
 *
 */
#pragma once

#include <memory>
#include <Poco/BasicEvent.h>
#include "MergeApp.h"

class CAboutDlg
{
// Construction
public:
	CAboutDlg();
	~CAboutDlg();
	int DoModal();

	AboutInfo m_info;
	Poco::BasicEvent<int> m_onclick_contributers;

private:
	CAboutDlg(const CAboutDlg &);
	CAboutDlg & operator=(const CAboutDlg &);

	class Impl;
	std::unique_ptr<Impl> m_pimpl;
};
