# Translations instructions

If you are interested in translating WinMerge to your own language, we'd be happy to include your language as well.

We have a list with the [status of current translations](https://winmerge.org/translations/), so you can check if your language is already available and/or it needs to be updated.

## Translating WinMerge

We use [gettext](https://en.wikipedia.org/wiki/Gettext) PO files for the translation of the WinMerge program.

PO files are plain text, so you can even translate using a normal text editor. But we recommend that you use [poEdit](https://poedit.net/) or other tools that can handle and manipulate PO files.

**NOTE:** We are not using gettext itself as a translation system, we only use PO- and POT-files as files to have translations. Our translation system is custom-made for WinMerge.

The PO template `English.pot` and the language translation files are located under the `Translations\WinMerge\` folder in the source code.

### Add new language to WinMerge

 1. Copy and rename `English.pot` to `YourLanguage.po`, where *YourLanguage* is the english name of your language.

 2. Now translate what you can using [poEdit](https://poedit.net/). If you are not sure with one or the other translation, mark it as fuzzy. You can enter a comment in poEdit to give some information about your thoughts to other translators.

 3. Compile WinMerge to test your changes.

### Update existing language

 1. Get the `English.pot` template and the `YourLanguage.po` file you want to improve.
 2. Start [poEdit](https://poedit.net/) with `YourLanguage.po` and select *Update from .pot file* from the *Catalog* menu.
 3. Select `English.pot` and wait until poEdit has finished merging the template and the current translation.
 4. The *untranslated* strings (and *fuzzy* translations) are always at the top of the list.
 5. Compile WinMerge to test your changes.

## Translating ShellExtension

ShellExtension (Explorer integration component) can be translated by translating PO file in the `Translations\ShellExtension\`-folder in the WinMerge source tree.

After updating one or more PO files the updated `RC` files are generated by the script `CreateTranslatedRcFiles.vbs`.

### Add new ShellExtension translation

 1. Copy and rename `English.pot` to `YourLanguage.po`, where *YourLanguage* is the english name of your language.

 2. Now translate what you can using [poEdit](https://poedit.net/). If you are not sure with one or the other translation, mark it as fuzzy. You can enter a comment in poEdit to give some information about your thoughts to other translators.

 3. Add a resource definition to file `ShellExtension\ShellExtension.rc`: 

```
"#if !defined(AFX_RESOURCE_DLL) || defined(AFX_TARG_XXX)\r\n"
"#ifdef _WIN32\r\n"
"LANGUAGE LANG_XXX, SUBLANG_DEFAULT\r\n"
"#pragma code_page(65001)\r\n"
"#include ""Languages\\ShellExtensionYourLanguage.rc""\r\n"
"#endif //_WIN32\r\n"
"#endif\r\n"
"\r\n"
```

### Update existing ShellExtension translation

 1. Get the `English.pot` template and the `YourLanguage.po` file you want to improve.
 2. Start [poEdit](https://poedit.net/) with `YourLanguage.po` and select *Update from .pot file* from the *Catalog* menu.
 3. Select `English.pot` and wait until poEdit has finished merging the template and the current translation.
 4. The *untranslated* strings (and *fuzzy* translations) are always at the top of the list.

## Translating Installer

Installer translation files are in `Translations\InnoSetup\` folder. Look for a file named by your language.

If one does not yet exist, copy and rename `English.isl` to `YourLanguage.isl`, where *YourLanguage* is the english name of your language.

Translate the text after the `=` character:

```
OptionalFeatures=Optional Features:
CompanyName=Thingamahoochie Software
…
```

## Translating ReadMe.txt

Please consider translating also `ReadMe.txt` file - it is shown in end of installer and is added to Start-menu. Translated versions of `ReadMe.txt` are in `Translations\Docs\Readme\` folder. And master `ReadMe.txt` is in `Docs\Users\ReadMe.txt`.

## Translating Website

We use PO files for the website too. But the source files are in its own [GitHub project](https://github.com/winmerge/website/).
