<?php

require_once(dirname(__FILE__) . '/../CommonDAO.php');
require_once(dirname(__FILE__) . '/MemberCollection.php');

class MemberDAO extends CommonDAO
{
    function &findByPrimaryKey($id)
    {
        return $this->queryOne("select * from member where id = $id");
    }
    
    function &findAll()
    {
        return $this->query("select * from member");
    }

    function insert($member)
    {
        return $this->doInsert("member", $member->get());
    }
    
    function update($member)
    {
        $id = $this->qstr($member->getPrimaryKey());
        return $this->doUpdate("member", $member->get(), "id = $id");
    }

    /**
     * Collection󥹥󥹤
     * @param $recordSet ̥쥳ɥå
     * @return Collection󥹥
     */
    function &createCollection($recordSet)
    {
        $collection = new MemberCollection($recordSet);
        return $collection;
    }
}

?>
