<?php
/**
 * @class  AbstractDAO
 * @brief  ǡ١Τݴ쥯饹
 * @author Daijiro Abe
 * @date   2005.12.15
 */

require_once(dirname(__FILE__) . '/Collection.php');
require_once(dirname(__FILE__) . '/ConnectionFactory.php');
require_once(dirname(__FILE__) . '/DBError.php');
require_once(dirname(__FILE__) . '/DateTime.php');

// Хѿ
$ADODB_FETCH_MODE = ADODB_FETCH_ASSOC;

class AbstractDAO
{
    var $conn = NULL;
    var $useCache = false;
    var $errors = array();
    
    /**
     * ǥХå⡼ɤꤷޤ
     * @param $isDebug ǥХå⡼
     */
    function setIsDebug($isDebug)
    {
        $this->conn->debug = true;
    }
    
    /**
     * Ѥʸ򥵥˥ޤ
     * @param $str ʸ
     * @return ˥ʸ
     */
    function qstr($str)
    {
        return $this->conn->qstr($str);
    }
    
    /**
     * åȤɤ֤ޤ
     * @return åȤ trueǤʤfalse
     */
    function getUseCache()
    {
        return $this->useCache;
    }
    
    /**
     * åȤɤꤷޤ
     * @param $useCache åȤɤ
     */
    function setUseCache($useCache)
    {
        $this->useCache = $useCache;
    }
    
    /**
     * åǥ쥯ȥꤷޤ
     * @param $dir åǥ쥯ȥ
     */
    function setCacheDirectory($dir)
    {
        global $ADODB_CACHE_DIR;
        if(!file_exists($dir))
            mkdir($dir,0777);
        $ADODB_CACHE_DIR = $dir;
    }
    
    /**
     * ǡ١³ޤ
     */
    function connect($dsn)
    {
        $this->conn = & ConnectionFactory::getInstance($dsn);
    }
    
    /**
     * 顼򥹥åɲ
     * @param $time 
     * @param $msg  顼å
     */
    function pushError($time, $msg)
    {
        $error = & new DBError($time, $msg);
        $this->errors[] = $error;
    }
    
    /**
     * ¹Ԥ
     * @param $sql SQLʸ
     * @param $params ѥ᡼
     * @return 
     */
    function &query($sql,$params=false)
    {
        if($this->getUseCache())
            $recordSet = &$this->conn->CacheExecute($sql, $params);
        else
            $recordSet = &$this->conn->Execute($sql, $params);
        
        if(is_bool($recordSet))
        {
            if(!$recordSet)
                $this->pushError(time(), $this->conn->ErrorMsg());
            return $recordSet;
        }
        else
        {
            $collection = & $this->createCollection($recordSet);
            return $collection;
        }
    }
    
    /**
     * query¹Ԥƺǽη̤饪֥Ȥ
     * @param $sql SQLʸ
     * @param $params ѥ᡼
     * @return 
     */
    function &queryOne($sql, $params=false)
    {
        $collection = & $this->query($sql, $params);
        if(!$collection)
            $retval = NULL;
        else
        {
            if(is_object($collection))
            {
                if($collection->hasNext())
                    $retval = $collection->next();
                else
                    $retval = NULL;
            }
            else
                $retval = $collection;
        }
        return $retval;
    }
    
    /**
     * Collection󥹥󥹤
     * @param $recordSet ̥쥳ɥå
     * @return Collection󥹥
     */
    function &createCollection(&$recordSet)
    {
        return new Collection($recordSet);
    }
    
    /**
     * Insert¹Ԥ
     * @param $table  ơ֥̾
     * @param $record ǡϢ
     * @return  trueԤ false
     */
    function doInsert($table, $record)
    {
        return $this->conn->AutoExecute($table, $record, 'INSERT');
    }
    
    /**
     * Update¹Ԥ
     * @param $table ơ֥̾
     * @param $record ǡϢ
     * @param $where update
     * @param $forceUpdate falseξ硢ͤפ˹ʤ
     */
    function doUpdate($table, $record, $where, $forceUpdate = false)
    {
        return $this->conn->AutoExecute($table, $record, 'UPDATE', $where, $forceUpdate);
    }
    
    /**
     * ȥ󥶥򳫻Ϥ
     */
    function startTrans()
    {
        $this->conn->StartTrans();
    }
    
    /**
     * ȥ󥶥λ
     * @return  trueԻ false
     */
    function completeTrans()
    {
        return $this->conn->CompleteTrans();
    }
    
    /**
     * տŪ˥ȥ󥶥Ԥޤ
     */
    function failTrans()
    {
        $this->conn->FailTrans();
    }
    
    /**
     * ȥ󥶥󤬼ԤɤĴ٤ޤ
     * @return SQL¹Ԥǥ顼뤫FailTrans()뤵줿 false
     */
    function hasFailedTrans()
    {
        return $this->conn->HasFailedTrans();
    }
}

?>
