<?php
/**
 * @class  DateTime
 * @brief  դ˴ؤǡѴ륯饹(for PostgreSQL)
 * @author Daijiro Abe
 * @date   2005.12.26
 */

define("YMD_EN", 0);
define("YMD_JA", 1);

class DateTime
{
    /**
     * ͤΤʬʸ֤ޤ
     * @return դʸͤʤNULL֤ޤ
     */
    function getDate($value)
    {
        if(strlen($value))
        {
            $datetime = preg_split("/\ /", $value);
            return $datetime[0];
        }
        else
            return NULL;
    }

    /**
     * ǯ֤ޤ
     * @return ǯͤʤ 0 ֤ޤ
     */
    function getYear($value)
    {
        if(strlen($value))
        {
            $value = str_replace("/", "-", $value);
            $date = preg_split("/\-/", $value);
            return $date[0];
        }
        else
            return 0;
    }

    /**
     * ֤ޤ
     * @return ͤʤȤ 0 ֤ޤ
     */
    function getMonth($value)
    {
        if($value)
        {
            $value = str_replace("/", "-", $value);
            $date = preg_split("/\-/", $value);
            return $date[1];
        }
        else
            return 0;
    }
    

    /**
     * ֤ޤ
     * @return ͤʤȤ 0 ֤ޤ
     */
    function getDay($value)
    {
        if($value)
        {
            $value = str_replace("/", "-", $value);
            $date = preg_split("/\-/", $value);
            return $date[2];
        }
        else
            return 0;
    }
    
    /**
     * ͤΤʬʸ֤ޤ
     * @return ֤򤢤魯ʸ󡣥ǡʤȤNULL֤ޤ
     */
    function getTime($value)
    {
        if(strlen($value))
        {
            $datetime = preg_split("/\ /", $value);
            $time = preg_split("/\./", $datetime[1]);
            return $time[0];
        }
        else
            return NULL;
    }
    
    /**
     * ֤֤ޤ
     * @return ֡ͤʤȤ -1 ֤ޤ
     */
    function getHour($value)
    {
        $timeStr = DateTime::getTime($value);
        if($timeStr)
        {
            $time = preg_split("/\:/", $timeStr);
            return $time[0];
        }
        else
            return -1;
    }

    /**
     * ʬ֤ޤ
     * @return ʬͤʤȤ -1 ֤ޤ
     */
    function getMinute($value)
    {
        $timeStr = DateTime::getTime($value);
        if($timeStr)
        {
            $time = preg_split("/\:/", $timeStr);
            return $time[1];
        }
        else
            return -1;
    }

    /**
     * ä֤ޤ
     * @return áͤʤȤ -1 ֤ޤ
     */
    function getSecond($value)
    {
        $timeStr = DateTime::getTime($value);
        if($timeStr)
        {
            $time = preg_split("/\:/", $timeStr);
            return $time[2];
        }
        else
            return -1;
    }
    
    /**
     * YYYY/MM/DD ֤ޤ
     * @param format YMD_JA ʤܸǡYMD_ENʤбѸ֤ޤ
     * @return YYYY/MM/DD֤ޤͤʤNULL֤ޤ
     */
    function getYMD($value, $format = YMD_EN)
    {
        if(strlen($value))
        {
            $value = str_replace("/", "-", $value);
            $dateStr = DateTime::getDate($value);
            $date = preg_split("/\-/", $dateStr);
            if($format == YMD_EN)
                return sprintf("%04d/%02d/%02d", $date[0], $date[1], $date[2]);
            else
                return sprintf("%04dǯ%02d%02d", $date[0], $date[1], $date[2]);
        }
        else
            return NULL;
    }

    /**
     * UNIXॹפ֤ͤޤ
     * @return 1970/01/01 ÿ֤ޤԤ -1 ֤ޤ
     */
    function getTimestamp($value)
    {
        if(strlen($value))
        {
            $datetime = preg_split("/\./", $value);
            return strtotime($datetime[0]);
        }
        else
            return -1;
    }
    
    /**
     * ɽʸѴޤ
     * @param format YMD_JAʤܸ졢YMD_ENʤбѸѴޤ
     * @return ɽʸͤʤNULL֤ޤ
     */
    function getDateTimeStr($value, $format=YMD_EN)
    {
        if(strlen($value))
        {
            return sprintf("%s %s", DateTime::getYMD($value, $format), DateTime::getTime($value));
        }
        else
            return NULL;
    }

}

?>
