<?php
/**
 * @class  Action
 * @brief  󥯥饹(ݥ饹)
 * @author Daijiro Abe
 * @date   2005.10.31
 */

class Action
{
    var $scope = 'request';
    var $validate = false;
    var $input = '';
    var $name = "";
    var $filter = "";
    
    /**
     * פꤹ
     * @param $scope פͤȤ request ޤ scope 
     */
    function setScope($scope)
    {
        $this->scope = $scope;
    }
    
    /**
     * פ
     * @return 
     */
    function getScope()
    {
        return $this->scope;
    }
    
    /**
     * ХǡԤɤ
     * @param $isValidate ХǡԤɤ
     */
    function setValidate($isValidate)
    {
        $this->validate = $isValidate;
    }
    
    /**
     * ХǡԤɤ֤ޤ
     * @return ХǡԤ trueԤʤ false
     */
    function isValidate()
    {
        return $this->validate;
    }
    
    /**
     * Хǡ˼Ԥ˸ƤӽФڡ
     * @param $page Хǡ˼ԤΥڡ
     */
    function setInput($page)
    {
        $this->input = $page;
    }
    
    /**
     * Хǡ˼Ԥ˸ƤӽФڡ֤ޤ
     * @return Хǡ˼ԤΥڡ
     */
    function getInput()
    {
        return $this->input;
    }
    
    /**
     * Bean ̾ꤷޤ
     * @param $name Bean̾
     */
    function setName($name)
    {
        $this->name = $name;
    }
    
    /**
     * Bean֤̾ޤ
     * @return Bean̾
     */
    function getName()
    {
        return $this->name;
    }
    
    /**
     * Filter̾ꤷޤ
     * @param $name Filter̾
     */
    function setFilter($name)
    {
        $this->filter = $name;
    }
    
    /**
     * Filter֤̾ޤ
     * @return Filter̾
     */
    function getFilter()
    {
        return $this->filter;
    }
    
    /**
     * ȥ󥶥ȡޤ
     * @param $request HttpRequest֥
     */
    function generateToken($request)
    {
        $rand = mt_rand();
        $str = $rand . $request->getRemoteAddr() . microtime();
        return md5($str);
    }
    
    /**
     * ȥ󥶥ȡ¸ޤ
     * @param $request HttpRequest֥
     */
    function saveToken(&$request)
    {
        $token = $this->generateToken($request);
        $session = $request->getSession(true);
        $session->setAttribute('phpgear_transaction_token', $token);
    }
    
    /**
     * ȥ󥶥ȡꥻåȤޤ
     * @param $request HttpRequest֥
     */
    function resetToken(&$request)
    {
        $session = $request->getSession(true);
        $session->removeAttribute('phpgear_transaction_token');
    }
    
    /**
     * ȥ󥶥ȡݻ졢
     * ĥꥯȥѥ᡼Ƥ뤫򸡾ڤޤ
     * @param $request HttpRequest֥
     * @param $reset å˥ȡꥻåȤ뤫ɤ
     */
    function isTokenValid(&$request, $reset)
    {
        $session = $request->getSession(true);
        $sess_token = $session->getAttribute('phpgear_transaction_token');
        $req_token = $request->getParameter('phpgear_transaction_token');

        if($reset)
            $this->resetToken($request);

        if($sess_token == $req_token)
            return true;
        else
            return false;
    }
    
    /**
     * ꥯȤ˥顼°Ȥɲäޤ
     * @param $request HttpRequest֥
     * @param $errors ActionErrors֥
     */
    function addErrors(&$request, &$errors)
    {
        $action_errors = $this->getErrors($request);
        if(!$action_errors)
            $action_errors = new ActionErrors();
        $properties = $errors->properties();
        foreach($properties as $property)
        {
            $errs = $errors->get($property);
            foreach($errs as $error)
                $action_errors->add($property, $error);
        }
        $this->saveErrors($request, $action_errors);
    }
    
    /**
     * ꥯȤϿƤ륨顼ƼФޤ
     * @param $request HttpRequest֥
     * @return ActionErrors ֥
     */
    function &getErrors(&$request)
    {
        return $request->getAttribute('phpgear_errors');
    }
    
    /**
     * ꥯȤ˥顼°Ȥ¸ޤ
     * @param $request HttpRequest֥
     * @param $errors ActionErrors֥
     */
    function saveErrors(&$request, &$errors)
    {
        $request->setAttribute('phpgear_errors', $errors);
    }
    
    /**
     * ¹Ԥޤ
     * @param $config ConfigLoader󥹥
     * @param $form ե
     * @param $request ꥯ
     * @param $response 쥹ݥ
     * @return ActionForward󥹥
     */
    function execute(&$config, &$form, &$request, &$response)
    {
        die('Action::execute()ɬС饤ɤƤ');
    }
}
?>
