<?php
/**
 * @class  ActionErrors
 * @brief  ActionErrorΥ쥯󥯥饹
 * @author Daijiro Abe
 * @date   2005.11.01
 */

require_once(dirname(__FILE__) . "/ActionError.php");

class ActionErrors
{
    var $errors = array();
    
    /**
     * ץѥƥ˴ؤƥ顼åɲäޤ
     * @param $property ץѥƥ
     * @param $error    ActionError
     */
    function add($property, $error)
    {
        if(!array_key_exists($property, $this->errors))
            $this->errors[$property] = array();
        $this->errors[$property][] = $error;
    }
    
    /**
     * 顼åƥꥢޤ
     */
    function clear()
    {
        $this->errors = array();
    }
    
    /**
     * 顼åϿƤʤɤĴ٤
     * @return 顼åʤ trueǤʤ false
     */
    function isEmpty()
    {
        if(count($this->errors) == 0)
            return true;
        else
            return false;
    }
    
    /**
     * 顼å֤ޤ
     * @param $property бץѥƥNULLʤƤΥ顼
     * @return ActionError
     */
    function get($property=NULL)
    {
        if($property)
        {
            if(array_key_exists($property, $this->errors))
                return $this->errors[$property];
            else
                return array();
        }
        $errors = array_values($this->errors);
        $retval = array();
        foreach($errors as $error_array)
        {
            $retval = array_merge($retval, $error_array);
        }
        return $retval;
    }
    
    /**
     * ʤȤ⣱İʾϿƤץѥƥ֤̾ޤ
     * @retrun ץѥƥ̾
     */
    function properties()
    {
        $properties = array();
        $_properties = array_keys($this->errors);
        foreach($_properties as $property)
        {
            if(count($this->errors[$property]) > 0)
                $properties[] = $property;
        }
        return $properties;
    }
    
    /**
     * 顼θĿ֤ޤ
     * @param $property бץѥƥNULLʤƤΥ顼
     * @return 顼θĿ
     */
    function size($property=NULL)
    {
        $errors = $this->get($property);
        return count($errors);
    }
}

?>
