<?php
/**
 * @class  ActionForm
 * @brief  ե९饹(ݥ饹)
 * @author Daijiro Abe
 * @date   2005.11.01
 */

require_once(dirname(__FILE__) . "/../File/IXMLLoader.php");
require_once(dirname(__FILE__) . "/ActionErrors.php");

class ActionForm extends IXMLLoader
{
    var $properties = array();

    // 
    var $property;
    var $conditions = array();
    var $stack = array();
    var $error;
    
    /**
     * Υ֥ȤΥץѥƥƥåȤ
     * @param $data ֥
     */
    function transferData(&$data)
    {
        $methods = get_class_methods(get_class($data));
        foreach($methods as $method)
        {
            $subindex = -1;
            $pos = strpos($method, 'get');
            if($pos === 0)
                $subindex = 3;
            else
            {
                $pos = strpos($method, 'is');
                if($pos === 0)
                    $subindex = 0;
            }

            if($subindex >= 0)
            {
                $value = $data->$method();
                $prop = substr($method, $subindex);
                $setMethod = "set" . $prop;
                if(method_exists($this, $setMethod))
                    $this->$setMethod($value);
            }
        }
    }
    
    /**
     * BeanƤΥץѥƥǥեȤξ֤˥ꥻåȤޤ
     * @param $config ConfigLoader֥
     * @param $request HttpRequest֥
     */
    function reset(&$config, &$request)
    {
        // ⤷ʤ
    }
    
    /**
     * ValidateXMLեɤ߹
     * @param $filename XMLե̾
     */
    function load($filename)
    {
        if(file_exists($filename))
            return $this->loadFile($filename);
        else
            return false;
    }
    
    /**
     * γϻ˸ƤФ륳Хåؿ
     * @param $parser XMLѡ
     * @param $name   ̾
     * @param $attrib °Ϣ
     */
    function startElement($parser, $name, $attrib)
    {
        switch($name)
        {
            case 'property':
                if(array_key_exists('name', $attrib))
                {
                    foreach($attrib as $key => $value)
                        $this->property[$key] = mb_convert_encoding($value, "EUC-JP", "UTF-8");
                }
                break;
            case 'conditions':
                if(array_key_exists('items', $this->conditions))
                    array_push($this->stack, $this->conditions);
                $this->conditions = array();
                if(array_key_exists('type', $attrib))
                    $this->conditions["type"] = $attrib["type"];
                else
                    $this->conditions["type"] = "and";
                $this->conditions["items"] = array();
                break;
            case 'condition':
                if(array_key_exists('name', $attrib))
                {
                    $condition = array();
                    foreach($attrib as $key => $value)
                        $condition[$key] = $value;
                    $this->conditions["items"][] = $condition;
                }
                break;
        }
    }
    
    /**
     * νλ˸ƤФ륳Хåؿ
     * @param $parser XMLѡ
     * @param $name   ̾
     */
    function endElement($parser, $name)
    {
        switch($name)
        {
            case 'property':
                $this->property["conditions"] = $this->conditions;
                $this->conditions = array();
                $this->stack = array();
                $this->properties[] = $this->property;
                $this->property = array();
                break;
            case 'conditions':
                if(count($this->stack))
                {
                    $conditions = array_pop($this->stack);
                    $conditions["items"][] = $this->conditions;
                    $this->conditions = $conditions;
                }
                break;
        }
    }

    /**
     * ¸ط(ͥåԤξ)Ƥ뤫ɤڤ
     * @param $conditions 
     * @return Ƥ trueǤʤ false
     */
    function checkConditions($conditions)
    {
        if(is_array($conditions) && array_key_exists('type', $conditions))
        {
            $type = $conditions["type"];
            foreach($conditions["items"] as $item)
            {
                if(!array_key_exists('name', $item))
                    $result = $this->checkConditions($item);
                else
                    $result = $this->validateCondition($item);

                if(($type == "and") && ($result == false))
                    break;
                else if(($type == "or") && ($result == true))
                    break;
            }
            return $result;
        }
    }

    /*
     * @brief  ̩ addr-spec (RFC2822) åɽʸ
     * @return ɽʸ
     */
    function getAddrSpecRegex()
    {
        $mail_regex =
        '(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\' .
        '\[\]\000-\037\x80-\xff])|"[^\\\\\x80-\xff\n\015"]*(?:\\\\[^\x80-\xff][' .
        '^\\\\\x80-\xff\n\015"]*)*")(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x' .
        '80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|"[^\\\\\x80-' .
        '\xff\n\015"]*(?:\\\\[^\x80-\xff][^\\\\\x80-\xff\n\015"]*)*"))*@(?:[^(' .
        '\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\0' .
        '00-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[^\x80-\xff])*' .
        '\])(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,' .
        ';:".\\\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[' .
        '^\x80-\xff])*\]))*';

        return $mail_regex;
    }

    /**
     * ץѥƥ򸡾ڤޤ
     * @param $config ConfigLoader֥
     * @param $request HttpRequest֥
     * @return ActionErrors󥹥
     */
    function validate(&$config, &$request)
    {
        $config_php = "";
        $xmlfile = ROOT_DIR . '/config/' . get_class($this) . '_validate.xml';
        $pos = strrpos($xmlfile, '.');
        if($pos != false)
        {
            $config_php = ROOT_DIR . '/cache/config/' . get_class($this) . '_validate.php';
            if(!file_exists(ROOT_DIR . '/cache/config'))
                mkdir(ROOT_DIR . '/cache/config', 0777);
            else if(file_exists($config_php))
            {
                if(filemtime($config_php) > filemtime($xmlfile))
                {
                    require_once($config_php);
                    return $this->doValidation();
                }
            }
        }
        if($this->load($xmlfile))
        {
            // åեν񤭽Ф
            $contents  = "<?php\n";
            $contents .= "  \$properties = \"" . addslashes(serialize($this->properties)) . "\";\n";
            $contents .= "  \$this->properties = unserialize(\$properties);\n";
            $contents .= "?>\n";

            $fp = fopen($config_php, "w");
            fwrite($fp, $contents);
            fclose($fp);
            
            return $this->doValidation();
        }
        else
            return NULL;
    }

    /**
     * ХǡԤ
     * @return
     */
    function doValidation()
    {
        $errors = new ActionErrors();
        foreach($this->properties as $property)
        {
            if(array_key_exists("conditions", $property) && count($property["conditions"]))
            {
                if(!$this->checkConditions($property["conditions"]))
                    continue;
            }
            if(!$this->validateCondition($property))
            {
                if(array_key_exists("error", $property))
                    $errkey = $property["error"];
                else
                {
                    if($this->error)
                        $errkey = $this->error;
                    else
                        $errkey = "error.exception";
                }
                
                if(array_key_exists("description", $property))
                    $error = new ActionError($errkey, $property["description"]);
                else
                    $error = new ActionError($errkey);
                $errors->add('error',$error);
            }
        }
        if(!$errors->isEmpty())
            return $errors;
        else
            return NULL;
    }
    
    /**
     * Ĵ٤
     * @param $condition 
     * @return  trueǤʤ false
     */
    function validateCondition($condition)
    {
        $this->error = NULL;
        // ͤμǤʤfalse֤
        if(!is_array($condition) || !array_key_exists('name', $condition))
            return false;
        
        $pos = strpos($condition["name"], "is");
        if($pos !== 0)
            $method = "get" . $condition["name"];
        else
            $method = $condition["name"];
        
        if(!method_exists($this, strtolower($method)))
            return false;

        // ͤμ
        $value = $this->$method();

        // ɬܥå
        if(array_key_exists('required', $condition) &&
            ($condition["required"] == 'true'))
        {
            if(empty($value))
            {
                $this->error = "error.required";
                return false;
            }
        }
        // ͤǤʤΤ
        if(!empty($value))
        {
            $result = true;
            // Ĺå
            if(array_key_exists('maxlength', $condition))
            {
                if(is_array($value) && (count($value) > $condition["maxlength"]))
                    $result = false;
                else if(!is_array($value) && (strlen($value) > $condition["maxlength"]))
                    $result = false;
            }
            if(!$result)
            {
                $this->error = "error.maxlength";
                return false;
            }
            // ǾĹå
            if(array_key_exists('minlength', $condition))
            {
                if(is_array($value) && (count($value) < $condition["maxlength"]))
                    $result = false;
                else if(!is_array($value) && (strlen($value) < $condition["maxlength"]))
                    $result = false;
            }
            if(!$result)
            {
                $this->error = "error.minlength";
                return false;
            }
            // üå
            if(array_key_exists('type', $condition))
            {
                switch($condition["type"])
                {
                    case 'int':
                        if(!preg_match('/^[\-\+]?[0-9]*$/', $value))
                            $result = false;
                        break;
                    case 'float':
                        if(!preg_match('/^[\-\+]?[0-9]*\.?[0-9]*$/', $value))
                            $result = false;
                        break;
                    case 'tel':
                        if(!preg_match('/^[0-9]*\-?[0-9]*\-?[0-9]*$/', $value))
                            $result = false;
                        break;
                    case 'zip':
                        if(!preg_match('/^[0-9]{0,3}\-?[0-9]{0,4}$/', $value))
                            $result = false;
                        break;
                    case 'onebyte':
                        if(!preg_match('/^[\x00-\x7f]*$/', $value))
                            $result = false;
                        break;
                    case 'mail':
                        $regex = $this->getAddrSpecRegex();
                        if(!preg_match("/^$regex\$/", $value))
                            $result = false;
                        break;
                }
                if(!$result)
                {
                    $this->error = "error.type";
                    return false;
                }
            }
            // ɽå
            if(array_key_exists('format', $condition))
            {
                $format = $condition["format"];
                if(!preg_match("/$format/", $value))
                {
                    $this->error = "error.format";
                    return false;
                }
            }
        }
        return true;
    }
}

?>
