<?php
/**
 * @class  ConfigLoader
 * @brief  ȥեɹߥ饹
 * @author Daijiro Abe
 * @date   2005.10.28
 */

require_once(dirname(__FILE__) . "/FilterChain.php");

class ConfigLoader
{
    var $filename;
    var $filters = array();
    var $forms = array();
    var $actions = array();
    var $msg_files = array();
    var $messages = array();
    var $exception = array();
    var $templates = array();
    var $default; // ǥեȤΥѥ
    var $isRewrite = false;
    var $encoding = array();
    var $appenders = array();
    var $layouts = array();
    
    // 
    var $action;
    var $filter;
    var $logger;
    var $appender;
    
    /**
     * mod_rewriteȤɤ֤ޤ
     * @return mod_rewriteȤtrueǤʤfalse
     */
    function isRewrite()
    {
        return $this->isRewrite;
    }
    
    /**
     * 󥹥ȥ饯
     * @param $filename ե̾ά2ؾΥǥ쥯ȥconfig.xmlȤʤ
     */
    function ConfigLoader($filename = '')
    {
        if(empty($filename))
            $this->filename = ROOT_DIR . '/webapp/config/config.xml';
        else
            $this->filename;
    }
    
    /**
     * 󥳡ǥ
     * @return 󥳡ǥ
     */
    function getEncoding()
    {
        return $this->encoding;
    }
    
    /**
     * եɹ
     * @return  trueԻ false
     */
    function load()
    {
        $config_php = "";
        $pos = strrpos($this->filename, '.');
        if($pos !== false)
        {
            // ǿXMLեǡPHPƤСɤ
            $config_php = ROOT_DIR . '/cache/config/config.php';
            if(!file_exists(ROOT_DIR . '/cache/config'))
                mkdir(ROOT_DIR . '/cache/config', 0777);
            else if(file_exists($config_php))
            {
                if(filemtime($config_php) > filemtime($this->filename))
                {
                    require_once($config_php);
                    $this->loadMessages();
                    return true;
                }
            }
        }
        if(file_exists($this->filename))
        {
            $parser = xml_parser_create('UTF-8');
            xml_set_object($parser, $this);
            xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
            xml_set_element_handler($parser, "startElement", "endElement");

            if(!($fp = fopen($this->filename, "r")))
            {
                $trace = debug_backtrace();
                $error = new EmbeddedError();
                $error->setTitle("XMLե(" . $this->filename . ")ޤ");
                $error->setTrace($trace);
                $error->throw();
            }
            
            while($data = fread($fp, 4096))
            {
                $data = mb_convert_encoding($data, "UTF-8", "EUC-JP");
                
                if(!xml_parse($parser, $data, feof($fp)))
                {
                    $trace = debug_backtrace();
                    $error = new EmbeddedError();
                    $error->setTitle("XMLΥѡ˼Ԥޤ");
                    $error->setFilename($this->filename);
                    $error->setLine(xml_get_current_line_number($parser));
                    $error->setSummary(xml_error_string(xml_get_error_code($parser)));
                    $error->setTrace($trace);
                    $error->throw();
                }
            }
            
            $this->loadMessages();
            
            xml_parser_free($parser);

            // phpե
            $contents  = "<?php\n";
            $contents .= "  \$forms = \"" . addslashes(serialize($this->forms)) . "\";\n";
            $contents .= "  \$this->forms = unserialize(\$forms);\n";
            $contents .= "  \$actions = \"" . addslashes(serialize($this->actions)) . "\";\n";
            $contents .= "  \$this->actions = unserialize(\$actions);\n";
            $contents .= "  \$msg_files = \"" . addslashes(serialize($this->msg_files)) . "\";\n";
            $contents .= "  \$this->msg_files = unserialize(\$msg_files);\n";
            $contents .= "  \$this->default = \"" . addslashes($this->default) . "\";\n";
            $contents .= "  \$filters = \"" . addslashes(serialize($this->filters)) . "\";\n";
            $contents .= "  \$this->filters = unserialize(\$filters);\n";
            $contents .= "  \$templates = \"" . addslashes(serialize($this->templates)) . "\";\n";
            $contents .= "  \$this->templates = unserialize(\$templates);\n";
            $contents .= "  \$exception = \"" . addslashes(serialize($this->exception)) . "\";\n";
            $contents .= "  \$this->exception = unserialize(\$exception);\n";
            $contents .= "  \$encoding = \"" . addslashes(serialize($this->encoding)) . "\";\n";
            $contents .= "  \$this->encoding = unserialize(\$encoding);\n";
            if($this->isRewrite)
                $contents .= "  \$this->isRewrite = true;\n";
            else
                $contents .= "  \$this->isRewrite = false;\n";
            
            $loggers = & Logger::getAllLoggers();
            $contents .= "  \$loggers = \"" . addslashes(serialize($loggers)) . "\";\n";
            foreach($this->appenders as $appender)
                $contents .= "  require_once(\"" . addslashes($appender) . "\");\n";
            foreach($this->layouts as $layout)
                $contents .= "  require_once(\"" . addslashes($layout) . "\");\n";
            $contents .= "  Logger::setAllLoggers(unserialize(\$loggers));\n";
            
            $contents .= "?>\n";

            $fp = fopen($config_php, 'w');
            fwrite($fp, $contents);
            fclose($fp);
            
            return true;
        }
    }
    
    /**
     * åɤ߹
     */
    function loadMessages()
    {
        foreach($this->msg_files as $file)
        {
            $str = "";
            $fp = fopen($file, 'r');
            while(!feof($fp))
            {
                $str .= fgets($fp, 1024);
                // եνüʸǽäƤйν
                if(feof($fp) || preg_match('/\r\n$/', $str))
                {
                    $pos = strpos($str, '=');
                    if($pos !== false)
                    {
                        $key = substr($str, 0, $pos);
                        $value = substr($str, $pos+1);
                        $this->messages[$key] = $value;
                    }
                    $str = "";
                }
            }
        }
    }
    
    /**
     * γϻ˸ƤФ륳Хåؿ
     * @param $parser XMLѡ
     * @param $name   ̾
     * @param $attrib °Ϣ
     */
    function startElement($parser, $name, $attrib)
    {
        switch($name)
        {
            case 'bean':
                if(array_key_exists('name', $attrib) && array_key_exists('type', $attrib))
                {
                    $form["name"] = $attrib["name"];
                    $form["type"] = $attrib["type"];
                    $this->forms[$attrib['name']] = $form;
                }
                break;
            case 'action':
                if(array_key_exists('path', $attrib) && array_key_exists('type', $attrib))
                {
                    foreach($attrib as $key => $value)
                        $this->action[$key] = $value;
                    if(array_key_exists('default', $attrib))
                        $this->default = $attrib['path'];
                    $this->action['forward'] = array();
                }
                break;
            case 'filter':
                if(array_key_exists('name', $attrib))
                {
                    $this->filter = array();
                    $this->filter['name'] = $attrib['name'];
                    $this->filter['items'] = array();
                }
                break;
            case 'filter-item':
                if(array_key_exists('type', $attrib))
                {
                    $filter_item = array();
                    $filter_item['type'] = $attrib['type'];
                    $this->filter['items'][] = $filter_item;
                }
                break;
            case 'forward':
                if(array_key_exists('name', $attrib))
                {
                    foreach($attrib as $key => $value)
                    {
                        $forward[$key] = $value;
                    }
                    $this->action['forward'][$attrib['name']] = $forward;
                }
                break;
            case 'message':
                if(array_key_exists('parameter', $attrib))
                    $this->msg_files[] = ROOT_DIR . '/webapp/config/' . $attrib['parameter'];
                break;
            case 'exception':
                if(array_key_exists('path', $attrib))
                {
                    $exception = array();
                    foreach($attrib as $key => $value)
                        $exception[$key] = $value;
                    $exception["exception"] = true;
                    $this->exception = $exception;
                }
                break;
            case 'template':
                if(array_key_exists('name', $attrib) && array_key_exists('path', $attrib))
                {
                    $this->templates[$attrib["name"]] = $attrib["path"];
                }
                break;
            case 'rewrite':
                $this->isRewrite = true;
                break;
            case 'encoding':
                foreach($attrib as $key => $value)
                    $this->encoding[$key] = $value;
                break;
            case 'logger':
                if(array_key_exists('target', $attrib))
                {
                    $this->logger = $attrib["target"];
                    $logger = & Logger::getLogger($attrib["target"]);
                    if(array_key_exists('level', $attrib))
                    {
                        switch($attrib["level"])
                        {
                            case "DEBUG":
                                $logger->setLevel(LOGLEVEL_DEBUG);
                                break;
                            case 'INFO':
                                $logger->setLevel(LOGLEVEL_INFO);
                                break;
                            case 'WARN':
                                $logger->setLevel(LOGLEVEL_WARN);
                                break;
                            case 'ERROR':
                                $logger->setLevel(LOGLEVEL_ERROR);
                                break;
                            case 'FATAL':
                                $logger->setLevel(LOGLEVEL_FATAL);
                                break;
                        }
                    }
                }
                break;
            case 'appender':
                if(array_key_exists('type', $attrib) && array_key_exists('name', $attrib))
                {
                    $class = $attrib["type"];
                    $filename = dirname(__FILE__) . '/../Logging/' . $class . '.php';
                    if(file_exists($filename))
                    {
                        if(array_search($filename, $this->appenders) === false)
                            $this->appenders[] = $filename;
                        require_once($filename);
                        $this->appender = & new $class();
                        $this->appender->setName($attrib["name"]);
                    }
                }
                break;
            case 'layout':
                if(array_key_exists("type", $attrib))
                {
                    $class = $attrib["type"];
                    $filename = dirname(__FILE__) . '/../Logging/' . $class . '.php';
                    if(file_exists($filename))
                    {
                        if(array_search($filename, $this->layouts) === false)
                            $this->layouts[] = $filename;
                        require_once($filename);
                        $layout = & new $class();
                        $this->appender->setLayout($layout);
                    }
                }
                break;
        }
    }
    
    /**
     * ƥץ졼ȥե̾μ
     * @param $name ̾
     * @return ե̾
     */
    function getTemplate($name)
    {
        if(array_key_exists($name, $this->templates))
            return $this->templates[$name];
        else
            return NULL;
    }
    
    /**
     * νλ˸ƤФ륳Хåؿ
     * @param $parser XMLѡ
     * @param $name   ̾
     */
    function endElement($parser, $name)
    {
        if(($name == "action") && $this->action)
        {
            $this->actions[$this->action['path']] = $this->action;
            $this->action = NULL;
        }
        if(($name == "filter") && $this->filter)
        {
            $this->filters[$this->filter['name']] = $this->filter;
            $this->filter = NULL;
        }
        if(($name == "appender") && $this->appender)
        {
            $logger = & Logger::getLogger($this->logger);
            $logger->addAppender($this->appender);
            $this->appender = NULL;
        }
        if(($name == "logger") && $this->logger)
        {
            $this->logger = NULL;
        }
    }
    
    /**
     * ̾Ǹ
     * @param $name ̾
     * @return Action󥹥󥹡ĤʤNULL
     */
    function &findActionByName($name)
    {
        $null = NULL;
        if(empty($name))
            $name = $this->default;
        if($name && array_key_exists($name, $this->actions))
        {
            $action_info = $this->actions[$name];
            $action_file = ROOT_DIR . '/webapp/classes/Actions/' . $action_info['type'] . '.php';
            if(file_exists($action_file))
            {
                require_once($action_file);
                $action = new $action_info['type'];
                if(array_key_exists('name', $action_info))
                    $action->setName($action_info['name']);
                if(array_key_exists('scope', $action_info))
                    $action->setScope($action_info['scope']);
                if(array_key_exists('validate', $action_info))
                {
                    if($action_info['validate'] == 'true')
                        $action->setValidate(true);
                    else
                        $action->setValidate(false);
                }
                else
                    $action->setValidate(false);
                if(array_key_exists('input', $action_info))
                    $action->setInput($action_info['input']);
                if(array_key_exists('filter', $action_info))
                    $action->setFilter($action_info['filter']);
                $this->action = $action_info;
                return $action;
            }
            else
                return $null;
        }
        else
            return $null;
    }
    
    /**
     * ե̾Ǹ
     * @param $name ե̾
     * @return ActionForm󥹥󥹡ĤʤNULL
     */
    function &findActionFormByName($name)
    {
        $null = NULL;
        if($name && array_key_exists($name, $this->forms))
        {
            $form_info = $this->forms[$name];
            $form_file = ROOT_DIR . '/webapp/classes/Beans/' . $form_info['type'] . '.php';
            if(file_exists($form_file))
            {
                require_once($form_file);
                $form = new $form_info['type'];
                return $form;
            }
            else
                return $null;
        }
        else
            return $null;
    }
    
    /**
     * ե륿̾Ǹ
     * @param $name ե륿̾
     * @return Filter󥹥󥹡ĤʤNULL
     */
    function &findFilterByName($name)
    {
        $null = NULL;
        if($name && array_key_exists($name, $this->filters))
        {
            $filter_info = $this->filters[$name];
            if(array_key_exists('items', $filter_info) && is_array($filter_info['items']))
            {
                $filter_items = $filter_info['items'];
                $filters = new FilterChain();
                foreach($filter_items as $item)
                {
                    if(array_key_exists('type', $item))
                    {
                        $filter_file = ROOT_DIR . '/webapp/classes/Filters/' . $item['type'] . '.php';
                        if(file_exists($filter_file))
                        {
                            require_once($filter_file);
                            $filter = new $item['type'];
                            $filters->add($filter);
                        }
                    }
                }
                return $filters;
            }
        }
        return $null;
    }
    
    /**
     * ̾forward򸡺
     * @param $name ̾
     * @return forward
     */
    function findForward($name)
    {
        $null = NULL;
        $forwards = $this->action['forward'];
        if($name && array_key_exists($name, $forwards))
            return $forwards[$name];
        else
            return $null;
    }
    
    /**
     * 顼ڡܤ
     * @param $msg  å
     * @return forward
     */
    function throw($msg)
    {
        if(!empty($this->exception))
        {
            $exception = $this->exception;
            $exception["message"] = $msg;
            return $exception;
        }
        else
        {
            $trace = "";
            if(function_exists("debug_backtrace"))
                $trace = debug_backtrace();
            $error = new EmbeddedError();
            if(is_string($msg))
                $error->setTitle($msg);
            else
            {
                $error->setTitle("ͽʤ顼ȯޤ");
                $error->setContext($msg);
            }
            $error->setTrace($trace);
            $error->throw();
        }
    }
    
    /**
     * å
     * @param $name ̾
     * @return бå
     */
    function getMessage($name)
    {
        if(array_key_exists($name, $this->messages))
            return $this->messages[$name];
        else
            return NULL;
    }
}

?>
