<?php
/**
 * @class  Controller
 * @brief  եȥȥ饯饹
 * @author Daijiro Abe
 * @date   2005.10.28
 */

require_once(dirname(__FILE__) . "/EmbeddedError.php");
require_once(dirname(__FILE__) . "/ConfigLoader.php");
require_once(dirname(__FILE__) . "/../Http/HttpRequest.php");
require_once(dirname(__FILE__) . "/../Http/HttpResponse.php");
require_once(dirname(__FILE__) . "/../View/Shape.php");
require_once(dirname(__FILE__) . "/../Http/FormFile.php");
require_once(dirname(__FILE__) . '/Action.php');
require_once(dirname(__FILE__) . '/ActionForm.php');
require_once(dirname(__FILE__) . '/../Logging/Logger.php');
require_once(dirname(__FILE__) . '/../Logging/Appender.php');

session_cache_limiter('private, must-revalidate');

class Controller
{
    var $configfile;    // եΥѥ
    
    /**
     * 󥹥ȥ饯
     */
    function Controller($configfile = "")
    {
        $this->configfile = $configfile;
        if(!defined('ROOT_DIR'))
        {
            define("ROOT_DIR", dirname(realpath(dirname(__FILE__) . '/../../')));
        }
    }
    
    /**
     * ¹Ԥ
     * @param $config ConfigLoader
     * @param $req HttpRequest
     * @param $res HttpResponse
     * @param $actionName ̾
     * @return forward
     */
    function action(&$config, &$req, &$res, $actionName)
    {
        $action = &$config->findActionByName($actionName);

        $forward = array();
        $name = "";
        
        if(!$action)
            $forward = $config->throw('ActionĤޤǤ');
        else
        {
            $name = $action->getName();

            // name 饢ե򸡺
            $form = NULL;
            if($name)
                $form = &$config->findActionFormByName($name);
            if($form && $action->getScope() == 'session')
            {
                $session = $req->getSession(true);
                $session_form = $session->getAttribute($name);
                if($session_form)
                    $form = $session_form;
            }

            if($form)
            {
                $form->reset($config, $req);
                $methods = get_class_methods(get_class($form));
                $names = $req->getParameterNames();
                foreach($names as $req_name)
                {
                    $method = 'set' . $req_name;
                    if(array_search(strtolower($method), $methods) !== false)
                        $form->$method($req->getParameter($req_name));
                }
                foreach($_FILES as $key => $file_info)
                {
                    $method = 'set' . $key;
                    if(array_search(strtolower($method), $methods) !== false)
                    {
                        $formFile = new FormFile();
                        $formFile->setFileName($file_info['name']);
                        $formFile->setTempFilename($file_info['tmp_name']);
                        $formFile->setContentType($file_info['type']);
                        $formFile->setError($file_info['error']);
                        $formFile->setFileSize($file_info['size']);
                        $form->$method($formFile);
                    }
                }
                if($action->getScope() == 'session')
                {
                    $session = $req->getSession(true);
                    $session->setAttribute($name, &$form);
                }
                else
                    $req->setAttribute($name, &$form);
            }
            
            $errors = NULL;
            if($form && $action->isValidate())
                $errors = $form->validate($config, &$req);
            if($errors)
            {
                $action->addErrors(&$req, &$errors);
                $input = $action->getInput();
                if($input)
                    $forward['path'] = $input;
            }
        }
        if(empty($forward))
        {
            $filter = $action->getFilter();
            if($filter)
            {
                $filters = &$config->findFilterByName(&$filter);
                $filters->setAction(&$action);
                $forward = $filters->execute(&$config,&$form,&$req,&$res);
            }
            else
                $forward = $action->execute(&$config, &$form, &$req, &$res);
        }
        return $this->show(&$forward, $name, &$config, &$req, &$res);
    }
    
    /**
     * ڡɽʸ֤ޤ
     * @param $forward ӥ塼
     * @parma $name   ̾
     * @param $config ConfigLoader
     * @param $req    HttpRequest
     * @param $res    HttpResponse
     * @return ɽʸ󡣥쥯Ȥξ֤˥쥯
     */
    function show($forward,$name,&$config,&$req,&$res)
    {
        if(!$forward)
            $forward = $config->throw("ڡĤޤ");

        if(array_key_exists('redirect', $forward) &&
           ($forward['redirect'] == 'true'))
        {
            if(array_key_exists('path', $forward))
                $res->sendRedirect($forward['path']);
            else if(array_key_exists('action', $forward))
            {
                if($config->isRewrite())
                {
                    if(dirname($_SERVER["PHP_SELF"]) == '/')
                        $path = '/' . $forward["action"] . '/';
                    else
                        $path = dirname($_SERVER["PHP_SELF"]) . '/' . $forward["action"] . '/';
                }
                else
                    $path = $_SERVER["PHP_SELF"] . '?action=' . $forward["action"];
                $res->sendRedirect($path);
            }
        }
        else
        {
            if(array_key_exists("exception", $forward))
            {
                if(array_key_exists("filter", $forward))
                {
                    $filter = $forward["filter"];
                    $filters = &$config->findFilterByName(&$filter);
                    $filters->execute(&$config,&$form,&$req,&$res);
                }
                if(array_key_exists("message", $forward))
                    $req->setAttribute("message", $forward["message"]);
            }
            $shape = new Shape(&$forward["path"], &$config, &$req, &$res);
            return $shape->show($name);
        }
    }
    
    /**
     * ȥ¹Ԥ
     */
    function execute()
    {
        ob_start();
        $config = new ConfigLoader($this->configfile);
        if(!$config->load())
        {
            $trace = debug_backtrace();
            $error = new EmbeddedError();
            $error->setTitle("XMLɤ߹ߤ˼Ԥޤ");
            $error->setTrace($trace);
            $error->throw();
        }

        $encoding = $config->getEncoding();
        $req = NULL;
        if(array_key_exists('request', $encoding))
            $req = new HttpRequest($encoding["request"]);
        else
            $req = new HttpRequest();
        $res = new HttpResponse();

        if(array_key_exists("response", $encoding))
            $res->setCharacterEncoding($encoding["response"]);

        $name = $req->getParameter('action');

        $str = $this->action(&$config, &$req, &$res, &$name);
        $res->write($str);
        ob_end_flush();
    }
}

?>
