<?php
/**
 * @class  EmbeddedError
 * @brief  Ȥ߹ޤ줿顼ɽѥ饹
 * @author Daijiro Abe
 * @date   2005.12.13
 */

require_once(dirname(__FILE__) . '/../Utils/check_version.php');

class EmbeddedError
{
    var $level;
    var $title;
    var $summary;
    var $description;
    var $filename;
    var $line;
    var $trace;
    var $context;
    
    /**
     * 顼ϥɥ
     * @param $errno      顼٥륳
     * @param $errstr     顼å
     * @param $errfile    顼ȯե̾
     * @param $errline    顼ȯԿ
     * @param $errcontext ѿ
     */
    function handler($errno, $errstr, $errfile, $errline, $errcontext)
    {
        if(ini_get('error_reporting') & $errno)
        {
            switch($errno)
            {
                case E_USER_ERROR:
                case E_ERROR:
                    $this->setTitle("ʼ¹Ի顼ȯޤ");
                    $this->setDescription("ʼ¹Ի顼ϡݤ˴ؤΤ褦Ǥʤ顼򼨤ޤץȤμ¹ԤǤޤ");
                    $this->setLevel(LOGLEVEL_ERROR);
                    break;
                case E_USER_WARNING:
                case E_WARNING:
                    $this->setTitle("¹Ի˷ٹȯޤ");
                    $this->setDescription("¹Իηٹ (̿Ūʥ顼ǤϤʤ)ץȤμ¹ԤǤޤ");
                    $this->setLevel(LOGLEVEL_WARN);
                    break;
                case E_PARSE:
                    $this->setTitle("ѥ˥ѡ顼ȯޤ");
                    $this->setDescription("ѥΥѡ顼ѡ顼ϥѡǤΤޤ");
                    $this->setLevel(LOGLEVEL_ERROR);
                    break;
                case E_USER_NOTICE:
                case E_NOTICE:
                    $this->setTitle("Ūʥ顼ȤʤꤦĽ꤬ޤ");
                    $this->setDescription("¹Իηٹ𡣥顼ȯȤ򼨤̾Υץȼ¹Ԥξˤ⤳ηٹȯ뤳Ȥꤦ롣");
                    $this->setLevel(LOGLEVEL_INFO);
                    break;
                case E_CORE_ERROR:
                    $this->setTitle("PHPϻ̿Ūʥ顼ȯޤ");
                    $this->setDescription("PHPϻȯʼ¹Ի顼ϡݤ˴ؤΤ褦Ǥʤ顼򼨤ޤץȤμ¹ԤǤޤ");
                    $this->setLevel(LOGLEVEL_ERROR);
                    break;
                case E_CORE_WARNING:
                    $this->setTitle("PHPϻ˷ٹȯޤ");
                    $this->setDescription("PHPϻȯ¹Իηٹ (̿Ūʥ顼ǤϤʤ)ץȤμ¹ԤǤޤ");
                    $this->setLevel(LOGLEVEL_WARN);
                    break;
                case E_COMPILE_ERROR:
                    $this->setTitle("ѥ̿Ūʥ顼ȯޤ");
                    $this->setDescription("Zendץƥ󥰥󥸥ȯԤʼ¹Ի顼ϡݤ˴ؤΤ褦Ǥʤ顼򼨤ޤץȤμ¹ԤǤޤ");
                    $this->setLevel(LOGLEVEL_ERROR);
                    break;
                case E_COMPILE_WARNING:
                    $this->setTitle("ѥ˷ٹȯޤ");
                    $this->setDescription("Zendץƥ󥰥󥸥ȯԤ¹Իηٹ (̿Ūʥ顼ǤϤʤ)ץȤμ¹ԤǤޤ");
                    $this->setLevel(LOGLEVEL_WARN);
                    break;
            }
            $this->setSummary($errstr);
            $this->setFilename($errfile);
            $this->setLine($errline);
            $this->setContext($errcontext);
            $this->throw(false);
        }
    }
    
    function throw($isExit=true)
    {
        $logger = &Logger::getLogger($this);
        if(is_object($logger))
            $logger->trace($this->getTitle(), $this->getLevel());
        print "<html><head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=EUC-JP\">\n";
        print "<title>" . $this->getTitle() . "</title>\n";
        print "</head>\n<body bgcolor=\"#ffffff\">\n";
        if(strlen($this->getTitle()))
        {
            print "<h1><font color=\"#ff0000\">" . $this->getTitle() . "</font></h1>\n";
            print "<hr size=\"1\">\n";
        }
        if(strlen($this->getSummary()))
            print "<h1><i><font color=\"#660000\">" . $this->getSummary() . "</font></i></h1>\n";
        if(strlen($this->getDescription()))
            print "<strong></strong>" . $this->getDescription() . "<br><br>\n";
        if(strlen($this->getFilename()))
        {
            $filename = $this->getFilename();
            if(strlen($this->getLine()))
            {
                print "<strong>顼</strong>\n";
                print "<table cellspacing=\"4\" width=\"98%\" border=\"0\" bgcolor=\"#ffffaa\">\n";
                print "<tr><td><xmp>\n";
                $start = $this->getLine() - 5;
                if($start < 1)
                    $start = 1;
                $i = 0;
                $end = $start + 10;
                $fp = fopen($filename, "r");
                $digit = strlen("$end");
                while($str = fgets($fp, 1024))
                {
                    if($i < $start)
                    {
                        $i++;
                        continue;
                    }
                    $i++;
                    if($i > $end)
                        break;

                    if($i == $this->getLine())
                        $sep = "";
                    else
                        $sep = "  ";
                    printf("%0" . $digit . "d", $i);
                    print($sep . $str);
                }
                fclose($fp);
                print "</xmp></td></tr></table><br>\n";
            }
            print "<strong>ե</strong>" . $this->getFilename() . "<br><br>\n";
        }
        
        $context = $this->getContext();
        if(!empty($context))
        {
            print "<strong>顼ȯѿ</strong>\n<br>";
            print "<textarea rows=\"8\" cols=\"100\">\n";
            print htmlspecialchars(var_export($this->getContext()));
            print "</textarea><br><br>\n";
        }
        
        $trace = $this->getTrace();
        if(!empty($trace))
        {
            print "<strong>Хåȥ졼</strong>\n<br>";
            print "<table cellspacing=\"4\" width=\"98%\" border=\"0\" bgcolor=\"#ffffaa\">\n";
            print "<tr><td>\n";
            foreach($trace as $info)
            {
                if(array_key_exists("class", $info))
                    print $info["class"];
                if(array_key_exists("type", $info))
                    print $info["type"];
                if(array_key_exists("function", $info))
                    print $info["function"];
                $file = basename($info['file']);
                print " (<a href=\"{$info['file']}\">$file</a>:{$info['line']})<br>\n";
            }
            print "</td></tr></table>\n";
        }
        print "</body>\n</html>\n";
        if($isExit)
            exit;
    }
    
    /**
     * 顼٥֤ޤ
     * @return 顼٥
     */
    function getLevel()
    {
        return $this->level;
    }
    
    /**
     * 顼٥ꤷޤ
     * @param $level 顼٥
     */
    function setLevel($level)
    {
        $this->level = $level;
    }
    
    /**
     * ȥ֤ޤ
     * @return ȥ
     */
    function getTitle()
    {
        return $this->title;
    }
    
    /**
     * ȥꤷޤ
     * @param $title ȥ
     */
    function setTitle($title)
    {
        $this->title = $title;
    }
    
    /**
     * פ֤ޤ
     * @return 
     */
    function getSummary()
    {
        return $this->summary;
    }
    
    /**
     * פꤷޤ
     * @param $summary 
     */
    function setSummary($summary)
    {
        $this->summary = $summary;
    }
    
    /**
     * ܺپ֤ޤ
     * @return ܺپ
     */
    function getDescription()
    {
        return $this->description;
    }
    
    /**
     * ܺپꤷޤ
     * @param $descripton ܺپ
     */
    function setDescription($description)
    {
        $this->description = $description;
    }
    
    /**
     * 顼ե֤̾ޤ
     * @return 顼ե̾
     */
    function getFilename()
    {
        return $this->filename;
    }
    
    /**
     * 顼ե̾ꤷޤ
     * @param $filename 顼ե̾
     */
    function setFilename($filename)
    {
        $this->filename = $filename;
    }
    
    /**
     * 顼εԿ֤ޤ
     * @return ֹ
     */
    function getLine()
    {
        return $this->line;
    }
    
    /**
     * 顼εԿꤷޤ
     * @param $line Կ
     */
    function setLine($line)
    {
        $this->line = $line;
    }
    
    /**
     * ȥ졼֤ޤ
     * @return ȥ졼
     */
    function getTrace()
    {
        return $this->trace;
    }
    
    /**
     * ȥ졼ꤷޤ
     * @param $trace ȥ졼
     */
    function setTrace($trace)
    {
        $this->trace = $trace;
    }
    
    /**
     * ƥȤ֤ޤ
     * @return ƥ
     */
    function getContext()
    {
        return $this->context;
    }
    
    /**
     * ƥȤꤷޤ
     * @param $context ƥ
     */
    function setContext($context)
    {
        $this->context = $context;
    }
}

if(check_version(PHP_VERSION, "4.3.0"))
    set_error_handler(array(new EmbeddedError(), "handler"));

?>
