<?php
 /**
  * @class  CsvReader
  * @brief  CSVɤ߹ߥ饹
  * @author Daijiro Abe
  * @date   2005.11.24
  */

define('CSV_ESCAPE_QUOTE', '"');

class CsvReader
{
    var $filename;
    var $fp;
    
    /**
     * 󥹥ȥ饯
     * @param $filename ե̾
     */
    function CsvReader($filename=NULL)
    {
        $this->filename = $filename;
    }
    
    /**
     * ե̾ꤹ
     * @param $filename ե̾
     */
    function setFilename($filename)
    {
        $this->filename = $filename;
    }
    
    /**
     * ե֤̾
     * @return ե̾
     */
    function getFilename()
    {
        return $this->filename;
    }
    
    /**
     * ե򳫤
     * @return  trueԤ false
     */
    function open()
    {
        if(!file_exists($this->filename))
            return false;
        
        $this->fp = fopen($this->filename, 'r');
        if(!$this->fp)
            return false;
        else
            return true;
    }
    
    /**
     * եĤ
     */
    function close()
    {
        fclose($this->fp);
        $this->fp = NULL;
    }
    
    /**
     * Ȥ֤
     * @return 
     */
    function load()
    {
        $result = array();
        while(!feof($this->fp))
        {
            $array = $this->readln();
            if($array !== NULL)
                $result[] = $array;
        }
        return $result;
    }
    
    /**
     * 1ɤ߹֤
     * @param $length ɤ߹ߥХȿ
     * @return 
     */
    function readln($length=4096)
    {
        $str = fgets($this->fp, $length);
        while((substr_count($str, '"') % 2 == 1) && !feof($this->fp))
            $str .= fgets($this->fp, $length);

        if(strlen($str) == 0)
            return NULL;

        $str = mb_convert_encoding($str,"EUC-JP","Shift_JIS");
        return $this->parseCsv($str);
    }
    
    /**
     * CSVʸϤˤޤ
     * @param $str CSVʸ
     * @return 
     */
    function parseCsv($str)
    {
        $data = array();
        $str = preg_replace('/(?:\x0D\x0A|[\x0D\x0A])?$/',',',$str,1);
        if(preg_match_all('/("[^"]*(?:' . CSV_ESCAPE_QUOTE . '"[^"]*)*"|[^,]*),/', $str, $matches) !== false)
        {
            $matches = $matches[1];
            $data = array_map("csv_unquote", $matches);
        }
        return $data;
    }
    
    /**
     * @brief  CSVǡʸˤ֤ޤ
     * @param  data 
     * @return CSVʸ
     */
    function make_csv($data)
    {
        $data = array_map("csv_quote", $data);
        return join(',', $data);
    }

}

/**
 * @brief  CSVǡΥ׽򸵤ᤷޤ
 * @param  str CSVǡ
 * @return פᤷʸ
 */
function csv_unquote($str)
{
    if(preg_match('/^"(.*)"$/s', $str, $matches))
    {
        $str = $matches[1];
        $str = preg_replace('/' . CSV_ESCAPE_QUOTE . '"/', '"', $str);
    }
    return $str;
}

/**
 * @brief  CSVǡΥơ򥨥פ֤ޤ
 * @param  str CSVǡ
 * @return ׽򤷤ʸ
 */
function csv_quote($str)
{
    $repstr = preg_replace('/"/', CSV_ESCAPE_QUOTE . '"', $str);
    if(($repstr != $str) || (preg_match('/[\r\n,]/',$str) !== false))
        $repstr = '"' . $repstr . '"';
    return $repstr;
}


?>
