<?php
/**
 * @class  IXMLLoader.php
 * @brief  XMLեɤ߹।󥿡ե
 * @author Daijiro Abe
 * @date   2005.11.08
 */

require_once(dirname(__FILE__) . '/../DataObject.php');

class IXMLLoader extends DataObject
{
    /**
     * XMLեɤ߹
     * @param $filename ե̾
     * @return  trueԤ false
     */
    function loadFile($filename)
    {
        if(file_exists($filename))
        {
            $parser = xml_parser_create('UTF-8');
            xml_set_object($parser, $this);
            xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
            xml_set_element_handler($parser, "startElement", "endElement");
            xml_set_character_data_handler($parser, "characters");

            if(!($fp = fopen($filename, "r")))
            {
                trigger_error($filename . " cannot be opened.", E_USER_ERROR);
                return false;
            }
            
            while($data = fread($fp, 4096))
            {
                $data = mb_convert_encoding($data, "UTF-8", "EUC-JP");
                
                if(!xml_parse($parser, $data, feof($fp)))
                {
                    trigger_error(sprintf("XML parse error: %s at line %d",
                        xml_error_string(xml_get_error_code($parser)),
                        xml_get_current_line_number($parser)), E_USER_ERROR);
                    return false;
                }
            }
            
            return xml_parser_free($parser);
        }
        else
        {
            trigger_error($filename . " is not exists.", E_USER_NOTICE);
            return false;
        }
    }

    /**
     * γϻ˸ƤФ륳Хåؿ
     * @param $parser XMLѡ
     * @param $name   ̾
     * @param $attrib °Ϣ
     */
    function startElement($parser, $name, $attrib)
    {
        // ⤷ʤ
    }
    
    /**
     * νλ˸ƤФ륳Хåؿ
     * @param $parser XMLѡ
     * @param $name   ̾
     */
    function endElement($parser, $name)
    {
        // ⤷ʤ
    }

    /**
     * ֤ʸɤ߹ߤλݤ˸ƤФ륳Хåؿ
     * @param $parser XMLѡ
     * @param $text   ֤Υƥ
     */
    function characters($parser, $text)
    {
        // ⤷ʤ
    }
}

?>
