<?php
/**
 * @class  UploadFile
 * @brief  ե륢åץɤ˴ؤ륯饹
 * @author Daijiro Abe
 * @date   2005-01-07
 */

require_once("PageUtil.php");

class UploadFile
{
	var $tmpdir;
	
	/**
	 * 󥹥ȥ饯
	 * @param dir ȥǥ쥯ȥꤹ롣åǽ롣
	 */
	function UploadFile($dir = '../tmp/')
	{
		$this->tmpdir = $dir;
	}
	
	/**
	 * ե뤬åץɤ줿ɤĴ٤롣upload᥽åɤη̤ǤϤʤ桼եꤷɤĴ٤롣
	 * @param name եեѿ̾
	 */
	function isUploaded($name)
	{
		if(array_key_exists($name, $_FILES) && is_uploaded_file($_FILES[$name]['tmp_name']))
			return TRUE;
		else
			return FALSE;
	}
	
	/**
	 * ǥ쥯ȥ˥åץɤޤ
	 * @param name եեѿ̾
	 * @param ext  Ĥĥҡʾάǽ
	 * @return åץɤХե̾򡢼ԤNULL֤ޤ
	 */
	function upload($name, $ext = "")
	{
		$this->deleteOldFiles();
		if($_FILES[$name]["name"] && $_FILES[$name]['error'] == UPLOAD_ERR_OK)
		{
			$flg = FALSE;
			if($ext == "")
			{
				$size = GetImageSize($_FILES[$name]["tmp_name"]);
				$flg = ($size[2] >= 1 && $size[2] <= 3);
			}
			else
			{
				if(is_array($ext) && count($ext))
				{
					foreach($ext as $tmp)
					{
						if(preg_match('/\.'.$tmp.'$/i', $_FILES[$name]["name"]))
						{
							$flg = TRUE;
							break;
						}
					}
				}
				else if(!is_array($ext))
				{
					if(preg_match('/\.'.$ext.'$/i',strtolower($_FILES[$name]['name'])))
					{
						$flg = TRUE;
					}
				}
			}
			if($flg)
			{
				$time = time();
				$filename = PageUtil::getPathName($this->tmpdir, $name . '.' . $time);
				move_uploaded_file($_FILES[$name]["tmp_name"], $filename);
				return $name . '.' . $time;
			}
		}
		return NULL;
	}
	
	/**
	 * åץɺѤߤΥեϿ
	 * @brief ե뤬¸ߤƤϿޤե̾ꤵƤ餺 del + ѿ̾ Υեͤ 1 ǤХեޤ
	 * @param name     ե̾ǼƤեѿ̾
	 * @param filename ϿΥե̾
	 */
	function regist($name, $filename)
	{
		if(array_key_exists($name, $_REQUEST) && strlen($_REQUEST[$name]))
		{
			$orgfile = PageUtil::getPathName($this->tmpdir, $_REQUEST[$name]);
			if(file_exists($orgfile))
			{
				if(file_exists($filename))
					unlink($filename);
				rename($orgfile, $filename);
			}
		}
		else if(array_key_exists('del'.$name, $_REQUEST) && $_REQUEST['del' . $name] == '1')
		{
			if(file_exists($filename))
				unlink($filename);
		}
	}

	/**
	 * ȥǥ쥯ȥ24ְʾвᤷե롣
	 */
	function deleteOldFiles()
	{
		$dir = $this->tmpdir;
		if($dh = opendir($dir))
		{
			while(($file = readdir($dh)) !== false)
			{
				if(preg_match("/\.([0-9]+)$/", $file, $match))
				{
					if(time() - $match[1] > 86400) // 24 hours = 86400 secs
						unlink(PageUtil::getPathName($dir, $file));
				}
			}
			closedir($dh);
		}
	}
	
	/**
	 * ꤷեѿ˳ǼƤեΥĴ٤
	 * @param name եΥեѿ̾
	 * @param size ե륵ξ
	 */
	function checkFileSize($name, $size)
	{
		if($_FILES[$name]["name"])
		{
			if($_FILES[$name]['error'] == UPLOAD_ERR_OK)
			{
				if(filesize($_FILES[$name]['tmp_name']) > $size)
					return FALSE;
			}
			else if($_FILES[$name]['error'] == UPLOAD_ERR_INI_SIZE || $_FILES[$name]['error'] = UPLOAD_ERR_FORM_SIZE)
				return FALSE;
		}
		return TRUE;
	}
	
	/**
	 * ڤؤJavaScript֤
	 * @return JavaScript 
	 */
	function getPicChangeScript()
	{
return "
<script language=\"JavaScript\" type=\"text/JavaScript\">
<!--

function changepic(pic, imgobj)
{
	
	if(document.getElementById)
	{
		document.getElementById(imgobj).style.display = 'none';
		document.getElementById(imgobj).src = pic.value;
	}
	else if(document.all)
	{
		document.all(imgobj).style.display = 'none';
		document.all(imgobj).src = pic.value;
	}
}

function loadpic(imgobj)
{
	if(document.getElementById)
		document.getElementById(imgobj).style.display = 'block';
	else if(document.all)
		document.all(imgobj).style.display = 'block';
}

//-->
</script>
";
	}
	
	/**
	 * Ūʥե륢åץɤΤΥե
	 * @param filename ꥸʥե̾
	 * @param pathname ꥸʥեգң
	 * @param varname եѿ̾
	 * @return ե륢åץɥե
	 */
	function getFileForm($filename, $pathname, $varname)
	{
		$html = "";
		$exists = FALSE;
		if(strlen($filename) && file_exists($filename))
		{
			$exists = TRUE;
			$size = filesize($filename) / 1000.0;
			$html .= "
				  <table><tr><td>
				  <input type=\"radio\" name=\"del" .$varname. "\" value=\"0\" checked>
				  </td><td>"
				  .PageUtil::getLinkedText($pathname, 'ǡե (' . $size . 'kb)', '_blank'). 
				  "</td></tr>";
		}
		if($exists)
		{
			$html .= " 
				  <tr><td>
				  <input type=\"radio\" name=\"del" .$varname. "\" value=\"1\"></td>
				  <td>";
		}

		  $html .= "<input name=\"" .$varname. "\" type=\"file\" size=\"60\">";

		if($exists)
		{
			$html.="
				  </td></tr></table>";
		}
		return $html;
	}
/*
	// ե륢åץɳǧ
	function getFileConfirm($filename, $orgfile, $orgpath, $varname, $type)
	{
		$html = "";
		if(strlen($filename) && file_exists(PageUtil::getPathName($this->tmpdir, $filename)))
		{
			$size = filesize(PageUtil::getPathName($this->tmpdir, $filename)) / 1000.0;
			$query["file"] = $filename;
			$query["type"] = $type;
			$html .=
				 "<input type=\"hidden\" name=\"$varname\" value=\"$filename\">".
				 PageUtil::getLinkedText('../viewer.php', 'Ͽǡե (' . $size . 'kb)',$query,'_blank');
		}
		else if((!array_key_exists("del" . $varname, $_REQUEST) ||
			$_REQUEST["del" . $varname] != 1) &&
			file_exists($orgfile))
		{
			$size = filesize($orgfile) / 1000.0;
			$html .= 
				 PageUtil::getLinkedText($orgpath, 'Ͽǡե (' . $size . 'kb)', '_blank');
		}
		if(array_key_exists("del" . $varname, $_REQUEST))
		{
			showHidden("del" . $varname);
		}
		return $html;
	}
*/
	// ե륢åץɳǧ
	function getFileConfirm($filename, $orgfile, $orgpath, $varname, $type)
	{
		$html = "";
		if(strlen($filename) && file_exists(PageUtil::getPathName($this->tmpdir, $filename)))
		{
			$size = filesize(PageUtil::getPathName($this->tmpdir, $filename)) / 1000.0;
			$html .=
				 "<input type=\"hidden\" name=\"$varname\" value=\"$filename\">".
				 PageUtil::getLinkedText(PageUtil::getPathName($this->tmpdir, $filename), 'Ͽǡե (' . $size . 'kb)', '_blank');
		}
		else if((!array_key_exists("del" . $varname, $_REQUEST) ||
			$_REQUEST["del" . $varname] != 1) &&
			file_exists(PageUtil::getPathName($orgpath, $orgfile)))
		{
			$size = filesize(PageUtil::getPathName($orgpath, $orgfile)) / 1000.0;
			$html .= 
				 PageUtil::getLinkedText(PageUtil::getPathName($orgpath, $orgfile), 'Ͽǡե (' . $size . 'kb)', '_blank');
		}
		if(array_key_exists("del" . $varname, $_REQUEST))
		{
			showHidden("del" . $varname);
		}
		return $html;
	}

	/**
	 * åץɤΤΥե
	 * @param filename ե̾
	 * @param varname եѿ̾
	 * @param showpic showpic.phpϤѥ᡼
	 */
	function getPicForm($filename, $varname, $showpic)
	{
		$html = "";
		if(strlen($filename) && file_exists($filename))
		{
			$exists = TRUE;
			$html .= "
				  <table><tr><td>
				  <input type=\"radio\" name=\"del$varname\" value=\"0\" checked>
				  </td><td>
				  <img src=\"$showpic\" name=\"img_$varname\" style=\"display:inline\" onLoad=\"loadpic('img_$varname');\"></td></tr>";
		}
		else
		{
			$exists = FALSE;
			$html .= "
				  <img src=\"\" name=\"img_$varname\" style=\"display:none\" onLoad=\"loadpic('img_$varname');\">";
		}
		if($exists)
		{
			$html .= "
				  <tr><td>
				  <input type=\"radio\" name=\"del$varname\" value=\"1\"></td>
				  <td>";
		}
			$html .= "
				  <input name=\"$varname\" type=\"file\" size=\"60\" onChange=\"changepic(this,'img_$varname');\">";
		if($exists)
		{
			$html .= "
				  </td></tr></table>";
		}
		return $html;
	}

	/**
	 * ǧ̤ǲɽ
	 * @param filename åץɤե̾
	 * @param orgfile ե̾
	 * @param varname եѿ̾
	 * @param showpic showpic.php
	 * @param mode showpic.phpϤ⡼
	 * @param code showpic.phpϤ
	 */
	function getPicConfirm($filename, $orgfile, $varname, $showpic, $mode, $code)
	{
		$html = "";
		if(strlen($filename) && file_exists(PageUtil::getPathName($this->tmpdir, $filename)))
		{
			$html .= "
				 <input type=\"hidden\" name=\"$varname\" value=\"$filename\">
				 <img src=\"$showpic?type=tmp&mode=$mode&file=$filename\">";
		}
		else if(($code > 0) && ($_REQUEST["del" . $varname] != 1) &&
			file_exists($orgfile))
		{
			$html .= "
				 <img src=\"$showpic?mode=$mode&code=$code\">";
		}
		if(array_key_exists("del" . $varname, $_REQUEST))
		{
			//showHidden("del" . $varname);
			$html .= "<input type=\"hidden\" name=\"del" . $varname . "\" value=\"" . $_REQUEST['del' . $varname] . "\">";
		}
		return $html;
	}
		
}
 
?>