<?php
/**
 * @class  HttpRequest
 * @brief  HTTPץȥΥꥯȥ饹
 * @author Daijiro Abe
 * @date   2005.10.31
 */

require_once(dirname(__FILE__) . '/Cookie.php');
require_once(dirname(__FILE__) . "/HttpSession.php");

class HttpRequest
{
    var $encoding = "EUC-JP";
    var $attributes = array();
    var $parameters = array();
    
    function convertEncoding($data, $srcEnc)
    {
        if(is_array($data))
        {
            foreach($data as $index => $item)
            {
                $data[$index] = $this->convertEncoding($item, $srcEnc);
            }
            return $data;
        }
        else
        {
            if(get_magic_quotes_gpc())
                $data = stripslashes($data);
            return mb_convert_encoding($data, "EUC-JP", $srcEnc);
        }
    }
    
    function HttpRequest($encoding=NULL)
    {
        $this->encoding = $encoding;
        if(HttpRequest::getMethod() == 'GET')
            $req = $_GET;
        else
            $req = $_POST;
        
        if(!get_magic_quotes_gpc())
        {
            if($encoding)
            {
                foreach($req as $key => $value)
                    $this->parameters[$key] = $this->convertEncoding($value, $encoding);
            }
            else
                $this->parameters = $req;
        }
        else
        {
            foreach($req as $key => $value)
            {
                if($encoding)
                      $value = $this->convertEncoding($value, $encoding);
                $this->parameters[$key] = $value;
            }
        }
    }
    
    /**
     * ѥ᡼ͤޤ
     * @param $name ѥ᡼̾
     * @return ѥ᡼͡ʤNULL
     */
    function getParameter($name)
    {
        $value = NULL;
        $parameters = $this->parameters;
        if(array_key_exists($name, $parameters))
            $value = $parameters[$name];
        return $value;
    }
    
    /**
     * ѥ᡼ͤꤷޤ
     * @param $name ѥ᡼̾
     * @param $value 
     */
    function setParameter($name, $value)
    {
        $this->parameters[$name] = $value;
    }
    
    /**
     * ѥ᡼Ϣ֤ޤ
     * @return ѥ᡼
     */
    function getParameterMap()
    {
        return $this->parameters;
    }
    
    /**
     * ѥ᡼ѿ֤̾ޤ
     * @return ѥ᡼ѿ̾
     */
    function getParameterNames()
    {
        return array_keys($this->parameters);
    }
    
    /**
     * 饤Ȥuser agent֤ޤ
     * @return 饤Ȥuser agent
     */
    function getUserAgent()
    {
        return $_SERVER["HTTP_USER_AGENT"];
    }
    
    
    /**
     * 饤Ȥreferer֤ޤ
     * @return 饤Ȥreferer
     */
    function getReferer()
    {
        return $_SERVER["HTTP_REFERER"];
    }
    /**
     * 饤ȤIPɥ쥹֤ޤ
     * @return 饤ȤIPɥ쥹
     */
    function getRemoteAddr()
    {
        return $_SERVER["REMOTE_ADDR"];
    }
    
    /**
     * 饤ȤΥۥ֤̾ޤ
     * @return 饤ȤΥۥ̾
     */
    function getRemoteHost()
    {
        return gethostbyaddr($_SERVER["REMOTE_ADDR"]);
    }
    
    /**
     * ФΥۥ֤̾ޤ
     * @return ФΥۥ̾
     */
    function getServerName()
    {
        return $_SERVER["SERVER_NAME"];
    }
    
    /**
     * ФΥݡֹ֤ޤ
     * @return ФΥݡֹ
     */
    function getServerPort()
    {
        return $_SERVER["SERVER_PORT"];
    }
    
    /**
     * ƤƤΥå֤ޤ
     * @return Cookie֥Ȥ
     */
    function &getCookies()
    {
        $cookie = array();
        foreach($_COOKIE as $key => $value)
        {
            if(!get_magic_quotes_gpc())
                $cookie[] = new Cookie($key, stripslashes($value));
            else
                $cookie[] = new Cookie($key, $value);
        }
        return $cookie;
    }
    
    /**
     * HTTP᥽åɤ֤̾ޤ
     * @return HTTP᥽åɤ̾
     */
    function getMethod()
    {
        return $_SERVER["REQUEST_METHOD"];
    }
    
    /**
     * PathInfo֤ͤޤ
     * @return PathInfo
     */
    function getPathInfo()
    {
        if(array_key_exists('PATH_INFO', $_SERVER))
            return $_SERVER["PATH_INFO"];
        else
            return NULL;
    }
    
    /**
     * ʸ֤ޤ
     * @return ʸ
     */
    function getQueryString()
    {
        return $_SERVER["QUERY_STRING"];
    }
    
    /**
     * 桼ǧڤƤ硢֤̾ޤ
     * @return ̾
     */
    function getRemoteUser()
    {
        if(array_key_exists('REMOTE_USER', $_SERVER))
            return $_SERVER["REMOTE_USER"];
        else
            return NULL;
    }
    
    /**
     * åID֤ޤ
     * @return åID
     */
    function getRequestedSessionId()
    {
        return session_id();
    }
    
    /**
     * ꥯURI֤ޤ
     * @return ꥯURI
     */
    function getRequestURI()
    {
        return $_SERVER["REQUEST_URI"];
    }
    
    /**
     * ߤΥå֤ޤ
     * @param $create å󤬤ʤ뤫ɤ
     * @return å
     */
    function getSession($create=true)
    {
        if($create && !session_id())
            session_start();
        return new HttpSession();
    }
    
    /**
     * ꥯȤʸ󥳡ǥ󥰤֤ޤ
     * @return ʸ󥳡ǥ
     */
    function getCharacterEncoding()
    {
        return $this->encoding;
    }
    
    /**
     * ꥯȤʸ󥳡ǥ󥰤ꤷޤ
     * @param $encoding ʸ󥳡ǥ
     */
    function setCharacterEncoding($encoding)
    {
        $this->encoding = $encoding;
    }
    
    /**
     * ꤵ줿̾°֤ͤޤ
     * @param $name ̾
     * @return °
     */
    function &getAttribute($name)
    {
        $attribute = NULL;
        if(array_key_exists($name, $this->attributes))
            $attribute = $this->attributes[$name];
        return $attribute;
    }
    
    /**
     * °̾ޤ
     * @return °̾
     */
    function getAttributeNames()
    {
        return array_keys($this->attributes);
    }
    
    /**
     * °ޤ
     * @param $name ̾
     */
    function removeAttribute($name)
    {
        if(array_key_exists($name, $this->attributes))
            unset($this->attributes[$name]);
    }
    
    /**
     * °򥻥åȤޤ
     * @param $name ̾
     * @parma $obj  ֥
     */
    function setAttribute($name, &$obj)
    {
        $this->attributes[$name] = $obj;
    }
    
    /**
     * HTTPSɤ֤ޤ
     * @return HTTPSʤ trueǤʤ false
     */
    function isHttps()
    {
        if(array_key_exists("HTTPS", $_SERVER))
        {
            if($_SERVER["HTTPS"] == "on")
                return true;
        }
        return false;
    }
}

?>
