<?php
/**
 * @class  HttpResponse
 * @brief  HTTP쥹ݥ󥹥饹
 * @author Daijiro Abe
 * @date   2005.10.31
 */

class HttpResponse
{
    var $encoding = "EUC-JP";
    var $contentType = "text/html";
    var $cookies = array();
    var $headers = array();
    
    /**
     * ʸ󥳡ǥ󥰤֤ޤ
     * @return ʸ󥳡ǥ
     */
    function getCharacterEncoding()
    {
        return $this->encoding;
    }
    
    /**
     * ʸ󥳡ǥ󥰤ꤷޤ
     * @param $encoding ʸ󥳡ǥ
     */
    function setCharacterEncoding($encoding)
    {
        $this->encoding = $encoding;
    }
    
    /**
     * ContentType֤ޤ
     * @return ContentType
     */
    function getContentType()
    {
        return $this->contentType;
    }
    
    /**
     * ContentTypeꤷޤ
     * @param $contentType ContentType
     */
    function setContentType($contentType)
    {
        $this->contentType = $contentType;
    }
    
    /**
     * ꤵ줿åɲäޤ
     * @param $cookie Cookie󥹥
     */
    function addCookie(&$cookie)
    {
        $this->cookies[] = $cookie;
    }
    
    /**
     * ꤵ줿̾դͤĥإåɲäޤ
     * @param $name ̾
     * @param $date աʥॹ͡
     */
    function addDateHeader($name, $date)
    {
        $this->headers[] = $name . ': ' . gmdate("D, d M Y H:i:s", $date)." GMT";
    }
    
    /**
     * ꤵ줿̾ͤĥإåɲäޤ
     * @param $name  ̾
     * @param $value 
     */
    function addHeader($name, $value)
    {
        $this->headers[] = "$name: $value";
    }
    
    /**
     * ꤵ줿̾ΥإåꤵƤ뤫ɤĴ٤ޤ
     * @return ꤵƤ trueǤʤ false
     */
    function containsHeader($name)
    {
        foreach($this->headers as $header)
        {
            if(preg_match("/^$name:/", $header))
                return true;
            else
                return false;
        }
    }
    
    /**
     * ꤵ줿URL򥨥󥳡ɤޤ
     * @param $url URL
     * @return 󥳡ɤ줿URL
     */
    function encodeRedirectURL($url)
    {
        if(!preg_match('/^https?:\/\/' . $_SERVER["SERVER_NAME"] . '/', $url))
            return $this->encodeURL($url);
        else
            return $url;
    }
    
    /**
     * ꤵ줿URL򡢥åIDޤƥ󥳡ɤޤ
     * @param $url URL
     * @return 󥳡ɤ줿URL
     */
    function encodeURL($url)
    {
        $sessname = ini_get('session.name');
        if(!session_id() || preg_match('/' . $sessname . '/', $url))
            return $url;
        else if(strpos($url, '?') === false)
            return $url . "?$sessname=" . session_id();
        else
            return $url . "&$sessname=" . session_id();
    }
    
    /**
     * ꤵ줿URLإ쥯Ȥޤ
     * @param $location 쥯
     */
    function sendRedirect($location)
    {
        $location = $this->encodeRedirectURL($location);
        header("Location: $location");
        exit;
    }
    
    /**
     * ꤵ줿̾դͤĥإåꤷޤ
     * @param $name ̾
     * @param $date 
     */
    function setDateHeader($name, $date)
    {
        $value = gmdate("D, d M Y H:i:s", $date)." GMT";
        $this->setHeader($name, $value);
    }
    
    /**
     * ꤵ줿̾ͤĥإåꤷޤ
     * @param $name ̾
     * @param $value 
     */
    function setHeader($name, $value)
    {
        $header_txt = "$name: $value";
        foreach($this->headers as $index => $header)
        {
            if(preg_match("/^$name:/", $header))
            {
                $this->headers[$index] = $header_txt;
                return;
            }
        }
        $this->headers[] = $header_txt;
    }
    
    /**
     * ХåեΥǡեå夷ޤ
     */
    function flushBuffer()
    {
        flush();
    }
    
    /**
     * Хåե֤ޤ
     * @return Хåե
     */
    function getBufferSize()
    {
        return ini_get('output_buffering');
    }
    
    /**
     * ϤԤޤ
     * @param $data Ϥǡ
     */
    function write($data)
    {
        print $data;
    }
    
    /**
     * CRLFղäϤԤޤ
     * @param $data Ϥǡ
     */
    function writeln($data)
    {
        print $data . "\r\n";
    }
    
    /**
     * Хåեꤷޤ
     * @param $size Хåե
     */
    function setBufferSize($size)
    {
        ini_set('output_buffering', $size);
    }
}

?>
