<?php
/**
 * @class  HttpSession
 * @brief  å򤢤魯饹
 * @author Daijiro Abe
 * @date   2005.10.31
 */

class HttpSession
{
    /**
     * 󥹥ȥ饯
     */
    function HttpSession()
    {
        $self = $_SERVER["PHP_SELF"];
        if(!array_key_exists($self, $_SESSION))
            $_SESSION[$self] = array();
    }
    
    /**
     * ꤵ줿̾ǥХɤ줿֥Ȥ֤ޤ
     * @param $name ̾
     * @return åǡ
     */
    function &getAttribute($name)
    {
        $session = NULL;
        $self = $_SERVER["PHP_SELF"];
        if(array_key_exists($self, $_SESSION) &&
            array_key_exists($name, $_SESSION[$self]))
            $session = $_SESSION[$self][$name];
        return $session;
    }
    
    /**
     * Хɤ줿٤ƤΥ֥Ȥ֤̾ޤ
     * @return åѿ̾
     */
    function getAttributeNames()
    {
        $self = $_SERVER["PHP_SELF"];
        if(array_key_exists($self, $_SESSION) && is_array($_SESSION[$self]))
            return array_keys($_SESSION[$self]);
        else
            return array();
    }
    
    /**
     * åID֤ޤ
     * @return åID
     */
    function getId()
    {
        return session_id();
    }
    
    /**
     * å֤ͭÿ֤ޤ
     * @return åͭ
     */
    function getMaxInactiveInterval()
    {
        return ini_get('session.gc_maxlifetime');
    }
    
    /**
     * ٤ƤΥå󥪥֥Ȥ򥢥Хɤޤ
     */
    function invalidate()
    {
        $sesskey = $this->getAttributeNames();
        foreach($sesskey as $key)
            $this->removeAttribute($key);
    }
    
    /**
     * ꤵ줿̾ǥХɤƤ֥Ȥޤ
     * @param $name ̾
     */
    function removeAttribute($name)
    {
        $self = $_SERVER["PHP_SELF"];
        if(array_key_exists($self, $_SESSION) &&
            array_key_exists($name, $_SESSION[$self]))
            unset($_SESSION[$self][$name]);
    }
    
    /**
     * ꤵ줿̾Ѥơ֥ȤХɤޤ
     * @param $name ̾
     * @param $obj  ֥
     */
    function setAttribute($name, &$obj)
    {
        $self = $_SERVER["PHP_SELF"];
        $_SESSION[$self][$name] = $obj;
    }
    
    /**
     * å֤ͭꤷޤ
     * @param $interval ͭ
     */
    function setMaxInactiveInterval($interval)
    {
        ini_set('session.gc_maxlifetime', $interval);
    }
}

?>
