<?php
/**
 * 饹
 *                                              2004.12.01 Daijiro Abe.
 */
class Image
{
    var $version;
    var $flg;
    var $img;
    var $size;
    var $filename;
    
    function Image($filename)
    {
        $this->filename = $filename;
        if(function_exists('ImageCreateTrueColor'))
            $this->version = 2;
        else if(function_exists('ImageCreate'))
            $this->version = 1;
        else
            $this->version = 0;
        
        $this->flg = FALSE;
        $size = GetImageSize($filename);
        $this->size = $size;

        if($this->version > 0)
        {
            if($size[2] == 1)
            {
                if($this->version == 2)
                {
                    $this->img = ImageCreateFromGif($filename);
                    $this->flg = TRUE;
                }
            }
            else if($size[2] == 2)
            {
                $this->img = ImageCreateFromJPEG($filename);
                $this->flg = TRUE;
            }
            else if($size[2] == 3)
            {
                $this->img = ImageCreateFromPNG($filename);
                $this->flg = TRUE;
            }
        }
    }
    
    function show($width=0, $height=0)
    {
        if($this->flg)
        {
            if($width && (!$height))
            {
                $rate = $this->size[0] / $width;
                $height = floor($this->size[1] / $rate);
            }
            if($width && $height)
            {
                if($this->version == 2)
                {
                    $img = ImageCreateTrueColor($width, $height);
                    ImageCopyResampled($img, $this->img, 0,0,0,0, $width, $height, $this->size[0], $this->size[1]);
                }
                else
                {
                    $img = ImageCreate($width,$height);
                    ImageCopyResized($img, $this->img, 0,0,0,0, $width, $height, $this->size[0], $this->size[1]);
                }
                ImageDestroy($this->img);
                $this->img = $img;
            }
            if($this->size[2] == 1)
            {
                if(function_exists('ImageGif'))
                {
                    ImageGif($this->img);
                    header("Content-type: image/gif");
                }
                else
                {
                    ImagePNG($this->img);
                    header("Content-type: image/png");
                }
                ImageDestroy($this->img);
            }
            else if($this->size[2] == 2)
            {
                ImageJPEG($this->img,"",100);
                header("Content-type: image/jpeg");
                ImageDestroy($this->img);
            }
            else if($this->size[2] == 3)
            {
                ImagePNG($this->img);
                header("Content-type: image/png");
                ImageDestroy($this->img);
            }
        }
        else
        {
            if($this->size[2] == 1)
                header("Content-type: image/gif");
            else if($this->size[2] == 2)
                header("Content-type: image/jpeg");
            else if($this->size[2] == 3)
                header("Content-type: image/png");
            if(file_exists($this->filename))
            {
                $fp = fopen($this->filename, "rb");
                while(!feof($fp))
                    print fread($fp, 4096);
                fclose($fp);
            }
        }
    }
}
?>
