<?php
/**
 * @class  Import
 * @brief  XMLɤ߹ǥǡ١˳Ǽ
 * @author Daijiro Abe
 * @date   2005-02-15
 */

require_once("utils/jcode.php");

class Import
{
	var $db;
	var $data = array();
	
	function Import($db)
	{
		$this->db = $db;
	}
	
	function load($xmlfile)
	{
		$this->data = array();
		if(!file_exists($xmlfile)) die("file is not found!");
		$fd = fopen($xmlfile, "r");
		if(!$fd) die("cannot open file!");
		$contents = fread($fd, filesize($xmlfile));
		fclose($fd);
		$parser = domxml_open_mem($contents);
		$root = $parser->document_element();
		
		$nodeList = $root->child_nodes();
		for($i = 0; $i < count($nodeList); $i++)
		{
			$element = $nodeList[$i];
			if($element->node_type() == XML_ELEMENT_NODE)
			{
				$tableName = $element->tagname;
				$fields = $element->attributes();

//				$factory = $this->db->createFactory($tableName);
				$rec = array();
				$sql = "insert into $tableName (";
				foreach($fields as $index => $att)
				{
					$name = JcodeConvert($att->name, 4, 1);
					$value = JcodeConvert($att->value, 4, 1);
					$rec[$name] = $value;
					if($index > 0)
						$sql .= ",";
					$sql .= $name;
				}
				$sql .= ") values (";
				foreach($fields as $index => $att)
				{
					$name = JcodeConvert($att->name, 4, 1);
					$value = JcodeConvert($att->value, 4, 1);
					if($index > 0)
						$sql .= ",";
					$sql .= "'".$value."'";
				}
				$sql .= ")";
				$this->data[$tableName][] = $rec;
//				$factory->insert($rec);
				$this->db->query($sql);
			}
		}
	}
	
	function getTable($tableName)
	{
		if(array_key_exists($tableName, $this->data))
			return $this->data[$tableName];
		else
			return NULL;
	}
	
	function getRecordAt($table, $index)
	{
		$array = $this->getTable($table);
		if($array)
		{
			if(count($array) > $index)
				return $array[$index];
			else
				return NULL;
		}
	}
}

?>