<?php
/**
 * @class  Logger
 * @brief  󥰥饹
 * @author Daijiro Abe
 * @date   2005.12.14
 */

define("LOGLEVEL_DEBUG", 5);
define("LOGLEVEL_INFO",  4);
define("LOGLEVEL_WARN",  3);
define("LOGLEVEL_ERROR", 2);
define("LOGLEVEL_FATAL", 1);
define("LOGLEVEL_OFF", 0);

class Logger
{
    var $name;
    var $level;
    var $appenders = array();
    
    /**
     * ٥̾
     * @param $level ٥
     */
    function getLevelName($level)
    {
        switch($level)
        {
            case LOGLEVEL_DEBUG:
                return "DEBUG";
            case LOGLEVEL_INFO:
                return "INFO";
            case LOGLEVEL_WARN:
                return "WARN";
            case LOGLEVEL_ERROR:
                return "ERROR";
            case LOGLEVEL_FATAL:
                return "FATAL";
        }
    }
    
    /**
     * 󥹥ȥ饯
     * @param $name ̾
     */
    function Logger($name)
    {
        $this->name = $name;
    }
    
    /**
     * 󥰥饹Υ󥹥󥹤֤ޤ
     * @param $class 󥹥ϥ饹̾
     */
    function &getLogger($class)
    {
        $instances = &Logger::getAllLoggers();
        
        if(is_object($class))
            $class = get_class($class);
        else
            $class = strtolower($class);
        
        if(!array_key_exists($class, $instances))
            $instances[$class] = & new Logger($class);

        return $instances[$class];
    }
    
    /**
     * ƤΥ󥰥󥹥󥹤
     * @return Logger
     */
    function &getAllLoggers()
    {
        static $instances = array();
        return $instances;
    }
    
    /**
     * 󥰥󥹥󥹤ꤹ
     * @param $loggers 󥹥󥹤
     */
    function setAllLoggers(&$loggers)
    {
        $org = &Logger::getAllLoggers();
        $org = $loggers;
    }
    
    /**
     * ٥ꤹ
     * @param $level ٥
     */
    function setLevel($level)
    {
        $this->level = $level;
    }
    
    /**
     * ǥХå٥ǤΥϤԤ
     * @param $msg å
     */
    function debug($msg)
    {
        if($this->level >= LOGLEVEL_DEBUG)
            $this->trace($msg, LOGLEVEL_DEBUG);
    }
    
    /**
     * INFO٥ǤΥϤԤ
     * @param $msg å
     */
    function info($msg)
    {
        if($this->level >= LOGLEVEL_INFO)
            $this->trace($msg, LOGLEVEL_INFO);
    }
    
    /**
     * WARN٥ǤΥϤԤ
     * @param $msg å
     */
    function warn($msg)
    {
        if($this->level >= LOGLEVEL_WARN)
            $this->trace($msg, LOGLEVEL_WARN);
    }
    
    /**
     * ERROR٥ǤΥϤԤ
     * @param $msg å
     */
    function error($msg)
    {
        if($this->level >= LOGLEVEL_ERROR)
            $this->trace($msg, LOGLEVEL_ERROR);
    }
    
    /**
     * FATAL٥ǤΥϤԤ
     * @param $msg å
     */
    function fatal($msg)
    {
        if($this->level >= LOGLEVEL_FATAL)
            $this->trace($msg, LOGLEVEL_FATAL);
    }
    
    /**
     * appenderΰ
     * @return appender
     */
    function &getAllAppenders()
    {
        return $this->appenders;
    }
    
    /**
     * appenderɲä
     * @param $appender Appender󥹥
     */
    function addAppender(&$appender)
    {
        $appenderName = $appender->getName();
        $appenders = & $this->getAllAppenders();
        if(!array_key_exists($appenderName, $appenders))
        {
            $appenders[$appenderName] = $appender;
        }
    }
    
    /**
     * appender ֤ޤ
     * @param $name appender̾
     */
    function &getAppender($name)
    {
        $appenders = & $this->getAllAppenders();
        if(array_key_exists($name, $appenders))
            return $appenders[$name];
        else
            return NULL;
    }
    
    /**
     * Ƥappender򥯥ꥢޤ
     */
    function removeAllAppenders()
    {
        $appenders = & $this->getAllAppenders();
        $appenders = array();
    }
    
    /**
     * appenderޤ
     * @param $appender 󥹥
     */
    function removeAppender($appender)
    {
        $appenders = & $this->getAllAppenders();
        $name = $appender->getName();
        if(array_key_exists($name, $appenders))
            unset($appenders[$name]);
    }
    
    /**
     * 󥰤Ԥޤ
     * @param $msg å
     * @param $level ٥
     */
    function trace($msg, $level)
    {
        $event["msg"] = $msg;
        $event["level"] = $this->getLevelName($level);
        $appenders = & $this->getAllAppenders();
        foreach($appenders as $appender)
        {
            $appender->doAppend($event);
        }
    }
}

?>
