<?php
/**
 * @class  PopClient
 * @brief  POP3饤ȥ饹
 * @date   2005.06.21
 * @author Daijiro Abe
 */
require_once(dirname(__FILE__) . "/../Utils/jcode.php");

// ǥեȥॢ Ȥꤢ20
define('DEFAULT_TIMEOUT', 20);

define('POPERR_SERVERUNDEF',      1); // ̤顼
define('POPERR_PORTUNDEF',        2); // ݡ̤顼
define('POPERR_CANNOTCONNECT',    3); // ³Ի顼
define('POPERR_TIMEDOUT',         4); // ॢȥ顼
define('POPERR_APOPNOTSUPPORTED', 5); // APOPб
define('POPERR_LOGGEDIN',         6); // 顼
define('POPERR_UNKNOWN',         99); // ʥ顼

class PopClient
{
    var $server;
    var $port;
    var $id;
    var $passwd;
    var $isApop;
    var $timeout;
    var $fp;
    var $delflg;
    
    /**
     * fp 򤫤ޤ
     * @return fp
     */
    function getFP() {
        return $this->fp;
    }
    
    /**
     * POPФ֤ޤ
     * @return POP
     */
    function getServer()
    {
        return $this->server;
    }
    
    /**
     * POPФꤷޤ
     * @param server POP
     */
    function setServer($server)
    {
        $this->server = $server;
    }
    
    /**
     * POPݡȤ֤ޤ
     * @return POPݡ
     */
    function getPort()
    {
        return $this->port;
    }
    
    /**
     * POPݡȤꤷޤ
     * @param port POPݡ
     */
    function setPort($port)
    {
        $this->port = $port;
    }
    
    /**
     * 桼ɣĤ֤ޤ
     * @return 桼ɣ
     */
    function getId()
    {
        return $this->id;
    }
    
    /**
     * 桼ɣĤꤷޤ
     * @param id 桼ɣ
     */
    function setId($id)
    {
        $this->id = $id;
    }
    
    /**
     * ѥɤ֤ޤ
     * @return ѥ
     */
    function getPassword()
    {
        return $this->passwd;
    }
    
    /**
     * ѥɤꤷޤ
     * @param passwd ѥ
     */
    function setPassword($passwd)
    {
        $this->passwd = $passwd;
    }
    
    /**
     * APOPѤ뤫ɤ֤ޤ
     * @return APOPѤʤ trueǤʤ false ֤ޤ
     */
    function isApop()
    {
        return $this->isApop;
    }
    
    /**
     * APOPѤ뤫ɤꤷޤ
     * @param isApop APOPѤʤ trueʤ false
     */
    function setIsApop($isApop)
    {
        $this->isApop = $isApop;
    }
    
    /**
     * ॢȤ֤ͤޤá
     * @return ॢ
     */
    function getTimeout()
    {
        if($this->timeout > 0)
            return $this->timeout;
        else
            return DEFAULT_TIMEOUT;
    }
    
    /**
     * ॢȤͤꤷޤ
     * @param timeout ॢ
     */
    function setTimeout($timeout)
    {
        $this->timeout = $timeout;
    }
    
    /**
     * ᡼뤫Ĥ
     * @return APOPѤʤ trueǤʤ false ֤ޤ
     */
    function getDelFlg()
    {
        return $this->delflg;
    }
    
    /**
     * ᡼뤫ꤷޤ
     * @param isApop APOPѤʤ trueʤ false
     */
    function setDelFlg($delflg)
    {
        $this->delflg = $delflg;
    }
    
    
    /**
     * Ф³

     * @return  trueԤ饨顼ɤ֤
     */
    function connect()
    {
        // м
        $server = $this->getServer();
        if(strlen($server) == 0)
            return POPERR_SERVERUNDEF;
        
        // ݡȼ
        $port = $this->getPort();
        if(strlen($port) == 0)
            return POPERR_PORTUNDEF;
        
        $timeout = $this->getTimeout();
        $this->fp = @fsockopen($server,$port,$errno, $errstr,$timeout);
        if(!$this->fp)
            return POPERR_CANNOTCONNECT;
        
        socket_set_timeout($this->fp, $timeout);
        
        // 륫åμ
        if(!feof($this->fp))
            $welcome = fgets($this->fp, 128);
        else if($this->isTimedOut())
        {
            fclose($this->fp);
            return POPERR_TIMEDOUT;
        }
        
        if($this->isApop())
        {
            if(preg_match("/<[^<]+>/", $welcome, $matches))
            {
                $challenge = $matches[0];
                $digest = md5($challenge . $this->getPassword());
                // ꥯ
                $this->sendRequest("APOP " . $this->getId() . " " . $digest);
                // 쥹ݥ󥹼
                $result = $this->getResponse($res);
                if($result === true)
                    return true;
                else if($result == false)
                    return POPERR_LOGGEDIN;
                else
                    return $result;
            }
            else
            {
                return POPERR_APOPNOTSUPPORTED;
            }
        }
        else
        {
            $this->sendRequest("USER " . $this->getId());
            $result = $this->getResponse($res);
            if($result === true)
            {
                $this->sendRequest("PASS " . $this->getPassword());
                $result = $this->getResponse($res);
                if($result === true)
                    return true;
                else if($result === false)
                    return POPERR_LOGGEDIN;
                else
                    return $result;
            }
            else if($result === false)
                return POPERR_LOGGEDIN;
            else
                return $result;
        }
    }
    
    /**
     * ॢȤƤʤå
     * @return ॢȤƤ trueǤʤ false
     */
    function isTimedOut()
    {
        $stat = socket_get_status($this->fp);
        if($stat["timed_out"])
            return true;
        else
            return false;
    }
    
    /**
     * ꥯ
     * @param req ꥯʸ

     * @return ХȿԻˤfalse
     */
    function sendRequest($req)
    {
        return @fputs($this->fp, $req . "\r\n");
    }
    
    /**
     * 쥹ݥ󥹼
     * @param res 쥹ݥʸ

     * @return trueԻ顼ɤޤfalse
     */
    function getResponse(&$res)
    {
        // 쥹ݥ󥹼
        if(!feof($this->fp))
        {
            $res = @fgets($this->fp, 128);
        }
        else
        {
            fclose($this->fp);
            if($this->isTimedOut())
                return POPERR_TIMEDOUT;
            else
                return POPERR_UNKNOWN;
        }
        if(substr($res,0,1) == '+')
        {
            // 

            return true;
        }
        else if(substr($res, 0, 1) == '-')
        {
            // 
            return false;
        }
    }
    
    
    
    /**
     * ᡼Ƥ
     * @param
     * @return ᡼Ƥ֤ޤ
     */
    function getMailData() {
        $dat = array();
        $line = array();
        $md = array();
        
        
        // ************************************************
        // ᡼륪ץ

        $ret = $this->connect();
        
        if ($ret === false) {
            // print "<br>";
            return FALSE;
        } elseif ($ret === true) {
            // print "<br>";
        } else {
            // print "RET $ret<br>";
            return FALSE;
        }
        
        
        // * STAT -ȥ +OK 8 1234
        $this->sendRequest("STAT");
        $result = $this->getResponse($data);
        sscanf($data, '+OK %d %d', $num, $size);
        
        
        // ************************************************
        // * ᡼0ξ

        if ($num == "0") {
            $this->sendRequest("QUIT");
            $result = $this->getResponse($buf);
            fclose($this->fp);
            return FALSE;
        }
        
        // ************************************************
        // * ᡼ʬ֤
        for ($i = 1; $i <= $num; $i++) {
            // * RETR n -nܤΥåʥإåޡ
            $this->sendRequest("RETR $i");
            $result = $this->getResponse($line);
            
            // * EOF.ޤɤ

            while (!ereg("^\.\r\n", $line)) {
                $line = fgets($this->fp, 512);
                if (isset($dat[$i]) && $dat[$i] != NULL) {
                    $dat[$i] .= $line;
                } else {
                    $dat[$i] = $line;
                }
            }
            $this->sendRequest("UIDL $i");
            $result = $this->getResponse($ret);
            $uidl[$i] = $ret;
            
            
            // ********************************************
            // * DELE n nܤΥå

            // print "DELFLG : ".$this->delflg."<br>";
            // if ($this->delflg === TRUE) {
            //     $this->sendRequest("DELE $i");
            //     $result = $this->getResponse($data);
            // }
        }
        
        // ************************************************
        // λ
        // $this->sendRequest("QUIT");
        // $result = $this->getResponse($data);
        // fclose($this->fp);
        
        
        
        $lines = array();
        
        
        for ($j = 1; $j <= $num; $j++) {
            /// UIDL 򥻥å(˻)
            $md[$j-1]['uidl'] = $uidl[$j];
            
            /// إåʸʬ

            list($head, $body) = $this->mime_split($dat[$j]);
            //print (nl2br($head));
            
            print nl2br(trim(JcodeConvert($body, 0, 1)));
                                                 print "<br>";
            
            
            /// 
            eregi("Date:[ \t]*([^\r\n]+)", $head, $datereg);
            // print "DATE : {$datereg[1]}<br>";
            /// ᡼

            // $md[$j-1]['senddate'] = $now;
            $md[$j-1]['senddate'] = $datereg[1];
            
            
            /// إåμ
            $head = ereg_replace ("\r\n? ", "", $head);
            $md[$j-1]['heads'] = $head;
            // print "<b>HEAD</b><br>".nl2br(htmlspecialchars($head))."<br>";
            
            
            // ֥Ȥ
            // subject ʹߤ
            // ֥Ȥʸ¿ʣԤˤʤ礬롣
            $subs = NULL;
            $line_cnt = 0;
            $subject = NULL;
            $substr = strstr($head, "Subject: ");
            $substr = preg_replace('/^Subject: /', '', $substr);
            // print "SUBSTR: $substr<br>";
            $sub = explode("\r\n", $substr);
            foreach ($sub as $val) {
                // print "VAL: $val<br>";
                // print "SUBS: $subs<br>";
                if ($subs == NULL) {
                    $subs = $val;
                    $line_cnt = 1;
                } elseif ($line_cnt == 1) {
                    if (preg_match('/^\s/', $val)) {
                        $subs .= $val;
                    } else {
                        $line_cnt = 2;
                    }
                }
            }
            $subject = $subs;
            $subject = base64_decode(substr($subject, 16, -2));
            $subject = JcodeConvert($subject, 0, 1);
            $md[$j-1]['subject'] = $subject;
            // print "SUBREG".$subject."<br>";
            
            
            // ᡼륢ɥ쥹Τ߼
            if (eregi("\nFrom:[ \t]*([^\r\n]+)", $head, $freg)) {
                $md[$j-1]['fromto'] = $this->addr_search($freg[1]);
                $freg[1] = base64_decode(substr($freg[1], 16, -2));
                $freg[1] = JcodeConvert($freg[1], 0, 1);
                $md[$j-1]['fromto_org'] = $freg[1];
            } elseif (eregi("\nReply-To:[ \t]*([^\r\n]+)", $head, $freg)) {
                $md[$j-1]['fromto'] = $this->addr_search($freg[1]);
                $freg[1] = base64_decode(substr($freg[1], 16, -2));
                $freg[1] = JcodeConvert($freg[1], 0, 1);
                $md[$j-1]['fromto_org'] = $freg[1];
            } elseif (eregi("\nReturn-Path:[ \t]*([^\r\n]+)", $head, $freg)) {
                $md[$j-1]['fromto'] = $this->addr_search($freg[1]);
                $freg[1] = base64_decode(substr($freg[1], 16, -2));
                $freg[1] = JcodeConvert($freg[1], 0, 1);
                $md[$j-1]['fromto_org'] = $freg[1];
            }
            // print "FROM : {$md[$j-1]['fromto']}<br>";
            // print "FROM ORG : ".htmlspecialchars($md[$j-1]['fromto_org'])."<br>";
            
            
            /// to 
            if (eregi("To:[ \t]*([^\r\n]+)", $head, $freg)) {
                $posstr = ereg_replace("To: ", "", $freg[1]);
                $posstr = preg_replace('/\s/', '', $posstr);
                $posstr = str_replace("<",   "", $posstr);
                $posstr = str_replace(">",   "", $posstr);
                $md[$j-1]['to'] = trim($posstr);
                
                /// 褬ʣ?
                $posarr = explode(',', $posstr);
                if (count($posarr) > 1) {
                    $tos = TRUE;
                } else {
                    $tos = FALSE;
                }
            }
            // print "TO : {$md[$j-1]['to']}<br>";
            
            
            /// cc 
            if (eregi("Cc:[ \t]*([^\r\n]+)", $head, $freg)) {
                $posstr = ereg_replace("Cc: ", "", $freg[1]);
                $posstr = preg_replace('/\s/', '', $posstr);
                $posstr = str_replace("<",   "", $posstr);
                $posstr = str_replace(">",   "", $posstr);
                $md[$j-1]['cc'] = trim($posstr);
                
                /// 褬ʣ?
                $posarr = explode(',', $posstr);
                if (count($posarr) > 1) {
                    $ccs = TRUE;
                } else {
                    $ccs = FALSE;
                }
            } else {
                $md[$j-1]['cc'] = NULL;
            }
            // print "CC : {$md[$j-1]['cc']}<br>";
            
            
            /// Message-ID
            if (eregi("Message-ID: [ \t]*([^\r\n]+)", $head, $freg)){
                 $posstr = ereg_replace("Message-ID: ", "", $freg[1]);
                 $posstr = preg_replace('/\s/', '', $posstr);
                 $posstr = str_replace("<",   "", $posstr);
                 $posstr = str_replace(">",   "", $posstr);
                 $md[$j-1]['messageid'] = trim($posstr);
            }
            // print "Message-ID: {$md[$j-1]['messageid']}<br>";
            
            
            /// ٤
            if (eregi("Importance: [ \t]*([^\r\n]+)", $head, $freg)) {
                $posstr = ereg_replace("Importance: ", "", $freg[1]);
                switch ($posstr) {
                    case "High":
                        $md[$j-1]['priority'] = 1;
                        break;
                    case "Normal":
                        $md[$j-1]['priority'] = 2;
                        break;
                    case "Low":
                        $md[$j-1]['priority'] = 3;
                        break;
                    default :
                        $md[$j-1]['priority'] = 2;
                        break;
                }
            }
            // print "PRIORITY : {$md[$j-1]['priority']}<br>";
            
            // ޥѡȤʤХХʬ

            if (eregi("\nContent-type:.*multipart/",$head)) {
                eregi('boundary="([^"]+)"', $head, $boureg);
                $part = explode("--".$boureg[1],$body);
                if (eregi('boundary="([^"]+)"', $body, $boureg2)) {//multipart/altanative
                    $part = explode("--".$boureg2[1],$body);
                }
            // ̤Υƥȥ᡼

            } else {
                $part[0] = $dat[$j];
            }
            
            
            foreach ($part as $multi) {
                /// إåʸʬΥ
                list($m_head, $m_body) = $this->mime_split($multi);
                $m_body = ereg_replace("\r\n\.\r\n$", "", $m_body);
                
                
                if (!eregi("Content-type: *([^;\n]+)", $m_head, $type)) {
                    continue;
                }
                
                
                list($main, $sub) = explode("/", $type[1]);
                // ʸǥ
                if (strtolower($main) == "text") {
                    $text = trim(JcodeConvert($m_body, 0, 1));
                    
                    if ($sub == "html") {
                        $text = strip_tags($text);
                    }
                    // mac 

                    $text = ereg_replace("Content-type: multipart/appledouble;[[:space:]]boundary=(.*)","",$text);
                    
                    // print "<b>BODY</b> :".nl2br($text)."<br>";
                    
                    /// Ԥ졣
                    $text = str_replace("\r\n", "\n", $text);
                    $text = str_replace("\r", "\n", $text);
                    $text = preg_replace("/\n{2,}/", "\n\n", $text);
                    $text = str_replace('', ' ', $text);
                    $md[$j-1]['body'] = $text;
                    // print "<b>BODY</b> :".nl2br($text)."<br>";
                }
                
                $md[$j-1]['bcc'] = NULL;
                
                /*
                // ե̾
                if (eregi("name=\"?([^\"\n]+)\"?",$m_head, $filereg)) {
                    $filename = ereg_replace("[\t\r\n]", "", $filereg[1]);
                    while (eregi("(.*)=\?iso-2022-jp\?B\?([^\?]+)\?=(.*)",$filename,$regs)) {
                        $filename = $regs[1].base64_decode($regs[2]).$regs[3];
                        $filename = convert($filename);
                    }
                    if (!$original) $filename = time()."-".$filename;
                }
                // źեǡǥɤ¸
                if (eregi("Content-Transfer-Encoding:.*base64", $m_head) && eregi($subtype, $sub)) {
                    $tmp = base64_decode($m_body);
                    if (!$filename) {
                        $filename = time().".$sub";
                    }
                    if (strlen($tmp) < $maxbyte && !eregi($viri, $filename) && $write) {
                        $fp = fopen($tmpdir.$filename, "w");
                        fputs($fp, $tmp);
                        fclose($fp);
                        $attach = $filename;
                    } else {
                        $write = false;
                    }
                }
                */
            }
        }
        
        return $md;
    }
    
    
    /**
     * ᡼򥵡С˻ĤʤϺե饰ΩƤ롣
     * @param $num ᡼No
     * @return  TRUE  FALSE
     * @Author motoki katayama
     */
    function setMailDel($num) {
        // ********************************************
        // * DELE n nܤΥå

        // print "DELFLG : ".$this->delflg."<br>";
        if ($this->delflg === TRUE) {
            $this->sendRequest("DELE $num");
            $result = $this->getResponse($data);
        }
        return $result;
    }
    
    
    
    /**
     * إåʸʬ䤹 
     * @param $data ᡼ǡ
     * @return part[0]إåpart[1]ʸ
     */
    function mime_split($data) {
        $part = split("\r\n\r\n", $data, 2);
        $part[1] = ereg_replace("\r\n[\t ]+", " ", $part[1]);
        
        $part = explode( "\r\n\r\n", $data, 2 );        ///    ʬ

        $part[0] = trim( $part[0] );
        $part[1] = mbereg_replace( '^This.*?MIME[^-]+?[-]+','', trim( $part[1] ), 'ip' );
        // $head = $this->splitheader( $list[0], 'attach' );
        
        return $part;
    }
    
    
    // ****************************************************
    // * ᡼륢ɥ쥹Ф

    // ****************************************************
    function addr_search($addr) {
        if (eregi("[-!#$%&\'*+\\./0-9A-Z^_`a-z{|}~]+@[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+", $addr, $fromreg)) {
            return $fromreg[0];
        } else {
            return false;
        }
    }
    
    /**
     * QUIT Ǥ

     */
    function Quit()
    {
        if($this->fp)
        {
            $this->sendRequest("QUIT");
            fclose($this->fp);
            return TRUE;
        }
        return FALSE;
    }

}
?>
