<?php
/**
 * @class  SendMail
 * @brief  ᡼饹
 * @author Daijiro Abe
 * @date   2005.07.20
 */

require_once(dirname(__FILE__) . "/PopClient.php");
require_once(dirname(__FILE__) . "/SmtpClient.php");
require_once(dirname(__FILE__) . "/../Utils/jcode.php");

class SendMail
{
    var $host;          // SMTP
    var $port;          // SMTPݡ
    
    var $isAuth=false;  // ǧڤ뤫ɤ
    var $popServer;     // POP
    var $popPort;       // POPݡ
    var $userid;        // POP桼ɣ
    var $passwd;        // POPѥ
    var $isApop;        // APOPǧڤɤ
    var $timeout;       // ॢȤ
    
    var $to = array();  // 

    var $from=array();  // ɮ
    var $sender=NULL;   // 
    var $return=NULL;   // Return-Path
    var $cc = array();  // Carbon Copy
    var $bcc = array(); // Blind Carbon Copy
    var $attached=array();  // źեե̾
    var $body=NULL;     // ʸƥ
    
    var $messageID;     // Message-ID
    var $replyHeader;   // replyإå
    var $subject;       // Subject
    var $importance;    // 
    
    var $error;         // 顼

    var $boundary;
    
    var $template;
    var $data;
    
    /**
     * SMTPФ֤ޤ
     * @return SMTP
     */
    function getHost()
    {
        return $this->host;
    }
    
    /**
     * SMTPФꤷޤ
     * @param host SMTP
     */
    function setHost($host)
    {
        $this->host = $host;
    }
    
    /**
     * SMTPݡȤ֤ޤ
     * @return SMTPݡ
     */
    function getPort()
    {
        return $this->port;
    }
    
    /**
     * SMTPݡȤꤷޤ
     * @param port SMTPݡ
     */
    function setPort($port)
    {
        $this->port = $port;
    }
    
    /**
     * ǧڤ뤫ɤ֤ޤ
     * @return ǧڤ trueǧڤʤ false
     */
    function isAuth()
    {
        return $this->isAuth;
    }
    
    /**
     * ǧڤ뤫ɤꤷޤ
     * @param isAuth ǧڤ trueǧڤʤ false
     */
    function setIsAuth($isAuth)
    {
        $this->isAuth = $isAuth;
    }
    
    /**
     * POPФ֤ޤ
     * @return POP
     */
    function getPopServer()
    {
        return $this->popServer;
    }
    
    /**
     * POPФꤷޤ
     * @param popServer POP
     */
    function setPopServer($popServer)
    {
        $this->popServer = $popServer;
    }
    
    /**
     * POPݡȤ֤ޤ
     * @return POPݡ
     */
    function getPopPort()
    {
        return $this->popPort;
    }
    
    /**
     * POPݡȤꤷޤ
     * @param popPort POPݡ
     */
    function setPopPort($popPort)
    {
        $this->popPort = $popPort;
    }
    
    /**
     * POP桼ɣĤ֤ޤ
     * @return POP桼ɣ
     */
    function getUserID()
    {
        return $this->userid;
    }
    
    /**
     * POP桼ɣĤꤷޤ
     * @param userid 桼ɣ
     */
    function setUserID($userid)
    {
        $this->userid = $userid;
    }
    
    /**
     * POPѥɤ֤ޤ
     * @return POPѥ
     */
    function getPassword()
    {
        return $this->password;
    }
    
    /**
     * POPѥɤꤷޤ
     * @param password ѥ
     */
    function setPassword($password)
    {
        $this->password = $password;
    }
    
    /**
     * APOPǧڤɤ֤ޤ
     * @return APOPǧڤɤ
     */
    function isApop()
    {
        return $this->isApop;
    }
    
    /**
     * APOPǧڤɤꤷޤ
     * @param isApop APOPǧڤʤ trueǤʤ false
     */
    function setIsApop($isApop)
    {
        $this->isApop = $isApop;
    }
    
    /**
     * 襢ɥ쥹֤ޤ
     * @return 襢ɥ쥹

     */
    function getTo()
    {
        return $this->to;
    }
    
    /**
     * 襢ɥ쥹ꤷޤ
     * @param to ɥ쥹

     */
    function setTo($to)
    {
        $this->to = $to;
    }
    
    /**
     * 襢ɥ쥹ɲäޤ
     * @param addr ɥ쥹
     * @param personal ̾
     */
    function addTo($addr, $personal=NULL)
    {
        $this->to[] = $this->makeMailboxArray($addr, $personal);
    }
    
    /**
     * Fromɥ쥹֤ޤ
     * @return Fromɥ쥹
     */
    function getFrom()
    {
        return $this->from;
    }
    
    /**
     * Fromɥ쥹ꤷޤ
     * @param from Fromɥ쥹
     */
    function setFrom($from)
    {
        $this->from = $from;
    }
    
    /**
     * Fromɥ쥹ɲäޤ
     * @param addr ɥ쥹
     * @param personal ̾
     */
    function addFrom($addr, $personal=NULL)
    {
        $this->from[] = $this->makeMailboxArray($addr, $personal);
    }
    
    /**
     * ԥɥ쥹֤ޤ
     * @return ԥɥ쥹
     */
    function getSender()
    {
        return $this->sender;
    }
    
    /**
     * ԥɥ쥹ꤷޤ
     * @param sender 
     * @param personal ̾
     */
    function setSender($sender, $personal=NULL)
    {
        $this->sender = $this->makeMailboxArray($sender, $personal);
    }
    
    /**
     * ƥץ졼ȥեꤷޤ
     * @param template ƥץ졼ȥե
     */
    function setTemplate($template)
    {
        $this->template = $template;
    }
    
    /**
     * ƥץ졼ȥե֤ޤ
     * @return ƥץ졼ȥե
     */
    function getTemplate()
    {
        return $this->template;
    }
    
    /**
     * ǡϥåȤꤷޤ
     * @param data ǡ
     */
    function setData($data)
    {
        $this->data = $data;
    }
    
    /**
     * ǡ֤ޤ
     * @param $key ϥå奭
     * @return ǡ
     */
    function getData($key = NULL)
    {
        if($key != NULL)
        {
            if(array_key_exists($key, $this->data))
                return $this->data[$key];
            else
                return NULL;
        }
        else
            return $this->data;
    }
    
    /**
     * Return-Path֤ޤ
     * @return Return-Path
     */
    function getReturnPath()
    {
        $returnPath = $this->return;
        $sender = $this->getSender();
        $from = $this->getFrom();
        
        if(strlen($returnPath) == 0)
        {
            if(!empty($sender))
                $returnPath = $sender['address'];
            else
            {
                if(count($from) > 0)
                    $returnPath = $from[0]['address'];
            }
        }
        return $returnPath;
    }
    
    /**
     * Return-Pathꤷޤ
     * @param return Return-Path
     */
    function setReturnPath($return)
    {
        $this->return = $return;
    }
    
    /**
     * CCɥ쥹֤ޤ
     * @return CCɥ쥹
     */
    function getCC()
    {
        return $this->cc;
    }
    
    /**
     * CCɥ쥹ꤷޤ
     * @param cc CCɥ쥹
     */
    function setCC($cc)
    {
        $this->cc = $cc;
    }
    
    /**
     * CC˥ɥ쥹ɲäޤ
     * @param addr ɥ쥹
     * @param personal ̾
     */
    function addCC($addr, $personal=NULL)
    {
        $this->cc[] = $this->makeMailboxArray($addr, $personal);
    }
    
    /**
     * BCCɥ쥹֤ޤ
     * @return BCCɥ쥹
     */
    function getBCC()
    {
        return $this->bcc;
    }
    
    /**
     * BCCɥ쥹ꤷޤ
     * @param bcc BCCɥ쥹
     */
    function setBCC($bcc)
    {
        $this->bcc = $bcc;
    }
    
    /**
     * BCC˥ɥ쥹ɲäޤ
     * @param addr ɥ쥹
     * @param personal ̾
     */
    function addBCC($addr, $personal=NULL)
    {
        $this->bcc[] = $this->makeMailboxArray($addr, $personal);
    }
    
    /**
     * źեե֤̾ޤ
     * @return źեե̾

     */
    function getAttached()
    {
        return $this->attached;
    }
    
    /**
     * źեե̾ꤷޤ
     * @param attached źեե̾

     */
    function setAttached($attached)
    {
        $this->attached = $attached;
    }
    
    /**
     * źեե̾ɲäޤ
     * @param filename ե̾
     * @param dispname ɽե̾
     */
    function addAttached($filename, $dispname=NULL)
    {
        $file = array('filename' => $filename);
        if(empty($dispname))
            $file['dispname'] = basename($filename);
        else
            $file['dispname'] = $dispname;
        $this->attached[] = $file;
    }
    
    /**
     * Message-ID֤ޤ
     * @return Message-ID
     */
    function getMessageID()
    {
        return $this->messageID;
    }
    
    /**
     * Message-IDꤷޤ
     * @param messageID Message-ID
     */
    function setMessageID($messageID)
    {
        $this->messageID = $messageID;
    }
    
    /**
     * replyΥإå֤ޤ
     * @return replyإå
     */
    function getReplyHeader()
    {
        return $this->replyHeader;
    }
    
    /**
     * replyΥإåꤷޤ
     * @param replyHeader replyΥإå
     */
    function setReplyHeader($replyHeader)
    {
        $this->replyHeader = $replyHeader;
    }
    
    /**
     * Subject֤ޤ
     * @return subject
     */
    function getSubject()
    {
        return $this->subject;
    }
    
    /**
     * Subjectꤷޤ
     * @param subject Subject
     */
    function setSubject($subject)
    {
        $this->subject = $subject;
    }
    
    /**
     * ٤֤ޤ
     * @return 
     */
    function getImportance()
    {
        return $this->importance;
    }
    
    /**
     * ٤ꤷޤ
     * @param importance 
     */
    function setImportance($importance)
    {
        $this->importance = $importance;
    }
    
    /**
     * ॢȤ֤ͤޤ
     * @return ॢȤ
     */
    function getTimeout()
    {
        return $this->timeout;
    }
    
    /**
     * ॢȤͤꤷޤ
     * @param timeout ॢȤ
     */
    function setTimeout($timeout)
    {
        $this->timeout = $timeout;
    }
    
    /**
     * ʸ֤ޤ
     * @return ʸ
     */
    function getBody()
    {
        if(strlen($this->body) == 0)
        {
            $data = $this->getData();
            $template = $this->getTemplate();
            if(is_array($data) && strlen($template))
            {
                while(preg_match('/%%([^%]+)%%/', $template, $matches))
                {
                    $str = $data[$matches[1]];
                    $template = str_replace($matches[0], $str, $template);
                }
                $template = str_replace("\x0d\x0a", "\x0d", $template);
                $template = str_replace("\x0a", "\x0d", $template);
                $template = str_replace("\x0d", "\x0d\x0a", $template);
                return $template;
            }
        }
        return $this->body;
    }
    
    /**
     * ʸꤷޤ
     * @param body ʸ
     */
    function setBody($body)
    {
        $this->body = $body;
    }
    
    /**
     * إåޤ
     * @return إåʬʸ

     */
    function makeHeader()
    {
        $sender = $this->getSender();
        $from = $this->getFrom();

        $header = "Date: " . date('r', time()) . "\r\n";
        
        $max_from_index = count($from) - 1;
        $header .= "From: ";
        foreach($from as $index => $addr)
        {
            if($index > 0)
                $header .= " ";
            $header .= $this->makeMailbox($addr);
            if($max_from_index < $index)
                $header .= ",";
            $header .= "\r\n";
        }
        
        if(!empty($sender))
            $header .= "Sender: " . $this->makeMailbox($sender) . "\r\n";

        $to = $this->getTo();
        $cc = $this->getCC();
        $bcc = $this->getBCC();

        if(count($to) > 0)
        {
            $max_to_index = count($to) - 1;
            $header .= "To: ";
            foreach($to as $index => $addr)
            {
                if($index > 0)
                    $header .= " ";
                $header .= $this->makeMailbox($addr);
                if($max_to_index < $index)
                    $header .= ",";
                $header .= "\r\n";
            }
        }

        if(count($cc) > 0)
        {
            $max_cc_index = count($cc) - 1;
            $header .= "Cc: ";
            foreach($cc as $index => $addr)
            {
                if($index > 0)
                    $header .= " ";
                $header .= $this->makeMailbox($addr);
                if($max_cc_index < $index)
                    $header .= ",";
                $header .= "\r\n";
            }
        }
        
        if(strlen($this->getMessageID()))
        {
            $header .= "Message-ID: <" . $this->getMessageID() . ">\r\n";
            
            $replyHeader = $this->getReplyHeader();
            if(!empty($replyHeader))
            {
                // unfolding
                $replyHeader = str_replace("\r\n ", " ", $replyHeader);
                $headers = explode("\r\n", $replyHeader);
                
                $replyMessageID = "";
                $replyInReplyTo = "";
                $replyReferences = "";
                foreach($headers as $line)
                {
                    if(!empty($line))
                    {
                        list($head, $body) = explode(":", $line);
                        if(strtolower($head) == "message-id")
                        {
                            $body = trim($body);
                            $replyMessageID = $body;
                        }
                        else if(strtolower($head) == "in-reply-to")
                        {
                            $body = trim($body);
                            $replyInReplyTo = $body;
                        }
                        else if(strtolower($head) == "references")
                        {
                            $body = trim($body);
                            $replyReferences = $body;
                        }
                    }
                }
                
                if(!empty($replyMessageID))
                    $header .= "In-Reply-To: " . $replyMessageID;
                
                if(!empty($replyReferences))
                    $references = $replyReferences;
                else if(!empty($replyInReplyTo))
                    $references = $replyInReplyTo;
                if(!empty($replyMessageID))
                    $references .= $replyMessageID;
                
                if(!empty($references))
                {
                    $references = str_replace("><", ">\r\n <", $references);
                    $header .= "References: " . $references;
                }
            }
        }
        
        $subject = $this->getSubject();
        if(!empty($subject))
            $header .= "Subject: " . $this->mimeConvert($subject) . "\r\n";

        $importance = $this->getImportance();
        if(!empty($importance))
        {
            switch($importance)
            {
                case 1:
                    $header .= "X-Priority: 1\r\n";
                    $header .= "X-MSMail-Priority: High\r\n";
                    break;
                case 2:
                    $header .= "X-Priority: 3\r\n";
                    $header .= "X-MSMail-Priority: Normal\r\n";
                    break;
                case 3:
                    $header .= "X-Priority: 5\r\n";
                    $header .= "X-MSMail-Priority: Low\r\n";
                    break;
            }
        }
        
        $header .= "MIME-Version: 1.0\r\n";
        
        $attached = $this->getAttached();
        if(count($attached) > 0)
        {
            $header .= "Content-Type: multipart/mixed; boundary=\"";
            $header .= $this->getBoundary() . "\"\r\n";
        }
        else
            $header .= "Content-Type: text/plain; charset=\"ISO-2022-JP\"\r\n";

        $header .= "Content-Transfer-Encoding: 7bit\r\n";
        
        return $header;
    }
    
    /**
     * multipart/mixed ξboundary֤ޤ
     * @return boundary
     */
    function getBoundary()
    {
        $boundary = $this->boundary;
        if(!empty($boundary))
            return $boundary;
        
        $this->boundary = "-----_" . md5(uniqid(time())) . "_";
        return $this->boundary;
    }
    
    /**
     * ܥǥޤ
     * @return ܥǥʸ

     */
    function makeBody()
    {
        $attached = $this->getAttached();
        if(count($attached) > 0)
        {
            $body  = "--" . $this->getBoundary() . "\r\n";
            $body .= "Content-Type: text/plain; charset=\"ISO-2022-JP\"\r\n";
            $body .= "Content-Transfer-Encoding: 7bit\r\n";
            $body .= "\r\n";
            $body .= JcodeConvert($this->getBody(), 0, 3);
            
            foreach($attached as $file)
            {
                if(file_exists($file['filename']))
                {
                    $body .= "\r\n--" . $this->getBoundary() . "\r\n";
                    $mime = "application/octet-stream";
                    $body .= "Content-Type: " . $mime . "\r\n ";
                    $body .= "name=\"" . $this->mimeConvert($file['dispname']) . "\"\r\n";
                    $body .= "Content-Disposition: attachment;\r\n ";
                    $body .= "filename=\"" . $this->mimeConvert($file['dispname']) . "\"\r\n";
                    $body .= "Content-Transfer-Encoding: base64\r\n";
                    $body .= "\r\n";
                    
                    $fp = fopen($file['filename'], "r");
                    $content = fread($fp, filesize($file['filename']));
                    fclose($fp);
                    $body .= chunk_split(base64_encode($content));
                }
            }
            $body .= "--" . $this->getBoundary() . "--\r\n";
        }
        else
            $body = JcodeConvert($this->getBody(), 0, 3);

        return $body;
    }
    
    /**
     * ᡼ޤ
     * @return  trueԤ false
     */
    function send()
    {
        $this->error = array();
        
        // host ȥ顼
        if(strlen($this->getHost()) == 0)
        {
            $error['code'] = -1;
            $error['message'] = "SMTPФꤵƤޤ";
            $this->error[] = $error;
        }
        
        // port ȥ顼
        if(strlen($this->getPort()) == 0)
        {
            $error['code'] = -1;
            $error['message'] = "SMTPݡȤꤵƤޤ";
            $this->error[] = $error;
        }
        
        // ǧڤ popServer ȥ顼
        if($this->isAuth())
        {
            if(strlen($this->getPopServer()) == 0)
            {
                $error['code'] = -1;
                $error['message'] = "POPФꤵƤޤ";
                $this->error[] = $error;
            }

            //                popPort   ȥ顼
            if(strlen($this->getPopPort()) == 0)
            {
                $error['code'] = -1;
                $error['message'] = "POPݡȤꤵƤޤ";
                $this->error[] = $error;
            }
            //                userid    ȥ顼
            if(strlen($this->getUserID()) == 0)
            {
                $error['code'] = -1;
                $error['message'] = "POPIDꤵƤޤ";
                $this->error[] = $error;
            }
            //                password  ȥ顼
            if(strlen($this->getPassword()) == 0)
            {
                $error['code'] = -1;
                $error['message'] = "POPѥɤꤵƤޤ";
                $this->error[] = $error;
            }
        }
        
        $to = $this->getTo();
        $cc = $this->getCC();
        $bcc = $this->getBCC();
        
        // To,Cc,BccΤɤ줬ҤȤĤǤʤȥ顼
        if(count($to) + count($cc) + count($bcc) == 0)
        {
            $error['code'] = -1;
            $error['message'] = "襢ɥ쥹ꤵƤޤ";
            $this->error[] = $error;
        }
        
        $from = $this->getFrom();
        
        // Fromȥ顼
        if(count($from) == 0)
        {
            $error['code'] = -1;
            $error['message'] = "ɥ쥹ꤵƤޤ";
            $this->error[] = $error;
        }
        
        if(count($this->error))
            return false;
        
        $header = $this->makeHeader();
        $body = $this->makeBody();
        
        if($this->isAuth())
        {
            // POP before SMTP
            $pop = new PopClient();
            $pop->setServer($this->getPopServer());
            $pop->setPort($this->getPopPort());
            $pop->setId($this->getUserID());
            $pop->setPassword($this->getPassword());
            $pop->setIsApop($this->isApop());
            $pop->setTimeout($this->getTimeout());
            $result = $pop->connect();
            $pop->Quit();
            if($result !== true)
            {
                $error['code'] = $result;
                switch($result)
                {
                    case POPERR_SERVERUNDEF:
                        $error['message'] = "POPФꤵƤޤ";
                        break;
                    case POPERR_PORTUNDEF:
                        $error['message'] = "POPݡȤꤵƤޤ";
                        break;
                    case POPERR_CANNOTCONNECT:
                        $error['message'] = "POPФؤ³˼Ԥޤ";
                        break;
                    case POPERR_TIMEDOUT:
                        $error['message'] = "POPФؤ³˥ॢȤޤ";
                        break;
                    case POPERR_APOPNOTSUPPORTED:
                        $error['message'] = "POPФAPOP򥵥ݡȤƤޤ";
                        break;
                    case POPERR_LOGGEDIN:
                        $error['message'] = "POPФؤΥ˼Ԥޤ";
                        break;
                    default:
                        $error['message'] = "POPХͽʤ顼ȯޤ";
                        break;
                }
                $this->error[] = $error;
                return false;
            }
        }
        
        $smtp = new SmtpClient();
        $smtp->setHost($this->getHost());
        $smtp->setPort($this->getPort());
        $smtp->setHeader($header);
        $smtp->setBody($body);
        
        $addresses = array_merge($to, $cc, $bcc);
        $recipients = array();
        foreach($addresses as $addr)
        {
            $recipients[] = $addr['address'];
        }
        $smtp->setRecipients($recipients);
        $smtp->setReversePath($this->getReturnPath());
        if(!$smtp->send())
        {
            $this->error = $smtp->getErrors();
            return false;
        }
        return true;
    }
    
    /**
     * mailboxΥɥ쥹Ĥ

     * @param address
     * @return mailbox
     */
    function makeMailbox($address)
    {
        if(is_array($address))
        {
            if(array_key_exists('personal', $address) && strlen($address['personal']))
                $mailbox = '"' . $address['personal'] . '" <' . $address['address'] . '>';
            else
                $mailbox = $address['address'];
        }
        else
            $mailbox = $address;
        return $mailbox;
    }
    
    /**
     * ɥ쥹ϢĤ

     * @param address
     * @param personal
     * @return Ϣ

     */
    function makeMailboxArray($address, $personal=NULL)
    {
        if(is_array($address))
            return $address;
        else
        {
            $assoc['address'] = $address;
            if(strlen($personal) > 0)
                $assoc['personal'] = $this->mimeConvert($personal);
            return $assoc;
        }
    }
    
    /**
     * B 󥳡ǥ󥰤Ԥ
     * @param str ʸ

     * @return 󥳡ɸʸ

     */
    function mimeConvert($str)
    {
        $str = JcodeConvert($str, 0, 3);
        return '=?ISO-2022-JP?B?' . base64_encode(JcodeConvert($str, 0, 3)) . '?=';
    }
    
    /**
     * 顼

     * @return 顼

     */
    function getErrors()
    {
        return $this->error;
    }
}

?>
