<?php
/**
 * @class  SmtpClient
 * @brief  SMTP³ȥ᡼Ԥ饹
 * @author Daijiro Abe
 * @date   2005.07.19
 */
require_once(dirname(__FILE__) . "/../Utils/jcode.php");

define('SMTP_CONNECT_TIMEOUT', 30);
define('SMTP_SOCKET_TIMEOUT', 30);

class SmtpClient
{
    // о

    var $host;
    var $port;

    // debug
    var $isDebug = false;
    
    // used in envelope
    var $reverse_path = "";
    var $recipients   = array();

    // used in data
    var $header = "";
    var $body   = "";

    // error array
    var $error  = array();
    
    var $fp = NULL; // socketΥݥ
    
    /**
     * smtpФ֤ޤ
     * @return smtp
     */
    function getHost()
    {
        return $this->host;
    }
    
    /**
     * smtpФꤷޤ
     * @param host smtp
     */
    function setHost($host)
    {
        $this->host = $host;
    }
    
    /**
     * smtpݡȤ֤ޤ
     * @return smtpݡ
     */
    function getPort()
    {
        return $this->port;
    }
    
    /**
     * smtpݡȤꤷޤ
     * @param port smtpݡ
     */
    function setPort($port)
    {
        $this->port = $port;
    }
    
    /**
     * 顼᡼ꤷޤ
     * @param reverse_path 顼᡼

     */
    function setReversePath($reverse_path)
    {
        $this->reverse_path = $reverse_path;
    }
    
    /**
     * 顼᡼֤ޤ
     * @return 顼᡼

     */
    function getReversePath()
    {
        return $this->reverse_path;
    }

    /**
     * ᡼ꤷޤ
     * @param recipients ᡼

     */
    function setRecipients($recipients)
    {
        $this->recipients = $recipients;
    }
    
    /**
     * ᡼֤ޤ
     * @return ᡼

     */
    function getRecipients()
    {
        return $this->recipients;
    }
    
    /**
     * ᡼ɲäޤ
     * @param recipient ᡼

     */
    function addRecipient($recipient)
    {
        $this->recipients[] = $recipient;
    }
    
    /**
     * إåꤷޤ
     * @param header إå
     */
    function setHeader($header)
    {
        $this->header = $header;
    }
    
    /**
     * إå֤ޤ
     * @return إå
     */
    function getHeader()
    {
        return $this->header;
    }
    
    /**
     * ܥǥꤷޤ
     * @param body ܥǥ
     */
    function setBody($body)
    {
        $this->body = $body;
    }
    
    /**
     * ܥǥ֤ޤ
     * @return ܥǥ
     */
    function getBody()
    {
        return $this->body;
    }
    
    /**
     * ᡼ޤ
     * @return  trueԻ false ֤ޤ
     */
    function send()
    {
        // ³
        if(!$this->connect())
            return false;

        // hello
        if(!$this->cmdHello())
            return false;

        // mail
        if(!$this->cmdMail())
            return false;

        // rcpt
        if(!$this->cmdRcpt())
            return false;

        // data
        if(!$this->cmdData())
            return false;

        // ǡ
        if(!$this->sendData())
            return false;
        
        // quit
        if(!$this->cmdQuit())
            return false;
        
        if(!$this->close())
            return false;

        // 

        return true;
    }
    
    /**
     * ³ǧ
     * @return ³Ƥ trueƤʤ false ֤ޤ
     */
    function isConnected()
    {
        if(!empty($this->fp))
        {
            $status = socket_get_status($this->fp);
            if($status["eof"])
            {
                $this->close();
                return false;
            }
            return true;
        }
        return false;
    }
    
    /**
     * ³Ĥޤ
     * @return  trueԤ false
     */
    function close()
    {
        $this->error = array();
        if(!empty($this->fp))
        {
            $res = fclose($this->fp);
            $this->fp = NULL;
            return $res;
        }
        return false;
    }
    
    /**
     * ³ޤ
     * @return  trueԤ false
     */
    function connect()
    {
        $host = $this->getHost();
        $port = $this->getPort();
        
        if($this->isConnected())
        {
            $error['errno'] = -1;   // ̤
            $error['message'] = "³Ƥޤ";
            $this->error[] = $error;
            return false;
        }
        
        $this->fp = fsockopen($host, $port, $errno, $errstr, SMTP_CONNECT_TIMEOUT);
        if(empty($this->fp))
        {
            $error['code'] = $errno;
            $error['message'] = $errstr;
            $this->error[] = $error;
            return false;
        }
        
        // WindowsǤʤХॢȻ֤ꤷƤ
        if(substr(PHP_OS, 0, 3) != "WIN")
            socket_set_timeout($this->fp, SMTP_SOCKET_TIMEOUT, 0);
        
        // 쥹ݥ󥹼
        $res = $this->getResponse();
        if($res != '220')
            return false;
        return true;
    }
    
    /**
     * ޥɤޤ
     * @param cmd ޥʸ

     * @param param ѥ᡼ʸ

     * @return  trueԤ false ֤ޤ
     */
    function sendCommand($cmd, $param="")
    {
        $command = $cmd;
        if(strlen($param))
            $cmd .= ' ' . $param;
        $cmd .= "\r\n";
        
        if($this->isDebug)
            print $cmd;
        
        if(fputs($this->fp, $cmd) === false)
            return false;
        else
            return true;
    }
    
    /**
     * 쥹ݥ󥹤֤ޤ
     * @param isCodeOnly ɤΤ֤åޤ᤿֤
     * @return 쥹ݥʸ

     */
    function getResponse($isCodeOnly=true)
    {
        while($str = fgets($this->fp, 512))
        {
            if(substr($str, 3, 1) == " ")
                break;
        }
        
        if($this->isDebug)
            print $str;

        $data[0] = substr($str, 0, 3);
        $data[1] = substr($str, 4);
        if($isCodeOnly)
            return $data[0];
        else
            return $data;
    }
    
    /**
     * EHLOޤHELOޥɤޤ
     * @return  trueԤ false
     */
    function cmdHello()
    {
        $domain = '[' . $_SERVER['SERVER_ADDR'] . ']';
        if(!$this->sendCommand('EHLO', $domain))
        {
            $error['code'] = -1;
            $error['message'] = "EHLOޥɤ˼Ԥޤ";
            $this->error[] = $error;
            return false;
        }
        $res = $this->getResponse();
        if(substr($res,0,1) == '5')
        {
            if(!$this->sendCommand('HELO', $domain))
            {
                $error['code'] = -1;
                $error['message'] = "HELOޥɤ˼Ԥޤ";
                $this->error[] = $error;
                return false;
            }
            $data = $this->getResponse(false);
            if(substr($data[0],0,1) == '5')
            {
                $error['code'] = $data[0];
                $error['message'] = $data[1];
                $this->error[] = $error;
                return false;
            }
        }
        return true;
    }
    
    /**
     * MAILޥɤޤ
     * @return  trueԤ false
     */
    function cmdMail()
    {
        if(!$this->sendCommand('MAIL FROM:', $this->getReversePath()))
        {
            $error['code'] = -1;
            $error['message'] = "MAILޥɤ˼Ԥޤ";
            $this->error[] = $error;
            return false;
        }
        $data = $this->getResponse(false);
        if($data[0] != '250')
        {
            $error['code'] = $data[0];
            $error['message'] = $data[1];
            $this->error[] = $error;
            return false;
        }
        return true;
    }
    
    /**
     * RCPTޥɤޤ
     * @return  trueԤ false
     */
    function cmdRcpt()
    {
        $recipients = $this->getRecipients();
        foreach($recipients as $addr)
        {
            if(!$this->sendCommand('RCPT TO:', $addr))
            {
                $error['code'] = -1;
                $error['message'] = "RCPTޥɤ˼Ԥޤ";
                $this->error[] = $error;
                return false;
            }
            $data = $this->getResponse(false);
            if(substr($data[0], 0, 2) != "25")
            {
                $error['code'] = $data[0];
                $error['message'] = $data[1];
                $this->error[] = $error;
                return false;
            }
        }
        return true;
    }
    
    /**
     * DATAޥɤޤ
     * @return  trueԤ false ֤ޤ
     */
    function cmdData()
    {
        if(!$this->sendCommand('DATA'))
        {
            $error['code'] = -1;
            $error['message'] = "DATAޥɤ˼Ԥޤ";
            $this->error[] = $error;
            return false;
        }
        $data = $this->getResponse(false);
        if($data[0] != '354')
        {
            $error['code'] = $data[0];
            $error['message'] = $data[1];
            $this->error[] = $error;
            return false;
        }
        return true;
    }
    
    /**
     * ǡޤ
     * @return  trueԤ false ֤ޤ
     */
    function sendData()
    {
        $header = $this->getHeader();
        $body   = $this->getBody();
        
        // إå
        if(fputs($this->fp, $header) !== false)
        {
            if($this->isDebug)
                print $header;
            
            // Ԥ
            if(fputs($this->fp, "\r\n\r\n") !== false)
            {
                if($this->isDebug)
                    print "\r\n\r\n";
                
                // ʸ
                if(fputs($this->fp, $body) !== false)
                {
                    if($this->isDebug)
                        print $body;
                    
                    // ǡü
                    if(fputs($this->fp, "\r\n.\r\n") !== false)
                    {
                        if($this->isDebug)
                            print "\r\n.\r\n";

                        $data = $this->getResponse(false);
                        if($data[0] != "250")
                        {
                            $error['code'] = $data[0];
                            $error['message'] = $data[1];
                            $this->error[] = $error;
                            return false;
                        }
                        return true;
                    }
                }
            }
        }
        $error['code'] = -1;
        $error['message'] = "ǡ˼Ԥޤ";
        $this->error[] = $error;
        return false;
    }
    
    /**
     * QUITޥɤޤ
     * @return  trueԤ false
     */
    function cmdQuit()
    {
        if(!$this->sendCommand('QUIT'))
        {
            $error['code'] = -1;
            $error['message'] = "QUITޥɤ˼Ԥޤ";
            $this->error[] = $error;
            return false;
        }
        $data = $this->getResponse(false);
        if($data[0] != '221')
        {
            $error['code'] = $data[0];
            $error['message'] = $data[1];
            $this->error[] = $error;
            return false;
        }
        return true;
    }
    
    /**
     * 顼ޤ
     * @return 顼

     */
    function getErrors()
    {
        return $this->error;
    }
}

?>
