<?php
/**
 * @file   preg_match.php
 * @brief  С preg_match
 * @author Daijiro Abe
 * @date   2006.01.11
 */

require_once(dirname(__FILE__) . '/check_version.php');

/**
 * PerlߴɽԤ (PHP 4.3ߴ)
 * @param $regex    ɽ
 * @param $str      оݥƥ
 * @param $matches  ޥåƥ
 * @param $mode     trueʤ顢ޥåΥǥå
 * @return ޥå trueʤ false
 */

function preg_match_4_3($regex, $str, &$matches, $mode=false)
{
    if(check_version(PHP_VERSION, '4.3.0'))
    {
        if($mode)
            $result = preg_match($regex, $str, $matches, PREG_OFFSET_CAPTURE);
        else
            $result = preg_match($regex, $str, $matches);
    }
    else
    {
        $result = preg_match($regex, $str, $matches);
        if($mode && $result)
        {
            if(is_array($matches))
            {
                foreach($matches as $index => $match)
                {
                    $matches[$index] = array();
                    $matches[$index][0] = $match;
                    if($match)
                        $matches[$index][1] = strpos($str, $match);
                }
            }
        }
    }
    return $result;
}


?>
