<?php
/**
 * @class  Shape
 * @brief  ƥץ졼ȥ饹
 * @author Daijiro Abe
 * @date   2005.12.09
 */

require_once(dirname(__FILE__) . '/../Utils/preg_match.php');
require_once(dirname(__FILE__) . '/../Utils/check_version.php');

if(!check_version(PHP_VERSION, '4.3.0'))
    require_once(dirname(__FILE__) . '/../Utils/file_get_contents.php');

class Shape
{
    var $filename;
    var $config;
    var $request;
    var $response;
    var $formName;

    var $attributes = array();
    
    /**
     * 󥹥ȥ饯
     * @param $filename ե̾
     * @param $request HttpRequest֥
     * @param $response HttpResponse֥
     */
    function Shape($filename, &$config, &$request, &$response)
    {
        $this->config = $config;
        $this->setFilename($filename);
        $this->request = $request;
        $this->response = $response;
    }
    
    /**
     * ե̾ꤹ
     * @param $filename ե̾
     */
    function setFilename($filename)
    {
        $this->filename = $filename;
    }
    
    /**
     * ե֤̾ޤ
     * @return ե̾
     */
    function getFilename()
    {
        if(substr($this->filename, 0, 1) != "/")
            return realpath(ROOT_DIR . "/webapp/templates/" . $this->filename);
        return $this->filename;
    }
    
    /**
     * åե֤̾ޤ
     * @return åե̾
     */
    function getCacheFilename()
    {
        $cachefile = ROOT_DIR . '/cache/';
        if(dirname($this->filename) != '/')
            $cachefile .= dirname($this->filename);
        if(!file_exists($cachefile))
            mkdir($cachefile, 0777);
        if(!preg_match('/\/$/', $cachefile))
            $cachefile .= '/';
        $cachefile .= basename($this->filename) . ".php";
        return $cachefile;
    }
    
    /**
     * ɽ
     */
    function show(&$name)
    {
        $this->formName = $name;
        $data = "";
        
        if(!file_exists($this->getFilename()))
            die("ե롧" . $this->getFilename() . " ϸĤޤǤ");
        
        $request = $this->request;
        $response = $this->response;
        $config = $this->config;

        // TODO: ʬåե뤬ɤ߹ɲ
        $isInclude = false;
        $cachefile = $this->getCacheFilename();
        if(file_exists($cachefile))
        {
            if(filemtime($cachefile) > filemtime($this->getFilename()))
            {
                include_once($cachefile);
                $isInclude = true;
            }
        }
        
        if(!$isInclude)
        {

            $fp = fopen($this->getFilename(), 'r');
            if(!$fp)
                die('<b>Error:</b> ' . $this->getFilename() . ' cannot be opened (may be not found).');
            
            $reqEncoding = $this->request->getCharacterEncoding();
            $resEncoding = $this->response->getCharacterEncoding();

            while($str = fgets($fp, 4096))
            {
                if($reqEncoding && ($reqEncoding != 'EUC-JP'))
                    $str = mb_convert_encoding($str, "EUC-JP", $reqEncoding);
                else if(!$reqEncoding)
                    $str = mb_convert_encoding($str, "EUC-JP", "EUC-JP, Shift_JIS");
                
                $data .= $str;

                if(feof($fp))
                    break;
            }
            fclose($fp);
            
            $data = $this->translateInclude($data);
            $str = $this->parse($data);
            
            if($resEncoding && ($resEncoding != 'EUC-JP'))
                $str = mb_convert_encoding($str, $resEncoding, "EUC-JP");
            else if(!$resEncoding && $reqEncoding)
                $str = mb_convert_encoding($str, $reqEncoding, "EUC-JP");
            
            $cookies = $this->response->cookies;
            foreach($cookies as $cookie)
            {
                setcookie($cookie->getName(), $cookie->getValue(), time() + $cookie->getMaxAge(), $cookie->getPath(), $cookie->getDomain(), $cookie->getSecure());
            }
            
            $headers = $this->response->headers;
            foreach($headers as $header)
            {
                header($header);
            }
            
            // 񤭽Ф
            $fp = fopen($cachefile, "w");
            fputs($fp, $str);
            fclose($fp);
            
            include_once($cachefile);
        }
    }

    /**
     * html:include ʬΤִԤ
     * @param $str оʸ
     * @return Ѵʸ
     */
    function translateInclude($str)
    {
        while(preg_match_4_3('/<html:include((\s*[^"\/>]*(=\"[^\"]*\")?\s*)*)\/\s*>/', $str, $matches, true))
        {
            $before = substr($str, 0, $matches[0][1]);
            $attribute = $this->_trim($matches[1][0]);
            $buffer = substr($str, $matches[0][1] + strlen($matches[0][0]));

            $attributes = $this->_getAttributes($attribute);
            $str = $before . $this->process("html", "include", $attributes, "", NULL) . $buffer;
        }
        return $str;
    }

    /**
     * ѡԤ
     * @param $str   оʸ
     * @param $extra ɲåѥ᡼
     * @return Ѵʸ
     */
    function parse($str, $extra=NULL)
    {
        while(preg_match_4_3('/<([^"\/:>]+):([^\s>]+)((\s*[^"\/>]*(=\"[^\"]*\")?\s*)*)(\/?)\s*>/', $str, $matches, true))
        {
            $nestCount = 0;
            $sentence = "";
            
            $prefix = $matches[1][0];
            $tagname = $matches[2][0];
            
            $before = substr($str, 0, $matches[0][1]);
            $attribute = $this->_trim($matches[3][0]);
            $buffer = substr($str, $matches[0][1] + strlen($matches[0][0]));
            
            // ñ쥿ʤ˰ܤ
            if($matches[6][0] == '/')
            {
                $attributes = $this->_getAttributes($attribute);
                $str = $before . $this->process($prefix, $tagname, $attributes, $sentence, $extra) . $buffer;
            }
            else
            {
                while(preg_match_4_3('/<(\/\s*|\s*)' . $prefix . ':' . $tagname . '([^>]*)>/', $buffer, $matches, true))
                {
                    $type = $matches[1][0];
                    $bef = substr($buffer, 0, $matches[0][1]);
                    $temp = substr($buffer, 0, $matches[0][1] + strlen($matches[0][0]));
                    $buffer = substr($buffer, $matches[0][1] + strlen($matches[0][0]));
                    $type = preg_replace('/\s/', '', $type);
                    
                    if($type != '/')
                    {
                        $sentence .= $temp;
                        $nestCount++;
                        continue;
                    }
                    else
                    {
                        if($nestCount > 0)
                        {
                            $sentence .= $temp;
                            $nestCount--;
                            continue;
                        }
                        else
                        {
                            $nestCount--;
                            $sentence .= $bef;

                            $attributes = $this->_getAttributes($attribute);

                            $str = $before . $this->process($prefix, $tagname, $attributes, $sentence, $extra) . $buffer;
                            break;
                        }
                    }
                }
                if($nestCount != -1)
                    die($prefix . ':' . $tagname . ' ΥбȤƤޤ.');
            }
        }
        return $str;
    }

    /**
     * νԤ
     * @param $prefix     Υץեå
     * @param $tagname    ̾
     * @param $attributes °
     * @param $sentence   ֤ˤƥ
     * @param $extra      ɲåѥ᡼
     * @return Ѵƥ
     */
    function process($prefix, $tagname, $attributes, $sentence, $extra)
    {
        switch($prefix)
        {
            case 'logic':
                $str = $this->processLogic($tagname, $attributes, $sentence);
                break;
            case 'html':
                $str = $this->processHtml($tagname, $attributes, $sentence, $extra);
                break;
            case 'bean':
                $str = $this->processBean($tagname, $attributes, $sentence);
                break;
        }
        return $str;
    }
    
    /**
     * value֤ޤ
     * @param $attributes °
     */
    function getValue($name, $property, $scope, $value)
    {
        if(strlen($value) == 0)
        {
            if(!$name)
                $name = $this->formName;
            
            $value = $this->getBean($name, $property, $scope);
        }
        else
        {
            $reqEncoding = $this->request->getCharacterEncoding();
            $resEncoding = $this->response->getCharacterEncoding();
            if($reqEncoding && ($reqEncoding != 'EUC-JP'))
                $value = mb_convert_encoding($value, "EUC-JP", $reqEncoding);
            else if(!$reqEncoding)
                $value = mb_convert_encoding($value, "EUC-JP", "EUC-JP, Shift_JIS");
        }
        return $value;
    }
    
    /**
     * °֤ͤ
     * @param $attributes °
     * @param $name ̾
     */
    function getAttrib($attributes,$name)
    {
        if(array_key_exists($name, $attributes))
            return $attributes[$name];
        return NULL;
    }
    
    /**
     * LogicνԤޤ
     * @param $tagname    ̾
     * @param $attributes °Ϣ
     * @param $sentence   Υƥ
     * @return Υƥ
     */
    function processLogic($tagname, $attributes, $sentence)
    {
        $str = "";
        $name = $this->getAttrib($attributes,'name');
        $property = $this->getAttrib($attributes, 'property');
        $scope = $this->getAttrib($attributes, 'scope');
        $value = $this->getAttrib($attributes, 'value');
        switch($tagname)
        {
            case 'notEmpty':
                $str  = "<?php if(!\$this->isEmpty(\$this->getValue(";
                $str .= "'$name','$property','$scope','$value'))) { ?>";
                $str .= $this->parse($sentence);
                $str .= "<?php } ?>";
                break;
            case 'empty':
                $str  = "<?php if(\$this->isEmpty(\$this->getValue(";
                $str .= "'$name','$property','$scope','$value'))) { ?>";
                $str .= $this->parse($sentence);
                $str .= "<?php } ?>";
                break;
            case 'iterate':
                $id = $this->getAttrib($attributes, 'id');
                $str  = "<?php \$collection = \$this->getValue('$name','$property','$scope','$value'); if(is_array(\$collection)) { foreach(\$collection as \$item) { \$this->setAttribute('$id', \$item); ?>";
                $str .= $this->parse($sentence);
                $str .= "<?php } } ?>";
                break;
        }
        return $str;
    }

    /**
     * BeanνԤޤ
     * @param $tagname     ̾
     * @param $attributes  °
     * @param $sentence    Υƥ
     * return Υƥ
     */
    function processBean($tagname, $attributes, $sentence)
    {
        $str = "";
        $name = $this->getAttrib($attributes,'name');
        $property = $this->getAttrib($attributes, 'property');
        $scope = $this->getAttrib($attributes, 'scope');
        $value = $this->getAttrib($attributes, 'value');
        switch($tagname)
        {
            case 'write':
                if(array_key_exists('filter', $attributes))
                {
                    if($attributes["filter"] == 'false')
                        $str = "<?php \$buffer = \$this->getValue('$name','$property','$scope','$value'); ?>";
                    else
                        $str = "<?php \$buffer = nl2br(htmlspecialchars(\$this->getValue('$name','$property','$scope','$value'))); ?>";
                }
                else if(!is_array($value))
                    $str = "<?php \$buffer = nl2br(htmlspecialchars(\$this->getValue('$name','$property','$scope','$value'))); ?>";

                $str .= "<?php \$this->print_enc(\$buffer); ?>";
                break;
        }
        return $str;
    }

    /**
     * GETκ
     * @param $value 
     * @param $name ͤǤʤΥ̾
     * @return ʸ
     */
    function makeQuery($value, $name)
    {
        $query = "";
        if(is_array($value))
        {
            $queries = array();
            foreach($value as $key => $val)
            {
                $queries[] = $key . "=" . rawurlencode($val);
            }
            $query = join('&', $queries);
        }
        else if(strlen($name))
        {
            $query  = $name . "=";
            $query .= rawurlencode($value);
        }
        return $query;
    }

    /**
     * Html
     * @param $tagname    ̾
     * @param $attributes °Ϣ
     * @param $sentence   Υƥ
     * @param $extra      ɲåѥ᡼
     * @return Υƥ
     */
    function processHtml($tagname, $attributes, $sentence, $extra)
    {
        $request = $this->request;
        $config = $this->config;
        $name = $this->getAttrib($attributes,'name');
        $property = $this->getAttrib($attributes, 'property');
        $scope = $this->getAttrib($attributes, 'scope');
        $value = $this->getAttrib($attributes, 'value');
        $str = "";
        switch($tagname)
        {
            case 'include':
                $path = NULL;
                if(array_key_exists('name', $attributes))
                {
                    $name = $attributes["name"];
                    $path = $config->getTemplate($name);
                }
                else if(array_key_exists('path', $attributes))
                    $path = $attributes["path"];
                if(file_exists($path))
                {
                    $contents = file_get_contents($path);
                    $reqenc = $request->getCharacterEncoding();
                    if($reqenc && (strtolower($reqenc) != "euc-jp"))
                        $contents = mb_convert_encoding($contents, "EUC-JP", $reqenc);
                    else if(!$reqenc)
                        $contents = mb_convert_encoding($contents, "EUC-JP");
                    $str = $contents;
                }
                break;
            case 'insert':
                if(array_key_exists('name', $attributes))
                {
                    $name = $attributes['name'];
                    $str = "<?php \$controller = new Controller(); \$controller->action(\$this->config, \$request, \$this->response, '$name'); ?>";
                }
                break;
            case 'img':
                $attributes = $this->removeSpecialAttributes($attributes);
                $src = $this->getAttrib($attributes, 'src');
                $id = $this->getAttrib($attributes, 'id');
                if($src)
                {
                    $str = "<?php \$src = '$src?' . \$this->makeQuery(\$this->getValue('$name','$property','$scope','$value'), '$id'); ?>";
                    unset($attributes["src"]);
                }
                else if($name)
                {
                    $str = "<?php \$src = \$this->getValue('$name','$property','$scope','$value'); ?>";
                }
                $str .= "<img " . $this->_makeAttributes($attributes) . " src=\"<?php \$this->print_enc(\$src); ?>\">";
                break;
            case 'textarea':
                $attributes = $this->removeSpecialAttributes($attributes);
                $str  = "<textarea " . $this->_makeAttributes($attributes) . ">";
                $str .= "<?php \$this->print_enc(htmlspecialchars(\$this->getValue('$name','$property','$scope','$value'))); ?></textarea>";
                break;
            case 'select':
                $attributes = $this->removeSpecialAttributes($attributes);
                $str  = "<select " . $this->_makeAttributes($attributes) . ">\n";
                $str .= "<?php \$selected = \$this->getValue('$name','$property','$scope','$value'); ?>";
                $str .= $this->parse($sentence);
                $str .= "</select>";
                break;
            
            case 'button':
            case 'submit':
            case 'password':
            case 'reset':
            case 'text':
            case 'file':
                $attributes = $this->removeSpecialAttributes($attributes);
                $attributes["type"] = $tagname;
                $str  = "<input " . $this->_makeAttributes($attributes);
                if($tagname != "file")
                {
                    $str .= "<?php \$value =\$this->getValue('$name','$property','$scope','$value'); if(!\$this->isEmpty(\$value)) { \$this->print_enc(\" value=\\\"\$value\\\"\"); } ?>";
                }
                $str .= ">";
                break;
            case 'option':
                $attributes = $this->removeSpecialAttributes($attributes);
                $str = "<option " . $this->_makeAttributes($attributes);
                $str .= "<?php \$value = \$this->getValue('$name','$property','$scope','$value'); if(!\$this->isEmpty(\$value)) { \$this->print_enc(\"value=\\\"\$value\\\"\"); if(\$value == \$selected) { \$this->print_enc(\" selected\"); } } ?>";
                $str .= ">";
                $str .= $sentence . "</option>";
                break;
            case 'optionsCollection':
                $str = "";
                $attributes = $this->removeSpecialAttributes($attributes);
                $str = "<?php \$value = \$this->getValue('$name','$property','$scope','$value'); if(is_array(\$value)) { foreach(\$value as \$label => \$val) { \$this->print_enc(\"<option value=\\\"\" . \$val . \"\\\"\"); if(\$val == \$selected) { \$this->print_enc(\" selected\"); } \$this->print_enc(\">\" . htmlspecialchars(\$label) . \"</option>\\n\"); } } ?>";
                break;
            case 'hidden':
                $attributes = $this->removeSpecialAttributes($attributes);
                if(array_key_exists('id', $attributes))
                {
                    $attributes["name"] = $attributes["id"];
                    unset($attributes["id"]);
                }
                $attributes["type"] = $tagname;
                $att_name = $attributes["name"];
                unset($attributes["name"]);
                if(array_key_exists("write", $attributes))
                {
                    unset($attributes["write"]);
                    $isWrite = true;
                }
                else
                    $isWrite = false;
                
                $str = "<?php \$value = \$this->getValue('$name','$property','$scope','$value'); if(!\$this->isEmpty(\$value)) { if(is_array(\$value)) { foreach(\$value as \$data) { ";
                if($isWrite)
                    $str .= " if(!is_array(\$data)) { \$this->print_enc(nl2br(htmlspecialchars(\$data)) . \"<br>\"); }";
                $str .= " \$this->print_enc('<input " . $this->_makeAttributes($attributes) . "'); \$this->print_enc(\" name=\\\"$att_name" . "[]\\\" value=\\\"\$data\\\">\"); } } else { ";
                if($isWrite)
                    $str .= " if(!is_array(\$value)) { \$this->print_enc(nl2br(htmlspecialchars(\$value))); }";
                $str .= " \$this->print_enc('<input " . $this->_makeAttributes($attributes) . "'); \$this->print_enc(\" name=\\\"$att_name\\\" value=\\\"\$value\\\">\"); } } ?>";
                break;
            case 'link':
                $str = $sentence;
                if(array_key_exists('href', $attributes))
                {
                    $href = $attributes["href"];
                    if(!preg_match('/^\//', $href))
                    {
                        $dir = dirname($_SERVER["PHP_SELF"]);
                        if($dir != '/')
                            $dir .= '/';
                        $href = $dir . $href;
                    }
                    unset($attributes["href"]);
                    $id = $this->getAttrib($attributes, "id");
                    if($id)
                        unset($attributes["id"]);
                    $str  = "<?php \$href = '$href'; \$query = \"\"; ";
                    if(array_key_exists("ssl", $attributes))
                        $str .= " \$href = 'https://' . \$request->getServerName() . \$href;";
                    else
                        $str .= " if(\$request->isHttps()) { \$href = 'http://' . \$request->getServerName() . \$href; } ";
                    $str .= " \$value = \$this->getValue('$name','$property','$scope','$value'); \$query = \$this->makeQuery(\$value, '$id'); ?>";
                    $str .= "<a " . $this->_makeAttributes($attributes);
                    $str .= " href=\"<?php \$this->print_enc(\$href); ?>";
                    if(!preg_match('/\?/', $href))
                        $str .= '?';
                    else
                        $str .= '&';
                    $str .= "<?php \$this->print_enc(\$query); ?>\">";
                    $str .= $this->parse($sentence);
                    $str .= "</a>";
                }
                else if(array_key_exists('action', $attributes))
                {
                    $href = "";
                    $str = "<?php \$href = \"\"; \$query = \"\"; ";
                    if(array_key_exists('ssl', $attributes))
                        $str .= " \$href = 'https://' . \$request->getServerName(); ";
                    else
                        $str .= " if(\$request->isHttps()) { \$href = 'http://' . \$request->getServerName(); } ";

                    if($this->config->isRewrite())
                    {
                        $dir .= dirname($_SERVER["PHP_SELF"]);
                        if(!preg_match('/\/$/', $dir))
                            $dir .= "/";
                        $str .= " \$href .= '$dir'; ";
                    }
                    else
                    {
                        $path = $_SERVER["PHP_SELF"] . "?action=";
                        $str .= " \$href .= '$path'; ";
                    }
                    $action = $attributes["action"];
                    if($this->config->isRewrite())
                        $action .= "/";
                    $id = $this->getAttrib($attributes, 'id');
                    if($id)
                        unset($attributes["id"]);
                    $str .= " \$href .= '$action'; ";
                    $str .= " \$value = \$this->getValue('$name','$property','$scope','$value'); if(is_array(\$value)) { \$queries = array(); foreach(\$value as \$key => \$val) { \$queries[] = rawurlencode(\$key) . '=' . rawurlencode(\$val); } \$query = join('&', \$queries); if(!preg_match('/\\?/', \$href)) { \$href .= '?'; } else { \$href .= '&'; } }";
                    if($id)
                    {
                        $str .= " else if(!\$this->isEmpty(\$value)) { ";
                        if($this->config->isRewrite())
                            $str .= " \$query = '$id' . rawurlencode(\$value) . '.html';";
                        else
                        {
                            $str .= " \$query = '$id' . \"=\" . rawurlencode(\$value);";
                            $str .= " if(!preg_match('/\\?/', \$href)) { \$href .= '?'; } else { \$href .= '&'; } ";
                        }
                        $str .= " } ";
                    }
                    $str .= " \$href .= \$query; ?>";
                    unset($attributes["action"]);
                    $str .= "<a " . $this->_makeAttributes($attributes);
                    $str .= " href=\"<?php \$this->print_enc(\$href); ?>\"" . ">";
                    $str .= $this->parse($sentence);
                    $str .= "</a>";
                }
                else
                {
                    $attributes = $this->removeSpecialAttributes($attributes);
                    $str  = "<a " . $this->_makeAttributes($attributes);
                    $str .= "<?php \$value = \$this->getValue('$name','$property','$scope','$value'); \$this->print_enc(' href=\"' . \$value . '\"'); ?>";
                    $str .= ">";
                    $str .= $this->parse($sentence);
                    $str .= "</a>";
                }
                break;
            case 'checkbox':
                $attributes = $this->removeSpecialAttributes($attributes);
                if(array_key_exists('id', $attributes))
                {
                    $attr_name = $attributes["id"];
                    unset($attributes["id"]);
                    if(array_key_exists("name", $attributes))
                        unset($attributes["name"]);
                }
                else if(array_key_exists('name', $attributes))
                {
                    $attr_name = $attributes["name"];
                    unset($attributes["name"]);
                }
                else
                    $attr_name = "";

                $str = "<?php \$checked = ''; \$value = \$this->getValue('$name','$property','$scope','$value'); \$values = \$this->getBean('" . $this->formName . "','" . $attr_name . "'); if(!empty(\$values)) { if(is_array(\$values) && (array_search(\$value, \$values) !== false)) { \$checked = ' checked'; } else { if(!is_array(\$values)) { if(\$values == \$value) { \$checked = ' checked'; } } } } ?>";
                if(array_key_exists('multi', $attributes))
                {
                    if($attributes["multi"] != "false")
                        $attr_name .= "[]";
                    unset($attributes["multi"]);
                }
                else
                    $attr_name .= "[]";

                $str .= "<input type=\"checkbox\" " . $this->_makeAttributes($attributes);
                $str .= " name=\"$attr_name\" value=\"<?php \$this->print_enc(\$value); ?>\"<?php \$this->print_enc(\$checked); ?>>";
                break;
            case 'radio':
                $attributes = $this->removeSpecialAttributes($attributes);
                if(array_key_exists('name', $attributes))
                {
                    $attr_name = $attributes["name"];
                    unset($attributes["name"]);
                }
                else
                    $attr_name = "";
                $str = "<?php \$checked = ''; \$values = \$this->getBean('" . $this->formName . "','" . $attr_name . "'); if(\$values == \$this->getValue('$name','$property','$scope','$value')) { \$checked = ' checked'; } ?>";
                $str .= "<input type=\"radio\" " . $this->_makeAttributes($attributes) . " name=\"$attr_name\" value=\"$value\"<?php \$this->print_enc(\$checked); ?>>";
                break;
            case 'errors':
                $str = "";
                $errors = NULL;
                if(array_key_exists('name', $attributes))
                    $errname = $name;
                else
                    $errname = "phpgear_errors";
                
                $str = "<?php \$errors = \$request->getAttribute('$errname'); if(is_object(\$errors)) { ";
                if($property)
                    $str .= "\$error_array = \$errors->get('$property'); ";
                else
                    $str .= "\$error_array = \$errors->get(); ";
                
                $str .= "\$this->print_enc(\$config->getMessage('errors.header')); ";
                $str .= "foreach(\$error_array as \$error_obj) { \$errmsg = \$config->getMessage(\$error_obj->getKey()); if(strlen(\$errmsg)) { \$patterns = array(); \$replacements = \$error_obj->getValues(); foreach(\$replacements as \$index => \$replace) { \$patterns[] = \"/\\{\$index\\}/\"; } \$this->print_enc(\$config->getMessage('errors.prefix')); \$this->print_enc(preg_replace(\$patterns, \$replacements, \$errmsg)); \$this->print_enc(\$config->getMessage('errors.suffix')); } } \$this->print_enc(\$config->getMessage('errors.footer')); } ?>";
                break;
            case 'form':
                if(array_key_exists('name', $attributes))
                    $attributes["property"] = $attributes["name"];
                $attributes = $this->removeSpecialAttributes($attributes);
                if(array_key_exists('action', $attributes))
                    $action = $attributes["action"];
                if(!preg_match("/^http/", $action))
                {
                    if($this->config->isRewrite())
                    {
                        $attributes["action"] = dirname($_SERVER['PHP_SELF']);
                        if(!preg_match('/\/$/', $attributes["action"]))
                            $attributes["action"] .= "/";
                        $attributes["action"] .= $action . "/index.html";
                    }
                    else
                        $attributes["action"] = $_SERVER['PHP_SELF'];
                }
                if(!array_key_exists('method', $attributes))
                {
                    if($this->config->isRewrite())
                        $attributes["method"] = "get";
                    else
                        $attributes["method"] = "post";
                }
                $str  = "<form " . $this->_makeAttributes($attributes) . ">";
                if(!preg_match("/^http/", $action))
                {
                    if(!$this->config->isRewrite() || ($attributes["method"] == 'post'))
                        $str .= "<input type=\"hidden\" name=\"action\" value=\"" . $action . "\">";
                    $str .= "<?php \$session = \$request->getSession(); \$token = \$session->getAttribute('phpgear_transaction_token'); if(!\$this->isEmpty(\$token)) { \$this->print_enc('<input type=\"hidden\" name=\"phpgear_transaction_token\" value=\"' . \$token . '\">'); } ?>";
                }
                $str .= $this->parse($sentence);
                $str .= "</form>";
                break;
        }
        return $str;
    }

    /**
     * ü°ä
     * @param $attributes °
     * @return ä
     */
    function &removeSpecialAttributes(&$attributes)
    {
        if(array_key_exists('property', $attributes))
        {
            $attributes["name"] = $attributes["property"];
            unset($attributes["property"]);
        }
        if(array_key_exists('value', $attributes))
            unset($attributes["value"]);
        if(array_key_exists('scope', $attributes))
            unset($attributes["scope"]);
        return $attributes;
    }

    // °
    function _getAttributes($str)
    {
        $attrib = array();
        if(preg_match_all('/(\s*)([^=]+)=("[^"]*"|\'[^\']*\'|[^"\'\s]+)(\s*)/', $str, $matches) !== false)
        {
            $count = count($matches[0]);
            for($i = 0; $i < $count; $i++)
            {
                $key = $matches[2][$i];
                $value = $matches[3][$i];
                if(preg_match('/"([^"]*)"/', $value, $mat))
                    $value = $mat[1];
                else if(preg_match('/\'([^\']*)\'/', $value, $mat))
                    $value = $mat[1];
                $attrib[$key] = $value;
            }
        }
        return $attrib;
    }
    
    // 
    function _trim($str)
    {
        $Zspace = '(?:\xA1\xA1)';
        $ascii = '[\x00-\x7F]';
        $twoBytes = '(?:[\x8E\xA1-\xFE][\xA1-\xFE])';
        $threeBytes = '(?:\x8F[\xA1-\xFE][\xA1-\xFE])';
        $character = "(?:$ascii|$twoBytes|$threeBytes)";
        
        $str = preg_replace("/^(?:\\s|$Zspace)+/", '', $str);
        $str = preg_replace("/^($character*?)(?:\\s|$Zspace)+$/", "$1", $str);
        return $str;
    }
    
    // °ʸ
    function _makeAttributes($attributes)
    {
        $attribs = array();
        foreach($attributes as $key => $value)
        {
            if(!is_array($value))
                $value = htmlspecialchars($value);
            if(!$this->isEmpty($value))
                $attribs[] = "$key=\"$value\"";
            else
                $attribs[] = $key;
        }
        return join(' ', $attribs);
    }
    
    function getBean($name, $property="", $scope="")
    {
        $request = $this->request;
        $session = $request->getSession();
        
        $properties = NULL;
        if(!$this->isEmpty($property))
            $properties = explode(".", $property);
        
        $data = NULL;
        // pageõ
        if(!$scope || ($scope == "page"))
        {
            $bean = $this->getAttribute($name);
            $data = $this->findBean($bean, $properties);
        }
        // requestõ
        if(($data === NULL) && (!$scope || ($scope == 'request')))
        {
            $bean = $request->getAttribute($name);
            $data = $this->findBean($bean, $properties);
        }
        // sessionõ
        if(($data === NULL) && (!$scope || ($scope == 'session')))
        {
            $bean = $session->getAttribute($name);
            $data = $this->findBean($bean, $properties);
        }
        return $data;
    }

    function findBean($bean, $properties=NULL)
    {
        if((is_object($bean) || is_array($bean)) && is_array($properties))
        {
            for($i = 0; $i < count($properties); $i++)
            {
                if(is_object($bean))
                {
                    $pos = strpos($properties[$i], 'is');
                    if($pos !== 0)
                        $method = 'get' . $properties[$i];
                    else
                        $method = $properties[$i];
                    if(!method_exists($bean, strtolower($method)))
                    {
                        $bean = NULL;
                        break;
                    }
                    $bean = $bean->$method();
                }
                else if(is_array($bean))
                {
                    if(array_key_exists($properties[$i], $bean))
                        $bean = $bean[$properties[$i]];
                    else
                    {
                        $bean = NULL;
                        break;
                    }
                }
            }
        }
        return $bean;
    }

    /**
     * ꤵ줿̾°֤ͤޤ
     * @param $name ̾
     * @return °
     */
    function getAttribute($name)
    {
        if(array_key_exists($name, $this->attributes))
            return $this->attributes[$name];
        else
            return NULL;
    }
    
    /**
     * °̾ޤ
     * @return °̾
     */
    function getAttributeNames()
    {
        return array_keys($this->attributes);
    }
    
    /**
     * °ޤ
     * @param $name ̾
     */
    function removeAttribute($name)
    {
        if(array_key_exists($name, $this->attributes))
            unset($this->attributes[$name]);
    }
    
    /**
     * °򥻥åȤޤ
     * @param $name ̾
     * @parma $obj  ֥
     */
    function setAttribute($name, $obj)
    {
        $this->attributes[$name] = $obj;
    }
    
    /**
     * ͤޤϵɤĴ٤
     * @param $value 
     * @return ʤ true,Ǥʤ false
     */
    function isEmpty($value)
    {
        if($value === NULL)
            return true;
        if($value === false)
            return true;
        
        // ξ
        if(is_array($value) && (count($value) == 0))
            return true;
        // ʸξ
        if(!is_object($value) && !is_array($value) && (strlen($value) == 0))
            return true;
        
        // ¾ξOK
        return false;
    }
    
    function print_enc($str)
    {
        $reqEncoding = $this->request->getCharacterEncoding();
        $resEncoding = $this->response->getCharacterEncoding();
        if($resEncoding && ($resEncoding != 'EUC-JP'))
            $str = mb_convert_encoding($str, $resEncoding, "EUC-JP");
        else if(!$resEncoding && $reqEncoding)
            $str = mb_convert_encoding($str, $reqEncoding, "EUC-JP");
        
        print $str;
    }
}

?>
