/*
 * Decompiled with CFR 0.152.
 */
package org.wnj2;

import org.wnj2.Synset;
import org.wnj2.Wnj2;
import org.wnj2.Word;

public class Sense {
    protected final Wnj2 parent;
    private final Synset synset;
    private final Word word;
    private final String lang;
    private final int rank;
    private final int lexid;
    private final int freq;
    private final String src;

    Sense(Wnj2 parent, String synset, int word, String lang, int rank, int lex, int freq, String src) {
        this.parent = parent;
        this.synset = Synset.create(parent, synset);
        this.word = Word.create(parent, word);
        this.lang = lang;
        this.rank = rank;
        this.lexid = lex;
        this.freq = freq;
        this.src = src;
    }

    public Synset getSynset() {
        return this.synset;
    }

    public Word getWord() {
        return this.word;
    }

    public String getLang() {
        return this.lang;
    }

    public int getRank() {
        return this.rank;
    }

    public int getLexID() {
        return this.lexid;
    }

    public int getFreq() {
        return this.freq;
    }

    public String getSrc() {
        return this.src;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Sense) {
            Sense that = (Sense)obj;
            return this.getSynset().equals(that.getSynset()) && this.getWord().equals(that.getWord());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getSynset().hashCode() * this.getWord().hashCode();
    }

    public String toString() {
        return String.format("Sense[ synsetid: %s, wordid: %d, lang: %s, rank %d, lexid: %d, freq: %d, src: %s]", this.getSynset().getSynsetID(), this.getWord().getWordID(), this.getLang(), this.getRank(), this.getLexID(), this.getFreq(), this.getSrc());
    }
}

