/*
 * Decompiled with CFR 0.152.
 */
package org.wnj2;

import java.sql.SQLException;
import java.util.List;
import org.wnj2.InitializedSynset;
import org.wnj2.Lang;
import org.wnj2.LazySynset;
import org.wnj2.Link;
import org.wnj2.Pos;
import org.wnj2.Sense;
import org.wnj2.Synlink;
import org.wnj2.SynsetDef;
import org.wnj2.Wnj2;

public abstract class Synset {
    protected final Wnj2 parent;
    private final String synsetid;

    protected Synset(Wnj2 parent, String id) {
        this.parent = parent;
        this.synsetid = id;
    }

    public String getSynsetID() {
        return this.synsetid;
    }

    public abstract Pos getPos();

    public abstract String getName();

    public abstract String getSrc();

    public SynsetDef getDef() throws SQLException {
        return this.parent.findSynsetDef(this);
    }

    public List<Sense> getSenses() throws SQLException {
        return this.parent.findSenses(this);
    }

    public List<Sense> getSenses(Lang lang) throws SQLException {
        assert (lang != null) : "lang is null";
        return this.parent.findSenses(this, lang);
    }

    public List<Synlink> getSynlinks() throws SQLException {
        return this.parent.findSynlinks(this);
    }

    public List<Synlink> getSynlinks(Link link) throws SQLException {
        assert (link != null) : "link is null";
        return this.parent.findSynlinks(this, link);
    }

    public List<Synset> getConnectedSynsets(Link link) throws SQLException {
        assert (link != null) : "link is null";
        return this.parent.findSynsets(this, link);
    }

    public boolean equals(Object obj) {
        try {
            Synset that = (Synset)obj;
            return this.getSynsetID().equals(that.getSynsetID());
        }
        catch (ClassCastException e) {
            return super.equals(obj);
        }
    }

    public int hashCode() {
        return this.getSynsetID().hashCode();
    }

    public String toString() {
        return String.format("Synset[ synsetid: %s, pos: %s, name: %s, src: %s]", new Object[]{this.getSynsetID(), this.getPos(), this.getName(), this.getSrc()});
    }

    static Synset create(Wnj2 parent, String id) {
        return new LazySynset(parent, id);
    }

    static Synset create(Wnj2 parent, String id, Pos pos, String name, String src) {
        return new InitializedSynset(parent, id, pos, name, src);
    }
}

