/*
 * Decompiled with CFR 0.152.
 */
package org.wnj2;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.wnj2.Lang;
import org.wnj2.Link;
import org.wnj2.Pos;
import org.wnj2.Sense;
import org.wnj2.Synlink;
import org.wnj2.Synset;
import org.wnj2.SynsetDef;
import org.wnj2.Word;

public class Wnj2
implements Closeable {
    private final Connection connection;
    private static final String FIND_WORD_BY_LEMMA = "select * from WORD where lemma = ?;";
    private static final String FIND_WORD_BY_LEMMA_AND_POS = "select * from WORD where lemma = ? and pos = ?;";
    private static final String FIND_WORD_BY_WORDID = "select * from WORD where wordid = ?;";
    private static final String FIND_SENSES_BY_WORDID = "select * from SENSE where wordid = ?";
    private static final String FIND_SENSES_BY_SYNSET = "select * from SENSE where synset = ?";
    private static final String FIND_SENSES_BY_SYNSET_AND_LANG = "select * from SENSE where synset = ? and lang = ?";
    private static final String FIND_SYNSETS_BY_NAME_AND_POS = "select * from SYNSET where name = ? and pos = ?;";
    private static final String FIND_SYNSET_BY_SYNSET = "select * from SYNSET where synset = ?;";
    private static final String FIND_SYNSET_BY_SYNSET_AND_LINK = "select s.synset, s.pos, s.name, s.src from SYNLINK l inner join SYNSET s on l.synset2 = s.synset where l.synset1 = ?;";
    private static final String FIND_SYNSETDEF_BY_SYNSET = "select * from SYNSET_DEF where synset = ?";
    private static final String FIND_SYNLINK_BY_SYNSET = "select * from SYNLINK where synset1 = ?;";
    private static final String FIND_SYNLINK_BY_SYNSET_AND_LINK = "select * from SYNLINK where synset1 = ? and link = ?";
    private Reference<PreparedStatement> findWordsByLemma = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findWordsByLemmaAndPos = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findWordByWordid = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSensesByWordid = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSensesBySynset = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSensesBySynsetAndLang = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSynsetsByNameAndPos = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSynsetBySynset = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSynsetBySynsetAndLink = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSynsetDefBySynset = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSynlinksBySynset = new SoftReference<Object>(null);
    private Reference<PreparedStatement> findSynlinksBySynsetAndLink = new SoftReference<Object>(null);

    public Wnj2(File file) throws ClassNotFoundException, SQLException, FileNotFoundException {
        assert (file != null) : "file is null";
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", file.getAbsolutePath()));
    }

    public Wnj2(Connection connection) {
        assert (connection != null) : "connection is null";
        this.connection = connection;
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public List<Word> findWords(String lemma) throws SQLException {
        assert (lemma != null) : "lemma is null";
        PreparedStatement ps = this.findWordsByLemma.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_WORD_BY_LEMMA);
            this.findWordsByLemma = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Word> ret = new ArrayList<Word>();
        ps.setString(1, lemma.toLowerCase());
        ret.addAll(this.createWords(ps));
        return ret;
    }

    public List<Word> findWords(String lemma, Pos pos) throws SQLException {
        assert (lemma != null) : "lemma is null";
        assert (pos != null) : "pos is null";
        PreparedStatement ps = this.findWordsByLemmaAndPos.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_WORD_BY_LEMMA_AND_POS);
            this.findWordsByLemmaAndPos = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Word> ret = new ArrayList<Word>();
        ps.setString(1, lemma.toLowerCase());
        ps.setString(2, pos.toString());
        ret.addAll(this.createWords(ps));
        return ret;
    }

    public List<Synset> findSynsets(String lemma, Pos pos) throws SQLException {
        assert (lemma != null) : "lemma is null";
        assert (pos != null) : "pos is null";
        PreparedStatement ps = this.findSynsetsByNameAndPos.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SYNSETS_BY_NAME_AND_POS);
            this.findSynsetsByNameAndPos = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Synset> ret = new ArrayList<Synset>();
        ps.setString(1, lemma);
        ps.setString(2, pos.toString());
        ret.addAll(this.createSynsets(ps));
        return ret;
    }

    Word findWord(Word word) throws SQLException {
        PreparedStatement ps = this.findWordByWordid.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_WORD_BY_WORDID);
            this.findWordByWordid = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Word> ret = new ArrayList<Word>();
        ps.setInt(1, word.getWordID());
        ret.addAll(this.createWords(ps));
        if (ret.size() == 0) {
            return null;
        }
        return (Word)ret.get(0);
    }

    List<Sense> findSenses(Word word) throws SQLException {
        PreparedStatement ps = this.findSensesByWordid.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SENSES_BY_WORDID);
            this.findSensesByWordid = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Sense> ret = new ArrayList<Sense>();
        ps.setInt(1, word.getWordID());
        ret.addAll(this.createSences(ps));
        return ret;
    }

    List<Sense> findSenses(Synset synset) throws SQLException {
        PreparedStatement ps = this.findSensesBySynset.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SENSES_BY_SYNSET);
            this.findSensesBySynset = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Sense> ret = new ArrayList<Sense>();
        ps.setString(1, synset.getSynsetID());
        ret.addAll(this.createSences(ps));
        return ret;
    }

    List<Sense> findSenses(Synset synset, Lang lang) throws SQLException {
        PreparedStatement ps = this.findSensesBySynsetAndLang.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SENSES_BY_SYNSET_AND_LANG);
            this.findSensesBySynsetAndLang = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Sense> ret = new ArrayList<Sense>();
        ps.setString(1, synset.getSynsetID());
        ps.setString(2, lang.toString());
        ret.addAll(this.createSences(ps));
        return ret;
    }

    Synset findSynset(Synset synset) throws SQLException {
        PreparedStatement ps = this.findSynsetBySynset.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SYNSET_BY_SYNSET);
            this.findSynsetBySynset = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Synset> ret = new ArrayList<Synset>();
        ps.setString(1, synset.getSynsetID());
        ret.addAll(this.createSynsets(ps));
        if (ret.size() == 0) {
            return null;
        }
        return (Synset)ret.get(0);
    }

    List<Synset> findSynsets(Synset synset, Link link) throws SQLException {
        PreparedStatement ps = this.findSynsetBySynsetAndLink.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SYNSET_BY_SYNSET_AND_LINK);
            this.findSynsetBySynsetAndLink = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Synset> ret = new ArrayList<Synset>();
        ps.setString(1, synset.getSynsetID());
        ret.addAll(this.createSynsets(ps));
        return ret;
    }

    SynsetDef findSynsetDef(Synset synset) throws SQLException {
        PreparedStatement ps = this.findSynsetDefBySynset.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SYNSETDEF_BY_SYNSET);
            this.findSynsetDefBySynset = new SoftReference<PreparedStatement>(ps);
        }
        SynsetDef ret = null;
        ps.setString(1, synset.getSynsetID());
        ResultSet rs = ps.executeQuery();
        try {
            if (rs.next()) {
                ret = new SynsetDef(this, synset, Lang.valueOf(rs.getString(2)), rs.getString(3), rs.getInt(4));
            }
        }
        finally {
            rs.close();
        }
        return ret;
    }

    List<Synlink> findSynlinks(Synset synset) throws SQLException {
        PreparedStatement ps = this.findSynlinksBySynset.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SYNLINK_BY_SYNSET);
            this.findSynlinksBySynset = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Synlink> ret = new ArrayList<Synlink>();
        ps.setString(1, synset.getSynsetID());
        ret.addAll(this.createSynlinks(ps));
        return ret;
    }

    List<Synlink> findSynlinks(Synset synset, Link link) throws SQLException {
        PreparedStatement ps = this.findSynlinksBySynsetAndLink.get();
        if (ps == null) {
            ps = this.createPreparedStatement(FIND_SYNLINK_BY_SYNSET_AND_LINK);
            this.findSynlinksBySynsetAndLink = new SoftReference<PreparedStatement>(ps);
        }
        ArrayList<Synlink> ret = new ArrayList<Synlink>();
        ps.setString(1, synset.getSynsetID());
        ps.setString(2, link.toString());
        ret.addAll(this.createSynlinks(ps));
        return ret;
    }

    private List<Word> createWords(PreparedStatement ps) throws SQLException {
        ArrayList<Word> words = new ArrayList<Word>();
        ResultSet rs = ps.executeQuery();
        try {
            while (rs.next()) {
                words.add(Word.create(this, rs.getInt(1), Lang.valueOf(rs.getString(2)), rs.getString(3), rs.getString(4), Pos.valueOf(rs.getString(5))));
            }
        }
        finally {
            rs.close();
        }
        return words;
    }

    private List<Sense> createSences(PreparedStatement ps) throws SQLException {
        ArrayList<Sense> senses = new ArrayList<Sense>();
        ResultSet rs = ps.executeQuery();
        try {
            while (rs.next()) {
                senses.add(new Sense(this, rs.getString(1), rs.getInt(2), rs.getString(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getString(7)));
            }
        }
        finally {
            rs.close();
        }
        return senses;
    }

    private List<Synset> createSynsets(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.executeQuery();
        ArrayList<Synset> synsets = new ArrayList<Synset>();
        try {
            if (rs.next()) {
                synsets.add(Synset.create(this, rs.getString(1), Pos.valueOf(rs.getString(2)), rs.getString(3), rs.getString(4)));
            }
        }
        finally {
            rs.close();
        }
        return synsets;
    }

    private List<Synlink> createSynlinks(PreparedStatement ps) throws SQLException {
        ArrayList<Synlink> synlinks = new ArrayList<Synlink>();
        ResultSet rs = ps.executeQuery();
        try {
            while (rs.next()) {
                synlinks.add(new Synlink(this, rs.getString(1), rs.getString(2), Link.valueOf(rs.getString(3)), rs.getString(4)));
            }
        }
        finally {
            rs.close();
        }
        return synlinks;
    }

    private PreparedStatement createPreparedStatement(String sql) throws SQLException {
        PreparedStatement ret = this.connection.prepareStatement(sql);
        assert (ret != null);
        return ret;
    }
}

