/*
 * Decompiled with CFR 0.152.
 */
package org.wnj2;

import java.sql.SQLException;
import java.util.List;
import org.wnj2.InitializedWord;
import org.wnj2.Lang;
import org.wnj2.LazyWord;
import org.wnj2.Pos;
import org.wnj2.Sense;
import org.wnj2.Synset;
import org.wnj2.Wnj2;

public abstract class Word {
    protected final Wnj2 parent;
    private final int wordid;

    protected Word(Wnj2 parent, int wordid) {
        this.parent = parent;
        this.wordid = wordid;
    }

    public int getWordID() {
        return this.wordid;
    }

    public abstract Lang getLang();

    public abstract String getLemma();

    public abstract String getPron();

    public abstract Pos getPos();

    public List<Sense> getSenses() throws SQLException {
        return this.parent.findSenses(this);
    }

    public List<Synset> getSynsets() throws SQLException {
        return this.parent.findSynsets(this.getLemma(), this.getPos());
    }

    public boolean equals(Object obj) {
        try {
            Word that = (Word)obj;
            return this.getWordID() == that.getWordID();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return Integer.valueOf(this.getWordID()).hashCode();
    }

    public String toString() {
        return String.format("{\"wordid\": %d, \"lang\": \"%s\", \"lemma\": \"%s\", \"pron\": \"%s\", \"pos\": \"%s\"}", new Object[]{this.getWordID(), this.getLang(), this.getLemma().replace("\"", "\\\""), this.getPron().replace("\"", "\\\""), this.getPos()});
    }

    static Word create(Wnj2 parent, int id) {
        return new LazyWord(parent, id);
    }

    static Word create(Wnj2 parent, int id, Lang lang, String lemma, String pron, Pos pos) {
        return new InitializedWord(parent, id, lang, lemma, pron, pos);
    }
}

