import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.mongo.MongoSQL;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;

import java.sql.SQLException;

import com.mongodb.DB;
import com.mongodb.DBCollection;

public class MongoCUITest {

	public static void main(String[] args) {
		MongoSQL sql = new MongoSQL();
		ConnectionProperties connectionProperties = new ConnectionProperties();
		connectionProperties.setAdminAuthenticate("superAdmin", "admin");
		connectionProperties.setHost("localhost");
		final Request request = new Request(SQLOperationType.CONNECT,
				connectionProperties);
		try {
			sql.doOperation(SQLOperationType.CONNECT, request);
			System.out.println(sql.getDatabaseNames());

		} catch (SQLException e) {
			e.printStackTrace();
		}

		try {
			DB db = sql.setCurrentDB("test");
			System.out.println("db=" + db);
			DBCollection collection = db.createCollection("col1", null);
			// System.out.println("col=" + collection);
			// BasicDBObject doc = new BasicDBObject();
			//
			// doc.put("name", "MongoDB");
			// doc.put("type", "database");
			// doc.put("count", 1);
			//
			// BasicDBObject info = new BasicDBObject();
			//
			// info.put("x", 203);
			// info.put("y", 102);
			//
			// doc.put("info", info);
			//
			// collection.insert(doc);

			DBSchema schema = new DBSchema(null);
			schema.setName("ho34");
			DBTable table = new DBTable(schema);
			table.setName("things");
			System.out.println("result=" + sql.getAllData2(table));

			System.out.println(db.getCollectionNames());
		} catch (Exception e) {
			e.printStackTrace();
		}

		// sql.setAdminAuthenticate("superAdmin", "admin");
		// sql.addUser("ho34", "joe", "pass");
		// sql.addAuthenticate("ho34", "joe", "pass");
		// sql.dumpAllCollectionNames();
		// sql.setCurrentDB("ho34");
		// System.out.println(sql.selectAll("things"));

		// BasicDBObject doc = new BasicDBObject();
		//
		// doc.put("name", "MongoDB");
		// doc.put("type", "database");
		// doc.put("count", 1);
		//
		// BasicDBObject info = new BasicDBObject();
		//
		// info.put("x", 203);
		// info.put("y", 102);
		//
		// BasicDBObject inner_info = new BasicDBObject();
		//
		// inner_info.put("ix", 503);
		// inner_info.put("iy", 502);
		// info.put("inner_info", inner_info);
		//
		// doc.put("info", info);
		//
		// sql.insert("things", doc);

	}
}
