package hiro.yoshioka.ast.sql;

import hiro.yoshioka.util.StringUtil;

public enum DatabaseType {
	// -------------------------------------------------------------------------
	// NO SQL
	// -------------------------------------------------------------------------
	MONGO(".*mongodb.Mongo", "com.mongodb.Mongo"),
	// -------------------------------------------------------------------------
	// LOTSU NOTES DOMINO SERVER
	// -------------------------------------------------------------------------
	DOMINO("lotus.domino.database", "lotus.domino.database"),
	// -------------------------------------------------------------------------
	// SQL
	// -------------------------------------------------------------------------
	/** oracle */
	ORACLE(".*oracle.*"),
	/** my sql */
	MYSQL(".*mysql.*"),
	/** hyper sonic sql */
	HSQL("org.hsqldb.*", "org.hsqldb.jdbcDriver"),
	/** microsoft sql server */
	MS_SQLSERVER(".*sqlserver.*"),
	/** fujitsu sybase */
	SYBASE(".*sybase.*"),
	/** postgres */
	POSTGRES(".*postgresql.*"),
	/** sqlite */
	SQLITE(".*sqlite.*"),
	/** odbc */
	ODBC(".*odbc.*", "sun.jdbc.odbc.JdbcOdbcDriver"),
	/** unkown */
	UNKNOWN("unkown");

	private String driverPattern;
	private String driverName;

	private DatabaseType(String driverPattern) {
		this(driverPattern, StringUtil.EMPTY_STRING);
	}

	private DatabaseType(String driverPattern, String driverName) {
		this.driverPattern = driverPattern;
		this.driverName = driverName;
	}

	public static DatabaseType parse(String driver) {
		System.out.println("DatabaseType#parse[" + driver + "]");
		for (DatabaseType types : values()) {
			if (driver.matches(types.driverPattern)) {
				return types;
			}
		}
		System.out.println("DatabaseType#parse retunKnown");
		return UNKNOWN;
	}

	public String getDriverName() {
		return driverName;
	}

	public String getDriverPattern() {
		return driverPattern;
	}

	public boolean isMongo() {
		return MONGO.equals(this);
	}

	public boolean isDomino() {
		return DOMINO.equals(this);
	}

	public boolean isOracle() {
		return ORACLE.equals(this);
	}

	public boolean isHsql() {
		return HSQL.equals(this);
	}

}
