package hiro.yoshioka.ast.sql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RowColumn {
	protected Log fLogger = LogFactory.getLog(this.getClass());
	public int _row;

	public int _column;

	public String[] fLineData;

	public RowColumn(int row, int column) {
		_row = row;
		_column = column;
	}

	public String toString() {
		return "[" + _row + "," + _column + "]";
	}

	public RowColumn backWord() {
		if (fLogger.isDebugEnabled()) {
			fLogger.debug("fLineData=" + fLineData + "/ to" + this);
		}
		int index = 0;
		try {
			if (fLineData != null) {
				index = _column - 2;
				if (fLogger.isDebugEnabled()) {
					fLogger.debug(fLineData.length + "[" + _row + "]");
					fLogger.debug("[" + fLineData[_row - 1] + "]" + index);
				}
				for (; index > 0; index--) {
					if (!(fLineData[_row - 1].charAt(index) == '\t')
							&& !(fLineData[_row - 1].charAt(index) == ' ')) {
						index++;
						break;
					}
				}
				if (index <= 0) {
					index = 1;
				}
				return new RowColumn(_row, index);
			}
			return new RowColumn(_row, _column - 1 == 0 ? 1 : _column - 1);
		} catch (RuntimeException e) {
			fLogger.error("index=" + index, e);
			if (fLineData != null) {
				for (int i = 0; i < fLineData.length; i++) {
					fLogger.info("[" + i + "][" + fLineData[i] + "]");
				}
			}
			fLogger.error("fLineData.length=" + fLineData.length
					+ " access_index=" + (_row - 1));
			throw e;
		}
	}

	public RowColumn back() {
		RowColumn ret = new RowColumn(_row, _column);
		ret._column--;
		if (ret._column <= 0) {
			ret._column = 1;
			ret._row--;
		}
		if (ret._column <= 0 || ret._row <= 0) {
			return null;
		}
		return ret;
	}
}