package hiro.yoshioka.ast.sql.mongo;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;

import java.util.ArrayList;
import java.util.List;

public class MongoAstNode extends AbsSimpleNode {
	public final MongoAstNodeType nodeType;
	private MongoAstNode parent;
	private List<MongoAstNode> childList;

	public MongoAstNode(AbsSQLParser p, int i) {
		super(p, i);
		nodeType = MongoAstNodeType.Unkown;
	}

	public MongoAstNode(MongoAstNode parent, MongoAstNodeType type) {
		super(0);
		this.parent = parent;
		this.nodeType = type;
		if (parent != null) {
			parent.add(this);
		}
	}

	public void setFirstToken(MongoToken token) {
		this.first = token;
	}

	@Override
	public String getNodeName() {
		return nodeType.name();
	}

	private void add(MongoAstNode mongoAstNode) {
		if (childList == null) {
			childList = new ArrayList<MongoAstNode>();
		}
		childList.add(mongoAstNode);
	}

	@Override
	public void dump(String prefix) {
		// TODO Auto-generated method stub

	}

	@Override
	public void dump2(String prefix) {
		// TODO Auto-generated method stub

	}

	@Override
	public AbsSimpleNode getChild(int i) {
		return childList.get(i);
	}

	@Override
	public AbsSimpleNode[] getChildren() {
		if (childList == null || childList.size() == 0) {
			return EMPTY_ARRAY;
		}
		return childList.toArray(new AbsSimpleNode[childList.size()]);
	}

	@Override
	protected String[] getNodeNames() {
		return null;
	}

	@Override
	public AbsSimpleNode getParent() {
		return parent;
	}

}
