package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.ast.sql.NodeInfomation;
import hiro.yoshioka.ast.sql.oracle.ASTConditionElement;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParserConstants;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParserTreeConstants;

public class NullCompareNodeVisitor extends DefaultSQLNodeVisitor {

	public Object doJob(SimpleNode node, Object data) {
		SimpleNode n;
		for (int ord = 0; ord < node.jjtGetNumChildren(); ord++) {
			n = (SimpleNode) node.jjtGetChild(ord);
			n.jjtAccept(this, data);
		}
		return v;
	}

	public Object visit(ASTConditionElement node, Object data) {
		AbsSimpleNode[] children = ((SimpleNode) node).getChildren();
		// NullCompareNodeVisitor
		if (children.length == 1) {
			if (children[0].getID() == WolfSQLParserTreeConstants.JJTEXPR) {
				IToken t = children[0].getSecondToken();
				IToken t2 = children[0].getThirdToken();
				if (t.getKind() == WolfSQLParserConstants.EQUAL
						&& t2.getKind() == WolfSQLParserConstants.EQUAL) {
					children[0].fInfomation = new NodeInfomation(
							"Comparison '=' is only one operator");
				}
			}
		} else if (children.length == 2) {
			if (children[0].getID() == WolfSQLParserTreeConstants.JJTEXPR
					&& children[1].getID() == WolfSQLParserTreeConstants.JJTSIMPLECOMPARISONCONDITION) {
				IToken t = children[1].getFirstToken();
				if (t.getKind() == WolfSQLParserConstants.EQUAL) {
					if (children[1].getSecondToken().getImage()
							.equalsIgnoreCase("null")) {
						children[1].fInfomation = new NodeInfomation(
								"you should use 'IS NULL' in the <WHERE clause>");
					}
				}
				if (t.getKind() == WolfSQLParserConstants.NOTEQUAL
						|| t.getKind() == WolfSQLParserConstants.NOTEQUAL2
						|| t.getKind() == WolfSQLParserConstants.NOTEQUAL3) {
					if (children[1].getSecondToken().getImage()
							.equalsIgnoreCase("null")) {
						children[1].fInfomation = new NodeInfomation(
								"you should use 'IS NOT NULL' in the <WHERE clause>");
					}
				}

			}
		}
		return doJob(node, data);
	}

}
