package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.sql.resource.IDBResource;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.swt.graphics.Image;

public class ASTProposalableAssist extends ASTAssist {
	public List fResourceList = new ArrayList();

	private List<CompletionProposal> fProposalList = new ArrayList<CompletionProposal>();

	public ASTProposalableAssist(ASTAssist obj) {
		super(obj.fAssist);
		fASTSchemaTableColumn = obj.fASTSchemaTableColumn;

		fKeyWordList = obj.fKeyWordList;
		fASTSchemaTableColumn = obj.fASTSchemaTableColumn;
		fASTQueryTableExpressionClause = obj.fASTQueryTableExpressionClause;
	}

	public void addProposal(BackWord back, String replacementString,
			Image image, String info) {
		CompletionProposal proposal = null;
		ContextInformation ctxt = new ContextInformation("XXXXXXX",
				"informationDisplayString");
		proposal = new CompletionProposal(replacementString, back
				.getReplacementOffset(true), back.getReplacementLength(true),
				replacementString.length(), image, info, ctxt,
				"additionalProposalInfo");
		fProposalList.add(proposal);
	}

	public List<CompletionProposal> completionProposals() {
		return fProposalList;
	}

	public IDBResource[] proposalDBResources() {
		IDBResource[] ret = new IDBResource[fResourceList.size()];
		for (int i = 0; i < fResourceList.size(); i++) {
			ret[i] = (IDBResource) fResourceList.get(i);
		}
		return ret;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer("Assist:");
		switch (fAssist) {
		case ASSIST_NOTHING:
			buf.append("Nothing..");
			break;
		case ASSIST_COLUMN:
			buf.append("Column..");
			buf.append(fResourceList);
			break;
		case ASSIST_TABLE:
			buf.append("Table..");
			buf.append(fResourceList);
			break;
		case ASSIST_KEY_WORD:
			buf.append("Key..").append(fKeyWordList);
			break;
		}

		return buf.toString();
	}

	/**
	 * @return
	 */
	public List<CompletionProposal> getProposalList() {
		return fProposalList;
	}

	public void addProposal(CompletionProposal comp) {
		fProposalList.add(comp);
	}

	public void dumpCnvText(String statement, BackWord back,
			String replacementString) {
		try {
			fLogger
					.info("-----------------------[DUMP]-------------------------------------");
			StringBuilder buf = new StringBuilder();
			buf.append(statement.substring(0, back.getReplacementOffset(true)));
			buf.append(replacementString);
			buf.append(statement.substring(back.getReplacementOffset(true)
					+ back.getReplacementLength(true)));
			fLogger.info(buf.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}