package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.DatabaseType;
import hiro.yoshioka.ast.sql.mongo.util.WolfMongoParserFactory;
import hiro.yoshioka.ast.sql.oracle.util.WolfParserFactory;

import java.io.File;

public abstract class ParserFactory {

	public static ParserFactory createFactory(String driverName) {
		switch (DatabaseType.parse(driverName)) {
		case MONGO:
			return new WolfMongoParserFactory();
		}
		return new WolfParserFactory();
	}

	public abstract ParserUtil createParserUtil(String statement);

	public abstract ParserUtil createParserUtil(File file);

	// --------------------------------------------------------------------------

}
