package hiro.yoshioka.sql;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

interface IAbsBasicSQL extends ISQLOpetaionTarget {

	abstract boolean load(File f);

	abstract boolean save(File f) throws IOException;

	boolean connect(ConnectionProperties properties) throws SQLException;

	boolean close() throws SQLException;

	abstract void addConnectionListner(SqlBasicListener listner);

	abstract void removeConnetionListener(SqlBasicListener listner);

	abstract void addTracsactionListner(SqlTransactionListener listener);

	abstract void removeTracsactionListner(SqlTransactionListener listener);

	ResultSetDataHolder renameField(IDBColumn before, String afterName)
			throws SQLException;

	abstract DBRoot getRoot();

	abstract void setRoot(DBRoot root);

	abstract DBRoot getCopyRoot();

	abstract ResultSetDataHolder getSchemas();

	abstract ResultSetDataHolder getTables(String text);

	abstract ResultSetDataHolder getProcedures(String name);

	abstract boolean isCapturing();

	abstract boolean canDoOperation(SQLOperationType operation);

	abstract void setBuildTimeStamp(String format);

	abstract void setBuildDate(String format);

}