package hiro.yoshioka.sql;

public interface IPostgresDBConst {
	String JDBC_URL_EXAMPLE = "jdbc:postgresql://localhost/database";

	String _SELECT_TAB_COMMENTS = "SELECT sut.schemaname AS OWNER, sut.relname AS TABLE_NAME,"
			+ " des.description AS COMMENTS FROM pg_stat_user_tables sut, pg_description des "
			+ " WHERE sut.relid = des.objoid AND schemaname = ? AND des.objsubid = 0";


	String _SELECT_TAB_COL_COMMENTS = "SELECT "
			+ "	sut.schemaname AS OWNER, sut.relname AS TABLE_NAME, "
			+ "    att.attname AS COLUMN_NAME, "
			+ "    com.description AS COMMENTS "
			+ " FROM pg_attribute att "
			+ " INNER JOIN pg_stat_user_tables sut ON (att.attrelid = sut.relid) "
			+ " INNER JOIN pg_description com ON ( att.attrelid = com.objoid AND att.attnum = com.objsubid) "
			+ " WHERE att.attnum > 0 AND sut.schemaname=?  "
			+ " ORDER BY att.attnum";

	String _SELECT_SCHEMA_CNT = "SELECT COUNT(*) AS \"CNT\" FROM information_schema.schemata WHERE schema_name ILIKE ?";
	String _SELECT_TABLE_CNT = "SELECT COUNT(*) AS \"CNT\" FROM information_schema.tables WHERE table_schema ILIKE ? AND table_name ILIKE ?";
	String _SELECT_ALL_SEQUENCE = "SELECT SEQUENCE_NAME AS \"NAME\" FROM information_schema.sequences WHERE sequence_schema ILIKE ?";
	String _SELECT_SEQUENCE_CNT = "SELECT COUNT(*) AS \"CNT\" FROM information_schema.sequences WHERE sequence_schema ILIKE ? AND sequence_name ILIKE ?";
	String _SELECT_SEQUENCE_BODY = "SELECT sequence_name AS \"SEQUENCE_NAME\", "
			+ "last_value AS \"LAST_NUMBER\", "
			+ "max_value AS \"MAX_VALUE\", "
			+ "min_value AS \"MIN_VALUE\", "
			+ "increment_by AS \"INCREMENT_BY\", "
			+ "cache_value AS \"CASHE_SIZE\", "
			+ "is_cycled AS \"CYCLE_FLAG\" " + " FROM ";
	String _SELECT_VIEW_CNT = "SELECT COUNT(*) AS \"CNT\" FROM information_schema.views  "
			+ "WHERE table_schema ILIKE ? AND table_name ILIKE ? ";
	String _SELECT_VIEW_TEXT = "SELECT view_definition AS \"TEXT\" FROM information_schema.views "
			+ "WHERE table_schema ILIKE ? AND table_name ILIKE ? ";
	String _SELECT_SESSION = "select * from pg_stat_activity ";
	String _SELECT_INDEX_CNT = "SELECT COUNT(*) AS \"CNT\" "
			+ "FROM information_schema.referential_constraints  "
			+ "WHERE constraint_schema ILIKE ? AND constraint_name ILIKE ? ";
}

