package hiro.yoshioka.sql;

import hiro.yoshioka.ast.sql.oracle.WolfSQLParserConstants;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.ResourceCaptionRequest;
import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.util.SQLTypesNum;
import hiro.yoshioka.util.StringUtil;

import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLiteSQL extends AbsTransactionSQL {
	Pattern SIZE_PATTERN = Pattern.compile(".*[(](\\d+)([.](\\d+))?[)].*");

	public static String getSuggestURL() {
		return "jdbc:sqlite:<AbsoluteFilePath>/<dbName>";
	}

	protected SQLiteSQL(Driver ds) {
		super(ds);
	}

	protected String getSupportToken() {
		StringBuffer buf = new StringBuffer();
		Pattern p = Pattern.compile("\"(\\w+)\"");
		String[] str = WolfSQLParserConstants.tokenImage;
		for (int i = 0; i < str.length; i++) {
			Matcher m = p.matcher(str[i]);
			if (m.matches()) {
				buf.append(m.group(1)).append(",");
			}
		}
		if (buf.length() > 0) {
			buf.setLength(buf.length() - 1);
		}
		return buf.toString();
	}

	protected ResultSetDataHolder createDBProcedureDef(
			ResourceCaptionRequest request) throws SQLException {
		return null;
	}

	protected ResultSetDataHolder createDBTableDef(
			ResourceCaptionRequest request) throws SQLException {
		ResultSetDataHolder rdh = null;

		rdh = RS2RDH(_meta.getTables(null, null, null, null), true, null, null);

		for (int i = 0; i < rdh.getRowCount(); i++) {
			String tableSchem = rdh.getStringData(i, "TABLE_SCHEM");
			String tableName = rdh.getStringData(i, "TABLE_NAME");
			String type = rdh.getStringData(i, "TABLE_TYPE").toUpperCase();
			if ("INDEX".equalsIgnoreCase(type)) {
				continue;
			}

			IDBSchema mschema = (IDBSchema) _root.getResource(tableSchem);
			if (mschema == null) {
				mschema = new DBSchema(_root);
				mschema.setName(tableSchem);
				_root.putResource(mschema.getName(), mschema);
			}
			DBTable dbTable = new DBTable(mschema);
			dbTable.setName(tableName);
			dbTable.setTableType(type);
			if (dbTable.isTable()) {
				setTableColumns(mschema.getName(), dbTable);
			}
			mschema.putTable(dbTable);

			setResourceProperties(dbTable, i, rdh);

		}
		return rdh;
	}

	@Override
	protected void setTableColumns(String schema, IDBTable table)
			throws SQLException {
		ArrayList<String> pkey = null;
		if (table.isSynonym()) {
			if (!StringUtil.isEmpty(table.getComment())) {
				String[] spl = table.getComment().split("[.]");
				if (spl.length == 2) {
					pkey = getTablePrimaryKeys(null, spl[0], spl[1]);
				}
			}
		} else {
			pkey = getTablePrimaryKeys(null, schema, table.getName());
		}

		ResultSet rs = null;
		Statement st = null;
		StringBuffer sql = new StringBuffer();
		try {
			rs = _meta.getColumns(null, null, table.getName(), "%");
			while (rs.next()) {
				DBColumn col = new DBColumn(table);
				col.setName(rs.getString(4));
				col.setNullable((short) rs.getInt(11));
				if (pkey != null) {
					col.setPKey(pkey);
				}
				col.setDataTypeString(rs.getString(6));
				SQLTypesNum ty = SQLTypesNum.parse(col.getDataTypeString());
				col.setDataType(Types.VARCHAR);
				// if (ty != null) {
				// col.setDataType(ty.getType());
				// }

				col.setSize(0);
				col.setDecimalDigits(0);
				try {
					String typeName = col.getDataTypeString();
					Matcher m = SIZE_PATTERN.matcher(typeName);
					if (m.find()) {
						if (!StringUtil.isEmpty(m.group(1))) {
							col.setSize(Integer.parseInt(m.group(1)));
						}
						if (!StringUtil.isEmpty(m.group(3))) {
							System.out.println("g3=" + m.group(3));
							col.setDecimalDigits(Integer.parseInt(m.group(3)));
						}
						col.setDataTypeString(typeName.replaceAll("(.*)[(].*",
								"$1"));
					}
				} catch (Exception e) {
				}

				col.setMaxColumnNameLength(_extra_con.getMetaData()
						.getMaxColumnNameLength());

				table.putResource(col.getName(), col);
			}
		} catch (Exception e) {
			fLogger.trace("sql=" + sql);
			fLogger.trace( e);
			return;
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (st != null) {
				st.close();
			}
		}
	}

	@Override
	protected void setTableText(ResourceCaptionRequest request)
			throws SQLException {
	}

	@Override
	protected void getTrigger() throws SQLException {
	}

	@Override
	public ResultSetDataHolder2 getSessionInfo() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public ResultSetDataHolder2 getLockInfo() throws SQLException {
		return null;
	}

	@Override
	protected void setComments(ResourceCaptionRequest request)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	protected void getSequence() throws SQLException {
	}

}